/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.nmrstar.utils;

import EDU.bmrb.nmrstar.utils.QuoteString;
import EDU.bmrb.sansj.STARLexer;
import gnu.getopt.Getopt;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;

public class SplitNMRSTAR {
    private boolean fInSf = false;
    private PrintStream fSFout = null;
    private PrintStream fOut = null;
    private String fSFname = null;
    private boolean fInLoop = false;
    private boolean fFirstVal = false;
    private int fColCount = 0;
    private int fValCount = 0;

    public SplitNMRSTAR(String string) {
        this.fSFname = "save_" + string;
    }

    public boolean split(String string, String string2, String string3) {
        try {
            InputStream inputStream = string == null ? System.in : new FileInputStream(string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            STARLexer sTARLexer = new STARLexer(bufferedReader);
            this.fSFout = new PrintStream(new FileOutputStream(string2));
            this.fOut = string3 == null ? System.out : new PrintStream(new FileOutputStream(string3));
            this.parse(sTARLexer);
            this.fSFout.flush();
            this.fSFout.close();
            this.fOut.flush();
            this.fOut.close();
            return true;
        }
        catch (Exception exception) {
            System.err.println(exception.getLocalizedMessage());
            exception.printStackTrace();
            return false;
        }
    }

    private void println(String string) {
        if (this.fInSf) {
            this.fSFout.println(string);
        } else {
            this.fOut.println(string);
        }
    }

    private void print(String string) {
        if (this.fInSf) {
            this.fSFout.print(string);
        } else {
            this.fOut.print(string);
        }
    }

    private void printValue(String string) {
        if (this.fInLoop) {
            if (this.fFirstVal) {
                this.println("");
                this.fFirstVal = false;
            }
            if (this.fValCount == this.fColCount) {
                this.println("");
                this.fValCount = 0;
            }
            this.print("\t");
            this.print(QuoteString.quote(string));
            ++this.fValCount;
        } else {
            this.print("\t");
            this.println(QuoteString.quote(string));
        }
    }

    public boolean parse(STARLexer sTARLexer) {
        try {
            int n;
            block14: do {
                n = sTARLexer.yylex();
                switch (n) {
                    case 0: {
                        System.err.println("Syntax error at line " + sTARLexer.getLine() + " column " + sTARLexer.getColumn() + ": " + sTARLexer.yytext());
                        sTARLexer.yyclose();
                        return false;
                    }
                    case 1: {
                        System.err.println("Scanner warning at line " + sTARLexer.getLine() + " column " + sTARLexer.getColumn() + ": " + sTARLexer.yytext());
                        break;
                    }
                    case 5: {
                        String string = sTARLexer.yytext();
                        if (this.fInSf) {
                            this.println("");
                            this.println("save_");
                            this.fInSf = false;
                        }
                        if (this.fSFname.equals(string)) {
                            this.fInSf = true;
                            this.println("data_" + string);
                            this.println("");
                        }
                        this.println(string);
                        break;
                    }
                    case 4: {
                        this.println(sTARLexer.yytext());
                        if (!this.fInSf) continue block14;
                        this.fInSf = false;
                        break;
                    }
                    case 6: {
                        this.fInLoop = true;
                        this.fFirstVal = true;
                        this.println(sTARLexer.yytext());
                        break;
                    }
                    case 7: {
                        this.fInLoop = false;
                        this.fColCount = 0;
                        this.fValCount = 0;
                        this.println("");
                        this.println(sTARLexer.yytext());
                        break;
                    }
                    case 8: {
                        if (this.fInLoop) {
                            this.println("\t" + sTARLexer.yytext());
                            ++this.fColCount;
                            break;
                        }
                        this.print(sTARLexer.yytext());
                        break;
                    }
                    case 12: 
                    case 13: {
                        this.printValue(sTARLexer.yytext());
                        break;
                    }
                    case 11: {
                        if (sTARLexer.getText().substring(0, 1).equals("\n")) {
                            this.printValue(sTARLexer.getText().substring(1));
                            break;
                        }
                        this.printValue(sTARLexer.getText());
                        break;
                    }
                    case 9: 
                    case 10: {
                        this.printValue(sTARLexer.getText());
                        break;
                    }
                    default: {
                        this.println(sTARLexer.yytext());
                    }
                }
            } while (n != -1);
            return true;
        }
        catch (Exception exception) {
            System.err.println(exception.getLocalizedMessage());
            exception.printStackTrace();
            return false;
        }
    }

    public static void usage() {
        System.out.println("Usage: java EDU.bmrb.nmrstar.utils.SplitNMRSTAR -n NAME -s FILE [-i FILE] [-o FILE]");
        System.out.println("  -n NAME: name of the saveframe to save into separate file (without leading save_)");
        System.out.println("  -s FILE: filename to save the savefrrame to");
        System.out.println("  -i FILE: input file (default: stdin)");
        System.out.println("  -o FILE: output file (default: stdout)");
    }

    public static void main(String[] stringArray) {
        try {
            int n;
            Getopt getopt = new Getopt("EDU.bmrb.nmrstar.dictionary.Load", stringArray, "hn:s:i:o:");
            String string = null;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            block9: while ((n = getopt.getopt()) != -1) {
                switch (n) {
                    case 104: {
                        SplitNMRSTAR.usage();
                        return;
                    }
                    case 110: {
                        string = getopt.getOptarg();
                        continue block9;
                    }
                    case 115: {
                        string2 = getopt.getOptarg();
                        continue block9;
                    }
                    case 105: {
                        string3 = getopt.getOptarg();
                        continue block9;
                    }
                    case 111: {
                        string4 = getopt.getOptarg();
                        continue block9;
                    }
                }
                SplitNMRSTAR.usage();
                return;
            }
            if (string == null || string2 == null) {
                SplitNMRSTAR.usage();
                return;
            }
            SplitNMRSTAR splitNMRSTAR = new SplitNMRSTAR(string);
            splitNMRSTAR.split(string3, string2, string4);
            return;
        }
        catch (Exception exception) {
            System.err.println(exception.getLocalizedMessage());
            exception.printStackTrace();
            return;
        }
    }
}

