/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.nmrstar.utils;

import EDU.bmrb.lib.ErrorList;
import EDU.bmrb.sansj.ErrorHandler;
import EDU.bmrb.sansj.STARLexer;
import EDU.bmrb.sansj.SimpleStarParser;
import EDU.bmrb.sansj.StarContentHandler;
import EDU.bmrb.sansj.starlib.DataNameNode;
import EDU.bmrb.sansj.starlib.DataValueNode;
import EDU.bmrb.sansj.starlib.StarNode;
import gnu.getopt.Getopt;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class StarToDb
implements StarContentHandler,
ErrorHandler {
    private static final boolean DEBUG = false;
    public static final String DRIVER_KEY = "DB.Driver";
    public static final String DBURL_KEY = "DB.Url";
    public static final String DBUSER_KEY = "DB.User";
    public static final String DBPASSWD_KEY = "DB.Password";
    private static final String ERR_COLTYPES = "Cannot get column types";
    private static final String ERR_DBEXC = "DB exception";
    private static final String ERR_DBTYPE = "Wrong data type for value ";
    private String fTableName = null;
    private int[] fColTypes = null;
    private PreparedStatement fStat = null;
    private List fColumns = null;
    private Connection fConn = null;
    private PrintWriter fOut = null;
    private ErrorList fErrs = null;
    private int fColNum = 0;
    private List fTables = null;
    private boolean fOracle = false;

    public StarToDb(Connection conn, PrintWriter out, ErrorList errs) {
        this.fConn = conn;
        this.fOut = out;
        this.fErrs = errs;
        this.fColumns = new ArrayList();
        this.fTables = new ArrayList();
    }

    private void fetchTableNames() throws SQLException {
        ResultSet rs;
        if (this.fConn == null || this.fConn.isClosed()) {
            System.err.println("Not connected to database");
            return;
        }
        String[] type = new String[]{"TABLE"};
        DatabaseMetaData md = this.fConn.getMetaData();
        if (md.getDatabaseProductName().matches(".*Oracle.*")) {
            this.fOracle = true;
            rs = md.getTables(null, md.getUserName(), null, type);
        } else {
            this.fOracle = false;
            rs = md.getTables(null, null, null, type);
        }
        while (rs.next()) {
            rs.getString(3);
            if (rs.wasNull()) continue;
            this.fTables.add(rs.getString(3).toUpperCase());
        }
    }

    public void load(BufferedReader in) throws SQLException {
        if (this.fConn == null || this.fConn.isClosed()) {
            System.err.println("Not connected to database");
            return;
        }
        this.fetchTableNames();
        STARLexer lex = new STARLexer(in);
        SimpleStarParser p = new SimpleStarParser(lex, this, this);
        p.parse();
        if (!this.fConn.getAutoCommit()) {
            this.fConn.commit();
        }
    }

    public static void usage() {
        System.out.print("Usage: java EDU.bmrb.javalib.StarToDb [-h]");
        System.out.println(" [-c FILE] [-i FILE] [-o FILE]");
        System.out.println("  -h: print this usage summary");
        System.out.println("  -c FILE: configuration FILE");
        System.out.println("  -i FILE: input FILE (default: stdin)");
        System.out.print("  -o FILE: output FILE for SQL statements (use ");
        System.out.println("single dash '-' for stdout)");
    }

    public static void main(String[] args) {
        int opt;
        Getopt g = new Getopt("EDU.bmrb.lib.StarToDb", args, "hc:i:o:");
        String conffile = null;
        String infile = null;
        String outfile = null;
        block7: while ((opt = g.getopt()) != -1) {
            switch (opt) {
                case 99: {
                    conffile = g.getOptarg();
                    continue block7;
                }
                case 105: {
                    infile = g.getOptarg();
                    continue block7;
                }
                case 111: {
                    outfile = g.getOptarg();
                    continue block7;
                }
            }
            StarToDb.usage();
            return;
        }
        if (conffile == null) {
            StarToDb.usage();
            return;
        }
        Connection conn = null;
        try {
            String drv;
            Properties props = new Properties();
            FileInputStream fin = new FileInputStream(conffile);
            props.load(fin);
            fin.close();
            BufferedReader in = infile == null ? new BufferedReader(new InputStreamReader(System.in)) : new BufferedReader(new FileReader(infile));
            PrintWriter out = null;
            if (outfile != null) {
                out = outfile.equals("-") ? new PrintWriter(System.out) : new PrintWriter(new FileOutputStream(outfile));
            }
            if ((drv = props.getProperty(DRIVER_KEY)) == null) {
                throw new NullPointerException("Missing DB driver");
            }
            String url = props.getProperty(DBURL_KEY);
            if (url == null) {
                throw new NullPointerException("Missing DB URL");
            }
            Class.forName(drv);
            conn = DriverManager.getConnection(url, props.getProperty(DBUSER_KEY), props.getProperty(DBPASSWD_KEY));
            conn.setAutoCommit(false);
            StarToDb obj = new StarToDb(conn, out, null);
            obj.load(in);
            conn.close();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }

    public void error(int line, int col, String str) {
        System.err.print("Parse error in line ");
        System.err.print(line);
        System.err.print(", column ");
        System.err.print(col);
        System.err.print(": ");
        System.err.println(str);
    }

    public boolean warning(int line, int col, String str) {
        System.err.print("Parse warning in line ");
        System.err.print(line);
        System.err.print(", column ");
        System.err.print(col);
        System.err.print(": ");
        System.err.println(str);
        return false;
    }

    public boolean startData(StarNode starNode) {
        return false;
    }

    public void endData(StarNode starNode) {
    }

    public boolean startSaveFrame(StarNode starNode) {
        String tablename = starNode.getValue();
        for (int i = 0; i < this.fTables.size(); ++i) {
            if (!tablename.equals(this.fTables.get(i))) continue;
            this.fTableName = tablename;
            return false;
        }
        System.err.print("Invalid table: ");
        System.err.print(tablename);
        System.err.print(" in line ");
        System.err.println(starNode.getLineNum());
        this.fTableName = null;
        return false;
    }

    public boolean endSaveFrame(StarNode starNode) {
        this.fTableName = null;
        return false;
    }

    public boolean startLoop(StarNode starNode) {
        return false;
    }

    public boolean endLoop(StarNode starNode) {
        if (this.fTableName == null) {
            return false;
        }
        try {
            this.fColTypes = null;
            this.fColumns.clear();
            if (this.fStat != null) {
                if (!this.fStat.getConnection().getAutoCommit()) {
                    this.fStat.getConnection().commit();
                }
                this.fStat.close();
                this.fStat = null;
            }
            return false;
        }
        catch (SQLException e) {
            if (this.fErrs != null) {
                this.fErrs.add(true, -1, -1, starNode.getLineNum(), ERR_DBEXC);
            }
            System.err.println(ERR_DBEXC);
            e.printStackTrace();
            return true;
        }
    }

    public boolean tag(DataNameNode node) {
        if (this.fTableName == null) {
            return false;
        }
        this.fColumns.add(node.getValue().substring(1));
        return false;
    }

    public boolean data(DataValueNode node) {
        if (this.fTableName == null) {
            return false;
        }
        if (this.fOracle) {
            return this.data_orrible(node);
        }
        return this.data_proper(node);
    }

    public boolean data_orrible(DataValueNode node) {
        if (this.fColTypes == null && !this.initRows()) {
            return true;
        }
        try {
            switch (this.fColTypes[this.fColNum]) {
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 8: {
                    if (node.getValue().equals(".")) {
                        this.fStat.setNull(this.fColNum + 1, 8);
                        break;
                    }
                    this.fStat.setFloat(this.fColNum + 1, Float.parseFloat(node.getValue()));
                    break;
                }
                case 1: {
                    if (node.getValue().equals(".")) {
                        this.fStat.setNull(this.fColNum + 1, 1);
                        break;
                    }
                }
                case 12: {
                    if (node.getValue().equals(".")) {
                        this.fStat.setNull(this.fColNum + 1, 12);
                        break;
                    }
                    this.fStat.setString(this.fColNum + 1, node.getValue());
                    break;
                }
                default: {
                    if (this.fErrs != null) {
                        this.fErrs.add(true, -1, -1, node.getLineNum(), ERR_DBTYPE + node.getValue() + " " + this.fColTypes[this.fColNum]);
                    }
                    System.err.println(ERR_DBTYPE + node.getValue() + " " + this.fColTypes[this.fColNum]);
                    return true;
                }
            }
            ++this.fColNum;
            if (this.fColNum == this.fColTypes.length) {
                this.fColNum = 0;
                this.fStat.executeUpdate();
                if (!this.fStat.getConnection().getAutoCommit()) {
                    this.fStat.getConnection().commit();
                }
            }
            return false;
        }
        catch (NumberFormatException ne) {
            if (this.fErrs != null) {
                this.fErrs.add(true, -1, -1, node.getLineNum(), ERR_DBTYPE + node.getValue());
            }
            System.err.println(ERR_DBTYPE + node.getValue());
            System.err.println(ne.getMessage());
            ne.printStackTrace();
            return true;
        }
        catch (SQLException e) {
            if (this.fErrs != null) {
                this.fErrs.add(true, -1, -1, node.getLineNum(), ERR_DBEXC);
            }
            System.err.println(ERR_DBEXC);
            System.err.println(e.getMessage());
            e.printStackTrace();
            return true;
        }
    }

    public boolean data_proper(DataValueNode node) {
        if (this.fTableName == null) {
            return false;
        }
        if (this.fColTypes == null && !this.initRows()) {
            return true;
        }
        try {
            switch (this.fColTypes[this.fColNum]) {
                case 8: {
                    if (node.getValue().equals(".")) {
                        this.fStat.setNull(this.fColNum + 1, 8);
                        break;
                    }
                    this.fStat.setDouble(this.fColNum + 1, Double.parseDouble(node.getValue()));
                    break;
                }
                case 6: 
                case 7: {
                    if (node.getValue().equals(".")) {
                        this.fStat.setNull(this.fColNum + 1, 6);
                        break;
                    }
                    this.fStat.setFloat(this.fColNum + 1, Float.parseFloat(node.getValue()));
                    break;
                }
                case 2: 
                case 4: {
                    if (node.getValue().equals(".")) {
                        this.fStat.setNull(this.fColNum + 1, 4);
                        break;
                    }
                    this.fStat.setInt(this.fColNum + 1, Integer.parseInt(node.getValue()));
                    break;
                }
                case 5: {
                    if (node.getValue().equals(".")) {
                        this.fStat.setNull(this.fColNum + 1, 5);
                        break;
                    }
                    this.fStat.setShort(this.fColNum, Short.parseShort(node.getValue()));
                    break;
                }
                case 1: {
                    if (node.getValue().equals(".")) {
                        this.fStat.setNull(this.fColNum + 1, 1);
                        break;
                    }
                }
                case 12: {
                    if (node.getValue().equals(".")) {
                        this.fStat.setNull(this.fColNum + 1, 12);
                        break;
                    }
                    this.fStat.setString(this.fColNum + 1, node.getValue());
                    break;
                }
                default: {
                    if (this.fErrs != null) {
                        this.fErrs.add(true, -1, -1, node.getLineNum(), ERR_DBTYPE + node.getValue() + " " + this.fColTypes[this.fColNum]);
                    }
                    System.err.println(ERR_DBTYPE + node.getValue() + " " + this.fColTypes[this.fColNum]);
                    return true;
                }
            }
            ++this.fColNum;
            if (this.fColNum == this.fColTypes.length) {
                this.fColNum = 0;
                this.fStat.executeUpdate();
                if (!this.fStat.getConnection().getAutoCommit()) {
                    this.fStat.getConnection().commit();
                }
            }
            return false;
        }
        catch (NumberFormatException ne) {
            if (this.fErrs != null) {
                this.fErrs.add(true, -1, -1, node.getLineNum(), ERR_DBTYPE + node.getValue());
            }
            System.err.println(ERR_DBTYPE + node.getValue());
            System.err.println(ne.getMessage());
            ne.printStackTrace();
            return true;
        }
        catch (SQLException e) {
            if (this.fErrs != null) {
                this.fErrs.add(true, -1, -1, node.getLineNum(), ERR_DBEXC);
            }
            System.err.println(ERR_DBEXC);
            System.err.println(e.getMessage());
            e.printStackTrace();
            return true;
        }
    }

    private boolean initRows() {
        try {
            int i;
            ResultSet rs;
            ResultSetMetaData dat;
            int numcols;
            Statement query = this.fConn.createStatement(1004, 1007);
            StringBuffer sql = new StringBuffer("SELECT * FROM ");
            sql.append(this.fTableName);
            if (this.fOut != null) {
                this.fOut.println(sql);
                this.fOut.flush();
            }
            if ((numcols = (dat = (rs = query.executeQuery(sql.toString())).getMetaData()).getColumnCount()) != this.fColumns.size()) {
                if (this.fErrs != null) {
                    this.fErrs.add(true, -1, -1, -1, ERR_COLTYPES);
                }
                System.err.println(ERR_COLTYPES);
                return false;
            }
            this.fColTypes = new int[numcols];
            sql.setLength(0);
            sql.append("INSERT INTO ");
            sql.append(this.fTableName);
            sql.append(" (");
            block2: for (i = 0; i < numcols; ++i) {
                sql.append((String)this.fColumns.get(i));
                if (i != numcols - 1) {
                    sql.append(',');
                }
                for (int j = 0; j <= numcols; ++j) {
                    if (!((String)this.fColumns.get(i)).equals(dat.getColumnName(j + 1).toUpperCase())) continue;
                    this.fColTypes[i] = dat.getColumnType(j + 1);
                    continue block2;
                }
            }
            sql.append(") VALUES (");
            for (i = 0; i < numcols; ++i) {
                sql.append('?');
                if (i == numcols - 1) continue;
                sql.append(',');
            }
            sql.append(')');
            this.fStat = this.fConn.prepareStatement(sql.toString());
            rs.close();
            query.close();
            if (this.fOut != null) {
                this.fOut.println(sql);
                this.fOut.flush();
            }
            sql.setLength(0);
            return true;
        }
        catch (Exception e) {
            System.err.println(ERR_COLTYPES);
            System.err.println(e.getLocalizedMessage());
            e.printStackTrace();
            return false;
        }
    }
}

