/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.nmrstar.utils;

import EDU.bmrb.nmrstar.dictionary.DBMgr;
import EDU.bmrb.nmrstar.dictionary.Props;
import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;

public class TestValidict {
    public static final String PROPFILE = "validator.properties";
    private Props fProps = null;
    private DBMgr fDbm = null;
    private Connection fConn = null;
    private StringBuffer fBuf = new StringBuffer();

    public TestValidict() {
        this.fBuf.append(System.getProperty("user.home"));
        this.fBuf.append(File.separatorChar);
        this.fBuf.append(PROPFILE);
        this.fProps = new Props();
        this.fProps.setPropFile(this.fBuf.toString());
        this.fProps.load();
        this.fDbm = new DBMgr(this.fProps);
    }

    public TestValidict(String string) {
        this.fProps = new Props();
        this.fProps.setPropFile(string);
        this.fProps.load();
        this.fDbm = new DBMgr(this.fProps);
    }

    public boolean connect() {
        if (this.fDbm.connect(false)) {
            this.fConn = this.fDbm.getConnection();
            return true;
        }
        return false;
    }

    protected void finalize() {
        this.fDbm.close();
    }

    public boolean checkMandatoryTags() {
        try {
            boolean bl = true;
            Statement statement = this.fDbm.getQuery();
            ResultSet resultSet = statement.executeQuery("SELECT t.SEQ, t.TAGNAME, t.MANDATORY, s.SFCAT FROM TAGS t, SFCATS s WHERE s.MANDATORY<>'M' AND (t.MANDATORY='V' OR t.MANDATORY='M') AND t.SFCAT=s.SFCAT");
            while (resultSet.next()) {
                System.out.print("Tag ");
                System.out.print(resultSet.getInt(1));
                System.out.print('(');
                System.out.print(resultSet.getString(2));
                System.out.print(") is '");
                System.out.print(resultSet.getString(3));
                System.out.print("' in optional saveframe category ");
                System.out.println(resultSet.getString(4));
                bl = false;
            }
            return bl;
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            exception.printStackTrace();
            return false;
        }
    }

    public static void main(String[] stringArray) {
        TestValidict testValidict = stringArray.length > 0 ? new TestValidict(stringArray[0]) : new TestValidict();
        testValidict.connect();
        if (!testValidict.checkMandatoryTags()) {
            System.out.println("Test failed");
        }
        testValidict.finalize();
    }
}

