/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.sansj;

import EDU.bmrb.sansj.ContentHandler;
import EDU.bmrb.sansj.DataItemNode;
import EDU.bmrb.sansj.ErrorHandler;
import EDU.bmrb.sansj.IntStringPair;
import EDU.bmrb.sansj.STARLexer;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;

public class CifParser {
    public static final String ERR_LEXER = "Lexer error: ";
    public static final String ERR_TOKEN = "Invalid token: ";
    public static final String ERR_LOOPNOTAGS = "Loop with no tags";
    public static final String ERR_LOOPNOVALS = "Loop with no values";
    public static final String WARN_KEYWORD = "Keyword in value: ";
    private ContentHandler fCh = null;
    private ErrorHandler fEh = null;
    STARLexer fLex = null;
    String fDataId = null;

    public CifParser(STARLexer sTARLexer) {
        this.fLex = sTARLexer;
    }

    public CifParser(STARLexer sTARLexer, ContentHandler contentHandler, ErrorHandler errorHandler) {
        this.fLex = sTARLexer;
        this.fCh = contentHandler;
        this.fEh = errorHandler;
    }

    public ContentHandler getContentHandler() {
        return this.fCh;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.fCh = contentHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.fEh;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.fEh = errorHandler;
    }

    public STARLexer getScanner() {
        return this.fLex;
    }

    public void setScanner(STARLexer sTARLexer) {
        this.fLex = sTARLexer;
    }

    public void parse() {
        try {
            int n;
            block8: do {
                n = this.fLex.yylex();
                switch (n) {
                    case 0: {
                        this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), ERR_LEXER + this.fLex.yytext());
                        return;
                    }
                    case 14: {
                        if (!this.fCh.comment(this.fLex.getLine(), this.fLex.yytext())) continue block8;
                        return;
                    }
                    case 3: {
                        this.fDataId = this.fLex.yytext().substring(5);
                        if (this.fCh.startData(this.fLex.getLine(), this.fDataId)) {
                            return;
                        }
                        if (!this.parseDataBlock()) continue block8;
                        return;
                    }
                    case -1: {
                        this.fCh.endData(this.fLex.getLine(), this.fDataId);
                        return;
                    }
                    default: {
                        this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), ERR_TOKEN + this.fLex.yytext());
                        return;
                    }
                }
            } while (n != -1);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            exception.printStackTrace();
        }
    }

    public boolean parseDataBlock() {
        int n = -1;
        String string = null;
        Object var4_3 = null;
        DataItemNode dataItemNode = null;
        try {
            int n2;
            block10: do {
                dataItemNode = null;
                n2 = this.fLex.yylex();
                switch (n2) {
                    case 0: {
                        this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), ERR_LEXER + this.fLex.yytext());
                        return true;
                    }
                    case 14: {
                        if (!this.fCh.comment(this.fLex.getLine(), this.fLex.yytext())) continue block10;
                        return true;
                    }
                    case -1: {
                        this.fCh.endData(this.fLex.getLine(), this.fDataId);
                        return true;
                    }
                    case 6: {
                        if (this.fCh.startLoop(this.fLex.getLine())) {
                            return true;
                        }
                        this.parseLoop();
                        break;
                    }
                    case 8: {
                        string = this.fLex.yytext();
                        n = this.fLex.getLine();
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: {
                        dataItemNode = new DataItemNode(n, string);
                        dataItemNode.setDelimType(n2);
                        dataItemNode.setValueLine(this.fLex.getLine());
                        if (n2 == 11) {
                            if (this.fLex.getText().substring(0, 1).equals("\n")) {
                                dataItemNode.setValue(this.fLex.getText().substring(1));
                            } else {
                                dataItemNode.setValue(this.fLex.getText());
                            }
                        } else if (n2 == 12) {
                            dataItemNode.setValue(this.fLex.yytext().substring(1));
                        } else if (n2 == 13) {
                            dataItemNode.setValue(this.fLex.yytext());
                        } else {
                            dataItemNode.setValue(this.fLex.getText());
                        }
                        dataItemNode.setLoopFlag(false);
                        if (!this.fCh.data(dataItemNode)) continue block10;
                        return true;
                    }
                    default: {
                        this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), ERR_TOKEN + this.fLex.yytext());
                        return true;
                    }
                }
            } while (n2 != -1);
            return false;
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            exception.printStackTrace();
            return true;
        }
    }

    public IntStringPair parseLoop() {
        int n = 0;
        Vector<IntStringPair> vector = new Vector<IntStringPair>();
        IntStringPair intStringPair = null;
        DataItemNode dataItemNode = null;
        boolean bl = false;
        try {
            int n2;
            block11: do {
                dataItemNode = null;
                n2 = this.fLex.yylex();
                switch (n2) {
                    case 0: {
                        this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), ERR_LEXER + this.fLex.yytext());
                        return null;
                    }
                    case 1: {
                        if (!this.fEh.warning(this.fLex.getLine(), this.fLex.getColumn(), WARN_KEYWORD + this.fLex.yytext())) continue block11;
                        return null;
                    }
                    case 14: {
                        if (!this.fCh.comment(this.fLex.getLine(), this.fLex.yytext())) continue block11;
                        return null;
                    }
                    case 6: {
                        if (!bl) {
                            this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), ERR_LOOPNOVALS);
                            return null;
                        }
                        this.fLex.pushBack(5);
                        return null;
                    }
                    case 8: {
                        intStringPair = new IntStringPair(this.fLex.getLine(), this.fLex.yytext());
                        if (!bl) {
                            vector.addElement(intStringPair);
                            break;
                        }
                        this.fLex.pushBack(this.fLex.yytext().length());
                        return null;
                    }
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: {
                        if (vector.size() < 1) {
                            this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), ERR_LOOPNOTAGS);
                            vector = null;
                            return null;
                        }
                        bl = true;
                        dataItemNode = new DataItemNode((IntStringPair)vector.elementAt(n));
                        dataItemNode.setDelimType(n2);
                        dataItemNode.setValueLine(this.fLex.getLine());
                        if (n2 == 11) {
                            if (this.fLex.getText().substring(0, 1).equals("\n")) {
                                dataItemNode.setValue(this.fLex.getText().substring(1));
                            } else {
                                dataItemNode.setValue(this.fLex.getText());
                            }
                        }
                        if (n2 == 12) {
                            dataItemNode.setValue(this.fLex.yytext().substring(1));
                        } else if (n2 == 13) {
                            dataItemNode.setValue(this.fLex.yytext());
                        } else {
                            dataItemNode.setValue(this.fLex.getText());
                        }
                        dataItemNode.setLoopFlag(true);
                        if (++n == vector.size()) {
                            n = 0;
                        }
                        if (!this.fCh.data(dataItemNode)) continue block11;
                        return null;
                    }
                    case -1: {
                        this.fCh.endData(this.fLex.getLine(), this.fDataId);
                        return null;
                    }
                    default: {
                        this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), ERR_TOKEN + this.fLex.yytext());
                        return null;
                    }
                }
            } while (n2 != -1);
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static void main(String[] stringArray) {
        try {
            InputStream inputStream = stringArray.length < 1 ? System.in : new FileInputStream(stringArray[0]);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            STARLexer sTARLexer = new STARLexer(bufferedReader);
            CifParser cifParser = new CifParser(sTARLexer);
            cifParser.test_parse();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void test_parse() {
        try {
            int n = this.fLex.yylex();
            while (n != -1) {
                System.out.print(STARLexer.TOKEN_TYPES[n] + "(" + this.fLex.getLine() + ":" + this.fLex.getColumn() + "): ");
                switch (n) {
                    case 9: 
                    case 10: 
                    case 11: {
                        System.out.println(this.fLex.getText());
                        break;
                    }
                    default: {
                        System.out.println(this.fLex.yytext());
                    }
                }
                n = this.fLex.yylex();
            }
            System.out.println("End of data_ (EOF)");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

