/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.sansj;

import EDU.bmrb.sansj.ContentHandler;
import EDU.bmrb.sansj.DataItemNode;
import EDU.bmrb.sansj.ErrorHandler;
import EDU.bmrb.sansj.IntStringPair;
import EDU.bmrb.sansj.STARLexer;
import java.util.ArrayList;

public class LoopParser {
    public static final String ERR_LEXER = "Lexer error: ";
    public static final String ERR_INVTOKEN = "Invalid token: ";
    public static final String ERR_UNXTOKEN = "Unexpected token: ";
    public static final String ERR_EOF = "Premature end of file";
    public static final String ERR_EMPTYLOOP = "Loop with no values";
    public static final String ERR_LOOPNOTAGS = "Loop with no tags";
    public static final String WARN_KEYWORD = "Keyword in value: ";
    public static final String WARN_LOOPCOUNT = "Loop count error";
    public static final String TOKEN = "Token ";
    public static final String ILLEGAL = " is not allowed inside a loop";
    private ContentHandler fCh = null;
    private ErrorHandler fEh = null;
    private STARLexer fLex = null;
    private boolean fParsingTags = true;
    private boolean fHaveStop = false;

    public LoopParser(STARLexer sTARLexer, ContentHandler contentHandler, ErrorHandler errorHandler) {
        this.fLex = sTARLexer;
        this.fCh = contentHandler;
        this.fEh = errorHandler;
    }

    public ContentHandler getContentHandler() {
        return this.fCh;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.fCh = contentHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.fEh;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.fEh = errorHandler;
    }

    public STARLexer getScanner() {
        return this.fLex;
    }

    public void setScanner(STARLexer sTARLexer) {
        this.fLex = sTARLexer;
    }

    public void parse() {
        int n = 0;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = 0;
        ArrayList<IntStringPair> arrayList = new ArrayList<IntStringPair>();
        IntStringPair[] intStringPairArray = null;
        DataItemNode dataItemNode = null;
        try {
            int n6;
            block12: do {
                n6 = this.fLex.yylex();
                switch (n6) {
                    case 0: {
                        this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), ERR_LEXER + this.fLex.yytext());
                        return;
                    }
                    case 1: {
                        if (!this.fEh.warning(this.fLex.getLine(), this.fLex.getColumn(), WARN_KEYWORD + this.fLex.yytext())) continue block12;
                        return;
                    }
                    case 14: {
                        if (!this.fCh.comment(this.fLex.getLine(), this.fLex.yytext())) continue block12;
                        return;
                    }
                    case 6: {
                        if (!this.fCh.startLoop(this.fLex.getLine())) continue block12;
                        return;
                    }
                    case 7: {
                        if (intStringPairArray.length < 1) {
                            this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), ERR_LOOPNOTAGS);
                            return;
                        }
                        if (n5 == 0) {
                            this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), ERR_EMPTYLOOP);
                            arrayList.clear();
                            arrayList = null;
                            return;
                        }
                        this.fHaveStop = true;
                        if (n5 % intStringPairArray.length != 0) {
                            this.fEh.warning(n3 >= 0 ? n3 : this.fLex.getLine(), n4 >= 0 ? n4 : -1, WARN_LOOPCOUNT);
                        }
                        this.fCh.endLoop(this.fLex.getLine());
                        return;
                    }
                    case 8: {
                        IntStringPair intStringPair = new IntStringPair(this.fLex.getLine(), this.fLex.yytext());
                        arrayList.add(intStringPair);
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: {
                        if (this.fParsingTags) {
                            this.fParsingTags = false;
                            intStringPairArray = new IntStringPair[arrayList.size()];
                            for (int i = 0; i < arrayList.size(); ++i) {
                                intStringPairArray[i] = (IntStringPair)arrayList.get(i);
                            }
                            arrayList.clear();
                            arrayList = null;
                        }
                        if (intStringPairArray == null || intStringPairArray.length < 1) {
                            this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), ERR_LOOPNOTAGS);
                            arrayList = null;
                            return;
                        }
                        dataItemNode = new DataItemNode(intStringPairArray[n]);
                        dataItemNode.setDelimType(n6);
                        dataItemNode.setValueLine(this.fLex.getLine());
                        if (n6 == 11) {
                            if (this.fLex.getText().substring(0, 1).equals("\n")) {
                                dataItemNode.setValue(this.fLex.getText().substring(1));
                            } else {
                                dataItemNode.setValue(this.fLex.getText());
                            }
                        }
                        if (n6 == 12) {
                            dataItemNode.setValue(this.fLex.yytext().substring(1));
                        } else if (n6 == 13) {
                            dataItemNode.setValue(this.fLex.yytext());
                        } else {
                            dataItemNode.setValue(this.fLex.getText());
                        }
                        dataItemNode.setLoopFlag(true);
                        ++n5;
                        if (++n == intStringPairArray.length && n2 < this.fLex.getLine() && n3 < 0) {
                            n3 = this.fLex.getLine();
                            n4 = this.fLex.getColumn();
                        }
                        n2 = this.fLex.getLine();
                        if (n == intStringPairArray.length) {
                            n = 0;
                        }
                        if (!this.fCh.data(dataItemNode)) continue block12;
                        return;
                    }
                    case -1: {
                        if (!this.fHaveStop) {
                            this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), ERR_EOF);
                        }
                        return;
                    }
                    default: {
                        this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), ERR_INVTOKEN + this.fLex.yytext());
                        return;
                    }
                }
            } while (n6 != -1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        System.err.println("Run TestLoopParser class to test this parser");
    }
}

