/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.sansj;

import EDU.bmrb.sansj.ContentHandler;
import EDU.bmrb.sansj.DataItemNode;
import EDU.bmrb.sansj.ErrorHandler;
import EDU.bmrb.sansj.IntStringPair;
import EDU.bmrb.sansj.STARLexer;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;

public class SansParser {
    public static final String ERR_LEXER = "Lexer error: ";
    public static final String ERR_GLOBAL = "Global blocks are illegal in NMR-STAR";
    public static final String ERR_TOKEN = "Invalid token: ";
    public static final String ERR_EOF = "Premature end of file";
    public static final String ERR_EMPTYLOOP = "Loop with no values";
    public static final String ERR_LOOPNOTAGS = "Loop with no tags";
    public static final String WARN_KEYWORD = "Keyword in value: ";
    public static final String WARN_LOOPCOUNT = "Loop count error";
    public static final String TOKEN = "Token ";
    public static final String NOTINDATABLOCK = " is not allowed outside of a data block";
    public static final String ILLEGAL = " is not allowed inside a";
    public static final String DATA_BLOCK = " data block";
    public static final String SAVEFRAME = " saveframe";
    public static final String LOOP = " loop";
    private ContentHandler fCh = null;
    private ErrorHandler fEh = null;
    STARLexer fLex = null;

    public SansParser(STARLexer sTARLexer) {
        this.fLex = sTARLexer;
    }

    public SansParser(STARLexer sTARLexer, ContentHandler contentHandler, ErrorHandler errorHandler) {
        this.fLex = sTARLexer;
        this.fCh = contentHandler;
        this.fEh = errorHandler;
    }

    public ContentHandler getContentHandler() {
        return this.fCh;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.fCh = contentHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.fEh;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.fEh = errorHandler;
    }

    public STARLexer getScanner() {
        return this.fLex;
    }

    public void setScanner(STARLexer sTARLexer) {
        this.fLex = sTARLexer;
    }

    public void parse() {
        String string = null;
        try {
            int n;
            block8: do {
                n = this.fLex.yylex();
                switch (n) {
                    case 0: {
                        this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), ERR_LEXER + this.fLex.yytext());
                        return;
                    }
                    case 14: {
                        if (!this.fCh.comment(this.fLex.getLine(), this.fLex.yytext())) continue block8;
                        return;
                    }
                    case 3: {
                        string = this.fLex.yytext().substring(5);
                        if (this.fCh.startData(this.fLex.getLine(), string)) {
                            return;
                        }
                        if (!this.parseDataBlock(string)) continue block8;
                        return;
                    }
                    case -1: {
                        this.fCh.endData(this.fLex.getLine(), string);
                        return;
                    }
                    default: {
                        this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), TOKEN + this.fLex.yytext() + NOTINDATABLOCK);
                        return;
                    }
                }
            } while (n != -1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean parseDataBlock(String string) {
        String string2 = null;
        try {
            int n;
            block8: do {
                n = this.fLex.yylex();
                switch (n) {
                    case 0: {
                        this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), ERR_LEXER + this.fLex.yytext());
                        return true;
                    }
                    case 14: {
                        if (!this.fCh.comment(this.fLex.getLine(), this.fLex.yytext())) continue block8;
                        return true;
                    }
                    case 5: {
                        string2 = this.fLex.yytext().substring(5);
                        if (this.fCh.startSaveFrame(this.fLex.getLine(), string2)) {
                            return true;
                        }
                        if (!this.parseSaveFrame(string2)) continue block8;
                        return true;
                    }
                    case -1: {
                        this.fCh.endData(this.fLex.getLine(), string);
                        return true;
                    }
                    default: {
                        this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), TOKEN + this.fLex.yytext() + ILLEGAL + DATA_BLOCK);
                        return true;
                    }
                }
            } while (n != -1);
            return false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return true;
        }
    }

    public boolean parseSaveFrame(String string) {
        String string2 = null;
        DataItemNode dataItemNode = null;
        int n = -1;
        try {
            int n2;
            block12: do {
                dataItemNode = null;
                n2 = this.fLex.yylex();
                switch (n2) {
                    case 0: {
                        this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), ERR_LEXER + this.fLex.yytext());
                        return true;
                    }
                    case 1: {
                        if (!this.fEh.warning(this.fLex.getLine(), this.fLex.getColumn(), WARN_KEYWORD + this.fLex.yytext())) continue block12;
                        return true;
                    }
                    case 4: {
                        return this.fCh.endSaveFrame(this.fLex.getLine(), string);
                    }
                    case 14: {
                        if (!this.fCh.comment(this.fLex.getLine(), this.fLex.yytext())) continue block12;
                        return true;
                    }
                    case 6: {
                        if (this.fCh.startLoop(this.fLex.getLine())) {
                            return true;
                        }
                        if (!this.parseLoop()) continue block12;
                        return true;
                    }
                    case 8: {
                        string2 = this.fLex.yytext();
                        n = this.fLex.getLine();
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: {
                        dataItemNode = new DataItemNode(n, string2);
                        dataItemNode.setDelimType(n2);
                        dataItemNode.setValueLine(this.fLex.getLine());
                        if (n2 == 11) {
                            if (this.fLex.getText().substring(0, 1).equals("\n")) {
                                dataItemNode.setValue(this.fLex.getText().substring(1));
                            } else {
                                dataItemNode.setValue(this.fLex.getText());
                            }
                        } else if (n2 == 12) {
                            dataItemNode.setValue(this.fLex.yytext().substring(1));
                        } else if (n2 == 13) {
                            dataItemNode.setValue(this.fLex.yytext());
                        } else {
                            dataItemNode.setValue(this.fLex.getText());
                        }
                        dataItemNode.setLoopFlag(false);
                        if (!this.fCh.data(dataItemNode)) continue block12;
                        return true;
                    }
                    case -1: {
                        this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), ERR_EOF);
                        return true;
                    }
                    default: {
                        this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), TOKEN + this.fLex.yytext() + ILLEGAL + SAVEFRAME);
                        return true;
                    }
                }
            } while (n2 != -1);
            return false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return true;
        }
    }

    public boolean parseLoop() {
        int n = 0;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = 0;
        Vector<IntStringPair> vector = new Vector<IntStringPair>();
        DataItemNode dataItemNode = null;
        try {
            int n6;
            block11: do {
                dataItemNode = null;
                n6 = this.fLex.yylex();
                switch (n6) {
                    case 0: {
                        this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), ERR_LEXER + this.fLex.yytext());
                        return true;
                    }
                    case 1: {
                        if (!this.fEh.warning(this.fLex.getLine(), this.fLex.getColumn(), WARN_KEYWORD + this.fLex.yytext())) continue block11;
                        return true;
                    }
                    case 14: {
                        if (!this.fCh.comment(this.fLex.getLine(), this.fLex.yytext())) continue block11;
                        return true;
                    }
                    case 4: 
                    case 7: {
                        if (vector.size() < 1) {
                            this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), ERR_LOOPNOTAGS);
                            vector = null;
                            return true;
                        }
                        if (n5 == 0) {
                            this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), ERR_EMPTYLOOP);
                            vector.removeAllElements();
                            vector = null;
                            return true;
                        }
                        boolean bl = false;
                        if (n5 % vector.size() != 0) {
                            bl = this.fEh.warning(n3 >= 0 ? n3 : this.fLex.getLine(), n4 >= 0 ? n4 : -1, WARN_LOOPCOUNT);
                        }
                        vector.removeAllElements();
                        vector = null;
                        bl = bl || this.fCh.endLoop(this.fLex.getLine());
                        return bl;
                    }
                    case 8: {
                        IntStringPair intStringPair = new IntStringPair(this.fLex.getLine(), this.fLex.yytext());
                        vector.addElement(intStringPair);
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: {
                        if (vector.size() < 1) {
                            this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), ERR_LOOPNOTAGS);
                            vector = null;
                            return true;
                        }
                        dataItemNode = new DataItemNode((IntStringPair)vector.elementAt(n));
                        dataItemNode.setDelimType(n6);
                        dataItemNode.setValueLine(this.fLex.getLine());
                        if (n6 == 11) {
                            if (this.fLex.getText().substring(0, 1).equals("\n")) {
                                dataItemNode.setValue(this.fLex.getText().substring(1));
                            } else {
                                dataItemNode.setValue(this.fLex.getText());
                            }
                        }
                        if (n6 == 12) {
                            dataItemNode.setValue(this.fLex.yytext().substring(1));
                        } else if (n6 == 13) {
                            dataItemNode.setValue(this.fLex.yytext());
                        } else {
                            dataItemNode.setValue(this.fLex.getText());
                        }
                        dataItemNode.setLoopFlag(true);
                        ++n5;
                        if (++n == vector.size() && n2 < this.fLex.getLine() && n3 < 0) {
                            n3 = this.fLex.getLine();
                            n4 = this.fLex.getColumn();
                        }
                        n2 = this.fLex.getLine();
                        if (n == vector.size()) {
                            n = 0;
                        }
                        if (!this.fCh.data(dataItemNode)) continue block11;
                        return true;
                    }
                    case -1: {
                        this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), ERR_EOF);
                        return true;
                    }
                    default: {
                        this.fEh.error(this.fLex.getLine(), this.fLex.getColumn(), TOKEN + this.fLex.yytext() + ILLEGAL + LOOP);
                        return true;
                    }
                }
            } while (n6 != -1);
            return false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return true;
        }
    }

    public static void main(String[] stringArray) {
        try {
            InputStream inputStream = stringArray.length < 1 ? System.in : new FileInputStream(stringArray[0]);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            STARLexer sTARLexer = new STARLexer(bufferedReader);
            SansParser sansParser = new SansParser(sTARLexer);
            sansParser.test_parse();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void test_parse() {
        try {
            int n = this.fLex.yylex();
            while (n != -1) {
                System.out.print(STARLexer.TOKEN_TYPES[n] + "(" + this.fLex.getLine() + ":" + this.fLex.getColumn() + "): ");
                switch (n) {
                    case 9: 
                    case 10: 
                    case 11: {
                        System.out.println(this.fLex.getText());
                        break;
                    }
                    default: {
                        System.out.println(this.fLex.yytext());
                    }
                }
                n = this.fLex.yylex();
            }
            System.out.println("End of data_ (EOF)");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

