/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.sansj;

import EDU.bmrb.sansj.ContentHandler;
import EDU.bmrb.sansj.DataItemNode;
import EDU.bmrb.sansj.ErrorHandler;
import EDU.bmrb.sansj.LoopParser;
import EDU.bmrb.sansj.STARLexer;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;

public class TestLoopParser
implements ContentHandler,
ErrorHandler {
    public static void main(String[] stringArray) {
        try {
            long l = System.currentTimeMillis();
            InputStream inputStream = stringArray.length < 1 ? System.in : new FileInputStream(stringArray[0]);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            STARLexer sTARLexer = new STARLexer(bufferedReader);
            TestLoopParser testLoopParser = new TestLoopParser();
            LoopParser loopParser = new LoopParser(sTARLexer, testLoopParser, testLoopParser);
            loopParser.parse();
            System.out.println("Elapsed: " + (System.currentTimeMillis() - l));
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            exception.printStackTrace();
        }
    }

    private void print(String string) {
        System.out.print(string);
    }

    private void print(int n) {
        System.out.print(n);
    }

    private void println(String string) {
        this.print(string);
        this.print("\n");
    }

    private void println(int n) {
        this.print(n);
        this.print("\n");
    }

    public void error(int n, int n2, String string) {
        this.print("Parse error in line ");
        this.print(n);
        this.print(", column ");
        this.print(n2);
        this.print(": ");
        this.println(string);
    }

    public boolean warning(int n, int n2, String string) {
        this.print("Parse warning in line ");
        this.print(n);
        this.print(", column ");
        this.print(n2);
        this.print(": ");
        this.println(string);
        return false;
    }

    public boolean comment(int n, String string) {
        this.print("# ");
        this.print(string);
        this.print(40);
        this.print(n);
        this.println(41);
        return false;
    }

    public boolean startLoop(int n) {
        this.print("Start of loop (");
        this.print(n);
        this.println(41);
        return false;
    }

    public boolean data(DataItemNode dataItemNode) {
        this.print("Value: ");
        this.print(dataItemNode.getTag());
        this.print(40);
        this.print(dataItemNode.getTagLine());
        this.print(") ");
        this.print(dataItemNode.getValue());
        this.print(40);
        this.print(dataItemNode.getValueLine());
        this.println(41);
        return false;
    }

    public boolean endLoop(int n) {
        this.print("End of loop (");
        this.print(n);
        this.println(41);
        return false;
    }

    public boolean startData(int n, String string) {
        this.println("ERROR: start of data block");
        return false;
    }

    public void endData(int n, String string) {
        this.println("ERROR: end of data block");
    }

    public boolean startSaveFrame(int n, String string) {
        this.println("ERROR: start of saveframe");
        return false;
    }

    public boolean endSaveFrame(int n, String string) {
        this.println("ERROR: end of saveframe");
        return false;
    }
}

