/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.stardb;

import EDU.bmrb.stardb.Star_DB;
import EDU.bmrb.validator.Error;
import EDU.bmrb.validator.ErrorList;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

public class CreateSchema {
    public static boolean createSchema(Connection conn, String script, PrintWriter out, ErrorList errs) {
        try {
            String str;
            Statement stat = conn.createStatement();
            BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(script)));
            StringBuffer sql = new StringBuffer();
            while ((str = in.readLine()) != null) {
                if ((str = str.trim()).equals("") || str.charAt(0) == '-' && str.charAt(1) == '-' || str.toLowerCase().equals("quit")) continue;
                int end = str.indexOf("--");
                if (end != -1) {
                    str = str.substring(0, end);
                }
                if ((end = str.indexOf(59)) != -1) {
                    sql.append(" ");
                    sql.append(str.substring(0, end));
                    if (out != null) {
                        out.println(sql);
                        out.flush();
                    }
                    if (sql.toString().toLowerCase().indexOf("drop") != -1) {
                        try {
                            stat.executeUpdate(sql.toString());
                        }
                        catch (SQLException ex) {
                            System.err.println(ex.getMessage());
                            System.err.println(sql);
                        }
                    } else if (sql.toString().toLowerCase().indexOf("commit") != -1) {
                        conn.commit();
                    } else {
                        stat.executeUpdate(sql.toString());
                    }
                    sql.setLength(0);
                    continue;
                }
                sql.append(" ");
                sql.append(str);
            }
            stat.getConnection().commit();
            stat.close();
            if (out != null) {
                out.flush();
            }
        }
        catch (SQLException e) {
            if (errs != null) {
                errs.clear();
                errs.add(new Error(true, -1, -1, -1, "Cannot create schema. DB exception, check error output"));
            }
            System.err.println(e.getLocalizedMessage());
            e.printStackTrace();
            return false;
        }
        catch (IOException ie) {
            if (errs != null) {
                errs.clear();
                errs.add(new Error(true, -1, -1, -1, "Cannot create schema. I/O exception, check error output"));
            }
            System.err.println(ie.getLocalizedMessage());
            ie.printStackTrace();
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        long now = System.currentTimeMillis();
        Star_DB star = args.length > 0 ? new Star_DB(args[0]) : new Star_DB();
        star.connect(false);
        PrintWriter out = new PrintWriter(System.err);
        if (!CreateSchema.createSchema(star.getConnection(), star.getProperty("DB.schema"), null, null)) {
            System.err.println("Failed to create schema");
        }
        star.disconnect();
        System.out.println("Elapsed: " + (System.currentTimeMillis() - now));
        out.flush();
    }
}

