/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.stardb;

import EDU.bmrb.stardb.Stardb;
import java.io.File;
import java.io.FileInputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

public class HSQLdb
implements Stardb {
    private static final boolean DEBUG = true;
    private Properties fProps = null;
    private Connection fConn = null;
    private boolean fSortTags = true;

    public static final int strlen(String str) {
        if (str == null) {
            return 0;
        }
        return str.length();
    }

    public HSQLdb() {
        this.fProps = new Properties();
        StringBuilder buf = new StringBuilder();
        buf.append(System.getProperty("user.home"));
        buf.append(File.separatorChar);
        buf.append("stardb.properties");
        this.loadProperties(buf.toString());
    }

    public HSQLdb(String name) {
        this.fProps = new Properties();
        this.loadProperties(name);
    }

    public HSQLdb(Properties props) {
        this.fProps = props;
    }

    private boolean loadProperties(String file) {
        try {
            FileInputStream in = new FileInputStream(file);
            this.fProps.load(in);
        }
        catch (Exception e) {
            System.err.println("Cannot load configuraton file");
            System.err.println(e.getLocalizedMessage());
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public Properties getProperties() {
        return this.fProps;
    }

    public void setProperties(Properties props) {
        this.fProps = props;
    }

    public String getProperty(String key) {
        return this.fProps.getProperty(key);
    }

    public boolean getSortTags() {
        return this.fSortTags;
    }

    public void setSortTags(boolean flag) {
        this.fSortTags = true;
    }

    public boolean getReindexLoops() {
        return false;
    }

    public void setReindexLoops(boolean flag) {
    }

    public boolean getSortAtoms() {
        return false;
    }

    public void setSortAtoms(boolean flag) {
    }

    public boolean getAddComments() {
        return false;
    }

    public void setAddComments(boolean flag) {
    }

    public boolean canBatch() {
        return false;
    }

    public boolean isHSQLDB() {
        return true;
    }

    public boolean isOracle() {
        return false;
    }

    public boolean isFirebird() {
        return false;
    }

    public boolean isMimer() {
        return false;
    }

    public boolean isPostgres() {
        return false;
    }

    public boolean isMySQL() {
        return false;
    }

    public int getEngineVersion() {
        try {
            if (this.fConn == null || this.fConn.isClosed()) {
                throw new NullPointerException("Not connected to database");
            }
            DatabaseMetaData md = this.fConn.getMetaData();
            return md.getDatabaseMajorVersion();
        }
        catch (SQLException e) {
            System.err.printf("SQL State %s\n", e.getSQLState());
            System.err.println(e);
            e.printStackTrace();
            return -1;
        }
    }

    public boolean isCachedTables() {
        try {
            if (this.fConn == null || this.fConn.isClosed()) {
                throw new NullPointerException("Not connected to database");
            }
            Statement query = this.fConn.createStatement(1003, 1007);
            boolean rc = false;
            ResultSet rs = query.executeQuery("SELECT PROPERTY_VALUE FROM INFORMATION_SCHEMA.SYSTEM_PROPERTIES WHERE PROPERTY_NAME='hsqldb.default_table_type'");
            if (rs.next()) {
                String str = rs.getString(1);
                if (!rs.wasNull()) {
                    rc = str.toLowerCase().equals("cached");
                }
            }
            rs.close();
            query.close();
            return rc;
        }
        catch (SQLException e) {
            System.err.printf("SQL State %s\n", e.getSQLState());
            System.err.println(e);
            e.printStackTrace();
            return false;
        }
    }

    public boolean isTextTables() {
        return false;
    }

    public String getValueType() {
        return "VARCHAR(" + this.getValueSize() + ")";
    }

    public int getValueSize() {
        try {
            if (this.fConn == null || this.fConn.isClosed()) {
                throw new NullPointerException("Not connected to database");
            }
            Statement query = this.fConn.createStatement(1003, 1007);
            ResultSet rs = query.executeQuery("SELECT TOP 1 VAL FROM ENTRYVALS");
            ResultSetMetaData md = rs.getMetaData();
            int rc = md.getColumnDisplaySize(1);
            rs.close();
            query.close();
            return rc;
        }
        catch (SQLException e) {
            System.err.printf("SQL State %s\n", e.getSQLState());
            System.err.println(e);
            e.printStackTrace();
            return Integer.MAX_VALUE;
        }
    }

    public void setValueSize(int size) {
    }

    public int getCommentSize() {
        try {
            if (this.fConn == null || this.fConn.isClosed()) {
                throw new NullPointerException("Not connected to database");
            }
            Statement query = this.fConn.createStatement(1003, 1007);
            ResultSet rs = query.executeQuery("SELECT TOP 1 PRECOMMENT FROM ENTRYVALS");
            ResultSetMetaData md = rs.getMetaData();
            int rc = md.getColumnDisplaySize(1);
            rs.close();
            query.close();
            return rc;
        }
        catch (SQLException e) {
            System.err.printf("SQL State %s\n", e.getSQLState());
            System.err.println(e);
            e.printStackTrace();
            return Integer.MAX_VALUE;
        }
    }

    public boolean hasDictionary() throws SQLException {
        Statement query = this.fConn.createStatement(1003, 1007);
        ResultSet rs = query.executeQuery("SELECT VERSION FROM INFO");
        boolean rc = rs.next();
        rs.close();
        query.close();
        return rc;
    }

    public boolean isConnected() {
        try {
            if (this.fConn != null && !this.fConn.isClosed()) {
                return true;
            }
        }
        catch (SQLException e) {
            System.err.println(e);
            e.printStackTrace();
        }
        return false;
    }

    public void setConnection(Connection conn) {
        this.fConn = conn;
    }

    public Connection getConnection() {
        return this.fConn;
    }

    public boolean connect(boolean autocommit) {
        return this.open(autocommit);
    }

    public boolean open(boolean autocommit) {
        try {
            if (this.fConn != null && !this.fConn.isClosed()) {
                return true;
            }
            String str = this.fProps.getProperty("DB.Driver");
            if (str == null || str.equals("")) {
                System.err.println("No database driver");
                return false;
            }
            Class.forName(str);
            String url = this.fProps.getProperty("DB.Url");
            if (url == null || url.length() == 0) {
                System.err.println("No database URL");
                return false;
            }
            this.fConn = DriverManager.getConnection(url, this.fProps.getProperty("DB.User"), this.fProps.getProperty("DB.Password"));
            this.fConn.setAutoCommit(autocommit);
            return true;
        }
        catch (SQLException e) {
            System.err.println("Cannot connect to database");
            System.err.println(e);
            e.printStackTrace();
            return false;
        }
        catch (ClassNotFoundException e) {
            System.err.println("No database driver");
            System.err.println(e);
            e.printStackTrace();
            return false;
        }
    }

    public boolean disconnect() {
        return this.close();
    }

    public boolean close() {
        try {
            if (this.fConn == null || this.fConn.isClosed()) {
                return true;
            }
            if (!this.fConn.getAutoCommit()) {
                this.fConn.commit();
            }
            this.fConn.close();
            return true;
        }
        catch (SQLException e) {
            System.err.println(e);
            e.printStackTrace();
            return false;
        }
    }

    public Statement getQueryStatement() {
        try {
            return this.fConn.createStatement(1003, 1007);
        }
        catch (SQLException e) {
            System.err.println("Cannot create statement");
            System.err.println(e.getLocalizedMessage());
            e.printStackTrace();
            return null;
        }
    }

    public Statement getStatement() {
        try {
            return this.fConn.createStatement();
        }
        catch (SQLException e) {
            System.err.println("Cannot create statement");
            System.err.println(e.getLocalizedMessage());
            e.printStackTrace();
            return null;
        }
    }

    public PreparedStatement getPreparedStatement(String sql) {
        try {
            return this.fConn.prepareStatement(sql);
        }
        catch (SQLException e) {
            System.err.println("Cannot prepare statement");
            System.err.println(e.getLocalizedMessage());
            e.printStackTrace();
            return null;
        }
    }

    public PreparedStatement getPreparedQuery(String sql) {
        try {
            return this.fConn.prepareStatement(sql, 1003, 1007);
        }
        catch (SQLException e) {
            System.err.println("Cannot prepare statement");
            System.err.println(e.getLocalizedMessage());
            e.printStackTrace();
            return null;
        }
    }

    public int getIdValue(String table) {
        if (table == null || table.trim().length() < 1) {
            return -1;
        }
        table = table.trim().toUpperCase();
        try {
            int rc = -1;
            Statement query = this.fConn.createStatement(1003, 1007);
            ResultSet rs = query.executeQuery("SELECT MAX(ID) FROM " + table);
            if (rs.next()) {
                rc = rs.getInt(1);
            }
            rs.close();
            query.close();
            return rc;
        }
        catch (SQLException e) {
            System.err.println("HSQLdb.getIdValue():");
            System.err.println(e.getLocalizedMessage());
            e.printStackTrace();
            return -1;
        }
    }

    public int nextId(String table) {
        if (table == null || table.trim().length() < 1) {
            return -1;
        }
        table = table.trim().toUpperCase();
        try {
            int rc = -1;
            Statement query = this.fConn.createStatement(1003, 1007);
            ResultSet rs = query.executeQuery("SELECT MAX(ID) FROM " + table);
            if (rs.next()) {
                rc = rs.getInt(1);
            }
            rs.close();
            query.close();
            return rc + 1;
        }
        catch (SQLException e) {
            System.err.println("HSQLdb.getIdValue():");
            System.err.println(e.getLocalizedMessage());
            e.printStackTrace();
            return -1;
        }
    }
}

