/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.stardb;

import EDU.bmrb.lib.CreateDBSchema;
import EDU.bmrb.nmrstar.utils.StarToDb;
import EDU.bmrb.stardb.AddDictionaryInfo;
import EDU.bmrb.stardb.LoadEntry;
import EDU.bmrb.stardb.Star_DB;
import EDU.bmrb.stardb.Stardb;
import EDU.bmrb.stardb.UnparseToStarlib;
import EDU.bmrb.starlibj.BlockNode;
import EDU.bmrb.starlibj.StarUnparser;
import EDU.bmrb.validator.Config;
import EDU.bmrb.validator.Error;
import EDU.bmrb.validator.ErrorList;
import gnu.getopt.Getopt;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;

public class TestHSQLDB {
    public static final String DICT_SCHEMA = "Dictionary.schema";
    public static final String DICT_CONSTR = "Dictionary.constraints";

    public static void usage() {
        System.out.print("Usage: java EDU.bmrb.stardb.TestHSQLDB <-d FILE> ");
        System.out.println("[-c FILE] [-i FILE] [-o FILE] [-h]");
        System.out.println(" -d FILE: dictionary FILE");
        System.out.print(" -c FILE: config FILE, default: ~/");
        System.out.println("stardb.properties");
        System.out.println(" -i FILE: input FILE, default: stdin");
        System.out.println(" -o FILE: output FILE");
        System.out.println(" -h: print this message and exit");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        long now;
        long total = now = System.currentTimeMillis();
        Stardb star = null;
        ErrorList errs = null;
        boolean rc = true;
        try {
            int opt;
            Getopt g = new Getopt("TestHSQLDB", args, "d:c:i:o:h");
            String dictfile = null;
            String conffile = null;
            String infile = null;
            String outfile = null;
            block15: while ((opt = g.getopt()) != -1) {
                switch (opt) {
                    case 99: {
                        conffile = g.getOptarg();
                        continue block15;
                    }
                    case 100: {
                        dictfile = g.getOptarg();
                        continue block15;
                    }
                    case 105: {
                        infile = g.getOptarg();
                        continue block15;
                    }
                    case 111: {
                        outfile = g.getOptarg();
                        continue block15;
                    }
                }
                TestHSQLDB.usage();
                return;
            }
            if (dictfile == null) {
                System.err.println("No dictionary");
                TestHSQLDB.usage();
                return;
            }
            Config cf = conffile == null ? new Config() : new Config(conffile);
            star = new Star_DB(cf.getProperties());
            errs = new ErrorList(true);
            star.connect(false);
            Connection conn = star.getConnection();
            System.err.println("DB open: " + (System.currentTimeMillis() - now));
            now = System.currentTimeMillis();
            String str = star.getProperty(DICT_SCHEMA);
            if (str == null) {
                System.err.println("Error in properties file: no dictionary SQL script");
                return;
            }
            CreateDBSchema.runScript(conn, str, null);
            BufferedReader din = new BufferedReader(new FileReader(dictfile));
            StarToDb dl = new StarToDb(conn, null, errs);
            dl.load(din);
            din.close();
            dl = null;
            str = star.getProperty(DICT_CONSTR);
            if (str == null) {
                System.err.println("Error in properties file: no dictionary SQL script");
                return;
            }
            CreateDBSchema.runScript(conn, str, null);
            System.err.println("Dictionary loaded: " + (System.currentTimeMillis() - now));
            now = System.currentTimeMillis();
            InputStreamReader in = infile == null ? new InputStreamReader(System.in, "ISO-8859-15") : new InputStreamReader((InputStream)new FileInputStream(infile), "ISO-8859-15");
            LoadEntry ldr = new LoadEntry(star, errs);
            rc = ldr.load(in, true);
            if (rc) {
                star.getConnection().commit();
                System.err.println("Entry loaded: " + (System.currentTimeMillis() - now));
                now = System.currentTimeMillis();
                AddDictionaryInfo.addDictionaryInfo(star);
                if (!AddDictionaryInfo.checkVersion(star, null)) {
                    errs.add(new Error(false, -1, -1, 0, "NMR-STAR versions don't match!"));
                }
                System.err.println("Added dictionary overrides: " + (System.currentTimeMillis() - now));
                now = System.currentTimeMillis();
                BlockNode data = UnparseToStarlib.createDataNode(star, true);
                StarUnparser unp2 = outfile == null ? new StarUnparser(System.out) : new StarUnparser(new FileOutputStream(outfile + ".u2"));
                unp2.writeOut(data, 0);
                System.err.println("Unparse finished: " + (System.currentTimeMillis() - now));
                now = System.currentTimeMillis();
            }
            star.disconnect();
            System.err.println("DB closed: " + (System.currentTimeMillis() - now));
            System.err.println("Total: " + (System.currentTimeMillis() - total));
        }
        catch (Exception e) {
            System.err.println(e.getLocalizedMessage());
            e.printStackTrace();
            rc = false;
        }
        finally {
            if (star != null) {
                star.disconnect();
            }
            System.err.println("DB closed: " + (System.currentTimeMillis() - now));
            if (errs != null && errs.size() > 0) {
                errs.printErrors(System.out);
            }
            if (!rc) {
                System.exit(1);
            }
        }
    }
}

