/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.stardb;

import EDU.bmrb.nmrstar.utils.QuoteString;
import EDU.bmrb.stardb.AddComments;
import EDU.bmrb.stardb.LoopTable;
import EDU.bmrb.stardb.Star_DB;
import EDU.bmrb.stardb.Stardb;
import EDU.bmrb.stardb.sdbException;
import EDU.bmrb.validator.Error;
import EDU.bmrb.validator.ErrorList;
import gnu.getopt.Getopt;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class Unparse {
    public static final int TABWIDTH = 4;
    private ErrorList fErrs = null;
    private LoopTable fLoopTable = null;
    private Stardb fStar = null;
    private List fLoops = null;
    private PreparedStatement fTagStat = null;
    private PreparedStatement fTagSortStat = null;
    private PreparedStatement fTagUnsStat = null;
    private PreparedStatement fValStat = null;
    private PreparedStatement fCommentStat = null;
    private PreparedStatement fSfStat = null;
    private PreparedStatement fTagLenStat = null;
    private StringBuffer fBuf = null;
    private int fVerbose = 0;

    public Unparse(Stardb star) throws SQLException {
        this.fStar = star;
        this.fLoopTable = new LoopTable(star);
        this.fLoops = new ArrayList();
        this.fBuf = new StringBuffer();
        this.init();
    }

    public Unparse(Stardb star, ErrorList errs) throws SQLException {
        this.fStar = star;
        this.fErrs = errs;
        this.fLoopTable = new LoopTable(star, errs);
        this.fLoops = new ArrayList();
        this.fBuf = new StringBuffer();
        this.init();
    }

    public Unparse(LoopTable loop) throws SQLException {
        this.fLoopTable = loop;
        this.fStar = loop.getStar();
        this.fErrs = loop.getErrs();
        this.fLoops = new ArrayList();
        this.fBuf = new StringBuffer();
        this.init();
    }

    public void init() throws SQLException {
        this.fTagStat = this.fStar.getPreparedStatement("SELECT NAME FROM ENTRYTAGS WHERE LOOPID IS NULL AND SFID = ?");
        this.fTagSortStat = this.fStar.getPreparedStatement("SELECT ID, LOOPID, NAME, PRECOMMENT FROM ENTRYTAGS WHERE SFID = ? ORDER BY SEQ");
        this.fTagUnsStat = this.fStar.getPreparedStatement("SELECT ID, LOOPID, NAME, PRECOMMENT FROM ENTRYTAGS WHERE SFID = ? ORDER BY LINE");
        this.fValStat = this.fStar.getPreparedStatement("SELECT VAL, DELIMITER, PRECOMMENT FROM ENTRYVALS WHERE TAGID = ?");
    }

    public void finalize() {
        try {
            this.fTagStat.close();
            this.fTagSortStat.close();
            this.fTagUnsStat.close();
            this.fValStat.close();
            this.fCommentStat.close();
            this.fLoops.clear();
        }
        catch (Exception e) {
            System.err.println("DB exception while trying to close statements");
            System.err.println(e.getLocalizedMessage());
            e.printStackTrace();
        }
    }

    public int getVerbose() {
        return this.fVerbose;
    }

    public void setVerbose(int verbose) {
        this.fVerbose = verbose;
    }

    public void print(PrintWriter out) throws SQLException, sdbException {
        if (this.fStar.getAddComments()) {
            AddComments ac = new AddComments(this.fStar);
            ac.addComments(false);
        }
        this.unparse(out);
    }

    public void unparse(PrintWriter out) throws SQLException, sdbException {
        this.fLoops.clear();
        Statement query = this.fStar.getQueryStatement();
        ResultSet rs = null;
        if (this.fVerbose > 2) {
            System.err.println("Line 285");
        }
        rs = query.executeQuery("SELECT NAME,PRECOMMENT FROM ENTRYINFO");
        if (this.fVerbose > 2) {
            System.err.println("Line 287");
        }
        if (!rs.next()) {
            throw new sdbException("Nothing to unparse");
        }
        rs.getString(2);
        if (!rs.wasNull()) {
            out.println(rs.getString(2));
        }
        out.print("data_");
        out.println(rs.getString(1));
        out.println();
        this.fBuf.setLength(0);
        this.fBuf.append("SELECT NAME,PRECOMMENT,ID,SEQ,LINE FROM ENTRYSFS");
        if (this.fStar.getSortTags()) {
            this.fBuf.append(" ORDER BY SEQ,LINE");
        } else {
            this.fBuf.append(" ORDER BY LINE");
        }
        rs = query.executeQuery(this.fBuf.toString());
        while (rs.next()) {
            rs.getString(2);
            if (!rs.wasNull()) {
                out.println(rs.getString(2));
                out.println();
            }
            this.printSaveFrame(out, rs.getString(1), rs.getInt(3));
        }
        out.flush();
        rs.close();
        query.close();
    }

    public void printSaveFrame(PrintWriter out, String name, int id) throws SQLException, sdbException {
        int length;
        long now = 0L;
        if (this.fVerbose > 1) {
            now = System.currentTimeMillis();
        }
        ResultSet rs = null;
        out.print("save_");
        out.println(name);
        int loopid = -1;
        int tagid = -1;
        int valoffset = 0;
        if (this.fTagLenStat == null) {
            this.fTagLenStat = this.fStar.getPreparedStatement("SELECT MAX(LENGTH(NAME)) FROM ENTRYTAGS WHERE LOOPID IS NULL AND SFID=?");
        }
        this.fTagLenStat.setInt(1, id);
        rs = this.fTagLenStat.executeQuery();
        if (rs.next() && (length = rs.getInt(1)) > valoffset) {
            valoffset = length;
        }
        valoffset += 4;
        if (this.fSfStat == null) {
            this.fSfStat = this.fStar.getPreparedStatement("SELECT ID,LOOPID,NAME,PRECOMMENT,SEQ,LINE FROM ENTRYTAGS WHERE SFID=? ORDER BY SEQ,LINE");
        }
        this.fSfStat.setInt(1, id);
        rs = this.fSfStat.executeQuery();
        while (rs.next()) {
            loopid = rs.getInt(2);
            if (rs.wasNull()) {
                int i;
                rs.getString(4);
                if (!rs.wasNull()) {
                    out.println(rs.getString(4));
                    out.println();
                }
                for (i = 0; i < 4; ++i) {
                    out.print(" ");
                }
                out.print(rs.getString(3));
                for (i = rs.getString(3).length(); i < valoffset; ++i) {
                    out.print(' ');
                }
                this.printValue(out, rs.getInt(1));
                out.println();
                continue;
            }
            this.printLoop(out, loopid);
        }
        out.println("save_");
        out.println();
        rs.close();
        if (this.fVerbose > 1) {
            System.err.print(name);
            System.err.print(':');
            System.err.println(System.currentTimeMillis() - now);
        }
    }

    public void printLoop(PrintWriter out, int id) throws SQLException, sdbException {
        long now = 0L;
        if (this.fVerbose > 1) {
            now = System.currentTimeMillis();
        }
        for (int i = 0; i < this.fLoops.size(); ++i) {
            if ((Integer)this.fLoops.get(i) != id) continue;
            return;
        }
        this.fLoops.add(new Integer(id));
        if (this.fVerbose > 1) {
            System.err.print("Loop ");
            System.err.println(id);
        }
        this.fLoopTable.setLoopId(id);
        if (!this.fLoopTable.load()) {
            throw new sdbException("Cannot load loop into temp. table");
        }
        if (this.fVerbose > 1) {
            System.err.print(" table loaded : ");
            System.err.print(System.currentTimeMillis() - now);
            now = System.currentTimeMillis();
        }
        this.fLoopTable.print(out);
        if (this.fVerbose > 1) {
            System.err.print(" printed : ");
            System.err.println(System.currentTimeMillis() - now);
        }
        out.flush();
    }

    public void printValue(PrintWriter out, int id) throws SQLException, sdbException {
        ResultSet rs;
        if (this.fCommentStat == null) {
            this.fCommentStat = this.fStar.getPreparedStatement("SELECT VAL,DELIMITER,PRECOMMENT FROM ENTRYVALS WHERE TAGID=?");
        }
        this.fCommentStat.setInt(1, id);
        if (this.fVerbose > 2) {
            System.err.println(this.fCommentStat);
        }
        if (!(rs = this.fCommentStat.executeQuery()).next()) {
            if (this.fErrs != null) {
                this.fErrs.add(new Error(true, -1, -1, -1, "No value!"));
            }
            throw new sdbException("No value to print!");
        }
        rs.getString(3);
        if (!rs.wasNull()) {
            out.println();
            out.println(rs.getString(3));
        }
        String val = rs.getString(1);
        if (rs.wasNull()) {
            val = ".";
        } else {
            int sep = rs.getInt(2);
            this.fBuf.setLength(0);
            if (sep == 12) {
                if (!val.equals("?") && !val.equals(".")) {
                    this.fBuf.append('$');
                }
                this.fBuf.append(val.replaceAll("\\s+", "_"));
                val = this.fBuf.toString();
            } else if (sep == 11) {
                this.fBuf.append("\n;\n");
                this.fBuf.append(val);
                this.fBuf.append("\n;");
                val = this.fBuf.toString();
            } else {
                val = QuoteString.quoteForSTAR(val);
            }
        }
        out.print(val);
        rs.close();
    }

    public static void usage() {
        System.out.println("Usage: java EDU.bmrb.stardb.Unparse [-h] [-c FILE] [-o FILE] [-m] [-s] [-v]");
        System.out.println("   -h: print this usage summary");
        System.out.println("   -c FILE: use config file FILE instead of ~/stardb.properties");
        System.out.println("   -o FILE: output file (default: stdout)");
        System.out.println("   -m: add standard comments");
        System.out.println("   -s: sort tags by sequence number");
        System.out.println("   -v: verbose (use multiple -v's to see more debugging messages)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        long now = System.currentTimeMillis();
        boolean error = false;
        ErrorList errs = null;
        try {
            int opt;
            String conffile = null;
            String outfile = null;
            boolean sort = false;
            boolean index = false;
            boolean atom_sort = false;
            boolean add_comments = false;
            int verbose = 0;
            Getopt g = new Getopt("Unparse", args, "c:o:ahimsv");
            block15: while ((opt = g.getopt()) != -1) {
                switch (opt) {
                    case 97: {
                        atom_sort = true;
                        continue block15;
                    }
                    case 99: {
                        conffile = g.getOptarg();
                        continue block15;
                    }
                    case 105: {
                        index = true;
                        continue block15;
                    }
                    case 109: {
                        add_comments = true;
                        continue block15;
                    }
                    case 111: {
                        outfile = g.getOptarg();
                        continue block15;
                    }
                    case 115: {
                        sort = true;
                        continue block15;
                    }
                    case 118: {
                        ++verbose;
                        continue block15;
                    }
                }
                Unparse.usage();
                return;
            }
            Star_DB star = conffile == null ? new Star_DB() : new Star_DB(conffile);
            star.connect(false);
            if (verbose > 0) {
                System.err.println("DB open: " + (System.currentTimeMillis() - now));
                now = System.currentTimeMillis();
            }
            star.setSortTags(sort);
            star.setReindexLoops(index);
            star.setSortAtoms(atom_sort);
            star.setAddComments(add_comments);
            PrintWriter out = outfile == null ? new PrintWriter(new OutputStreamWriter((OutputStream)System.out, "ISO-8859-15")) : new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outfile), "ISO-8859-15"));
            errs = new ErrorList();
            LoopTable lt = new LoopTable(star, errs);
            lt.setVerbose(verbose);
            Unparse unp = new Unparse(lt);
            unp.setVerbose(verbose);
            unp.unparse(out);
            if (verbose > 0) {
                System.err.println("Unparse finished: " + (System.currentTimeMillis() - now));
                now = System.currentTimeMillis();
            }
            out.close();
            star.disconnect();
            if (verbose > 0) {
                System.err.println("DB closed: " + (System.currentTimeMillis() - now));
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            error = true;
        }
        finally {
            if (errs != null) {
                errs.printErrors(System.out);
            }
            if (error) {
                System.exit(1);
            }
        }
    }
}

