/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.stardb;

import EDU.bmrb.nmrstar.utils.QuoteString;
import EDU.bmrb.stardb.Star_DB;
import EDU.bmrb.stardb.Stardb;
import EDU.bmrb.starlibj.BlockNode;
import EDU.bmrb.starlibj.DataItemNode;
import EDU.bmrb.starlibj.DataLoopNameListNode;
import EDU.bmrb.starlibj.DataLoopNode;
import EDU.bmrb.starlibj.DataNameNode;
import EDU.bmrb.starlibj.DataValueNode;
import EDU.bmrb.starlibj.LoopNameListNode;
import EDU.bmrb.starlibj.LoopRowNode;
import EDU.bmrb.starlibj.LoopTableNode;
import EDU.bmrb.starlibj.SaveFrameNode;
import EDU.bmrb.starlibj.StarUnparser;
import gnu.getopt.Getopt;
import java.io.FileOutputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class UnparseToStarlib {
    private static final boolean DEBUG = false;

    public static short getDelim(int delim) {
        switch (delim) {
            case 10: {
                return DataValueNode.DOUBLE;
            }
            case 12: {
                return DataValueNode.FRAMECODE;
            }
            case 13: {
                return DataValueNode.NON;
            }
            case 11: {
                return DataValueNode.SEMICOLON;
            }
            case 9: {
                return DataValueNode.SINGLE;
            }
        }
        return DataValueNode.NON;
    }

    public static DataLoopNode createLoopNode(Stardb star, int loopid, boolean strip_sfids) throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT NAME,PRECOMMENT,SEQ,ID FROM ENTRYTAGS WHERE LOOPID=");
        sql.append(loopid);
        if (strip_sfids) {
            sql.append(" AND (SEQ NOT IN (SELECT SEQ FROM TAGS WHERE SFIDFLAG='Y') OR SEQ IS NULL)");
        }
        if (star.getSortTags()) {
            sql.append(" ORDER BY SEQ,ID");
        } else {
            sql.append(" ORDER BY LINE,ID");
        }
        Statement query = star.getQueryStatement();
        ResultSet rs = query.executeQuery(sql.toString());
        LoopNameListNode namelist = new LoopNameListNode();
        while (rs.next()) {
            DataNameNode tag = new DataNameNode(rs.getString(1));
            rs.getString(2);
            if (!rs.wasNull()) {
                tag.setPreComment(rs.getString(2) + "\n");
            }
            namelist.addElement(tag);
        }
        DataLoopNameListNode names = new DataLoopNameListNode();
        names.addElement(namelist);
        LoopTableNode values = new LoopTableNode(true);
        LoopRowNode row = null;
        int rownum = -1;
        sql.setLength(0);
        sql.append("SELECT VAL,PRECOMMENT,DELIMITER,LOOPROW,SEQ,TAGID FROM ENTRYVALS ");
        sql.append("WHERE LOOPID=");
        sql.append(loopid);
        if (strip_sfids) {
            sql.append(" AND (SEQ NOT IN (SELECT SEQ FROM TAGS WHERE SFIDFLAG='Y') OR SEQ IS NULL)");
        }
        if (star.getSortTags()) {
            sql.append(" ORDER BY LOOPROW,SEQ,ID");
        } else {
            sql.append(" ORDER BY LOOPROW,TAGID");
        }
        rs = query.executeQuery(sql.toString());
        while (rs.next()) {
            if (rownum != rs.getInt(4)) {
                if (row != null) {
                    values.addElement(row);
                }
                row = new LoopRowNode();
                rownum = rs.getInt(4);
            }
            rs.getString(1);
            DataValueNode val = rs.wasNull() ? new DataValueNode(".", DataValueNode.NON) : (rs.getString(1).equals(".") || rs.getString(1).equals("?") ? new DataValueNode(rs.getString(1), DataValueNode.NON) : (rs.getString(1).trim().length() < 1 ? new DataValueNode("?", DataValueNode.NON) : (rs.getInt(3) == 11 || rs.getInt(3) == 12 ? new DataValueNode(rs.getString(1), UnparseToStarlib.getDelim(rs.getInt(3))) : new DataValueNode(rs.getString(1), UnparseToStarlib.getDelim(QuoteString.findSTARQuoteStyle(rs.getString(1)))))));
            rs.getString(2);
            if (!rs.wasNull()) {
                val.setPreComment(rs.getString(2) + "\n");
            }
            row.addElement(val);
        }
        if (row != null) {
            values.addElement(row);
        }
        DataLoopNode loop = new DataLoopNode(names, values);
        sql.setLength(0);
        sql.append("SELECT PRECOMMENT FROM ENTRYLOOPS WHERE ID=");
        sql.append(loopid);
        rs = query.executeQuery(sql.toString());
        if (rs.next()) {
            rs.getString(1);
            if (!rs.wasNull()) {
                loop.setPreComment(rs.getString(1) + "\n");
            }
        }
        rs.close();
        query.close();
        return loop;
    }

    public static SaveFrameNode createSaveframeNode(Stardb star, String name, int sfid, boolean strip_sfids, String comment) throws SQLException {
        SaveFrameNode save = new SaveFrameNode(name);
        if (comment != null) {
            save.setPreComment(comment + "\n");
        }
        ArrayList<Integer> loopid = new ArrayList<Integer>();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT t.NAME,t.PRECOMMENT,v.VAL,v.PRECOMMENT,v.DELIMITER,");
        sql.append("t.LOOPID,t.SEQ,t.LINE,t.ID FROM ENTRYTAGS t,ENTRYVALS v WHERE t.SFID=");
        sql.append(sfid);
        if (strip_sfids) {
            sql.append(" AND (t.SEQ NOT IN (SELECT SEQ FROM TAGS WHERE SFIDFLAG='Y') OR t.SEQ IS NULL)");
        }
        sql.append(" AND t.ID=v.TAGID");
        if (star.getSortTags()) {
            sql.append(" ORDER BY t.SEQ,t.ID");
        } else {
            sql.append(" ORDER BY t.LINE,t.ID");
        }
        Statement query = star.getQueryStatement();
        ResultSet rs = query.executeQuery(sql.toString());
        while (rs.next()) {
            DataItemNode item;
            boolean found = false;
            rs.getInt(6);
            if (!rs.wasNull()) {
                for (int i = 0; i < loopid.size(); ++i) {
                    if (((Integer)loopid.get(i)).intValue() != rs.getInt(6)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                loopid.add(new Integer(rs.getInt(6)));
                save.addElement(UnparseToStarlib.createLoopNode(star, rs.getInt(6), strip_sfids));
                continue;
            }
            rs.getString(3);
            if (rs.wasNull()) {
                item = new DataItemNode(rs.getString(1), ".", DataValueNode.NON);
            } else if (rs.getString(3).equals(".") || rs.getString(3).equals("?")) {
                item = new DataItemNode(rs.getString(1), rs.getString(3), DataValueNode.NON);
            } else if (rs.getString(1).equals("_Entity.Polymer_seq_one_letter_code") || rs.getString(1).equals("_Entity.Polymer_seq_one_letter_code_can")) {
                rs.getString(3);
                if (!rs.wasNull() && rs.getString(3).trim().length() > 0) {
                    String tmp = rs.getString(3).replaceAll("\\n", "");
                    tmp = tmp.replaceAll("\\s+", "");
                    sql.setLength(0);
                    for (int i = 0; i < tmp.length(); ++i) {
                        sql.append(tmp.charAt(i));
                        if ((i + 1) % 20 != 0) continue;
                        sql.append("\n");
                    }
                    item = new DataItemNode(rs.getString(1), sql.toString(), DataValueNode.SEMICOLON);
                } else {
                    item = new DataItemNode(rs.getString(1), ".", DataValueNode.NON);
                }
            } else {
                item = rs.getInt(5) == 11 || rs.getInt(5) == 12 ? new DataItemNode(rs.getString(1), rs.getString(3), UnparseToStarlib.getDelim(rs.getInt(5))) : new DataItemNode(rs.getString(1), rs.getString(3), UnparseToStarlib.getDelim(QuoteString.findSTARQuoteStyle(rs.getString(3))));
            }
            rs.getString(2);
            if (!rs.wasNull()) {
                item.getNameNode().setPreComment(rs.getString(2) + "\n");
            }
            rs.getString(4);
            if (!rs.wasNull()) {
                item.getValueNode().setPreComment(rs.getString(4) + "\n");
            }
            save.addElement(item);
        }
        rs.close();
        query.close();
        loopid.clear();
        return save;
    }

    public static BlockNode createDataNode(Stardb star, boolean strip_sfids) throws SQLException {
        StringBuffer sql = new StringBuffer("SELECT NAME,PRECOMMENT FROM ENTRYINFO");
        Statement query = star.getQueryStatement();
        ResultSet rs = query.executeQuery(sql.toString());
        rs.next();
        sql.setLength(0);
        sql.append("data_");
        sql.append(rs.getString(1));
        BlockNode data = new BlockNode(sql.toString());
        rs.getString(2);
        if (!rs.wasNull()) {
            data.setPreComment(rs.getString(2) + "\n");
        }
        sql.setLength(0);
        sql.append("SELECT ID,NAME,PRECOMMENT,SEQ,LINE FROM ENTRYSFS");
        if (star.getSortTags()) {
            sql.append(" ORDER BY SEQ,ID");
        } else {
            sql.append(" ORDER BY ID");
        }
        rs = query.executeQuery(sql.toString());
        while (rs.next()) {
            sql.setLength(0);
            sql.append("save_");
            sql.append(rs.getString(2));
            String str = rs.getString(3);
            if (rs.wasNull()) {
                str = null;
            }
            SaveFrameNode save = UnparseToStarlib.createSaveframeNode(star, sql.toString(), rs.getInt(1), strip_sfids, str);
            data.addElement(save);
        }
        rs.close();
        query.close();
        return data;
    }

    public static void usage() {
        System.out.println("Usage: java EDU.bmrb.stardb.UnparseToStarlib [-h] [-c FILE] [-o FILE] [-r] [-s]");
        System.out.println("   -h: print this usage summary");
        System.out.println("   -c FILE: use config file FILE instead of ~/validator.properties");
        System.out.println("   -o FILE: output file (default: stdout)");
        System.out.println("   -r: \"release\" output: do not strip Sf_ID tags");
        System.out.println("   -s: sort saveframes and tags by dictionary sequence");
    }

    public static void main(String[] args) {
        long now = System.currentTimeMillis();
        try {
            int opt;
            String conffile = null;
            String outfile = null;
            boolean strip_sfids = true;
            boolean sort = false;
            Getopt g = new Getopt("Unparse", args, "c:o:hrsi");
            block9: while ((opt = g.getopt()) != -1) {
                switch (opt) {
                    case 99: {
                        conffile = g.getOptarg();
                        continue block9;
                    }
                    case 111: {
                        outfile = g.getOptarg();
                        continue block9;
                    }
                    case 114: {
                        strip_sfids = false;
                        continue block9;
                    }
                    case 115: {
                        sort = true;
                        continue block9;
                    }
                    case 105: {
                        continue block9;
                    }
                }
                UnparseToStarlib.usage();
                return;
            }
            Star_DB star = conffile == null ? new Star_DB() : new Star_DB(conffile);
            star.setSortTags(sort);
            star.connect(false);
            System.err.println("DB open: " + (System.currentTimeMillis() - now));
            now = System.currentTimeMillis();
            BlockNode data = UnparseToStarlib.createDataNode(star, strip_sfids);
            star.disconnect();
            StarUnparser unp = outfile == null ? new StarUnparser(System.out) : new StarUnparser(new FileOutputStream(outfile));
            unp.writeOut(data, 0);
            System.err.println("Done: " + (System.currentTimeMillis() - now));
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
        }
    }
}

