/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.starlibj;

import EDU.bmrb.starlibj.BlockListVector;
import EDU.bmrb.starlibj.NameViolatesStarSyntax;
import EDU.bmrb.starlibj.SkipTextHandler;
import EDU.bmrb.starlibj.StarNode;
import EDU.bmrb.starlibj.StarValidity;
import EDU.bmrb.starlibj.VectorCheckType;
import EDU.bmrb.starlibj.WrongElementType;
import java.util.Enumeration;

public class BlockNode
extends StarNode
implements Cloneable {
    public SkipTextHandler skipper;
    protected BlockListVector myDataList;
    protected String myHeading;

    public BlockNode(String name) throws NameViolatesStarSyntax {
        if (!StarValidity.isValidBlockName(name)) {
            throw new NameViolatesStarSyntax(name, "Block Name");
        }
        this.myHeading = name;
        this.myDataList = new BlockListVector();
        this.skipper = null;
    }

    public BlockNode(BlockNode copyMe) {
        super(copyMe);
        this.myDataList = new BlockListVector();
        for (int i = 0; i < copyMe.size(); ++i) {
            this.addElement(copyMe.elementAt(i).clone());
        }
        this.myHeading = copyMe.myHeading == null ? null : new String(copyMe.myHeading);
        this.skipper = new SkipTextHandler(copyMe.mySkips());
    }

    public Object clone() {
        return new BlockNode(this);
    }

    public String getLabel() {
        return this.myHeading;
    }

    public void setLabel(String newName) throws NameViolatesStarSyntax {
        this.myHeading = newName;
        if (!StarValidity.isValidBlockName(newName)) {
            throw new NameViolatesStarSyntax(newName, "Block Name");
        }
    }

    public void setSize(int newSize) {
        this.myDataList.setSize(newSize);
    }

    public int size() {
        return this.myDataList.size();
    }

    public boolean isEmpty() {
        return this.myDataList.isEmpty();
    }

    public Enumeration elements() {
        return this.myDataList.elements();
    }

    public boolean contains(Object obj) {
        return this.myDataList.contains(obj);
    }

    public int indexOf(Object obj) {
        return this.myDataList.indexOf(obj);
    }

    public int indexOf(Object obj, int index) {
        return this.myDataList.indexOf(obj, index);
    }

    public int lastIndexOf(Object obj) {
        return this.myDataList.lastIndexOf(obj);
    }

    public int lastIndexOf(Object obj, int index) {
        return this.myDataList.lastIndexOf(obj, index);
    }

    public StarNode elementAt(int index) {
        return (StarNode)this.myDataList.elementAt(index);
    }

    public StarNode firstElement() {
        return (StarNode)this.myDataList.firstElement();
    }

    public StarNode lastElement() {
        return (StarNode)this.myDataList.lastElement();
    }

    public void setElementAt(Object obj, int index) throws WrongElementType {
        this.myDataList.setElementAt(obj, index);
        ((StarNode)this.myDataList.elementAt(index)).setParent(this);
    }

    public void removeElementAt(int index) {
        ((StarNode)this.myDataList.elementAt(index)).setParent(null);
        this.myDataList.removeElementAt(index);
    }

    public void insertElementAt(Object obj, int index) throws WrongElementType {
        this.myDataList.insertElementAt(obj, index);
        ((StarNode)this.myDataList.elementAt(index)).setParent(this);
    }

    public void addElement(Object obj) throws WrongElementType {
        this.myDataList.addElement(obj);
        ((StarNode)this.myDataList.lastElement()).setParent(this);
    }

    public boolean removeElement(Object obj) {
        ((StarNode)obj).setParent(null);
        return this.myDataList.removeElement(obj);
    }

    public VectorCheckType searchByName(String searchFor) {
        VectorCheckType retVal = new VectorCheckType();
        try {
            retVal.addType(Class.forName(StarValidity.clsNameStarNode));
            retVal.freezeTypes();
            if (this.getLabel().equalsIgnoreCase(searchFor)) {
                retVal.addElement(this);
            }
            for (int i = 0; i < this.myDataList.size(); ++i) {
                VectorCheckType tmpVect = ((StarNode)this.myDataList.elementAt(i)).searchByName(searchFor);
                for (int j = 0; j < tmpVect.size(); ++j) {
                    retVal.addElement(tmpVect.elementAt(j));
                }
            }
        }
        catch (ClassNotFoundException exc) {
            System.err.println("Should never happen exception: " + exc.getMessage());
            exc.printStackTrace();
        }
        return retVal;
    }

    public VectorCheckType searchByTagValue(String tag, String value) {
        VectorCheckType retVal = new VectorCheckType();
        try {
            retVal.addType(Class.forName(StarValidity.clsNameStarNode));
            retVal.freezeTypes();
            for (int i = 0; i < this.myDataList.size(); ++i) {
                VectorCheckType tmpVect = ((StarNode)this.myDataList.elementAt(i)).searchByTagValue(tag, value);
                for (int j = 0; j < tmpVect.size(); ++j) {
                    retVal.addElement(tmpVect.elementAt(j));
                }
            }
        }
        catch (ClassNotFoundException exc) {
            System.err.println("Should never happen exception: " + exc.getMessage());
            exc.printStackTrace();
        }
        return retVal;
    }

    public VectorCheckType searchForType(Class type, short delim) {
        VectorCheckType retVal = new VectorCheckType();
        try {
            retVal.addType(Class.forName(StarValidity.clsNameStarNode));
            retVal.freezeTypes();
            if (type.isInstance(this)) {
                retVal.addElement(this);
            }
            for (int i = 0; i < this.myDataList.size(); ++i) {
                VectorCheckType tmpVect = ((StarNode)this.myDataList.elementAt(i)).searchForType(type, delim);
                for (int j = 0; j < tmpVect.size(); ++j) {
                    retVal.addElement(tmpVect.elementAt(j));
                }
            }
        }
        catch (ClassNotFoundException exc) {
            System.err.println("Should never happen exception: " + exc.getMessage());
            exc.printStackTrace();
        }
        return retVal;
    }

    public void Unparse(int indent) {
    }

    public SkipTextHandler mySkips() {
        if (this.skipper != null) {
            return this.skipper;
        }
        this.skipper = new SkipTextHandler();
        return this.skipper;
    }
}

