/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.starlibj;

import EDU.bmrb.starlibj.BadValueForDelimiter;
import EDU.bmrb.starlibj.StarNode;
import EDU.bmrb.starlibj.StarValidity;
import EDU.bmrb.starlibj.VectorCheckType;

public class DataValueNode
extends StarNode
implements Cloneable {
    public static short DONT_CARE = (short)-1;
    public static short NON = 0;
    public static short DOUBLE = 1;
    public static short SINGLE = (short)2;
    public static short SEMICOLON = (short)3;
    public static short FRAMECODE = (short)4;
    protected String myStrVal;
    protected short delimType;

    public short getDelimType() {
        return this.delimType;
    }

    public void setDelimType(short setTo) throws BadValueForDelimiter {
        if (!StarValidity.isValidForDelim(this.myStrVal, setTo)) {
            throw new BadValueForDelimiter(this.myStrVal, setTo);
        }
        this.delimType = setTo;
    }

    public String getValue() {
        return this.myStrVal;
    }

    public void setValue(String newVal) throws BadValueForDelimiter {
        if (!StarValidity.isValidForDelim(newVal, this.delimType)) {
            throw new BadValueForDelimiter(newVal, this.delimType);
        }
        this.myStrVal = newVal;
    }

    public void setValue(String newVal, short newDelim) throws BadValueForDelimiter {
        if (!StarValidity.isValidForDelim(newVal, newDelim)) {
            throw new BadValueForDelimiter(newVal, newDelim);
        }
        this.myStrVal = newVal;
        this.delimType = newDelim;
    }

    public DataValueNode(String str) throws BadValueForDelimiter {
        short i;
        this.myStrVal = str;
        for (i = NON; i <= SEMICOLON; i = (short)(i + 1)) {
            if (!StarValidity.isValidForDelim(str, i)) continue;
            this.delimType = i;
            break;
        }
        if (i > SEMICOLON) {
            throw new BadValueForDelimiter(str, i);
        }
    }

    public DataValueNode(String str, short delim) throws BadValueForDelimiter {
        if (!StarValidity.isValidForDelim(str, delim)) {
            throw new BadValueForDelimiter(str, delim);
        }
        this.myStrVal = str;
        this.delimType = delim;
    }

    public DataValueNode(DataValueNode copyMe) {
        super(copyMe);
        this.myStrVal = copyMe.getValue() == null ? null : new String(copyMe.getValue());
        this.delimType = copyMe.getDelimType();
    }

    public Object clone() {
        return new DataValueNode(this);
    }

    public String getLabel() {
        return this.myStrVal;
    }

    public void Unparse(int indent) {
    }

    public int myLongestStr() {
        int retVal = this.myStrVal.length();
        if (this.delimType == NON) {
            ++retVal;
        } else if (this.delimType == SINGLE) {
            retVal += 2;
        } else if (this.delimType == DOUBLE) {
            retVal += 2;
        } else if (this.delimType == FRAMECODE) {
            ++retVal;
        } else if (this.delimType == SEMICOLON) {
            retVal += 4;
        }
        return retVal;
    }

    public VectorCheckType searchForType(Class type, short delim) {
        short i = delim;
        VectorCheckType retVal = new VectorCheckType();
        try {
            retVal.addType(Class.forName(StarValidity.clsNameStarNode));
            retVal.freezeTypes();
            if (type.isInstance(this) && (delim == this.getDelimType() || delim == DONT_CARE)) {
                retVal.addElement(this);
            }
        }
        catch (ClassNotFoundException exc) {
            System.err.println("Should never happen exception: " + exc.getMessage());
            exc.printStackTrace();
        }
        return retVal;
    }
}

