/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.starlibj;

import EDU.bmrb.starlibj.DataLoopNameListNode;
import EDU.bmrb.starlibj.DataLoopNode;
import EDU.bmrb.starlibj.DataNameNode;
import EDU.bmrb.starlibj.DataValueNode;
import EDU.bmrb.starlibj.StarNode;
import EDU.bmrb.starlibj.StarValidity;
import EDU.bmrb.starlibj.TagsVector;
import EDU.bmrb.starlibj.VectorCheckType;
import EDU.bmrb.starlibj.WrongElementType;
import java.util.Enumeration;

public class LoopNameListNode
extends StarNode
implements Cloneable {
    TagsVector nameList = new TagsVector();

    public LoopNameListNode() {
    }

    public LoopNameListNode(LoopNameListNode copyMe) {
        super(copyMe);
        for (int i = 0; i < copyMe.size(); ++i) {
            this.addElement(new DataNameNode(copyMe.elementAt(i)));
        }
    }

    public Object clone() {
        return new LoopNameListNode(this);
    }

    public void setSize(int newSize) {
        this.nameList.setSize(newSize);
    }

    public int size() {
        return this.nameList.size();
    }

    public boolean isEmpty() {
        return this.nameList.isEmpty();
    }

    public Enumeration elements() {
        return this.nameList.elements();
    }

    public boolean contains(Object obj) {
        return this.nameList.contains(obj);
    }

    public int indexOf(Object obj) {
        return this.nameList.indexOf(obj);
    }

    public int indexOf(Object obj, int index) {
        return this.nameList.indexOf(obj, index);
    }

    public int lastIndexOf(Object obj) {
        return this.nameList.lastIndexOf(obj);
    }

    public int lastIndexOf(Object obj, int index) {
        return this.nameList.lastIndexOf(obj, index);
    }

    public DataNameNode elementAt(int index) {
        return (DataNameNode)this.nameList.elementAt(index);
    }

    public DataNameNode firstElement() {
        return (DataNameNode)this.nameList.firstElement();
    }

    public DataNameNode lastElement() {
        return (DataNameNode)this.nameList.lastElement();
    }

    public void setElementAt(Object obj, int index) throws WrongElementType {
        this.nameList.setElementAt(obj, index);
        ((DataNameNode)this.nameList.elementAt(index)).setParent(this);
    }

    public void removeElementAt(int index) {
        ((DataNameNode)this.nameList.elementAt(index)).setParent(null);
        this.nameList.removeElementAt(index);
        int depth = this.getDepth();
        if (depth >= 0) {
            StarNode par;
            for (par = this; par != null && !(par instanceof DataLoopNode); par = par.getParent()) {
            }
            if (par != null) {
                ((DataLoopNode)par).getVals().removeColumnAtDepth(depth, index);
            }
        }
    }

    public void insertElementAt(Object obj, int index) throws WrongElementType {
        this.insertElementAt(obj, index, new DataValueNode("."));
    }

    public void insertElementAt(Object obj, int index, DataValueNode val) throws WrongElementType {
        this.nameList.insertElementAt(obj, index);
        ((DataNameNode)this.nameList.elementAt(index)).setParent(this);
        int depth = this.getDepth();
        if (depth >= 0) {
            StarNode par;
            for (par = this; par != null && !(par instanceof DataLoopNode); par = par.getParent()) {
            }
            if (par != null) {
                ((DataLoopNode)par).getVals().insertColumnAtDepth(depth, index, val);
            }
        }
    }

    public void addElement(Object obj) throws WrongElementType {
        this.insertElementAt(obj, this.size());
    }

    public void addElement(Object obj, DataValueNode val) throws WrongElementType {
        this.insertElementAt(obj, this.size(), val);
    }

    public void removeElement(Object obj) {
        int idx = this.indexOf(obj);
        this.removeElementAt(idx);
    }

    public int getDepth() {
        StarNode par = this.getParent();
        if (par == null) {
            return -1;
        }
        return ((DataLoopNameListNode)par).indexOf(this);
    }

    public String getLabel() {
        if (this.nameList.size() > 0) {
            return ((DataNameNode)this.nameList.elementAt(0)).getLabel();
        }
        return null;
    }

    public VectorCheckType searchByName(String searchFor) {
        VectorCheckType retVal = new VectorCheckType();
        try {
            retVal.addType(Class.forName(StarValidity.clsNameStarNode));
            retVal.freezeTypes();
            for (int i = 0; i < this.nameList.size(); ++i) {
                if (!((DataNameNode)this.nameList.elementAt(i)).getLabel().equalsIgnoreCase(searchFor)) continue;
                retVal.addElement(this.nameList.elementAt(i));
            }
        }
        catch (ClassNotFoundException exc) {
            System.err.println("Should never happen exception: " + exc.getMessage());
            exc.printStackTrace();
            return null;
        }
        return retVal;
    }

    public VectorCheckType searchForType(Class type) {
        VectorCheckType retVal = new VectorCheckType();
        try {
            retVal.addType(Class.forName(StarValidity.clsNameStarNode));
            retVal.freezeTypes();
            if (type.isInstance(this)) {
                retVal.addElement(this);
            }
            if (type == Class.forName(StarValidity.clsNameDataNameNode)) {
                for (int i = 0; i < this.nameList.size(); ++i) {
                    retVal.addElement(this.nameList.elementAt(i));
                }
            }
        }
        catch (ClassNotFoundException exc) {
            System.err.println("Should never happen exception: " + exc.getMessage());
            exc.printStackTrace();
            return null;
        }
        return retVal;
    }

    public void Unparse(int indent) {
    }
}

