/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.starlibj;

import EDU.bmrb.starlibj.DataValueNode;
import EDU.bmrb.starlibj.ParseValFromRetVal;
import EDU.bmrb.starlibj.StarNode;

public class StarValidity {
    private static String packageNameStatic = null;
    public static String clsNameASCII_CharStream = "EDU.bmrb.starlibj.ASCII_CharStream";
    public static String clsNameBadValueForDelimiter = "EDU.bmrb.starlibj.BadValueForDelimiter";
    public static String clsNameBlockListVector = "EDU.bmrb.starlibj.BlockListVector";
    public static String clsNameBlockNode = "EDU.bmrb.starlibj.BlockNode";
    public static String clsNameCharStream = "EDU.bmrb.starlibj.CharStream";
    public static String clsNameDataItemNode = "EDU.bmrb.starlibj.DataItemNode";
    public static String clsNameDataLoopNameListNode = "EDU.bmrb.starlibj.DataLoopNameListNode";
    public static String clsNameDataLoopNode = "EDU.bmrb.starlibj.DataLoopNode";
    public static String clsNameDataNameNode = "EDU.bmrb.starlibj.DataNameNode";
    public static String clsNameDataValueNode = "EDU.bmrb.starlibj.DataValueNode";
    public static String clsNameDataValuesVector = "EDU.bmrb.starlibj.DataValuesVector";
    public static String clsNameHomemadeStringBuffer = "EDU.bmrb.starlibj.HomemadeStringBuffer";
    public static String clsNameInternalException = "EDU.bmrb.starlibj.InternalException";
    public static String clsNameLoopNameListNode = "EDU.bmrb.starlibj.LoopNameListNode";
    public static String clsNameLoopRowNode = "EDU.bmrb.starlibj.LoopRowNode";
    public static String clsNameLoopRowsVector = "EDU.bmrb.starlibj.LoopRowsVector";
    public static String clsNameLoopTableNode = "EDU.bmrb.starlibj.LoopTableNode";
    public static String clsNameNameListVector = "EDU.bmrb.starlibj.NameListVector";
    public static String clsNameNameViolatesStarSyntax = "EDU.bmrb.starlibj.NameViolatesStarSyntax";
    public static String clsNameOperationCausesMismatchedLoopData = "EDU.bmrb.starlibj.OperationCausesMismatchedLoopData";
    public static String clsNameParseException = "EDU.bmrb.starlibj.ParseException";
    public static String clsNameParseValFromRetVal = "EDU.bmrb.starlibj.ParseValFromRetVal";
    public static String clsNameRemoteInt = "EDU.bmrb.starlibj.RemoteInt";
    public static String clsNameSaveFrameNode = "EDU.bmrb.starlibj.SaveFrameNode";
    public static String clsNameSaveListVector = "EDU.bmrb.starlibj.SaveListVector";
    public static String clsNameStarFileNode = "EDU.bmrb.starlibj.StarFileNode";
    public static String clsNameStarListVector = "EDU.bmrb.starlibj.StarListVector";
    public static String clsNameStarNode = "EDU.bmrb.starlibj.StarNode";
    public static String clsNameStarParser = "EDU.bmrb.starlibj.StarParser";
    public static String clsNameStarParserConstants = "EDU.bmrb.starlibj.StarParserConstants";
    public static String clsNameStarParserTokenManager = "EDU.bmrb.starlibj.StarParserTokenManager";
    public static String clsNameStarUnparser = "EDU.bmrb.starlibj.StarUnparser";
    public static String clsNameStarValidity = "EDU.bmrb.starlibj.StarValidity";
    public static String clsNameStarVectorLike = "EDU.bmrb.starlibj.StarVectorLike";
    public static String clsNameTagsVector = "EDU.bmrb.starlibj.TagsVector";
    public static String clsNameTinyAbsDataValueNode = "EDU.bmrb.starlibj.TinyAbsDataValueNode";
    public static String clsNameTinyRelDataValueNode = "EDU.bmrb.starlibj.TinyRelDataValueNode";
    public static String clsNameToken = "EDU.bmrb.starlibj.Token";
    public static String clsNameTokenMgrError = "EDU.bmrb.starlibj.TokenMgrError";
    public static String clsNameTypesAreFrozen = "EDU.bmrb.starlibj.TypesAreFrozen";
    public static String clsNameTypesNotFrozenYet = "EDU.bmrb.starlibj.TypesNotFrozenYet";
    public static String clsNameVectorCheckType = "EDU.bmrb.starlibj.VectorCheckType";
    public static String clsNameWrongElementType = "EDU.bmrb.starlibj.WrongElementType";

    public static String pkgName() {
        if (packageNameStatic == null) {
            StarNode dummyObj = new StarNode();
            String className = dummyObj.getClass().getName();
            packageNameStatic = className.substring(0, className.lastIndexOf(46));
        }
        return packageNameStatic;
    }

    public static boolean isValidTagName(String s) {
        if (s.charAt(0) != '_') {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (!Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidSaveName(String s) {
        if (!s.substring(0, 5).equals("save_")) {
            return false;
        }
        if (s.length() <= 5) {
            return false;
        }
        for (int i = 5; i < s.length(); ++i) {
            if (!Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidBlockName(String s) {
        if (s.equals("global_")) {
            return true;
        }
        if (!s.substring(0, 5).equals("data_")) {
            return false;
        }
        if (s.length() <= 5) {
            return false;
        }
        for (int i = 5; i < s.length(); ++i) {
            if (!Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidValueForNonDelim(String s) {
        if (s.length() == 0) {
            return false;
        }
        if (s.charAt(0) == '\'') {
            return false;
        }
        if (s.charAt(0) == '\"') {
            return false;
        }
        if (s.charAt(0) == '$') {
            return false;
        }
        if (s.charAt(0) == '_') {
            return false;
        }
        if (s.charAt(0) == '#') {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (!Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return !s.toLowerCase().startsWith("data_") && !s.toLowerCase().startsWith("save_") && !s.toLowerCase().equals("global_") && !s.toLowerCase().equals("loop_") && !s.toLowerCase().equals("stop_");
    }

    public static boolean isValidValueForSingleDelim(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == '\n' || s.charAt(i) == '\r') {
                return false;
            }
            if (s.charAt(i) != '\'') continue;
            if (i < s.length() - 1) {
                if (s.charAt(i + 1) != ' ') continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public static boolean isValidValueForDoubleDelim(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == '\n' || s.charAt(i) == '\r') {
                return false;
            }
            if (s.charAt(i) != '\"') continue;
            if (i < s.length() - 1) {
                if (s.charAt(i + 1) != ' ') continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public static boolean isValidValueForFrameCodeDelim(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (!Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidForDelim(String s, int delim) {
        if (delim == DataValueNode.NON) {
            return StarValidity.isValidValueForNonDelim(s);
        }
        if (delim == DataValueNode.DOUBLE) {
            return StarValidity.isValidValueForDoubleDelim(s);
        }
        if (delim == DataValueNode.SINGLE) {
            return StarValidity.isValidValueForSingleDelim(s);
        }
        if (delim == DataValueNode.SEMICOLON) {
            return true;
        }
        if (delim == DataValueNode.FRAMECODE) {
            return StarValidity.isValidValueForFrameCodeDelim(s);
        }
        return false;
    }

    public static short getValidDelimFor(String s) {
        if (StarValidity.isValidValueForNonDelim(s)) {
            return DataValueNode.NON;
        }
        if (StarValidity.isValidValueForDoubleDelim(s)) {
            return DataValueNode.DOUBLE;
        }
        if (StarValidity.isValidValueForSingleDelim(s)) {
            return DataValueNode.SINGLE;
        }
        return DataValueNode.SEMICOLON;
    }

    public static ParseValFromRetVal parseValFrom(String str, boolean makeNew) {
        int idx = 0;
        boolean inLeadingWhitespace = true;
        boolean inNonQuoted = false;
        boolean inFramecode = false;
        boolean inSingle = false;
        boolean inDouble = false;
        boolean inSemicolon = false;
        boolean reachedEnd = false;
        int startIdx = 0;
        int endIdx = 0;
        int nextIdx = 0;
        boolean found = false;
        boolean rowOffset = false;
        boolean colOffset = false;
        while (!reachedEnd) {
            if (idx >= str.length()) {
                reachedEnd = true;
                nextIdx = endIdx = idx;
                continue;
            }
            if (inLeadingWhitespace) {
                if (Character.isWhitespace(str.charAt(idx))) {
                    ++idx;
                    continue;
                }
                inLeadingWhitespace = false;
                found = true;
                char curChar = str.charAt(idx);
                if (curChar == '\"') {
                    inDouble = true;
                    startIdx = ++idx;
                    continue;
                }
                if (curChar == '\'') {
                    inSingle = true;
                    startIdx = ++idx;
                    continue;
                }
                if (curChar == ';') {
                    inSemicolon = true;
                    ++idx;
                    while (str.charAt(idx) == '\n' || str.charAt(idx) == '\r') {
                        ++idx;
                    }
                    startIdx = idx;
                    continue;
                }
                if (curChar == '$') {
                    inFramecode = true;
                    startIdx = ++idx;
                    continue;
                }
                inNonQuoted = true;
                startIdx = idx++;
                continue;
            }
            if (inDouble && str.charAt(idx) == '\"') {
                reachedEnd = true;
                endIdx = idx;
                nextIdx = idx + 1;
                continue;
            }
            if (inSingle && str.charAt(idx) == '\'') {
                reachedEnd = true;
                endIdx = idx;
                nextIdx = idx + 1;
                continue;
            }
            if (inSemicolon && str.charAt(idx) == ';' && (str.charAt(idx - 1) == '\n' || str.charAt(idx - 1) == '\r')) {
                reachedEnd = true;
                endIdx = idx - 1;
                nextIdx = idx + 1;
                continue;
            }
            if ((inNonQuoted || inFramecode) && Character.isWhitespace(str.charAt(idx))) {
                reachedEnd = true;
                endIdx = idx;
                nextIdx = idx;
                continue;
            }
            ++idx;
        }
        ParseValFromRetVal retVal = new ParseValFromRetVal();
        if (makeNew) {
            retVal.delim = inNonQuoted ? DataValueNode.NON : (inDouble ? DataValueNode.DOUBLE : (inSingle ? DataValueNode.SINGLE : (inSemicolon ? DataValueNode.SEMICOLON : (inFramecode ? DataValueNode.FRAMECODE : DataValueNode.DONT_CARE))));
            retVal.str = str.substring(startIdx, endIdx);
        } else {
            retVal.str = null;
        }
        retVal.endingIdx = endIdx;
        retVal.nextIdx = nextIdx;
        retVal.found = found;
        return retVal;
    }
}

