/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.valdb;

import EDU.bmrb.lib.CreateDBSchema;
import EDU.bmrb.nmrstar.utils.StarToDb;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;

public class CreateHtml {
    private static final boolean DEBUG = false;
    private static final String DB_DRIVER = "org.hsqldb.jdbcDriver";
    private static final String DB_URL = "jdbc:hsqldb:mem:temp";
    private static final String DB_USER = "sa";
    private static final String DDL_SCRIPT = "/share2/dmaziuk/valdb/sql/valdb_fromstar.hsqlm";
    private static final String DDL_CONSTR = "/share2/dmaziuk/valdb/sql/valdbconstr_fromstar.hsql";
    private Connection fConn = null;

    public void connect() throws ClassNotFoundException, SQLException {
        Class.forName(DB_DRIVER);
        this.fConn = DriverManager.getConnection(DB_URL, DB_USER, "");
        this.fConn.setAutoCommit(false);
    }

    public void close() throws SQLException {
        this.fConn.commit();
        this.fConn.close();
        this.fConn = null;
    }

    public Connection getConnection() throws SQLException {
        return this.fConn;
    }

    public void readDb(BufferedReader bufferedReader) throws ClassNotFoundException, IOException, SQLException {
        if (this.fConn == null) {
            this.connect();
        }
        CreateDBSchema.runScript(this.fConn, DDL_SCRIPT, null);
        StarToDb starToDb = new StarToDb(this.fConn, null, null);
        starToDb.load(bufferedReader);
        CreateDBSchema.runScript(this.fConn, DDL_CONSTR, null);
    }

    public void print(PrintWriter printWriter) throws SQLException {
        PreparedStatement preparedStatement = this.fConn.prepareStatement("SELECT a.NAME FROM ATOMS a,PSEUDOS p WHERE p.ID=? AND a.ID=p.ATOMID", 1003, 1007);
        ResultSet resultSet = null;
        Statement statement = this.fConn.createStatement(1003, 1007);
        ResultSet resultSet2 = statement.executeQuery("SELECT t.NAME,r.LABEL,a.NAME,a.PSEUDO,a.ID,r.ID FROM RESTYPES t,RESIDUES r,ATOMS a WHERE a.NOMID=0 AND r.TYPEID=t.ID AND a.RESID=r.ID ORDER BY t.NAME,r.ID,a.PSEUDO,a.NAME");
        printWriter.println("<HTML lang=\"en-US\">");
        printWriter.println("<HEAD>");
        printWriter.println("<TITLE>STARch pseudoatom map</TITLE>");
        printWriter.println("</HEAD>");
        printWriter.println("<BODY>");
        printWriter.println("<H2>Residues</H2>");
        printWriter.println("<P>");
        printWriter.println("Yellow background = pseudoatom. Rightmost column lists atoms it is expanded to.");
        printWriter.println("<P>");
        printWriter.println("<STRONG>X</STRONG> residue: conversion rules that apply to all residues");
        printWriter.println("<TABLE border=\"1\">");
        printWriter.println("<TR>");
        printWriter.println("<TH>Type</TH>");
        printWriter.println("<TH>Label</TH>");
        printWriter.println("<TH>Atom</TH>");
        printWriter.println("<TH>expanded to</TH>");
        printWriter.println("</TR>");
        while (resultSet2.next()) {
            printWriter.println("<TR>");
            printWriter.print("<TD>");
            printWriter.print(resultSet2.getString(1));
            printWriter.println("</TD>");
            printWriter.print("<TD align=\"center\"><STRONG>");
            printWriter.print(resultSet2.getString(2));
            printWriter.println("</STRONG></TD>");
            resultSet2.getString(4);
            if (!resultSet2.wasNull() && resultSet2.getString(4).equals("Y")) {
                printWriter.print("<TD align=\"center\" bgcolor=\"yellow\">");
            } else {
                printWriter.print("<TD align=\"center\">");
            }
            printWriter.print(resultSet2.getString(3));
            printWriter.println("</TD>");
            resultSet2.getString(4);
            if (!resultSet2.wasNull() && resultSet2.getString(4).equals("Y")) {
                boolean bl = true;
                preparedStatement.setInt(1, resultSet2.getInt(5));
                resultSet = preparedStatement.executeQuery();
                printWriter.print("<TD bgcolor=\"yellow\">");
                while (resultSet.next()) {
                    if (!bl) {
                        printWriter.print(", ");
                    }
                    printWriter.print(resultSet.getString(1));
                    if (!bl) continue;
                    bl = false;
                }
                printWriter.println("</TD>");
            } else {
                printWriter.println("<TD>&nbsp;</TD>");
            }
            printWriter.println("</TR>");
        }
        if (resultSet != null) {
            resultSet.close();
        }
        preparedStatement.close();
        resultSet2.close();
        statement.close();
        printWriter.println("</TABLE>");
        printWriter.println("<P>Updated: ");
        printWriter.println(new Date());
        printWriter.println("</HTML>");
        printWriter.flush();
    }

    public static void main(String[] stringArray) {
        try {
            BufferedReader bufferedReader = stringArray.length < 1 ? new BufferedReader(new InputStreamReader(System.in)) : new BufferedReader(new FileReader(stringArray[0]));
            PrintWriter printWriter = new PrintWriter(System.out);
            CreateHtml createHtml = new CreateHtml();
            createHtml.connect();
            createHtml.readDb(bufferedReader);
            createHtml.print(printWriter);
            printWriter.close();
            createHtml.close();
        }
        catch (Exception exception) {
            System.err.println(exception);
            exception.printStackTrace();
            System.exit(1);
        }
    }
}

