/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.valdb;

import EDU.bmrb.nmrstar.utils.DbToStar;
import EDU.bmrb.valdb.CsvReader;
import EDU.bmrb.valdb.MemDB;
import EDU.bmrb.valdb.Pseudos;
import java.io.PrintWriter;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class CsvToStar {
    private static final boolean DEBUG = true;
    public static final String[] AA_LABELS = new String[]{"ALA", "ARG", "ASN", "ASP", "CYS", "GLN", "GLU", "GLY", "HIS", "ILE", "LEU", "LYS", "MET", "PHE", "PRO", "SER", "THR", "TRP", "TYR", "VAL"};
    public static final String[] AA_NAMES = new String[]{"ALANINE", "ARGININE", "ASPARAGINE", "ASPARTIC ACID", "CYSTEINE", "GLUTAMINE", "GLUTAMIC ACID", "GLYCINE", "HISTIDINE", "ISOLEUCINE", "LEUCINE", "LYSINE", "METHIONINE", "PHENYLALANINE", "PROLINE", "SERINE", "THREONINE", "TRYPTOPHAN", "TYROSINE", "VALINE"};

    public static void addNomenclatures(CsvReader src, MemDB tgt) throws SQLException {
        PreparedStatement stat = tgt.prepareStatement("INSERT INTO NOMENCLATURES(NAME) VALUES(?)");
        Statement query = src.getQuery();
        ResultSet rs = query.executeQuery("SELECT NAME FROM nomenclatures");
        while (rs.next()) {
            stat.setString(1, rs.getString(1));
            stat.executeUpdate();
        }
        stat.getConnection().commit();
        stat.close();
        rs.close();
        query.close();
    }

    public static void addResidueTypes(CsvReader src, MemDB tgt) throws SQLException {
        PreparedStatement stat = tgt.prepareStatement("INSERT INTO RESTYPES(NAME) VALUES(?)");
        Statement query = src.getQuery();
        ResultSet rs = query.executeQuery("SELECT NAME FROM restypes");
        while (rs.next()) {
            stat.setString(1, rs.getString(1));
            stat.executeUpdate();
        }
        stat.getConnection().commit();
        stat.close();
        rs.close();
        query.close();
    }

    public static void addDefaults(MemDB tgt) throws SQLException {
        Statement stat = tgt.getStatement();
        stat.executeUpdate("INSERT INTO RESIDUES(TYPEID,LABEL,CODE,NAME,NOMID) VALUES (0,'X','X','for conversions that apply to all residues',0)");
        stat.getConnection().commit();
        stat.close();
        Statement query = tgt.getQuery();
        ResultSet rs = query.executeQuery("SELECT ID FROM RESIDUES WHERE LABEL='X'");
        rs.next();
        int resid = rs.getInt(1);
        query.close();
        PreparedStatement pstat = tgt.prepareStatement("INSERT INTO ATOMS(RESID,NAME,PSEUDO,NOMID) VALUES (" + resid + ",?,?,0)");
        pstat.setString(2, "Y");
        pstat.setString(1, "NH");
        pstat.executeUpdate();
        pstat.setString(1, "HN");
        pstat.executeUpdate();
        pstat.setString(1, "NN");
        pstat.executeUpdate();
        pstat.setString(1, "CO");
        pstat.executeUpdate();
        pstat.setString(2, "N");
        pstat.setString(1, "H");
        pstat.executeUpdate();
        pstat.setString(1, "N");
        pstat.executeUpdate();
        pstat.setString(1, "C");
        pstat.executeUpdate();
        pstat.getConnection().commit();
        pstat.close();
        PreparedStatement pquery = tgt.prepareQuery("SELECT ID FROM ATOMS WHERE NAME=?");
        int id = -1;
        pquery.setString(1, "NH");
        rs = pquery.executeQuery();
        rs.next();
        id = rs.getInt(1);
        pquery.setString(1, "H");
        rs = pquery.executeQuery();
        rs.next();
        pstat = tgt.prepareStatement("INSERT INTO PSEUDOS(ID,ATOMID) VALUES(?,?)");
        pstat.setInt(1, id);
        pstat.setInt(2, rs.getInt(1));
        pstat.executeUpdate();
        pquery.setString(1, "HN");
        rs = pquery.executeQuery();
        rs.next();
        id = rs.getInt(1);
        pquery.setString(1, "H");
        rs = pquery.executeQuery();
        rs.next();
        pstat.setInt(1, id);
        pstat.setInt(2, rs.getInt(1));
        pstat.executeUpdate();
        pquery.setString(1, "NN");
        rs = pquery.executeQuery();
        rs.next();
        id = rs.getInt(1);
        pquery.setString(1, "N");
        rs = pquery.executeQuery();
        rs.next();
        pstat.setInt(1, id);
        pstat.setInt(2, rs.getInt(1));
        pstat.executeUpdate();
        pquery.setString(1, "CO");
        rs = pquery.executeQuery();
        rs.next();
        id = rs.getInt(1);
        pquery.setString(1, "C");
        rs = pquery.executeQuery();
        rs.next();
        pstat.setInt(1, id);
        pstat.setInt(2, rs.getInt(1));
        pstat.executeUpdate();
        pstat.getConnection().commit();
        pstat.close();
        rs.close();
        pquery.close();
    }

    public static void processTable(CsvReader src, MemDB tgt, String name, String type) throws SQLException {
        StringBuffer sql = new StringBuffer("SELECT ID FROM RESTYPES WHERE NAME='");
        sql.append(type);
        sql.append("'");
        Statement typeq = tgt.getQuery();
        ResultSet rs = typeq.executeQuery(sql.toString());
        if (!rs.next()) {
            throw new IllegalArgumentException("No residue type " + type);
        }
        int typeid = rs.getInt(1);
        typeq.close();
        String lastresidue = null;
        int lastresid = -1;
        int lastatomid = -1;
        String atomtype = null;
        sql.setLength(0);
        sql.append("INSERT INTO RESIDUES(TYPEID,LABEL,CODE,NAME,NOMID) VALUES (");
        sql.append(typeid);
        sql.append(",?,?,?,0)");
        PreparedStatement resstat = tgt.prepareStatement(sql.toString());
        sql.setLength(0);
        sql.append("INSERT INTO ATOMS(RESID,NAME,TYPE,PSEUDO,NOMID) VALUES(?,?,?,?,0)");
        PreparedStatement atomstat = tgt.prepareStatement(sql.toString());
        sql.setLength(0);
        sql.append("INSERT INTO CHEMSHIFTS(ATOMID,SHIFTAVG,SHIFTSTD,SHIFTMIN,SHIFTMAX)");
        sql.append(" VALUES (?,?,?,?,?)");
        PreparedStatement shiftstat = tgt.prepareStatement(sql.toString());
        sql.setLength(0);
        sql.append("SELECT RCODE,RLABEL,ATOM,SHAVG,SHSTD,SHMIN,SHMAX,NUMSHIFTS FROM ");
        sql.append(name);
        Statement query = src.getQuery();
        rs = query.executeQuery(sql.toString());
        while (rs.next()) {
            if (lastresidue == null || !lastresidue.equals(rs.getString(2).toUpperCase())) {
                int i;
                lastresidue = rs.getString(2).toUpperCase();
                if (type.equals("polypeptide")) {
                    resstat.setString(1, lastresidue);
                } else {
                    resstat.setString(1, rs.getString(1).toUpperCase());
                }
                resstat.setString(2, rs.getString(1).toUpperCase());
                for (i = 0; i < AA_LABELS.length && !AA_LABELS[i].equals(lastresidue); ++i) {
                }
                if (i < AA_LABELS.length) {
                    resstat.setString(3, AA_NAMES[i]);
                } else {
                    resstat.setNull(3, 12);
                }
                resstat.executeUpdate();
                lastresid = tgt.lastId();
            }
            atomstat.setInt(1, lastresid);
            atomstat.setString(2, rs.getString(3).toUpperCase());
            atomtype = rs.getString(3).toUpperCase().substring(0, 1);
            System.err.print("residue type is |" + type + "|");
            System.err.println(", atom is |" + rs.getString(3).toUpperCase() + "|," + "type is |" + atomtype + "|");
            if (!type.equals("polypeptide") && rs.getString(3).toUpperCase().indexOf("OP") != -1) {
                atomtype = "P";
                System.err.println("found OP, atomtype is |" + atomtype + "|");
            }
            atomstat.setString(3, atomtype);
            atomstat.setString(4, "N");
            if (type.equals("polypeptide")) {
                if (lastresidue.equals("ALA") && rs.getString(3).toUpperCase().equals("HB")) {
                    atomstat.setString(4, "Y");
                }
                if (lastresidue.equals("ILE") && (rs.getString(3).toUpperCase().equals("HG2") || rs.getString(3).toUpperCase().equals("HD1"))) {
                    atomstat.setString(4, "Y");
                }
                if (lastresidue.equals("LEU") && (rs.getString(3).toUpperCase().equals("HD1") || rs.getString(3).toUpperCase().equals("HD2"))) {
                    atomstat.setString(4, "Y");
                }
                if (lastresidue.equals("LYS") && rs.getString(3).toUpperCase().equals("HZ")) {
                    atomstat.setString(4, "Y");
                }
                if (lastresidue.equals("THR") && rs.getString(3).toUpperCase().equals("HG2")) {
                    atomstat.setString(4, "Y");
                }
                if (lastresidue.equals("VAL") && (rs.getString(3).toUpperCase().equals("HG1") || rs.getString(3).toUpperCase().equals("HG2"))) {
                    atomstat.setString(4, "Y");
                }
            }
            System.err.println(atomstat);
            atomstat.executeUpdate();
            lastatomid = tgt.lastId();
            int numshifts = rs.getInt(8);
            if (rs.wasNull() || numshifts < 1) continue;
            shiftstat.setInt(1, lastatomid);
            shiftstat.setFloat(2, rs.getFloat(4));
            shiftstat.setFloat(3, rs.getFloat(5));
            shiftstat.setFloat(4, rs.getFloat(6));
            shiftstat.setFloat(5, rs.getFloat(7));
            shiftstat.executeUpdate();
        }
        shiftstat.getConnection().commit();
        shiftstat.close();
        atomstat.close();
        resstat.close();
        rs.close();
        query.close();
    }

    public static void addPseudoAtoms(CsvReader src, MemDB tgt) throws SQLException {
        PreparedStatement res_query = tgt.prepareQuery("SELECT t.ID,r.ID FROM RESTYPES t,RESIDUES r WHERE t.NAME=? AND r.LABEL=? AND r.TYPEID=t.ID");
        ResultSet rs1 = null;
        PreparedStatement nom_query = tgt.prepareQuery("SELECT ID FROM NOMENCLATURES WHERE NAME=?");
        PreparedStatement pa_query = tgt.prepareQuery("SELECT ID,PSEUDO  FROM ATOMS WHERE NAME=? AND RESID=? AND NOMID=?");
        PreparedStatement pa_ustat = tgt.prepareStatement("UPDATE ATOMS SET PSEUDO='Y' WHERE ID=?");
        PreparedStatement pa_istat = tgt.prepareStatement("INSERT INTO ATOMS (RESID,NAME,PSEUDO,NOMID) VALUES (?,?,'Y',?)");
        int nomid = -1;
        int typeid = -1;
        int resid = -1;
        Statement query = src.getQuery();
        ResultSet rs = query.executeQuery("SELECT RESTYPE,RESLABEL,PSEUDO,NOMENCLATURE FROM pseudoexp");
        while (rs.next()) {
            res_query.setString(1, rs.getString(1));
            res_query.setString(2, rs.getString(2));
            rs1 = res_query.executeQuery();
            if (!rs1.next()) {
                System.err.println("No residue: " + rs.getString(1) + ":" + rs.getString(2));
                continue;
            }
            typeid = rs1.getInt(1);
            if (rs1.wasNull()) {
                System.err.println("No residue type: " + rs.getString(1) + ":" + rs.getString(2));
                continue;
            }
            resid = rs1.getInt(2);
            if (rs1.wasNull()) {
                System.err.println("No residue label: " + rs.getString(1) + ":" + rs.getString(2));
                continue;
            }
            nom_query.setString(1, rs.getString(4));
            rs1 = nom_query.executeQuery();
            if (!rs1.next()) {
                System.err.println("No atom nomenclature: " + rs.getString(4));
                continue;
            }
            nomid = rs1.getInt(1);
            if (rs1.wasNull()) {
                System.err.println("Null atom nomenclature ID: " + rs.getString(4));
                continue;
            }
            pa_query.setString(1, rs.getString(3));
            pa_query.setInt(2, resid);
            pa_query.setInt(3, nomid);
            rs1 = pa_query.executeQuery();
            if (rs1.next()) {
                System.err.println("Updating pseudo flag for " + rs.getString(3) + "," + resid);
                pa_ustat.setInt(1, rs1.getInt(1));
                pa_ustat.executeUpdate();
                continue;
            }
            System.err.println("Inserting pseudo atom " + rs.getString(3) + "," + resid);
            pa_istat.setInt(1, resid);
            pa_istat.setString(2, rs.getString(3));
            pa_istat.setInt(3, nomid);
            pa_istat.executeUpdate();
            CsvToStar.expandPseudoAtoms(src, tgt, rs.getString(1), typeid, rs.getString(2), resid, rs.getString(3), rs.getString(4), nomid);
        }
        rs.close();
        query.close();
        if (rs1 != null) {
            rs1.close();
        }
        res_query.close();
        nom_query.close();
        pa_query.close();
        pa_ustat.getConnection().commit();
        pa_istat.getConnection().commit();
        pa_ustat.close();
        pa_istat.close();
    }

    public static void expandPseudoAtoms(CsvReader src, MemDB tgt, String restype, int typeid, String reslabel, int resid, String atom, String nomname, int nomid) throws SQLException {
        System.err.println("Expand pseudoatoms");
        StringBuffer sql = new StringBuffer("SELECT ID FROM ATOMS WHERE RESID=");
        sql.append(resid);
        sql.append(" AND NAME='");
        sql.append(atom);
        sql.append("' AND NOMID=");
        sql.append(nomid);
        int pid = -1;
        Statement query = tgt.getQuery();
        ResultSet rs = query.executeQuery(sql.toString());
        if (rs.next()) {
            pid = rs.getInt(1);
            if (rs.wasNull()) {
                pid = -1;
            }
        }
        if (pid < 0) {
            System.err.println("No record for pseudoatom " + atom + ", " + reslabel + ", " + nomname);
            rs.close();
            query.close();
            return;
        }
        sql.setLength(0);
        sql.append("SELECT SHIFTAVG,SHIFTSTD,SHIFTMIN,SHIFTMAX FROM CHEMSHIFTS WHERE ATOMID=");
        sql.append(pid);
        PreparedStatement shift_q = tgt.prepareQuery(sql.toString());
        float avg = Float.NaN;
        float std = Float.NaN;
        float min = Float.NaN;
        float max = Float.NaN;
        rs = shift_q.executeQuery();
        if (rs.next()) {
            avg = rs.getFloat(1);
            if (rs.wasNull()) {
                avg = Float.NaN;
            }
            std = rs.getFloat(2);
            if (rs.wasNull()) {
                std = Float.NaN;
            }
            min = rs.getFloat(3);
            if (rs.wasNull()) {
                min = Float.NaN;
            }
            max = rs.getFloat(4);
            if (rs.wasNull()) {
                max = Float.NaN;
            }
        }
        sql.setLength(0);
        sql.append("INSERT INTO ATOMS (NAME,RESID,NOMID,PSEUDO) VALUES (?,");
        sql.append(resid);
        sql.append(',');
        sql.append(nomid);
        sql.append(",'N')");
        PreparedStatement a_stat = tgt.prepareStatement(sql.toString());
        sql.setLength(0);
        sql.append("INSERT INTO CHEMSHIFTS (ATOMID,SHIFTAVG,SHIFTSTD,SHIFTMIN,SHIFTMAX) VALUES (?,?,?,?,?)");
        PreparedStatement s_stat = tgt.prepareStatement(sql.toString());
        PreparedStatement p_stat = tgt.prepareStatement("INSERT INTO PSEUDOS (ID,ATOMID) VALUES (?,?)");
        sql.setLength(0);
        sql.append("SELECT ID FROM ATOMS WHERE RESID=");
        sql.append(resid);
        sql.append(" AND NAME=? AND NOMID=");
        sql.append(nomid);
        PreparedStatement atom_q = tgt.prepareStatement(sql.toString());
        ResultSet rs1 = null;
        sql.setLength(0);
        sql.append("SELECT ATOM FROM pseudoexp WHERE RESTYPE='");
        sql.append(restype);
        sql.append("' AND RESLABEL='");
        sql.append(reslabel);
        sql.append("' AND PSEUDO='");
        sql.append(atom);
        sql.append("' AND NOMENCLATURE='");
        sql.append(nomname);
        Statement a_query = src.getQuery();
        rs = a_query.executeQuery(sql.toString());
        while (rs.next()) {
            atom_q.setString(1, rs.getString(1));
            rs1 = atom_q.executeQuery();
            if (!rs1.next()) {
                a_stat.setString(1, rs.getString(1));
                a_stat.executeUpdate();
                rs1 = atom_q.executeQuery();
                s_stat.setInt(1, rs1.getInt(1));
                if (!Float.isNaN(avg)) {
                    s_stat.setFloat(1, avg);
                } else {
                    s_stat.setNull(1, 6);
                }
                if (!Float.isNaN(std)) {
                    s_stat.setFloat(2, std);
                } else {
                    s_stat.setNull(2, 6);
                }
                if (!Float.isNaN(min)) {
                    s_stat.setFloat(3, min);
                } else {
                    s_stat.setNull(3, 6);
                }
                if (!Float.isNaN(max)) {
                    s_stat.setFloat(4, max);
                } else {
                    s_stat.setNull(4, 6);
                }
                s_stat.executeUpdate();
            }
            p_stat.setInt(1, pid);
            p_stat.setInt(2, rs1.getInt(1));
            p_stat.executeUpdate();
        }
        a_stat.getConnection().commit();
        a_stat.close();
        s_stat.getConnection().commit();
        s_stat.close();
        p_stat.getConnection().commit();
        p_stat.close();
        if (rs1 != null) {
            rs1.close();
        }
        rs.close();
        query.close();
        shift_q.close();
        atom_q.close();
    }

    private static void expandMethyl(PreparedStatement pseudoq, PreparedStatement protoq, PreparedStatement pstat, String residue, String pseudo, String[] protons) throws SQLException {
        pseudoq.setString(1, residue);
        pseudoq.setString(2, pseudo);
        ResultSet idrs = null;
        ResultSet rs = pseudoq.executeQuery();
        if (rs.next()) {
            pstat.setFloat(1, rs.getFloat(1));
            pstat.setFloat(2, rs.getFloat(2));
            pstat.setFloat(3, rs.getFloat(3));
            pstat.setFloat(4, rs.getFloat(4));
            protoq.setString(1, residue);
            for (int i = 0; i < protons.length; ++i) {
                protoq.setString(2, protons[i]);
                idrs = protoq.executeQuery();
                if (!idrs.next()) continue;
                pstat.setInt(5, idrs.getInt(1));
                pstat.executeUpdate();
            }
        }
        if (idrs != null) {
            idrs.close();
        }
        rs.close();
    }

    public static void addIsotopeTable(CsvReader src, MemDB tgt) throws SQLException {
        PreparedStatement pstat = tgt.prepareStatement("INSERT INTO ISOTOPES (TYPE,ISOTOPE) VALUES (?,?)");
        Statement query = src.getQuery();
        ResultSet rs = query.executeQuery("SELECT ATYPE,ISOTOPE FROM isotopes");
        while (rs.next()) {
            pstat.setString(1, rs.getString(1));
            pstat.setInt(2, rs.getInt(2));
            pstat.executeUpdate();
        }
        pstat.getConnection().commit();
        pstat.close();
        rs.close();
        query.close();
    }

    public static void addAmbiguityTable(CsvReader src, MemDB tgt) throws SQLException {
        PreparedStatement pstat = tgt.prepareStatement("INSERT INTO AMBICODES (ATOMID,AMBICODE) VALUES (?,?)");
        PreparedStatement pquery = tgt.prepareQuery("SELECT a.ID FROM ATOMS a,RESIDUES r,RESTYPES t WHERE t.NAME=? AND r.LABEL=? AND a.NAME=? AND r.TYPEID=t.ID AND a.RESID=r.ID");
        ResultSet rs1 = null;
        Statement query = src.getQuery();
        ResultSet rs = query.executeQuery("SELECT RESTYPE,RESLABEL,ATOM,AMBICODE FROM ambicodes");
        while (rs.next()) {
            pquery.setString(1, rs.getString(1));
            pquery.setString(2, rs.getString(2));
            pquery.setString(3, rs.getString(3));
            rs1 = pquery.executeQuery();
            if (rs1.next()) {
                pstat.setInt(1, rs1.getInt(1));
                pstat.setInt(2, rs.getInt(4));
                pstat.executeUpdate();
                continue;
            }
            System.err.println("No parent atom for " + rs.getString(1) + ":" + rs.getString(2) + ":" + rs.getString(3));
        }
        pstat.getConnection().commit();
        pstat.close();
        if (rs1 != null) {
            rs1.close();
        }
        pquery.close();
        rs.close();
        query.close();
    }

    public static void addAmbiReplaceTable(CsvReader src, MemDB tgt) throws SQLException {
        int atomid1 = -1;
        int atomid2 = -1;
        PreparedStatement pstat = tgt.prepareStatement("INSERT INTO AMBIREPLACE (RESID,ATOMID1,ATOMID2,ORGCODE,NEWCODE) VALUES (?,?,?,?,?)");
        PreparedStatement pquery = tgt.prepareQuery("SELECT a.ID,r.ID FROM ATOMS a,RESIDUES r WHERE r.TYPEID=? AND r.LABEL=? AND a.NAME=? AND a.RESID=r.ID");
        ResultSet rs1 = null;
        Statement query = src.getQuery();
        ResultSet rs = query.executeQuery("SELECT RESTYPE,LABEL,ATOM1,ATOM2,ORGCODE,NEWCODE FROM ambireplace");
        while (rs.next()) {
            pquery.setInt(1, rs.getInt(1));
            pquery.setString(2, rs.getString(2));
            pquery.setString(3, rs.getString(3));
            rs1 = pquery.executeQuery();
            if (rs1.next()) {
                atomid1 = rs1.getInt(1);
                if (rs1.wasNull()) {
                    atomid1 = -1;
                }
            }
            if (atomid1 < 0) {
                System.err.println("No ID for atom " + rs.getString(2) + "," + rs.getString(3));
                continue;
            }
            pquery.setString(3, rs.getString(4));
            rs1 = pquery.executeQuery();
            if (rs1.next()) {
                atomid2 = rs1.getInt(1);
                if (rs1.wasNull()) {
                    atomid2 = -1;
                }
            }
            if (atomid2 < 0) {
                System.err.println("No ID for atom " + rs.getString(2) + "," + rs.getString(3));
                continue;
            }
            pstat.setInt(1, rs1.getInt(2));
            pstat.setInt(2, atomid1);
            pstat.setInt(3, atomid2);
            pstat.setInt(4, rs.getInt(5));
            pstat.setInt(5, rs.getInt(6));
            pstat.executeUpdate();
        }
        pstat.getConnection().commit();
        pstat.close();
        if (rs1 != null) {
            rs1.close();
        }
        pquery.close();
        rs.close();
        query.close();
    }

    public static void add21AtomTable(CsvReader src, MemDB tgt) throws SQLException {
        PreparedStatement pstat = tgt.prepareStatement("INSERT INTO STAR3TO2 (TYPEID,RESLABEL,ATOM30,ATOM21) VALUES (?,?,?,?)");
        Statement query = src.getQuery();
        ResultSet rs = query.executeQuery("SELECT RESTYPE,LABEL,ATOM30,ATOM21 FROM star21atoms");
        while (rs.next()) {
            pstat.setInt(1, rs.getInt(1));
            pstat.setString(2, rs.getString(2));
            pstat.setString(3, rs.getString(3));
            pstat.setString(4, rs.getString(4));
            System.err.println(pstat);
            pstat.executeUpdate();
        }
        pstat.getConnection().commit();
        pstat.close();
        rs.close();
        query.close();
    }

    public static void addMethyleneTable(CsvReader src, MemDB tgt) throws SQLException {
        PreparedStatement pstat = tgt.prepareStatement("INSERT INTO METHYLENES(TYPEID,RESLABEL,ATOM1,ATOM2,NEW1,NEW2) VALUES (?,?,?,?,?,?)");
        Statement query = src.getQuery();
        ResultSet rs = query.executeQuery("SELECT RESTYPE,LABEL,ATOM1,ATOM2,NEW1,NEW2 FROM methylenes");
        while (rs.next()) {
            pstat.setInt(1, rs.getInt(1));
            pstat.setString(2, rs.getString(2));
            pstat.setString(3, rs.getString(3));
            pstat.setString(4, rs.getString(4));
            pstat.setString(5, rs.getString(5));
            pstat.setString(6, rs.getString(6));
            System.err.println(pstat);
            pstat.executeUpdate();
        }
        pstat.getConnection().commit();
        pstat.close();
        rs.close();
        query.close();
    }

    public static void main(String[] args) {
        try {
            long now = System.currentTimeMillis();
            CsvReader csv = new CsvReader();
            if (args.length > 0) {
                csv.connect(args[0]);
            } else {
                System.err.println("Usage: java EDU.bmrb.valdb.CsvToStar <csv dir>");
                System.exit(1);
            }
            MemDB db = new MemDB();
            db.connect();
            db.createTables();
            CsvToStar.addNomenclatures(csv, db);
            CsvToStar.addResidueTypes(csv, db);
            CsvToStar.addDefaults(db);
            CsvToStar.processTable(csv, db, "aastatsl", "polypeptide");
            CsvToStar.processTable(csv, db, "dnastatsl", "polydeoxyribonucleotide");
            CsvToStar.processTable(csv, db, "rnastatsl", "polyribonucleotide");
            Pseudos.flagPseudoAtoms(csv, db);
            Pseudos.expandPseudoAtoms(csv, db);
            Pseudos.addPseudoAtomMap(csv, db);
            CsvToStar.addIsotopeTable(csv, db);
            CsvToStar.addAmbiguityTable(csv, db);
            CsvToStar.addAmbiReplaceTable(csv, db);
            CsvToStar.add21AtomTable(csv, db);
            CsvToStar.addMethyleneTable(csv, db);
            Pseudos.addMethylShifts(db);
            csv.disconnect();
            DbToStar o = new DbToStar(db.getConnection(), new PrintWriter(System.out), null);
            ArrayList<String> list = new ArrayList<String>();
            list.add("NOMENCLATURES");
            list.add("RESTYPES");
            list.add("RESIDUES");
            list.add("ATOMS");
            list.add("ISOTOPES");
            list.add("PSEUDOS");
            list.add("AMBICODES");
            list.add("AMBIREPLACE");
            list.add("CHEMSHIFTS");
            list.add("ATOMNOM");
            list.add("STAR3TO2");
            list.add("METHYLENES");
            o.print(list);
            db.disconnect();
            System.err.println("Elapsed: " + (System.currentTimeMillis() - now));
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
        }
    }
}

