/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.validator;

import EDU.bmrb.validator.Severity;
import java.io.PrintWriter;
import java.io.StringWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Error
implements Comparable<Error> {
    private static final boolean DEBUG = false;
    private Severity fSvr = null;
    private int fLine = -1;
    private int fFun = -1;
    private int fNum = -1;
    private String fMsg = null;
    public static final String ERR = "ERR";
    public static final String WARN = "WARN";
    private boolean fErr = true;
    private StringBuffer fBuf = null;

    public Error(Severity svr, int func, int num) {
        this.fSvr = svr;
        this.fFun = func;
        this.fNum = num;
    }

    public Error(Severity svr, int func, int num, int line, String msg) {
        this.fSvr = svr;
        this.fFun = func;
        this.fNum = num;
        this.fLine = line;
        this.fMsg = msg;
    }

    public Error(Severity svr, int func, int num, int line, String format, Object ... args) {
        this.fSvr = svr;
        this.fFun = func;
        this.fNum = num;
        this.fLine = line;
        StringWriter str = new StringWriter();
        PrintWriter s = new PrintWriter(str);
        s.printf(format, args);
        this.fMsg = str.toString();
    }

    public Error() {
    }

    public Error(boolean iserr, int func, int num, int line, String msg) {
        this.fErr = iserr;
        this.fSvr = iserr ? Severity.ERR : Severity.WARN;
        this.fFun = func;
        this.fNum = num;
        this.fLine = line;
        this.fMsg = msg;
    }

    public boolean isError() {
        return this.fSvr == Severity.ERR || this.fSvr == Severity.CRIT;
    }

    public Severity getSeverity() {
        return this.fSvr;
    }

    public void setSeverity(boolean iserr) {
        this.fSvr = iserr ? Severity.ERR : Severity.WARN;
    }

    public void setSeverity(Severity svr) {
        this.fSvr = svr;
    }

    public int getFuncNum() {
        return this.fFun;
    }

    public void setFuncNum(int num) {
        this.fFun = num;
    }

    public int getErrNum() {
        return this.fNum;
    }

    public void setErrNum(int num) {
        this.fNum = num;
    }

    public int getLineNum() {
        return this.fLine;
    }

    public void setLineNum(int num) {
        this.fLine = num;
    }

    public String getMessage() {
        return this.fMsg;
    }

    public void setMessage(String msg) {
        this.fMsg = msg;
    }

    public void setMessage(String format, Object ... args) {
        StringWriter str = new StringWriter();
        PrintWriter s = new PrintWriter(str);
        s.printf(format, args);
        this.fMsg = str.toString();
    }

    public int getId() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.fFun);
        buf.append(this.fNum);
        return Integer.parseInt(buf.toString());
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append((Object)this.fSvr);
        buf.append(':');
        buf.append(this.fLine);
        buf.append(':');
        buf.append(this.fFun);
        buf.append('-');
        buf.append(this.fNum);
        buf.append(' ');
        buf.append(this.fMsg);
        return buf.toString();
    }

    public boolean equals(Error obj) {
        return this.compareTo(obj) == 0;
    }

    @Override
    public int compareTo(Error obj) {
        return this.compareFuncFirst(obj);
    }

    protected int compareLineFirst(Error obj) {
        if (obj == null) {
            return 1;
        }
        if (obj == this) {
            return 0;
        }
        int i = this.fLine - obj.getLineNum();
        if (i != 0) {
            return i;
        }
        i = this.fFun - obj.getFuncNum();
        if (i != 0) {
            return i;
        }
        i = this.fNum - obj.getErrNum();
        if (i != 0) {
            return i;
        }
        if (this.fMsg != null) {
            return this.fMsg.compareTo(obj.getMessage());
        }
        return 1;
    }

    protected int compareFuncFirst(Error obj) {
        if (obj == null) {
            return 1;
        }
        if (obj == this) {
            return 0;
        }
        if (!obj.fSvr.equals((Object)this.fSvr)) {
            return this.fSvr.compareTo(obj.fSvr);
        }
        if (obj.fFun != this.fFun) {
            return this.fFun - obj.fFun;
        }
        if (obj.fNum != this.fNum) {
            return this.fNum - obj.fNum;
        }
        if (obj.fLine != this.fLine) {
            return this.fLine - obj.fLine;
        }
        if (this.fMsg != null) {
            return this.fMsg.compareTo(obj.getMessage());
        }
        return 1;
    }
}

