/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.validator;

import EDU.bmrb.stardb.Star_DB;
import EDU.bmrb.validator.Config;
import EDU.bmrb.validator.Error;
import EDU.bmrb.validator.ErrorList;
import EDU.bmrb.validator.Validator;
import gnu.getopt.Getopt;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class Jedit {
    private static final boolean DEBUG = false;

    public static void usage() {
        System.err.println("Usage: java EDU.bmrb.validator.Validator [-c FILE] <-i FILE> [-o FILE] [-f NUM [-f NUM ...]] [-n] [-e]  [-h]");
        System.err.println("  -c FILE: use config FILE instead of ~/validator.conf");
        System.err.println("  -i FILE: input file name (required)");
        System.err.println("  -o FILE: output file name (default: stdout)");
        System.err.println("  -f NUM: validation function to run.");
        System.err.print("     Multiple -f's are allowed. If omitted, apply functions");
        System.err.println("     selected in config file. If no functions are selected,");
        System.err.println("     read the input and print any parse errors/warnings");
        System.err.println("  -n: do not load metadata into database");
        System.err.println("  -e: run editing functions (default: validation functions)");
        System.err.println("  -h: print this message");
    }

    /*
     * WARNING - void declaration
     */
    public static void main(String[] args) {
        long now = System.currentTimeMillis();
        try {
            int opt;
            Getopt g = new Getopt("Jedit", args, "c:i:o:f:neh");
            String arg = null;
            String conffile = null;
            String infile = null;
            String outfile = null;
            Object var9_8 = null;
            boolean load = true;
            boolean edit = false;
            List<Object> list = new ArrayList<void>();
            block12: while ((opt = g.getopt()) != -1) {
                switch (opt) {
                    case 102: {
                        void var9_12;
                        arg = g.getOptarg();
                        try {
                            Integer n = new Integer(arg);
                        }
                        catch (NumberFormatException e) {
                            Object var9_11 = null;
                        }
                        if (var9_12 == null) {
                            System.err.println("Invalid option: -f " + arg);
                            Jedit.usage();
                            return;
                        }
                        list.add(var9_12);
                        continue block12;
                    }
                    case 99: {
                        conffile = g.getOptarg();
                        continue block12;
                    }
                    case 105: {
                        infile = g.getOptarg();
                        continue block12;
                    }
                    case 110: {
                        load = false;
                        continue block12;
                    }
                    case 101: {
                        edit = true;
                        continue block12;
                    }
                    case 111: {
                        outfile = g.getOptarg();
                        continue block12;
                    }
                }
                Jedit.usage();
                System.exit(1);
            }
            if (infile == null) {
                Jedit.usage();
                System.exit(2);
            }
            Config c = conffile != null ? new Config(conffile) : new Config();
            if (list.size() < 1) {
                list = c.listSelectedFunctions();
            }
            if (list == null) {
                Jedit.usage();
                System.exit(3);
            }
            ErrorList errs = new ErrorList();
            Star_DB star = new Star_DB(c.getProperties());
            Validator v = new Validator(errs, c, star);
            v.deselectAll();
            for (Integer n : list) {
                if (v.select(n)) continue;
                System.err.println("No such function: " + n);
            }
            if (!star.connect(false)) {
                System.err.println("Failed to open database");
                errs.add(new Error(true, -1, -1, -1, "Failed to open database"));
                return;
            }
            FileInputStream fin = new FileInputStream(infile);
            long seek_set = fin.getChannel().position();
            boolean load_ok = true;
            if (load) {
                BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)fin, "ISO-8859-1"));
                load_ok = v.loadMetadata(in);
                fin.getChannel().position(seek_set);
            }
            if (!load_ok) {
                System.exit(4);
            }
            if (!edit) {
                v.validate(fin, seek_set);
            } else {
                v.edit();
            }
            fin.close();
            star.disconnect();
            if (outfile == null) {
                errs.printErrors(System.out);
                System.out.flush();
            } else {
                FileOutputStream out = new FileOutputStream(outfile);
                errs.printErrors(out);
                out.close();
            }
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
            System.exit(5);
        }
    }
}

