/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.validator;

import EDU.bmrb.stardb.AddDataTags;
import EDU.bmrb.stardb.AddDictionaryInfo;
import EDU.bmrb.stardb.LoadMetadata;
import EDU.bmrb.stardb.Star_DB;
import EDU.bmrb.stardb.Stardb;
import EDU.bmrb.stardb.UnparseToStarlib;
import EDU.bmrb.starlibj.BlockNode;
import EDU.bmrb.starlibj.StarUnparser;
import EDU.bmrb.validator.Config;
import EDU.bmrb.validator.EditingFunction;
import EDU.bmrb.validator.Error;
import EDU.bmrb.validator.ErrorList;
import EDU.bmrb.validator.ValidationFunction;
import EDU.bmrb.validator.functions.AddRowIndexes;
import EDU.bmrb.validator.functions.CheckCharset;
import EDU.bmrb.validator.functions.CheckDataTypes;
import EDU.bmrb.validator.functions.CheckDataValues;
import EDU.bmrb.validator.functions.CheckEmptyRows;
import EDU.bmrb.validator.functions.CheckFrameCodes;
import EDU.bmrb.validator.functions.CheckInvalidTags;
import EDU.bmrb.validator.functions.CheckMandatoryTags;
import EDU.bmrb.validator.functions.CheckResidueSequence;
import EDU.bmrb.validator.functions.CheckSaveFrames;
import EDU.bmrb.validator.functions.CheckTagOrder;
import EDU.bmrb.validator.functions.CheckXlinkBond;
import EDU.bmrb.validator.functions.EditResidueLabels;
import EDU.bmrb.validator.functions.FixFramecodes;
import EDU.bmrb.validator.functions.InsertDataSetCount;
import EDU.bmrb.validator.functions.InsertEntryID;
import EDU.bmrb.validator.functions.InsertLocalIDs;
import EDU.bmrb.validator.functions.InsertValues;
import EDU.bmrb.validator.functions.MarkFramecodeValues;
import EDU.bmrb.validator.functions.TrimAditDeposition;
import EDU.bmrb.validator.functions.TrimValues;
import EDU.bmrb.validator.functions.UpdateRelatedTags;
import edu.bmrb.starobj.db.LoadDict;
import edu.bmrb.starobj.db.RunSQL;
import gnu.getopt.Getopt;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;

public class JurgensChecks {
    private static final boolean DEBUG = false;
    public static final String DICT_SCHEMA = "Dictionary.schema";
    public static final String DICT_CONSTR = "Dictionary.constraints";
    public static final String REFDB_SCHEMA = "Refdata.schema";
    public static final String REFDB_CONSTR = "Refdata.constraints";

    public static void usage() {
        System.out.print("Usage: java EDU.bmrb.validator.ADITPostProcess3 <-d FILE> ");
        System.out.println("<-r FILE> <-i FILE> [-c FILE] [-o FILE] [-l FILE] [-h]");
        System.out.println(" -d FILE: dictionary FILE");
        System.out.println(" -r FILE: reference data FILE");
        System.out.println(" -i FILE: input FILE");
        System.out.print(" -c FILE: config FILE, default: ~/");
        System.out.println("validator.properties");
        System.out.println(" -o FILE: output FILE, use dash for stdout");
        System.out.println(" -l FILE: log FILE, use dash for stdout");
        System.out.println(" -h: print this message and exit");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        boolean rc;
        PrintStream log;
        ErrorList errs;
        Stardb star;
        long now;
        block104: {
            block103: {
                block102: {
                    block101: {
                        block100: {
                            long total = now = System.currentTimeMillis();
                            star = null;
                            errs = null;
                            log = null;
                            rc = true;
                            try {
                                try {
                                    String str;
                                    int opt;
                                    Getopt g = new Getopt("ADITPostProcess3", args, "d:c:i:l:o:r:h");
                                    String dictfile = null;
                                    String reffile = null;
                                    String conffile = null;
                                    String infile = null;
                                    String outfile = null;
                                    String logfile = null;
                                    block12: while ((opt = g.getopt()) != -1) {
                                        switch (opt) {
                                            case 99: {
                                                conffile = g.getOptarg();
                                                continue block12;
                                            }
                                            case 100: {
                                                dictfile = g.getOptarg();
                                                continue block12;
                                            }
                                            case 105: {
                                                infile = g.getOptarg();
                                                continue block12;
                                            }
                                            case 108: {
                                                logfile = g.getOptarg();
                                                continue block12;
                                            }
                                            case 111: {
                                                outfile = g.getOptarg();
                                                continue block12;
                                            }
                                            case 114: {
                                                reffile = g.getOptarg();
                                                continue block12;
                                            }
                                        }
                                        JurgensChecks.usage();
                                        System.exit(1);
                                    }
                                    if (dictfile == null) {
                                        System.err.println("No dictionary");
                                        JurgensChecks.usage();
                                        System.exit(2);
                                    }
                                    if (reffile == null) {
                                        System.err.println("No reference data");
                                        JurgensChecks.usage();
                                        System.exit(3);
                                    }
                                    if (infile == null) {
                                        System.err.println("No input file");
                                        JurgensChecks.usage();
                                        System.exit(4);
                                    }
                                    Config cf = conffile == null ? new Config() : new Config(conffile);
                                    star = new Star_DB(cf.getProperties());
                                    errs = new ErrorList(true);
                                    star.connect(false);
                                    if (logfile != null) {
                                        log = logfile.equals("-") ? System.err : new PrintStream(new FileOutputStream(logfile, true));
                                    }
                                    if (log != null) {
                                        log.println("DB open: " + (System.currentTimeMillis() - now));
                                        now = System.currentTimeMillis();
                                    }
                                    if ((str = star.getProperty(DICT_SCHEMA)) == null) {
                                        if (log != null) {
                                            log.println("Error in properties file: no dictionary SQL script. Terminating");
                                        }
                                        System.err.println("Error in properties file: no dictionary SQL script");
                                        Object var28_18 = null;
                                        if (star != null) {
                                            star.disconnect();
                                        }
                                        break block100;
                                    }
                                    BufferedReader in = new BufferedReader(new FileReader(str));
                                    RunSQL.run(star.getConnection(), in, null);
                                    in.close();
                                    in = new BufferedReader(new FileReader(dictfile));
                                    LoadDict dl = new LoadDict(star.getConnection());
                                    dl.load(in);
                                    in.close();
                                    str = star.getProperty(DICT_CONSTR);
                                    if (str == null) {
                                        if (log != null) {
                                            log.println("Error in properties file: no dictionary SQL (constraints) script. Terminating");
                                        }
                                        System.err.println("Error in properties file: no dictionary (constraints) SQL script");
                                        break block101;
                                    }
                                    in = new BufferedReader(new FileReader(str));
                                    RunSQL.run(star.getConnection(), in, null);
                                    in.close();
                                    if (log != null) {
                                        log.println("Dictionary loaded: " + (System.currentTimeMillis() - now));
                                        now = System.currentTimeMillis();
                                    }
                                    if ((str = star.getProperty(REFDB_SCHEMA)) == null) {
                                        if (log != null) {
                                            log.println("Error in properties file: no refdb SQL script. Terminating");
                                        }
                                        System.err.println("Error in properties file: no refdb SQL script");
                                        break block102;
                                    }
                                    in = new BufferedReader(new FileReader(str));
                                    RunSQL.run(star.getConnection(), in, null);
                                    in.close();
                                    in = new BufferedReader(new FileReader(reffile));
                                    dl.load(in);
                                    in.close();
                                    str = star.getProperty(REFDB_CONSTR);
                                    if (str == null) {
                                        if (log != null) {
                                            log.println("Error in properties file: no refdb SQL (constraints) script. Terminating");
                                        }
                                        System.err.println("Error in properties file: no refdb (constraints) SQL script");
                                        break block103;
                                    }
                                    in = new BufferedReader(new FileReader(str));
                                    RunSQL.run(star.getConnection(), in, null);
                                    in.close();
                                    in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(infile), "ISO-8859-15"));
                                    LoadMetadata ldr = new LoadMetadata(star, errs);
                                    rc = ldr.load(in, true);
                                    in.close();
                                    if (rc) {
                                        ValidationFunction vfn;
                                        EditingFunction fn;
                                        star.getConnection().commit();
                                        if (log != null) {
                                            log.println("Entry loaded: " + (System.currentTimeMillis() - now));
                                            now = System.currentTimeMillis();
                                        }
                                        AddDictionaryInfo.addDictionaryInfo(star);
                                        if (!AddDictionaryInfo.checkVersion(star, null)) {
                                            errs.add(new Error(false, -1, -1, 0, "NMR-STAR versions don't match!"));
                                        }
                                        if (log != null) {
                                            log.println("Added dictionary overrides: " + (System.currentTimeMillis() - now));
                                            now = System.currentTimeMillis();
                                        }
                                        if (!(fn = new TrimAditDeposition(errs, cf, star)).edit(false)) {
                                            rc = false;
                                        }
                                        if (!(fn = new TrimValues(errs, cf, star)).edit(false)) {
                                            rc = false;
                                        }
                                        if (!(fn = new FixFramecodes(errs, cf, star)).edit(false)) {
                                            rc = false;
                                        }
                                        if (!(fn = new MarkFramecodeValues(errs, cf, star)).edit(false)) {
                                            rc = false;
                                        }
                                        if (!(fn = new InsertValues(errs, cf, star)).edit(false)) {
                                            rc = false;
                                        }
                                        if (!(vfn = new CheckSaveFrames(errs, cf)).validate(star.getConnection())) {
                                            rc = false;
                                        }
                                        if (!(vfn = new CheckInvalidTags(errs, cf)).validate(star.getConnection())) {
                                            rc = false;
                                        }
                                        if (!(vfn = new CheckMandatoryTags(errs, cf)).validate(star.getConnection())) {
                                            rc = false;
                                        }
                                        if (!(vfn = new CheckTagOrder(errs, cf)).validate(star.getConnection())) {
                                            rc = false;
                                        }
                                        if (!(vfn = new CheckFrameCodes(errs, cf)).validate(star.getConnection())) {
                                            rc = false;
                                        }
                                        if (!(vfn = new CheckDataTypes(errs, cf)).validate(star.getConnection())) {
                                            rc = false;
                                        }
                                        if (!(vfn = new CheckDataValues(errs, cf)).validate(star.getConnection())) {
                                            rc = false;
                                        }
                                        if (!(vfn = new CheckEmptyRows(errs, cf)).validate(star.getConnection())) {
                                            rc = false;
                                        }
                                        if (!(vfn = new CheckCharset(errs, cf)).validate(star.getConnection())) {
                                            rc = false;
                                        }
                                        if (!(vfn = new CheckXlinkBond(errs, cf)).validate(star.getConnection())) {
                                            rc = false;
                                        }
                                        if (!(vfn = new CheckResidueSequence(errs, cf)).validate(star.getConnection())) {
                                            rc = false;
                                        }
                                        if (!(fn = new EditResidueLabels(errs, cf, star)).edit(false)) {
                                            rc = false;
                                        }
                                        if (!(fn = new InsertLocalIDs(errs, cf, star)).edit(false)) {
                                            rc = false;
                                        }
                                        if (!(fn = new InsertEntryID(errs, cf, star)).edit(false)) {
                                            rc = false;
                                        }
                                        if (!(fn = new UpdateRelatedTags(errs, cf, star)).edit(false)) {
                                            rc = false;
                                        }
                                        if (!(fn = new InsertDataSetCount(errs, cf, star)).edit(false)) {
                                            rc = false;
                                        }
                                        if (!(fn = new AddRowIndexes(errs, cf, star)).edit(false)) {
                                            rc = false;
                                        }
                                        if (log != null) {
                                            log.println("Edited: " + (System.currentTimeMillis() - now));
                                            now = System.currentTimeMillis();
                                        }
                                        star.setSortTags(true);
                                        star.setReindexLoops(true);
                                        BlockNode data = UnparseToStarlib.createDataNode(star, true);
                                        AddDataTags adt = new AddDataTags(data, star);
                                        in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(infile), "ISO-8859-15"));
                                        adt.parse(in);
                                        in.close();
                                        StarUnparser unp = outfile == null ? new StarUnparser(System.out) : new StarUnparser(new FileOutputStream(outfile));
                                        unp.writeOut(data, 0);
                                        if (log != null) {
                                            log.println("Unparse finished: " + (System.currentTimeMillis() - now));
                                            now = System.currentTimeMillis();
                                        }
                                    }
                                    star.disconnect();
                                    if (log != null) {
                                        log.println("Total time: " + (System.currentTimeMillis() - total));
                                    }
                                    break block104;
                                }
                                catch (Exception e) {
                                    System.err.println(e);
                                    e.printStackTrace();
                                    if (log != null) {
                                        log.println(e);
                                        e.printStackTrace(log);
                                    }
                                    rc = false;
                                    Object var28_23 = null;
                                    if (star != null) {
                                        star.disconnect();
                                    }
                                    if (log != null) {
                                        log.println("DB closed: " + (System.currentTimeMillis() - now));
                                    }
                                    if (errs != null && errs.size() > 0) {
                                        if (log != null) {
                                            errs.printErrors(log);
                                        } else {
                                            errs.printErrors(System.out);
                                        }
                                    }
                                    if (log != null) {
                                        log.flush();
                                        log.close();
                                    }
                                    if (rc) return;
                                    System.exit(5);
                                    return;
                                }
                            }
                            catch (Throwable throwable) {
                                Object var28_24 = null;
                                if (star != null) {
                                    star.disconnect();
                                }
                                if (log != null) {
                                    log.println("DB closed: " + (System.currentTimeMillis() - now));
                                }
                                if (errs != null && errs.size() > 0) {
                                    if (log != null) {
                                        errs.printErrors(log);
                                    } else {
                                        errs.printErrors(System.out);
                                    }
                                }
                                if (log != null) {
                                    log.flush();
                                    log.close();
                                }
                                if (rc) throw throwable;
                                System.exit(5);
                                throw throwable;
                            }
                        }
                        if (log != null) {
                            log.println("DB closed: " + (System.currentTimeMillis() - now));
                        }
                        if (errs != null && errs.size() > 0) {
                            if (log != null) {
                                errs.printErrors(log);
                            } else {
                                errs.printErrors(System.out);
                            }
                        }
                        if (log != null) {
                            log.flush();
                            log.close();
                        }
                        if (rc) return;
                        System.exit(5);
                        return;
                    }
                    Object var28_19 = null;
                    if (star != null) {
                        star.disconnect();
                    }
                    if (log != null) {
                        log.println("DB closed: " + (System.currentTimeMillis() - now));
                    }
                    if (errs != null && errs.size() > 0) {
                        if (log != null) {
                            errs.printErrors(log);
                        } else {
                            errs.printErrors(System.out);
                        }
                    }
                    if (log != null) {
                        log.flush();
                        log.close();
                    }
                    if (rc) return;
                    System.exit(5);
                    return;
                }
                Object var28_20 = null;
                if (star != null) {
                    star.disconnect();
                }
                if (log != null) {
                    log.println("DB closed: " + (System.currentTimeMillis() - now));
                }
                if (errs != null && errs.size() > 0) {
                    if (log != null) {
                        errs.printErrors(log);
                    } else {
                        errs.printErrors(System.out);
                    }
                }
                if (log != null) {
                    log.flush();
                    log.close();
                }
                if (rc) return;
                System.exit(5);
                return;
            }
            Object var28_21 = null;
            if (star != null) {
                star.disconnect();
            }
            if (log != null) {
                log.println("DB closed: " + (System.currentTimeMillis() - now));
            }
            if (errs != null && errs.size() > 0) {
                if (log != null) {
                    errs.printErrors(log);
                } else {
                    errs.printErrors(System.out);
                }
            }
            if (log != null) {
                log.flush();
                log.close();
            }
            if (rc) return;
            System.exit(5);
            return;
        }
        Object var28_22 = null;
        if (star != null) {
            star.disconnect();
        }
        if (log != null) {
            log.println("DB closed: " + (System.currentTimeMillis() - now));
        }
        if (errs != null && errs.size() > 0) {
            if (log != null) {
                errs.printErrors(log);
            } else {
                errs.printErrors(System.out);
            }
        }
        if (log != null) {
            log.flush();
            log.close();
        }
        if (rc) return;
        System.exit(5);
    }
}

