/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.validator;

import EDU.bmrb.stardb.AddDataTags;
import EDU.bmrb.stardb.AddDictionaryInfo;
import EDU.bmrb.stardb.LoadMetadata;
import EDU.bmrb.stardb.Star_DB;
import EDU.bmrb.stardb.Stardb;
import EDU.bmrb.stardb.UnparseToStarlib;
import EDU.bmrb.stardb.sdbException;
import EDU.bmrb.starlibj.BlockNode;
import EDU.bmrb.starlibj.StarUnparser;
import EDU.bmrb.validator.Config;
import EDU.bmrb.validator.EditingFunction;
import EDU.bmrb.validator.Error;
import EDU.bmrb.validator.ErrorList;
import EDU.bmrb.validator.functions.AddRowIndexes;
import EDU.bmrb.validator.functions.EditResidueLabels;
import EDU.bmrb.validator.functions.FixFramecodes;
import EDU.bmrb.validator.functions.InsertDataSetCount;
import EDU.bmrb.validator.functions.InsertEntryID;
import EDU.bmrb.validator.functions.InsertLocalIDs;
import EDU.bmrb.validator.functions.InsertResidueLoop;
import EDU.bmrb.validator.functions.InsertValues;
import EDU.bmrb.validator.functions.MarkFramecodeValues;
import EDU.bmrb.validator.functions.TrimAditDeposition;
import EDU.bmrb.validator.functions.TrimValues;
import EDU.bmrb.validator.functions.UpdateRelatedTags;
import edu.bmrb.starobj.db.LoadDict;
import edu.bmrb.starobj.db.RunSQL;
import gnu.getopt.Getopt;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;

public class PDBPostProcess {
    private static final boolean DEBUG = false;
    public static final String DICT_SCHEMA = "Dictionary.schema";
    public static final String DICT_CONSTR = "Dictionary.constraints";
    public static final String REFDB_SCHEMA = "Refdata.schema";
    public static final String REFDB_CONSTR = "Refdata.constraints";

    public static void usage() {
        System.out.print("Usage: java EDU.bmrb.validator.PDBPostProcess <-d FILE> ");
        System.out.println("<-r FILE> <-i FILE> [-c FILE] [-p FILE] [-o FILE] [-l FILE] [-h]");
        System.out.println(" -d FILE: dictionary FILE");
        System.out.println(" -r FILE: reference data FILE");
        System.out.println(" -i FILE: input FILE");
        System.out.print(" -p FILE: original PDBX FILE. If omitted, do not extract");
        System.out.println("          additional information from PDBX");
        System.out.print(" -c FILE: config FILE, default: ~/");
        System.out.println("validator.properties");
        System.out.println(" -o FILE: output FILE, use dash for stdout");
        System.out.println(" -l FILE: log FILE, use dash for stdout");
        System.out.println(" -h: print this message and exit");
    }

    private static boolean loadDictionary(Stardb star, String dictfile, String reffile, ErrorList errs, PrintStream log) {
        try {
            String str = star.getProperty(DICT_SCHEMA);
            if (str == null) {
                if (log != null) {
                    log.println("Error in properties file: no dictionary SQL script. Terminating");
                }
                System.err.println("Error in properties file: no dictionary SQL script");
                return false;
            }
            PrintWriter logw = null;
            if (log != null) {
                logw = new PrintWriter(log);
            }
            BufferedReader in = new BufferedReader(new FileReader(str));
            RunSQL.run(star.getConnection(), in, null);
            in.close();
            in = new BufferedReader(new FileReader(dictfile));
            LoadDict dl = new LoadDict(star.getConnection());
            dl.load(in);
            in.close();
            str = star.getProperty(DICT_CONSTR);
            if (str == null) {
                if (log != null) {
                    log.println("Error in properties file: no dictionary SQL (constraints) script. Terminating");
                }
                System.err.println("Error in properties file: no dictionary (constraints) SQL script");
                return false;
            }
            in = new BufferedReader(new FileReader(str));
            RunSQL.run(star.getConnection(), in, null);
            in.close();
            str = star.getProperty(REFDB_SCHEMA);
            if (str == null) {
                if (log != null) {
                    log.println("Error in properties file: no refdb SQL script. Terminating");
                }
                System.err.println("Error in properties file: no refdb SQL script");
                return false;
            }
            in = new BufferedReader(new FileReader(str));
            RunSQL.run(star.getConnection(), in, null);
            in.close();
            in = new BufferedReader(new FileReader(reffile));
            dl.load(in);
            in.close();
            str = star.getProperty(REFDB_CONSTR);
            if (str == null) {
                if (log != null) {
                    log.println("Error in properties file: no refdb SQL (constraints) script. Terminating");
                }
                System.err.println("Error in properties file: no refdb (constraints) SQL script");
                return false;
            }
            in = new BufferedReader(new FileReader(str));
            RunSQL.run(star.getConnection(), in, null);
            in.close();
            return true;
        }
        catch (IOException e) {
            System.err.println(e);
            e.printStackTrace();
            if (log != null) {
                log.println(e);
                e.printStackTrace(log);
            }
            return false;
        }
        catch (SQLException e) {
            System.err.println(e);
            e.printStackTrace();
            if (log != null) {
                log.println(e);
                e.printStackTrace(log);
            }
            return false;
        }
    }

    private static boolean loadEntry(Stardb star, String infile, ErrorList errs, PrintStream log) {
        try {
            InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(infile), "ISO-8859-15");
            LoadMetadata ldr = new LoadMetadata(star, errs);
            if (ldr.load(in, true)) {
                star.getConnection().commit();
            }
            ((Reader)in).close();
            AddDictionaryInfo.addDictionaryInfo(star);
            if (!AddDictionaryInfo.checkVersion(star, null)) {
                errs.add(new Error(false, -1, -1, 0, "NMR-STAR versions don't match!"));
            }
            return true;
        }
        catch (IOException e) {
            System.err.println(e);
            e.printStackTrace();
            if (log != null) {
                log.println(e);
                e.printStackTrace(log);
            }
            return false;
        }
        catch (SQLException e) {
            System.err.println(e);
            e.printStackTrace();
            if (log != null) {
                log.println(e);
                e.printStackTrace(log);
            }
            return false;
        }
        catch (sdbException e) {
            System.err.println(e);
            e.printStackTrace();
            if (log != null) {
                log.println(e);
                e.printStackTrace(log);
            }
            return false;
        }
    }

    private static boolean unparseToStarlib(Stardb star, String infile, String outfile, PrintStream log) {
        try {
            star.setSortTags(true);
            star.setReindexLoops(true);
            BlockNode data = UnparseToStarlib.createDataNode(star, true);
            AddDataTags adt = new AddDataTags(data, star);
            InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(infile), "ISO-8859-15");
            adt.parse(in);
            ((Reader)in).close();
            StarUnparser unp = outfile == null ? new StarUnparser(System.out) : new StarUnparser(new FileOutputStream(outfile));
            unp.writeOut(data, 0);
            return true;
        }
        catch (IOException e) {
            System.err.println(e);
            e.printStackTrace();
            if (log != null) {
                log.println(e);
                e.printStackTrace(log);
            }
            return false;
        }
        catch (SQLException e) {
            System.err.println(e);
            e.printStackTrace();
            if (log != null) {
                log.println(e);
                e.printStackTrace(log);
            }
            return false;
        }
    }

    private static boolean readPdbx(Stardb star, String pdbxfile, PrintStream log) {
        try {
            String line;
            StringBuilder buf = new StringBuilder();
            boolean inloop = false;
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(pdbxfile), "ISO-8859-15"));
            while ((line = in.readLine()) != null) {
                if (!inloop && line.trim().matches("^_struct_conn[.].*")) {
                    inloop = true;
                }
                if (!inloop) continue;
                if (line.trim().matches("^_struct_conn_.*")) {
                    inloop = false;
                    break;
                }
                buf.append(line);
                buf.append('\n');
            }
            in.close();
            if (buf.length() > 0) {
                Statement query = star.getQueryStatement();
                ResultSet rs = query.executeQuery("SELECT v.ID FROM ENTRYVALS v,ENTRYTAGS t WHERE t.NAME='_Assembly.Details' AND v.TAGID=t.ID");
                if (!rs.next()) {
                    System.err.println("No _Assembly.Details (should never happen)");
                    query.close();
                    return false;
                }
                line = rs.getString(1);
                query.close();
                Statement stat = star.getStatement();
                String val = buf.toString().replaceAll("'", "''");
                stat.executeUpdate("UPDATE ENTRYVALS SET VAL='" + val + "',DELIMITER=11 WHERE ID=" + line);
                if (!stat.getConnection().getAutoCommit()) {
                    stat.getConnection().commit();
                }
            }
            return true;
        }
        catch (IOException e) {
            System.err.println(e);
            e.printStackTrace();
            if (log != null) {
                log.println(e);
                e.printStackTrace(log);
            }
            return false;
        }
        catch (SQLException e) {
            System.err.println(e);
            e.printStackTrace();
            if (log != null) {
                log.println(e);
                e.printStackTrace(log);
            }
            return false;
        }
    }

    private static boolean addDataTables(Stardb star, PrintStream log) {
        try {
            PreparedStatement pstat = star.getPreparedStatement("UPDATE ENTRYVALS SET VAL=?,DELIMITER=10 WHERE LOOPROW=? AND TAGID=(SELECT ID FROM ENTRYTAGS WHERE NAME='_Upload_data.Data_file_Sf_category')");
            PreparedStatement pstat2 = star.getPreparedStatement("UPDATE ENTRYVALS SET VAL=? WHERE TAGID=(SELECT ID FROM ENTRYTAGS WHERE NAME=?)");
            Statement query = star.getQueryStatement();
            ResultSet rs = query.executeQuery("SELECT v.VAL,v.LOOPROW FROM ENTRYVALS v,ENTRYTAGS t WHERE t.NAME='_Upload_data.Data_file_name' ORDER BY v.LOOPROW");
            while (rs.next()) {
                rs.getString(1);
                if (rs.wasNull()) continue;
                if (rs.getString(1).trim().matches(".*-cs-.*")) {
                    pstat.setString(1, "Assigned chemical shifts");
                    pstat.setInt(2, rs.getInt(2));
                    pstat.executeUpdate();
                    pstat2.setString(1, "yes");
                    pstat2.setString(2, "_Entry_interview.Assigned_chem_shifts");
                    pstat2.executeUpdate();
                    pstat2.setString(1, rs.getString(1).trim());
                    pstat2.setString(2, "_Assigned_chem_shift_list.Data_file_name");
                    pstat2.executeUpdate();
                    pstat2.setString(1, "ask author");
                    pstat2.setString(2, "_Chem_shift_reference.Proton_shifts_flag");
                    pstat2.executeUpdate();
                }
                if (!rs.getString(1).trim().matches(".*-cc-.*")) continue;
                pstat.setString(1, "Coupling constants");
                pstat.setInt(2, rs.getInt(2));
                pstat.executeUpdate();
                pstat2.setString(1, "yes");
                pstat2.setString(2, "_Entry_interview.Coupling_constants");
                pstat2.executeUpdate();
                pstat2.setString(1, rs.getString(1).trim());
                pstat2.setString(2, "_Coupling_constant_list.Data_file_name");
                pstat2.executeUpdate();
            }
            rs.close();
            if (!pstat.getConnection().getAutoCommit()) {
                pstat.getConnection().commit();
            }
            pstat.close();
            if (!pstat2.getConnection().getAutoCommit()) {
                pstat2.getConnection().commit();
            }
            pstat2.close();
            return true;
        }
        catch (SQLException e) {
            System.err.println(e);
            e.printStackTrace();
            if (log != null) {
                log.println(e);
                e.printStackTrace(log);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        boolean rc;
        PrintStream log;
        ErrorList errs;
        Stardb star;
        long total;
        long now;
        block80: {
            block79: {
                block78: {
                    total = now = System.currentTimeMillis();
                    star = null;
                    errs = null;
                    log = null;
                    rc = true;
                    try {
                        try {
                            int i;
                            int opt;
                            Getopt g = new Getopt("PDBPostProcess", args, "d:c:i:l:o:p:r:h");
                            String dictfile = null;
                            String reffile = null;
                            String conffile = null;
                            String infile = null;
                            String pdbxfile = null;
                            String outfile = null;
                            String logfile = null;
                            block13: while ((opt = g.getopt()) != -1) {
                                switch (opt) {
                                    case 99: {
                                        conffile = g.getOptarg();
                                        continue block13;
                                    }
                                    case 100: {
                                        dictfile = g.getOptarg();
                                        continue block13;
                                    }
                                    case 105: {
                                        infile = g.getOptarg();
                                        continue block13;
                                    }
                                    case 108: {
                                        logfile = g.getOptarg();
                                        continue block13;
                                    }
                                    case 111: {
                                        outfile = g.getOptarg();
                                        continue block13;
                                    }
                                    case 112: {
                                        pdbxfile = g.getOptarg();
                                        continue block13;
                                    }
                                    case 114: {
                                        reffile = g.getOptarg();
                                        continue block13;
                                    }
                                }
                                PDBPostProcess.usage();
                                System.exit(1);
                            }
                            if (dictfile == null) {
                                System.err.println("No dictionary");
                                PDBPostProcess.usage();
                                System.exit(2);
                            }
                            if (reffile == null) {
                                System.err.println("No reference data");
                                PDBPostProcess.usage();
                                System.exit(3);
                            }
                            if (infile == null) {
                                System.err.println("No input file");
                                PDBPostProcess.usage();
                                System.exit(4);
                            }
                            Config cf = conffile == null ? new Config() : new Config(conffile);
                            star = new Star_DB(cf.getProperties());
                            errs = new ErrorList(true);
                            star.connect(false);
                            if (logfile != null) {
                                log = logfile.equals("-") ? System.err : new PrintStream(new FileOutputStream(logfile, true));
                            }
                            if (log != null) {
                                log.println("DB open: " + (System.currentTimeMillis() - now));
                                now = System.currentTimeMillis();
                            }
                            if (!PDBPostProcess.loadDictionary(star, dictfile, reffile, errs, log)) {
                                star.close();
                                Object var26_18 = null;
                                if (star != null) {
                                    star.disconnect();
                                }
                                break block78;
                            }
                            if (log != null) {
                                log.println("Dictionary loaded: " + (System.currentTimeMillis() - now));
                                now = System.currentTimeMillis();
                            }
                            if (!PDBPostProcess.loadEntry(star, infile, errs, log)) {
                                star.close();
                                break block79;
                            }
                            if (log != null) {
                                log.println("Entry loaded: " + (System.currentTimeMillis() - now));
                                now = System.currentTimeMillis();
                            }
                            if (pdbxfile != null) {
                                PDBPostProcess.readPdbx(star, pdbxfile, log);
                            }
                            PDBPostProcess.addDataTables(star, log);
                            EditingFunction fn = new TrimAditDeposition(errs, cf, star);
                            if (!fn.edit(false)) {
                                rc = false;
                            }
                            if (!(fn = new TrimValues(errs, cf, star)).edit(false)) {
                                rc = false;
                            }
                            if (!(fn = new FixFramecodes(errs, cf, star)).edit(false)) {
                                rc = false;
                            }
                            if (!(fn = new MarkFramecodeValues(errs, cf, star)).edit(false)) {
                                rc = false;
                            }
                            if (!(fn = new InsertValues(errs, cf, star)).edit(false)) {
                                rc = false;
                            }
                            if (!(fn = new InsertLocalIDs(errs, cf, star)).edit(false)) {
                                rc = false;
                            }
                            ArrayList<Integer> list = new ArrayList<Integer>();
                            Statement stat = star.getStatement();
                            ResultSet rs = stat.executeQuery("SELECT DISTINCT LOOPID FROM ENTRYTAGS WHERE NAME LIKE '_Entity_comp_index.%'");
                            while (rs.next()) {
                                list.add(rs.getInt(1));
                            }
                            stat.executeUpdate("DELETE FROM ENTRYTAGS WHERE NAME LIKE '_Entity_comp_index.%'");
                            Iterator i$ = list.iterator();
                            while (i$.hasNext()) {
                                i = (Integer)i$.next();
                                stat.executeUpdate("DELETE FROM ENTRYLOOPS WHERE ID=" + i);
                            }
                            list.clear();
                            rs = stat.executeQuery("SELECT DISTINCT LOOPID FROM ENTRYTAGS WHERE NAME LIKE '_PDBX_poly_seq_scheme.%'");
                            while (rs.next()) {
                                list.add(rs.getInt(1));
                            }
                            stat.executeUpdate("DELETE FROM ENTRYTAGS WHERE NAME LIKE '_PDBX_poly_seq_scheme.%'");
                            i$ = list.iterator();
                            while (i$.hasNext()) {
                                i = (Integer)i$.next();
                                stat.executeUpdate("DELETE FROM ENTRYLOOPS WHERE ID=" + i);
                            }
                            list.clear();
                            rs = stat.executeQuery("SELECT DISTINCT LOOPID FROM ENTRYTAGS WHERE NAME LIKE '_PDBX_nonpoly_scheme.%'");
                            while (rs.next()) {
                                list.add(rs.getInt(1));
                            }
                            rs.close();
                            stat.executeUpdate("DELETE FROM ENTRYTAGS WHERE NAME LIKE '_PDBX_nonpoly_scheme.%'");
                            i$ = list.iterator();
                            while (i$.hasNext()) {
                                i = (Integer)i$.next();
                                stat.executeUpdate("DELETE FROM ENTRYLOOPS WHERE ID=" + i);
                            }
                            list.clear();
                            if (!stat.getConnection().getAutoCommit()) {
                                stat.getConnection().commit();
                            }
                            stat.close();
                            fn = new InsertResidueLoop(errs, cf, star);
                            if (!fn.edit(false)) {
                                rc = false;
                            }
                            if (!(fn = new EditResidueLabels(errs, cf, star)).edit(false)) {
                                rc = false;
                            }
                            if (!(fn = new InsertLocalIDs(errs, cf, star)).edit(false)) {
                                rc = false;
                            }
                            if (!(fn = new InsertEntryID(errs, cf, star)).edit(false)) {
                                rc = false;
                            }
                            if (!(fn = new UpdateRelatedTags(errs, cf, star)).edit(false)) {
                                rc = false;
                            }
                            if (!(fn = new InsertDataSetCount(errs, cf, star)).edit(false)) {
                                rc = false;
                            }
                            if (!(fn = new AddRowIndexes(errs, cf, star)).edit(false)) {
                                rc = false;
                            }
                            fn = null;
                            if (log != null) {
                                log.println("Edited: " + (System.currentTimeMillis() - now));
                                now = System.currentTimeMillis();
                            }
                            PDBPostProcess.unparseToStarlib(star, infile, outfile, log);
                            if (log != null) {
                                log.println("Unparse finished: " + (System.currentTimeMillis() - now));
                                now = System.currentTimeMillis();
                            }
                            break block80;
                        }
                        catch (Exception e) {
                            System.err.println(e);
                            e.printStackTrace();
                            if (log != null) {
                                log.println(e);
                                e.printStackTrace(log);
                            }
                            rc = false;
                            Object var26_21 = null;
                            if (star != null) {
                                star.disconnect();
                            }
                            if (log != null) {
                                log.println("DB closed: " + (System.currentTimeMillis() - now));
                                log.println("Total time: " + (System.currentTimeMillis() - total));
                            }
                            if (errs != null && errs.size() > 0) {
                                if (log != null) {
                                    errs.printErrors(log);
                                } else {
                                    errs.printErrors(System.out);
                                }
                            }
                            if (log != null) {
                                log.flush();
                                log.close();
                            }
                            if (rc) return;
                            System.exit(5);
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var26_22 = null;
                        if (star != null) {
                            star.disconnect();
                        }
                        if (log != null) {
                            log.println("DB closed: " + (System.currentTimeMillis() - now));
                            log.println("Total time: " + (System.currentTimeMillis() - total));
                        }
                        if (errs != null && errs.size() > 0) {
                            if (log != null) {
                                errs.printErrors(log);
                            } else {
                                errs.printErrors(System.out);
                            }
                        }
                        if (log != null) {
                            log.flush();
                            log.close();
                        }
                        if (rc) throw throwable;
                        System.exit(5);
                        throw throwable;
                    }
                }
                if (log != null) {
                    log.println("DB closed: " + (System.currentTimeMillis() - now));
                    log.println("Total time: " + (System.currentTimeMillis() - total));
                }
                if (errs != null && errs.size() > 0) {
                    if (log != null) {
                        errs.printErrors(log);
                    } else {
                        errs.printErrors(System.out);
                    }
                }
                if (log != null) {
                    log.flush();
                    log.close();
                }
                if (rc) return;
                System.exit(5);
                return;
            }
            Object var26_19 = null;
            if (star != null) {
                star.disconnect();
            }
            if (log != null) {
                log.println("DB closed: " + (System.currentTimeMillis() - now));
                log.println("Total time: " + (System.currentTimeMillis() - total));
            }
            if (errs != null && errs.size() > 0) {
                if (log != null) {
                    errs.printErrors(log);
                } else {
                    errs.printErrors(System.out);
                }
            }
            if (log != null) {
                log.flush();
                log.close();
            }
            if (rc) return;
            System.exit(5);
            return;
        }
        Object var26_20 = null;
        if (star != null) {
            star.disconnect();
        }
        if (log != null) {
            log.println("DB closed: " + (System.currentTimeMillis() - now));
            log.println("Total time: " + (System.currentTimeMillis() - total));
        }
        if (errs != null && errs.size() > 0) {
            if (log != null) {
                errs.printErrors(log);
            } else {
                errs.printErrors(System.out);
            }
        }
        if (log != null) {
            log.flush();
            log.close();
        }
        if (rc) return;
        System.exit(5);
    }
}

