/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.validator.functions;

import EDU.bmrb.sansj.ContentHandler;
import EDU.bmrb.sansj.DataItemNode;
import EDU.bmrb.sansj.ErrorHandler;
import EDU.bmrb.sansj.STARLexer;
import EDU.bmrb.sansj.SansParser;
import EDU.bmrb.stardb.Star_DB;
import EDU.bmrb.validator.Config;
import EDU.bmrb.validator.DataValidationFunction;
import EDU.bmrb.validator.Error;
import EDU.bmrb.validator.ErrorList;
import EDU.bmrb.validator.Severity;
import gnu.getopt.Getopt;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class CheckAmbiguityCodes
extends DataValidationFunction
implements ErrorHandler,
ContentHandler {
    private static final boolean DEBUG = false;
    public static final int NUMBER = 22;
    public static final String SHIFTCAT = "Atom_chem_shift";
    public static final String AMBICAT = "Ambiguous_atom_chem_shift";
    private String fSfName = null;
    private boolean fInLoop = false;
    private boolean fInShifts = false;
    private String fFirstTag = null;
    private int fRow = 0;
    private boolean fFirstRow = true;
    private Row fLastRow = null;
    private boolean fHasAmbiLoop = false;
    private ArrayList<Row> fAmbiShifts = null;
    private PreparedStatement fAmbiQuery = null;
    private ResultSet fRs = null;
    private String[] LOOP_TAGS = null;
    private String[] AMBI_TAGS = null;
    private static int SEQ_IDX = -1;
    private static int LBL_IDX = -1;
    private static int ATOM_IDX = -1;
    private static int TYPE_IDX = -1;
    private static int VAL_IDX = -1;
    private static int AMBI_IDX = -1;

    public CheckAmbiguityCodes(ErrorList errs, Config conf) {
        super(errs, conf);
        this.fNum = 22;
        this.fName = CheckAmbiguityCodes.className(this.getClass().getName());
        this.init(22);
        this.fAmbiShifts = new ArrayList();
    }

    public boolean validate(Connection conn, Reader in) {
        try {
            if (this.fAmbiQuery == null) {
                this.fAmbiQuery = conn.prepareStatement("SELECT c.AMBICODE FROM AMBICODES c JOIN ATOMS a ON a.ID=c.ATOMID JOIN RESIDUES r ON r.ID=a.RESID WHERE r.LABEL=? AND a.NAME=? AND c.AMBICODE=?", 1003, 1007);
            }
            if (!this.getLoopTags(conn)) {
                return false;
            }
            STARLexer lex = new STARLexer(in);
            SansParser p = new SansParser(lex, this, this);
            p.parse();
            if (this.fRs != null) {
                this.fRs.close();
            }
            this.fAmbiQuery.close();
            this.fAmbiQuery = null;
            return true;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            this.fErrs.add(new Error(Severity.CRIT, 22, -1, -1, "Caught exception, check error output"));
            return false;
        }
    }

    private boolean getLoopTags(Connection conn) {
        try {
            ArrayList<String> shift_tags = new ArrayList<String>();
            ArrayList<String> ambi_tags = new ArrayList<String>();
            Statement query = conn.createStatement(1003, 1007);
            ResultSet rs = query.executeQuery("SELECT TAGNAME,ROWIDXFLAG FROM TAGS WHERE TAGCAT='Atom_chem_shift'");
            while (rs.next()) {
                rs.getString(2);
                if (!rs.wasNull() && rs.getString(2).toUpperCase().equals("Y")) {
                    shift_tags.add(0, rs.getString(1));
                    continue;
                }
                shift_tags.add(rs.getString(1));
            }
            rs = query.executeQuery("SELECT TAGNAME FROM TAGS WHERE TAGCAT='Ambiguous_atom_chem_shift'");
            while (rs.next()) {
                ambi_tags.add(rs.getString(1));
            }
            rs.close();
            query.close();
            if (ambi_tags.size() > 0) {
                this.AMBI_TAGS = new String[ambi_tags.size()];
                for (int i = 0; i < ambi_tags.size(); ++i) {
                    this.AMBI_TAGS[i] = (String)ambi_tags.get(i);
                }
                ambi_tags.clear();
            }
            if (shift_tags.size() > 0) {
                this.LOOP_TAGS = new String[shift_tags.size()];
                PreparedStatement pquery = conn.prepareStatement("SELECT SEQID,COMPID,ATOMID,ATOMTYPE,VAL,AMBICODE,AUTHOR FROM STARCH WHERE TAGNAME=?", 1003, 1007);
                block13: for (int i = 0; i < shift_tags.size(); ++i) {
                    this.LOOP_TAGS[i] = (String)shift_tags.get(i);
                    pquery.setString(1, this.LOOP_TAGS[i]);
                    rs = pquery.executeQuery();
                    if (!rs.next()) continue;
                    rs.getString(7);
                    if (!rs.wasNull() && rs.getString(7).toUpperCase().equals("Y")) continue;
                    block14: for (int j = 1; j < 7; ++j) {
                        rs.getString(j);
                        if (rs.wasNull() || !rs.getString(j).toUpperCase().equals("Y")) continue;
                        switch (j) {
                            case 1: {
                                SEQ_IDX = i;
                                continue block13;
                            }
                            case 2: {
                                LBL_IDX = i;
                                continue block13;
                            }
                            case 3: {
                                ATOM_IDX = i;
                                continue block13;
                            }
                            case 4: {
                                TYPE_IDX = i;
                                continue block13;
                            }
                            case 5: {
                                VAL_IDX = i;
                                continue block13;
                            }
                            case 6: {
                                AMBI_IDX = i;
                                continue block13;
                            }
                            default: {
                                continue block14;
                            }
                        }
                    }
                }
                rs.close();
                pquery.close();
            }
            if (this.AMBI_TAGS == null || this.LOOP_TAGS == null) {
                this.fErrs.add(new Error(Severity.CRIT, 22, -1, -1, "Dictionary problem, no tag names"));
                return false;
            }
            return true;
        }
        catch (SQLException e) {
            this.fErrs.add(new Error(Severity.CRIT, 22, -1, -1, "DB exception, check error output"));
            System.err.println(e);
            e.printStackTrace();
            return false;
        }
    }

    public void checkRow() {
        int code = -1;
        try {
            code = Integer.parseInt(this.fLastRow.code);
        }
        catch (NumberFormatException e) {
            code = -1;
        }
        if (code < 0) {
            this.fErrs.add(new Error(Severity.ERR, 22, 0, this.fLastRow.line, "Shift ambiguity code is not a number: %s", this.fLastRow));
        } else if (code == 0) {
            this.fErrs.add(new Error(Severity.ERR, 22, 1, this.fLastRow.line, "Invalid ambiguity code %s", this.fLastRow));
        } else {
            try {
                this.fAmbiQuery.setString(1, this.fLastRow.label);
                this.fAmbiQuery.setString(2, this.fLastRow.atom);
                this.fAmbiQuery.setInt(3, code);
                this.fRs = this.fAmbiQuery.executeQuery();
                if (this.fRs.next()) {
                    this.fErrs.add(new Error(Severity.ERR, 22, 1, this.fLastRow.line, "Invalid ambiguity code %s: %s", this.fLastRow.code, this.fLastRow));
                }
            }
            catch (SQLException e) {
                System.err.println(e);
                e.printStackTrace();
                this.fErrs.add(new Error(Severity.CRIT, 22, -1, -1, "DB exception, check error output"));
            }
        }
        if (code == 4 || code == 5) {
            this.fAmbiShifts.add(this.fLastRow);
        }
        ++this.fRow;
        this.fLastRow = new Row();
    }

    public static void usage() {
        System.err.print("Usage: java EDU.bmrb.validator.functions.CheckAmbiguityCodes ");
        System.err.println("[-c FILE] [-i FILE] [-h]");
        System.err.println("  -c FILE: use config FILE instead of ~/validator.conf");
        System.err.println("  -i FILE: input file name (default: stdin)");
        System.err.println("  -h: print this message");
    }

    public static void main(String[] args) {
        try {
            int opt;
            Getopt g = new Getopt("CheckAmbiguityCodes", args, "c:i:h");
            String conffile = null;
            String infile = null;
            block6: while ((opt = g.getopt()) != -1) {
                switch (opt) {
                    case 99: {
                        conffile = g.getOptarg();
                        continue block6;
                    }
                    case 105: {
                        infile = g.getOptarg();
                        continue block6;
                    }
                }
                CheckAmbiguityCodes.usage();
                return;
            }
            Config conf = conffile == null ? new Config() : new Config(conffile);
            ErrorList errs = new ErrorList();
            BufferedReader in = infile == null ? new BufferedReader(new InputStreamReader(System.in)) : new BufferedReader(new FileReader(infile));
            long start = System.currentTimeMillis();
            Star_DB star = new Star_DB(conf.getProperties());
            star.connect(true);
            System.err.println("DB open: " + (System.currentTimeMillis() - start));
            CheckAmbiguityCodes chk = new CheckAmbiguityCodes(errs, conf);
            chk.validate(star.getConnection(), in);
            System.err.println("Validated: " + (System.currentTimeMillis() - start));
            star.disconnect();
            ((Reader)in).close();
            if (errs.size() > 0) {
                errs.sort();
                errs.printErrors(System.out);
            }
            System.err.println("Elapsed: " + (System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }

    public void error(int param, int param1, String str) {
        this.fErrs.add(new Error(Severity.CRIT, 22, -1, param, str));
        System.err.printf("Parse error in line %d, col %d: %s\n", param, param1, str);
    }

    public boolean warning(int param, int param1, String str) {
        this.fErrs.add(new Error(Severity.ERR, 22, -1, param, str));
        System.err.printf("Parse warning in line %d, col %d: %s\n", param, param1, str);
        return false;
    }

    public boolean startSaveFrame(int param, String str) {
        this.fSfName = str;
        this.fHasAmbiLoop = false;
        this.fAmbiShifts.clear();
        return false;
    }

    public boolean endSaveFrame(int param, String str) {
        if (this.fAmbiShifts.size() > 0) {
            for (Row r : this.fAmbiShifts) {
                this.fErrs.add(new Error(Severity.ERR, 22, 2, r.line, "Ambiguity code 4 or 5: %s", r));
            }
        }
        this.fSfName = null;
        return false;
    }

    public boolean startLoop(int param) {
        this.fInLoop = true;
        this.fFirstRow = true;
        return false;
    }

    public boolean endLoop(int param) {
        if (this.fInShifts) {
            this.checkRow();
        }
        this.fInLoop = false;
        this.fInShifts = false;
        this.fFirstTag = null;
        this.fRow = 0;
        return false;
    }

    public boolean data(DataItemNode node) {
        int i;
        if (!this.fInLoop) {
            return false;
        }
        if (!this.fInShifts) {
            for (i = 0; i < this.LOOP_TAGS.length; ++i) {
                if (!this.LOOP_TAGS[i].equals(node.getName())) continue;
                this.fInShifts = true;
                break;
            }
        }
        if (!this.fInShifts) {
            for (i = 0; i < this.AMBI_TAGS.length; ++i) {
                if (!this.AMBI_TAGS[i].equals(node.getName())) continue;
                this.fHasAmbiLoop = true;
            }
            return false;
        }
        if (this.fFirstTag == null) {
            this.fFirstTag = node.getTag();
            this.fLastRow = new Row();
        }
        if (this.fFirstTag.equals(node.getTag())) {
            if (this.fFirstRow) {
                this.fFirstRow = false;
            } else {
                this.checkRow();
            }
        }
        if (node.getTag().equals(this.LOOP_TAGS[0])) {
            this.fLastRow.id = node.getValue();
        }
        if (node.getTag().equals(this.LOOP_TAGS[SEQ_IDX])) {
            this.fLastRow.seq = node.getValue();
        }
        if (node.getTag().equals(this.LOOP_TAGS[LBL_IDX])) {
            this.fLastRow.label = node.getValue();
        }
        if (node.getTag().equals(this.LOOP_TAGS[ATOM_IDX])) {
            this.fLastRow.atom = node.getValue();
        }
        if (node.getTag().equals(this.LOOP_TAGS[TYPE_IDX])) {
            this.fLastRow.type = node.getValue();
        }
        if (node.getTag().equals(this.LOOP_TAGS[VAL_IDX])) {
            this.fLastRow.shift = node.getValue();
        }
        if (node.getTag().equals(this.LOOP_TAGS[AMBI_IDX])) {
            this.fLastRow.line = node.getValueLine();
            this.fLastRow.code = node.getValue();
        }
        return false;
    }

    public boolean comment(int param, String str) {
        return false;
    }

    public boolean startData(int param, String str) {
        return false;
    }

    public void endData(int param, String str) {
    }

    class Row {
        int line = -1;
        String id = null;
        String seq = null;
        String label = null;
        String atom = null;
        String type = null;
        String shift = null;
        String code = null;

        Row() {
        }

        public String toString() {
            int i;
            StringBuilder buf = new StringBuilder();
            if (Integer.toString(this.line).length() < 6) {
                for (i = Integer.toString(this.line).length(); i < 6; ++i) {
                    buf.append(' ');
                }
            }
            if (this.id == null) {
                System.err.printf("Id is null: %s %s %s\n", this.seq, this.label, this.atom);
            } else {
                buf.append(this.id);
                if (this.id.length() < 6) {
                    for (i = this.id.length(); i < 6; ++i) {
                        buf.append(' ');
                    }
                }
            }
            buf.append(this.seq);
            if (this.seq.length() < 5) {
                for (i = this.seq.length(); i < 5; ++i) {
                    buf.append(' ');
                }
            }
            buf.append(' ');
            buf.append(this.label);
            if (this.label.length() < 3) {
                for (i = this.seq.length(); i < 3; ++i) {
                    buf.append(' ');
                }
            }
            buf.append("  ");
            buf.append(this.atom);
            if (this.atom.length() < 2) {
                for (i = this.atom.length(); i < 2; ++i) {
                    buf.append(' ');
                }
            }
            buf.append("  ");
            buf.append(this.type);
            if (this.type.length() < 2) {
                for (i = this.type.length(); i < 2; ++i) {
                    buf.append(' ');
                }
            }
            buf.append("  ");
            buf.append(this.shift);
            if (this.shift.length() < 9) {
                for (i = this.shift.length(); i < 9; ++i) {
                    buf.append(' ');
                }
            }
            buf.append("  ");
            buf.append(this.code);
            return buf.toString();
        }
    }
}

