/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.validator.functions;

import EDU.bmrb.stardb.Star_DB;
import EDU.bmrb.validator.Config;
import EDU.bmrb.validator.Error;
import EDU.bmrb.validator.ErrorList;
import EDU.bmrb.validator.ValidationFunction;
import EDU.bmrb.validator.utils.TypeChecker;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;

public class CheckDataTypes
extends ValidationFunction {
    public static final int NUMBER = 11;
    public static final String[] ERRS = new String[]{"Not a framecode value: ", "Not an integer value: ", "Not a floating-point value: ", "Not a valid date: ", "Value too long: ", "Whitespace in framecode value: "};

    public CheckDataTypes(ErrorList errs, Config conf) {
        super(errs, conf);
        this.fNum = new Integer(11);
        this.fName = CheckDataTypes.className(this.getClass().getName());
        this.init(11);
    }

    public boolean validate(Connection conn) {
        boolean rc = true;
        ResultSet rs = null;
        StringBuffer sql = new StringBuffer();
        try {
            Statement stat = conn.createStatement(1004, 1007);
            sql.append("SELECT v.LINE,v.VAL,d.TAGNAME FROM TAGS d,ENTRYVALS v ");
            sql.append("WHERE d.VALTYPE='FRAMECODE' AND v.DELIMITER<>");
            sql.append(12);
            sql.append(" AND v.SEQ IS NOT NULL AND v.VAL IS NOT NULL");
            sql.append(" AND v.VAL<>'.' AND v.VAL<>'?' AND v.SEQ=d.SEQ");
            rs = stat.executeQuery(sql.toString());
            while (rs.next()) {
                sql.setLength(0);
                sql.append(ERRS[0]);
                sql.append(rs.getString(2));
                sql.append(" (");
                sql.append(rs.getString(3));
                sql.append(')');
                this.fErrs.add(new Error(true, 11, 0, rs.getInt(1), sql.toString()));
                if (rs.getString(2).matches(".*\\s.*")) {
                    sql.setLength(0);
                    sql.append(ERRS[5]);
                    sql.append(rs.getString(2));
                    sql.append(" (");
                    sql.append(rs.getString(3));
                    sql.append(')');
                    this.fErrs.add(new Error(true, 11, 5, rs.getInt(1), sql.toString()));
                }
                rc = false;
            }
            sql.setLength(0);
            sql.append("SELECT v.LINE,v.VAL,d.TAGNAME FROM TAGS d,ENTRYVALS v ");
            sql.append("WHERE d.VALTYPE='INTEGER' AND v.SEQ IS NOT NULL ");
            sql.append("AND v.VAL IS NOT NULL AND v.VAL<>'.' AND v.VAL<>'?' ");
            sql.append("AND v.SEQ=d.SEQ");
            rs = stat.executeQuery(sql.toString());
            while (rs.next()) {
                if (TypeChecker.isInt(rs.getString(2))) continue;
                sql.setLength(0);
                sql.append(ERRS[1]);
                sql.append(rs.getString(2));
                sql.append(" (");
                sql.append(rs.getString(3));
                sql.append(')');
                this.fErrs.add(new Error(true, 11, 1, rs.getInt(1), sql.toString()));
                rc = false;
            }
            sql.setLength(0);
            sql.append("SELECT v.LINE,v.VAL,d.TAGNAME FROM TAGS d,ENTRYVALS v ");
            sql.append("WHERE d.VALTYPE='FLOAT' AND v.SEQ IS NOT NULL ");
            sql.append("AND v.VAL IS NOT NULL AND v.VAL<>'.' AND v.VAL<>'?' ");
            sql.append("AND v.SEQ=d.SEQ");
            rs = stat.executeQuery(sql.toString());
            while (rs.next()) {
                if (TypeChecker.isFloat(rs.getString(2))) continue;
                sql.setLength(0);
                sql.append(ERRS[2]);
                sql.append(rs.getString(2));
                sql.append(" (");
                sql.append(rs.getString(3));
                sql.append(')');
                this.fErrs.add(new Error(true, 11, 2, rs.getInt(1), sql.toString()));
                rc = false;
            }
            sql.setLength(0);
            sql.append("SELECT v.LINE,v.VAL,d.TAGNAME FROM TAGS d,ENTRYVALS v ");
            sql.append("WHERE d.VALTYPE='DATE' AND v.SEQ IS NOT NULL ");
            sql.append("AND v.VAL IS NOT NULL AND v.VAL<>'.' AND v.VAL<>'?' ");
            sql.append("AND v.SEQ=d.SEQ");
            rs = stat.executeQuery(sql.toString());
            while (rs.next()) {
                if (TypeChecker.isIsoDate(rs.getString(2))) continue;
                sql.setLength(0);
                sql.append(ERRS[3]);
                sql.append(rs.getString(2));
                sql.append(" (");
                sql.append(rs.getString(3));
                sql.append(')');
                this.fErrs.add(new Error(true, 11, 3, rs.getInt(1), sql.toString()));
                rc = false;
            }
            sql.setLength(0);
            sql.append("SELECT v.LINE,v.VAL,d.VALSIZE,d.TAGNAME ");
            sql.append("FROM TAGS d,ENTRYVALS v ");
            sql.append("WHERE v.SEQ IS NOT NULL AND v.VAL IS NOT NULL ");
            sql.append("AND d.VALTYPE='STRING' AND v.SEQ=d.SEQ");
            rs = stat.executeQuery(sql.toString());
            while (rs.next()) {
                int len = rs.getInt(3);
                if (rs.wasNull()) continue;
                String val = rs.getString(2);
                if (rs.wasNull() || val.length() <= len) continue;
                sql.setLength(0);
                sql.append(ERRS[4]);
                sql.append(rs.getString(2));
                sql.append(" (");
                sql.append(rs.getString(4));
                sql.append(" maxlength = ");
                sql.append(len);
                sql.append(')');
                this.fErrs.add(new Error(true, 11, 4, rs.getInt(1), sql.toString()));
                rc = false;
            }
            stat.close();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            this.fErrs.add(new Error(true, 11, -1, -1, "DB exception, check error output"));
            return false;
        }
        return rc;
    }

    public static void main(String[] args) {
        Config conf;
        long start = System.currentTimeMillis();
        ErrorList errs = new ErrorList();
        if (args.length > 0) {
            if (args[0].equals("-h")) {
                System.err.println("Usage: java EDU.bmrb.validator.functions.CheckDataValues [config file]");
                System.err.println("Error messages:");
                for (int i = 0; i < ERRS.length; ++i) {
                    System.err.println(ERRS[i]);
                }
                return;
            }
            conf = new Config(args[0]);
        } else {
            conf = new Config();
        }
        Star_DB star = new Star_DB(conf.getProperties());
        CheckDataTypes chk = new CheckDataTypes(errs, conf);
        star.connect(true);
        System.err.println("DB open: " + (System.currentTimeMillis() - start));
        chk.validate(star.getConnection());
        System.err.println("Validated: " + (System.currentTimeMillis() - start));
        star.disconnect();
        if (errs.size() > 0) {
            errs.sort();
            errs.printErrors(System.out);
        }
        System.err.println("Elapsed: " + (System.currentTimeMillis() - start));
    }
}

