/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.validator.functions;

import EDU.bmrb.stardb.Star_DB;
import EDU.bmrb.validator.Config;
import EDU.bmrb.validator.Error;
import EDU.bmrb.validator.ErrorList;
import EDU.bmrb.validator.Severity;
import EDU.bmrb.validator.ValidationFunction;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class CheckEmptyRows
extends ValidationFunction {
    private static final boolean DEBUG = false;
    public static final int NUMBER = 15;

    public CheckEmptyRows(ErrorList errs, Config conf) {
        super(errs, conf);
        this.fNum = 15;
        this.fName = CheckEmptyRows.className(this.getClass().getName());
        this.init(15);
    }

    public boolean validate(Connection conn) {
        boolean rc = true;
        ResultSet rs1 = null;
        ResultSet rs2 = null;
        try {
            Statement stat1 = conn.createStatement(1004, 1007);
            PreparedStatement pstat = conn.prepareStatement("SELECT LINE,VAL FROM ENTRYVALS WHERE LOOPID=? AND LOOPROW=? ORDER BY LINE", 1004, 1007);
            rs1 = stat1.executeQuery("SELECT DISTINCT LOOPID,LOOPROW FROM ENTRYVALS WHERE LOOPID IS NOT NULL ORDER BY LOOPID,LOOPROW");
            while (rs1.next()) {
                pstat.setInt(1, rs1.getInt(1));
                pstat.setInt(2, rs1.getInt(2));
                rs2 = pstat.executeQuery();
                if (!rs2.next()) {
                    this.fErrs.add(new Error(Severity.ERR, 15, 0, 0, "No rows in loop %d", rs1.getInt(1)));
                    continue;
                }
                int line = -1;
                boolean found = false;
                do {
                    if (line < 0) {
                        line = rs2.getInt(1);
                    }
                    String str = rs2.getString(2);
                    if (rs2.wasNull() || str.equals("?")) continue;
                    found = true;
                    break;
                } while (rs2.next());
                if (found) continue;
                this.fErrs.add(new Error(Severity.ERR, 15, 1, line, "Empty loop row"));
                rc = false;
            }
            rs1.close();
            stat1.close();
            if (rs2 != null) {
                rs2.close();
            }
            pstat.close();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            this.fErrs.add(new Error(Severity.CRIT, 15, -1, -1, "Caught exception, check error output"));
            return false;
        }
        return rc;
    }

    public static void main(String[] args) {
        Config conf;
        long start = System.currentTimeMillis();
        ErrorList errs = new ErrorList();
        if (args.length > 0) {
            if (args[0].equals("-h")) {
                System.err.println("Usage: java EDU.bmrb.validator.functions.CheckEmptyRows [config file]");
                return;
            }
            conf = new Config(args[0]);
        } else {
            conf = new Config();
        }
        Star_DB star = new Star_DB(conf.getProperties());
        CheckEmptyRows chk = new CheckEmptyRows(errs, conf);
        star.connect(true);
        System.err.println("DB open: " + (System.currentTimeMillis() - start));
        chk.validate(star.getConnection());
        System.err.println("Validated: " + (System.currentTimeMillis() - start));
        star.disconnect();
        if (errs.size() > 0) {
            errs.sort();
            errs.printErrors(System.out);
        }
        System.err.println("Elapsed: " + (System.currentTimeMillis() - start));
    }
}

