/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.validator.functions;

import EDU.bmrb.stardb.Star_DB;
import EDU.bmrb.validator.Config;
import EDU.bmrb.validator.Error;
import EDU.bmrb.validator.ErrorList;
import EDU.bmrb.validator.Severity;
import EDU.bmrb.validator.ValidationFunction;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;

public class CheckFrameCodes
extends ValidationFunction {
    public static final int NUMBER = 10;

    public CheckFrameCodes(ErrorList errs, Config conf) {
        super(errs, conf);
        this.fNum = 10;
        this.fName = CheckFrameCodes.className(this.getClass().getName());
        this.init(10);
    }

    public boolean validate(Connection conn) {
        boolean rc = true;
        ResultSet rs = null;
        StringBuffer sql = new StringBuffer();
        try {
            Statement stat = conn.createStatement(1004, 1007);
            rs = stat.executeQuery("SELECT LINE,VAL FROM ENTRYVALS WHERE DELIMITER=12 AND VAL NOT IN (SELECT NAME FROM ENTRYSFS)");
            while (rs.next()) {
                this.fErrs.add(new Error(Severity.ERR, 10, 0, rs.getInt(1), "Saveframe not found: %s", rs.getString(2)));
                rc = false;
            }
            stat.close();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            this.fErrs.add(new Error(Severity.CRIT, 10, -1, -1, "Caught exception, check error output"));
            return false;
        }
        return rc;
    }

    public static void main(String[] args) {
        Config conf;
        long start = System.currentTimeMillis();
        ErrorList errs = new ErrorList();
        if (args.length > 0) {
            if (args[0].equals("-h")) {
                System.err.println("Usage: java EDU.bmrb.validator.functions.CheckFrameCodes [config file]");
                return;
            }
            conf = new Config(args[0]);
        } else {
            conf = new Config();
        }
        Star_DB star = new Star_DB(conf.getProperties());
        CheckFrameCodes chk = new CheckFrameCodes(errs, conf);
        star.connect(true);
        System.err.println("DB open: " + (System.currentTimeMillis() - start));
        chk.validate(star.getConnection());
        System.err.println("Validated: " + (System.currentTimeMillis() - start));
        star.disconnect();
        if (errs.size() > 0) {
            errs.sort();
            errs.printErrors(System.out);
        }
        System.err.println("Elapsed: " + (System.currentTimeMillis() - start));
    }
}

