/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.validator.functions;

import EDU.bmrb.stardb.Star_DB;
import EDU.bmrb.validator.Config;
import EDU.bmrb.validator.Dictionary;
import EDU.bmrb.validator.Error;
import EDU.bmrb.validator.ErrorList;
import EDU.bmrb.validator.Severity;
import EDU.bmrb.validator.ValidationFunction;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class CheckMandatoryTags
extends ValidationFunction {
    private static final boolean DEBUG = false;
    public static final int NUMBER = 2;

    public CheckMandatoryTags(ErrorList errs, Config conf) {
        super(errs, conf);
        this.fNum = 2;
        this.fName = CheckMandatoryTags.className(this.getClass().getName());
        this.init(2);
    }

    private void checkAllTags(Connection conn, String sfcat, int sfid, int line) throws SQLException {
        StringBuilder sql = new StringBuilder("SELECT t.NAME,v.LINE,v.VAL FROM ENTRYTAGS t JOIN ENTRYVALS v ON v.TAGID=t.ID WHERE t.SFID=");
        sql.append(sfid);
        sql.append(" AND t.SEQ=?");
        PreparedStatement pquery = conn.prepareStatement(sql.toString(), 1004, 1007);
        ResultSet rs2 = null;
        sql.setLength(0);
        sql.append("SELECT SEQ,TAGNAME,MANDATORY,LOOPMANDATORY,SFIDFLAG FROM TAGS WHERE SFCAT='");
        sql.append(sfcat);
        sql.append("' AND METADATA='Y' ORDER BY SEQ");
        Statement query = conn.createStatement(1004, 1007);
        ResultSet rs = query.executeQuery(sql.toString());
        block7: while (rs.next()) {
            int tagline;
            char loopmandatory;
            rs.getString(5);
            if (!rs.wasNull() && rs.getString(5).charAt(0) == 'Y') continue;
            int mandatory = Dictionary.checkOverride(conn, sfcat, sfid, rs.getInt(1));
            if (mandatory == 0) {
                mandatory = rs.getString(3).charAt(0);
            }
            rs.getString(4);
            if (!rs.wasNull() && rs.getString(4).charAt(0) == 'Y' && mandatory != 73 && (loopmandatory = Dictionary.checkLoopMandatory(conn, sfid, rs.getString(2))) != 'I' && loopmandatory != 'O' && loopmandatory != '\u0000') {
                mandatory = 76;
            }
            pquery.setInt(1, rs.getInt(1));
            rs2 = pquery.executeQuery();
            boolean has_tag = rs2.next();
            switch (mandatory) {
                case 73: {
                    continue block7;
                }
                case 67: 
                case 77: {
                    if (has_tag) continue block7;
                    tagline = Dictionary.getMissingTagLine(conn, sfcat, sfid, rs.getInt(1));
                    if (tagline < 0) {
                        tagline = line;
                    }
                    this.fErrs.add(new Error(Severity.ERR, 2, 0, tagline, "Missing tag: %s", rs.getString(2)));
                    continue block7;
                }
                case 82: 
                case 86: {
                    if (!has_tag) {
                        tagline = Dictionary.getMissingTagLine(conn, sfcat, sfid, rs.getInt(1));
                        if (tagline < 0) {
                            tagline = line;
                        }
                        this.fErrs.add(new Error(Severity.ERR, 2, 0, tagline, "Missing tag: %s", rs.getString(2)));
                        continue block7;
                    }
                    rs2.getString(3);
                    if (!rs2.wasNull() && !rs2.getString(3).trim().equals("?") && !rs2.getString(3).trim().equals(".")) continue block7;
                    this.fErrs.add(new Error(Severity.ERR, 2, 1, rs2.getInt(2), "Missing value for tag: %s", rs.getString(2)));
                    continue block7;
                }
                case 76: {
                    if (has_tag) continue block7;
                    tagline = Dictionary.getMissingTagLine(conn, sfcat, sfid, rs.getInt(1));
                    if (tagline < 0) {
                        tagline = line;
                    }
                    this.fErrs.add(new Error(Severity.ERR, 2, 4, tagline, "Missing loop-mandatory tag: %s", rs.getString(2)));
                    continue block7;
                }
                case 79: {
                    continue block7;
                }
            }
            tagline = Dictionary.getMissingTagLine(conn, sfcat, sfid, rs.getInt(1));
            if (tagline < 0) {
                tagline = line;
            }
            this.fErrs.add(new Error(Severity.CRIT, 2, 6, tagline, "Dictionary error: wrong mandatory code for %s", rs.getString(2)));
        }
        if (rs2 != null) {
            rs2.close();
        }
        pquery.close();
        rs.close();
        query.close();
    }

    public boolean validate(Connection conn) {
        boolean rc = true;
        try {
            Statement query = conn.createStatement(1003, 1007);
            ResultSet rs = query.executeQuery("SELECT CATEGORY,ID,LINE  FROM ENTRYSFS WHERE CATEGORY IS NOT NULL ORDER BY ID");
            while (rs.next()) {
                this.checkAllTags(conn, rs.getString(1), rs.getInt(2), rs.getInt(3));
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            this.fErrs.add(new Error(Severity.CRIT, 2, -1, -1, "Caught exception, check error output"));
            return false;
        }
        return rc;
    }

    public static void main(String[] args) {
        Config conf;
        long start = System.currentTimeMillis();
        ErrorList errs = new ErrorList();
        if (args.length > 0) {
            if (args[0].equals("-h")) {
                System.err.println("Usage: java EDU.bmrb.validator.functions.CheckMandatoryTags [config file]");
                return;
            }
            conf = new Config(args[0]);
        } else {
            conf = new Config();
        }
        Star_DB star = new Star_DB(conf.getProperties());
        CheckMandatoryTags chk = new CheckMandatoryTags(errs, conf);
        star.connect(true);
        System.err.println("DB open: " + (System.currentTimeMillis() - start));
        chk.validate(star.getConnection());
        System.err.println("Validated: " + (System.currentTimeMillis() - start));
        star.disconnect();
        if (errs.size() > 0) {
            errs.sort();
            errs.printErrors(System.out);
        }
        System.err.println("Elapsed: " + (System.currentTimeMillis() - start));
    }
}

