/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.validator.functions;

import EDU.bmrb.stardb.Star_DB;
import EDU.bmrb.validator.Config;
import EDU.bmrb.validator.Error;
import EDU.bmrb.validator.ErrorList;
import EDU.bmrb.validator.Severity;
import EDU.bmrb.validator.ValidationFunction;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;

public class CheckResidueSequence
extends ValidationFunction {
    private static final boolean DEBUG = false;
    public static final int NUMBER = 32;
    public static final String ENTITY_SFCAT = "entity";
    public static final String TAG_EID = "_Entity.ID";
    public static final String TAG_SEQ = "_Entity.Polymer_seq_one_letter_code";
    public static final String TAG_SEQCAN = "_Entity.Polymer_seq_one_letter_code_can";

    public CheckResidueSequence(ErrorList errs, Config conf) {
        super(errs, conf);
        this.fNum = 32;
        this.fName = CheckResidueSequence.className(this.getClass().getName());
        this.init(32);
    }

    public boolean validate(Connection conn) {
        try {
            boolean rc = true;
            Statement query = conn.createStatement(1003, 1007);
            ResultSet rs = query.executeQuery("SELECT DISTINCT ID,LINE FROM ENTRYSFS WHERE CATEGORY='entity' ORDER BY ID");
            while (rs.next()) {
                if (this.checkSaveframe(conn, rs.getInt(1), rs.getInt(2))) continue;
                rc = false;
            }
            rs.close();
            query.close();
            return rc;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            this.fErrs.add(new Error(Severity.CRIT, 32, -1, -1, "Caught exception, check error output"));
            return false;
        }
    }

    public boolean checkSaveframe(Connection conn, int sfid, int line) throws SQLException {
        int i;
        int eid;
        boolean rc = true;
        String tmp = null;
        StringBuilder sql = new StringBuilder("SELECT v.VAL,v.LINE FROM ENTRYVALS v JOIN ENTRYTAGS t ON t.ID=v.TAGID WHERE t.SFID=");
        sql.append(sfid);
        sql.append(" AND t.NAME='_Entity.ID'");
        Statement query = conn.createStatement(1003, 1007);
        ResultSet rs = query.executeQuery(sql.toString());
        if (!rs.next()) {
            if (this.fErrs != null) {
                this.fErrs.add(new Error(Severity.ERR, 32, 0, line, "No entity ID"));
            }
            rs.close();
            query.close();
            return false;
        }
        tmp = rs.getString(1);
        if (rs.wasNull()) {
            if (this.fErrs != null) {
                this.fErrs.add(new Error(Severity.ERR, 32, 1, rs.getInt(2), "Entity ID is null"));
            }
            rs.close();
            query.close();
            return false;
        }
        try {
            eid = Integer.parseInt(tmp);
        }
        catch (NumberFormatException ne) {
            if (this.fErrs != null) {
                this.fErrs.add(new Error(Severity.WARN, 32, 4, rs.getInt(2), "Entity ID is not a number: %s", tmp));
            }
            rs.close();
            query.close();
            return false;
        }
        sql.setLength(0);
        sql.append("SELECT ENTITY FROM ENTRYRESTYPES WHERE EID='");
        sql.append(eid);
        sql.append('\'');
        tmp = null;
        rs = query.executeQuery(sql.toString());
        if (rs.next()) {
            tmp = rs.getString(1);
            if (rs.wasNull()) {
                tmp = null;
                if (this.fErrs != null) {
                    this.fErrs.add(new Error(Severity.ERR, 32, 2, line, "No residue type"));
                }
                rs.close();
                query.close();
                return false;
            }
        } else {
            rs.close();
            query.close();
            return true;
        }
        String restype = tmp.toLowerCase().indexOf("polypeptide") >= 0 ? "polypeptide" : tmp.toLowerCase();
        ArrayList<String> codes = new ArrayList<String>();
        sql.setLength(0);
        sql.append("SELECT r.CODE FROM RESIDUES r JOIN RESTYPES t ON t.ID=r.TYPEID WHERE t.NAME='");
        sql.append(restype);
        sql.append("' AND r.CODE IS NOT NULL ORDER BY r.CODE");
        rs = query.executeQuery(sql.toString());
        while (rs.next()) {
            codes.add(rs.getString(1));
        }
        if (codes.size() < 1) {
            if (this.fErrs != null) {
                this.fErrs.add(new Error(Severity.ERR, 32, 3, line, "Unknown residue type"));
            }
            rs.close();
            query.close();
            return false;
        }
        Collections.sort(codes);
        String seq = null;
        sql.setLength(0);
        sql.append("SELECT v.VAL,v.LINE FROM ENTRYVALS v JOIN ENTRYTAGS t ON t.ID=v.TAGID WHERE t.SFID=");
        sql.append(sfid);
        sql.append(" AND t.NAME='_Entity.Polymer_seq_one_letter_code_can'");
        rs = query.executeQuery(sql.toString());
        if (rs.next()) {
            seq = rs.getString(1);
            if (rs.wasNull()) {
                seq = null;
            }
        }
        if (seq != null) {
            seq = seq.replaceAll("\\s+", "");
            seq = seq.toUpperCase();
            for (i = 0; i < seq.length(); ++i) {
                if (Collections.binarySearch(codes, seq.substring(i, i + 1)) >= 0 || this.fErrs == null) continue;
                this.fErrs.add(new Error(Severity.ERR, 32, 3, rs.getInt(2), "Unknown residue code: %s (wrong entity id or residue type?)", seq.substring(i, i + 1)));
                rc = false;
            }
        }
        seq = null;
        sql.setLength(0);
        sql.append("SELECT v.VAL,v.LINE FROM ENTRYVALS v JOIN ENTRYTAGS t ON t.ID=v.TAGID WHERE t.SFID=");
        sql.append(sfid);
        sql.append(" AND t.NAME='_Entity.Polymer_seq_one_letter_code'");
        rs = query.executeQuery(sql.toString());
        if (rs.next()) {
            seq = rs.getString(1);
            if (rs.wasNull()) {
                seq = null;
            }
        }
        if (seq != null) {
            seq = seq.replaceAll("\\s+", "");
            seq = seq.toUpperCase();
            for (i = 0; i < seq.length(); ++i) {
                if (Collections.binarySearch(codes, seq.substring(i, i + 1)) >= 0 || this.fErrs == null) continue;
                this.fErrs.add(new Error(Severity.ERR, 32, 3, rs.getInt(2), "Unknown residue code: %s", seq.substring(i, i + 1)));
                rc = false;
            }
        }
        rs.close();
        query.close();
        return rc;
    }

    public static void main(String[] args) {
        Config conf;
        long start = System.currentTimeMillis();
        ErrorList errs = new ErrorList();
        if (args.length > 0) {
            if (args[0].equals("-h")) {
                System.err.println("Usage: java EDU.bmrb.validator.functions.CheckResidueSequence [config file]");
                return;
            }
            conf = new Config(args[0]);
        } else {
            conf = new Config();
        }
        Star_DB star = new Star_DB(conf.getProperties());
        CheckResidueSequence chk = new CheckResidueSequence(errs, conf);
        star.connect(true);
        System.err.println("DB open: " + (System.currentTimeMillis() - start));
        chk.validate(star.getConnection());
        System.err.println("Validated: " + (System.currentTimeMillis() - start));
        star.disconnect();
        if (errs.size() > 0) {
            errs.sort();
            errs.printErrors(System.out);
        }
        System.err.println("Elapsed: " + (System.currentTimeMillis() - start));
    }
}

