/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.validator.functions;

import EDU.bmrb.sansj.ContentHandler;
import EDU.bmrb.sansj.DataItemNode;
import EDU.bmrb.sansj.ErrorHandler;
import EDU.bmrb.sansj.STARLexer;
import EDU.bmrb.sansj.SansParser;
import EDU.bmrb.stardb.Star_DB;
import EDU.bmrb.validator.Config;
import EDU.bmrb.validator.DataValidationFunction;
import EDU.bmrb.validator.Error;
import EDU.bmrb.validator.ErrorList;
import gnu.getopt.Getopt;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class CheckRowIndexes
extends DataValidationFunction
implements ErrorHandler,
ContentHandler {
    private static final boolean DEBUG = false;
    public static final String[] ERRS = new String[]{"Not a number: ", "Incorrect row index, expected "};
    public static final int NUMBER = 18;
    private boolean fInLoop = false;
    private boolean fCheckFlag = true;
    private int fLastIndex = 0;
    private String fIndexTag = null;
    PreparedStatement fQuery = null;

    public CheckRowIndexes(ErrorList errs, Config conf) {
        super(errs, conf);
        this.fNum = new Integer(18);
        this.fName = CheckRowIndexes.className(this.getClass().getName());
        this.init(18);
    }

    public boolean validate(Connection conn, Reader in) {
        try {
            this.fQuery = conn.prepareStatement("SELECT TAGNAME FROM TAGS WHERE TAGNAME LIKE ? AND ROWIDXFLAG='Y'");
            STARLexer lex = new STARLexer(in);
            SansParser p = new SansParser(lex, this, this);
            p.parse();
            this.fQuery.close();
            return true;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            this.fErrs.add(new Error(true, 18, -1, -1, "Caught exception, check error output"));
            return false;
        }
    }

    public static void usage() {
        System.err.print("Usage: java EDU.bmrb.validator.functions.CheckRowIndexes ");
        System.err.println("[-c FILE] [-i FILE] [-h]");
        System.err.println("  -c FILE: use config FILE instead of ~/validator.conf");
        System.err.println("  -i FILE: input file name (default: stdin)");
        System.err.println("  -h: print this message");
    }

    public static void main(String[] args) {
        try {
            int opt;
            Getopt g = new Getopt("CheckShiftStats", args, "c:i:h");
            String conffile = null;
            String infile = null;
            block6: while ((opt = g.getopt()) != -1) {
                switch (opt) {
                    case 99: {
                        conffile = g.getOptarg();
                        continue block6;
                    }
                    case 105: {
                        infile = g.getOptarg();
                        continue block6;
                    }
                }
                CheckRowIndexes.usage();
                return;
            }
            Config conf = conffile == null ? new Config() : new Config(conffile);
            ErrorList errs = new ErrorList();
            BufferedReader in = infile == null ? new BufferedReader(new InputStreamReader(System.in)) : new BufferedReader(new FileReader(infile));
            long start = System.currentTimeMillis();
            Star_DB star = new Star_DB(conf.getProperties());
            star.connect(true);
            System.err.println("DB open: " + (System.currentTimeMillis() - start));
            CheckRowIndexes chk = new CheckRowIndexes(errs, conf);
            chk.validate(star.getConnection(), in);
            System.err.println("Validated: " + (System.currentTimeMillis() - start));
            star.disconnect();
            ((Reader)in).close();
            if (errs.size() > 0) {
                errs.sort();
                errs.printErrors(System.out);
            }
            System.err.println("Elapsed: " + (System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }

    public boolean startLoop(int param) {
        this.fInLoop = true;
        this.fCheckFlag = true;
        this.fIndexTag = null;
        this.fLastIndex = 1;
        return false;
    }

    public boolean endLoop(int param) {
        this.fInLoop = false;
        return false;
    }

    public boolean data(DataItemNode node) {
        try {
            if (!this.fInLoop) {
                return false;
            }
            if (!this.fCheckFlag) {
                return false;
            }
            if (this.fIndexTag == null) {
                int i = node.getName().indexOf(46);
                if (i < 0) {
                    return false;
                }
                String tagcat = node.getName().substring(0, i + 1);
                this.fQuery.setString(1, tagcat + "%");
                ResultSet rs = this.fQuery.executeQuery();
                if (!rs.next()) {
                    this.fCheckFlag = false;
                    return false;
                }
                this.fIndexTag = rs.getString(1);
                if (rs.wasNull()) {
                    this.fIndexTag = null;
                    this.fCheckFlag = false;
                }
            }
            int index = -1;
            if (node.getName().equals(this.fIndexTag)) {
                try {
                    index = Integer.parseInt(node.getValue());
                }
                catch (NumberFormatException ne) {
                    this.fErrs.add(new Error(true, 18, 0, node.getValueLine(), ERRS[0] + node.getValue() + "(" + node.getName() + ")"));
                    index = -1;
                }
                if (index >= 0 && index != this.fLastIndex) {
                    this.fErrs.add(new Error(true, 18, 1, node.getValueLine(), ERRS[1] + this.fLastIndex + "(" + node.getName() + ")"));
                }
                ++this.fLastIndex;
            }
            return false;
        }
        catch (SQLException e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            this.fErrs.add(new Error(true, 18, -1, node.getValueLine(), "Caught exception, check error output"));
            return false;
        }
    }

    public void error(int param, int param1, String str) {
        this.fErrs.add(new Error(true, 18, -1, param, str));
        System.err.print("Parse error in line ");
        System.err.print(param);
        System.err.print(", col ");
        System.err.print(param1);
        System.err.print(": ");
        System.err.println(str);
    }

    public boolean warning(int param, int param1, String str) {
        this.fErrs.add(new Error(false, 18, -1, param, str));
        System.err.print("Parse warning in line ");
        System.err.print(param);
        System.err.print(", col ");
        System.err.print(param1);
        System.err.print(": ");
        System.err.println(str);
        return false;
    }

    public boolean comment(int param, String str) {
        return false;
    }

    public void endData(int param, String str) {
    }

    public boolean endSaveFrame(int param, String str) {
        return false;
    }

    public boolean startData(int param, String str) {
        return false;
    }

    public boolean startSaveFrame(int param, String str) {
        return false;
    }
}

