/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.validator.functions;

import EDU.bmrb.sansj.ContentHandler;
import EDU.bmrb.sansj.DataItemNode;
import EDU.bmrb.sansj.ErrorHandler;
import EDU.bmrb.sansj.STARLexer;
import EDU.bmrb.sansj.SansParser;
import EDU.bmrb.stardb.Star_DB;
import EDU.bmrb.validator.Config;
import EDU.bmrb.validator.DataValidationFunction;
import EDU.bmrb.validator.Error;
import EDU.bmrb.validator.ErrorList;
import EDU.bmrb.validator.Severity;
import gnu.getopt.Getopt;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

public class CheckShiftLoop
extends DataValidationFunction
implements ErrorHandler,
ContentHandler {
    private static final boolean DEBUG = false;
    public static final int NUMBER = 21;
    public static final String[] LOOP_TAGS = new String[]{"_Atom_chem_shift.ID", "_Atom_chem_shift.Entity_assembly_ID", "_Atom_chem_shift.Entity_ID", "_Atom_chem_shift.Comp_index_ID", "_Atom_chem_shift.Seq_ID", "_Atom_chem_shift.Comp_ID", "_Atom_chem_shift.Atom_ID", "_Atom_chem_shift.Atom_type", "_Atom_chem_shift.Atom_isotope_number", "_Atom_chem_shift.Auth_seq_ID", "_Atom_chem_shift.Auth_comp_ID", "_Atom_chem_shift.Auth_atom_ID", "_Atom_chem_shift.Val", "_Atom_chem_shift.Val_err", "_Atom_chem_shift.Assign_fig_of_merit", "_Atom_chem_shift.Ambiguity_code", "_Atom_chem_shift.Occupancy", "_Atom_chem_shift.Entry_ID", "_Atom_chem_shift.Sf_ID", "_Atom_chem_shift.Assigned_chem_shif_list_ID", "_Atom_chem_shift.Assembly_atom_ID", "_Atom_chem_shift.Resonance_ID"};
    private static final int EIDIDX = 2;
    private static final int SEQIDX = 4;
    private static final int LBLIDX = 5;
    private static final int ATMIDX = 6;
    private static final int ATYPEIDX = 7;
    private static final int ISOIDX = 8;
    private static final int VALIDX = 12;
    private static final int AMBIDX = 15;
    private PreparedStatement fEntityQuery = null;
    private PreparedStatement fRescheckQuery = null;
    private PreparedStatement fRestypeQuery = null;
    private PreparedStatement fAtomQuery = null;
    private PreparedStatement fIsoQuery = null;
    private PreparedStatement fMethylQuery = null;
    private ResultSet fRs = null;
    private String fSfName = null;
    private boolean fInLoop = false;
    private boolean fInShifts = false;
    private String fFirstTag = null;
    private Row fRow = null;
    private int fLastSeq = -1;
    private boolean fCheckResidue = true;
    private boolean fQueryResidue = false;
    private Row fHisDRow = null;
    private Row fHisERow = null;
    private Row fTrpERow = null;
    private Row fThrGRow = null;
    private Row fLastRow = null;
    private ArrayList<String> fMethyls = null;
    private ArrayList<String> fEntryMethyls = null;

    public CheckShiftLoop(ErrorList errs, Config conf) {
        super(errs, conf);
        this.fNum = 21;
        this.fName = CheckShiftLoop.className(this.getClass().getName());
        this.init(21);
    }

    public boolean validate(Connection conn, Reader in) {
        try {
            if (this.fEntityQuery == null) {
                this.fEntityQuery = conn.prepareStatement("SELECT v.VAL FROM ENTRYVALS v JOIN ENTRYTAGS t ON t.ID=v.TAGID WHERE t.NAME='_Entity.ID' AND v.VAL=?", 1003, 1007);
            }
            if (this.fRescheckQuery == null) {
                this.fRescheckQuery = conn.prepareStatement("SELECT v1.VAL,v2.VAL FROM ENTRYVALS v1 JOIN ENTRYVALS v2 ON v2.LOOPID=v1.LOOPID AND v2.LOOPROW=v1.LOOPROW JOIN ENTRYVALS v3 ON v3.LOOPID=v2.LOOPID AND v3.LOOPROW=v1.LOOPROW JOIN ENTRYTAGS t1 ON t1.ID=v1.TAGID JOIN ENTRYTAGS t2 ON t2.ID=v2.TAGID JOIN ENTRYTAGS t3 ON t3.ID=v3.TAGID WHERE t1.NAME='_Entity_comp_index.ID' AND t2.NAME='_Entity_comp_index.Comp_ID' AND t3.NAME='_Entity_comp_index.Entity_ID' AND v3.VAL=? AND v1.VAL=? AND v2.VAL=?", 1003, 1007);
            }
            if (this.fRestypeQuery == null) {
                this.fRestypeQuery = conn.prepareStatement("SELECT ENTITY FROM ENTRYRESTYPES WHERE EID=?", 1003, 1007);
            }
            if (this.fAtomQuery == null) {
                this.fAtomQuery = conn.prepareStatement("SELECT a.TYPE,a.PSEUDO,a.ID FROM ATOMS a JOIN RESIDUES r ON r.ID=a.RESID JOIN RESTYPES t ON t.ID=r.TYPEID WHERE t.NAME=? AND r.LABEL=? AND a.NAME=?", 1003, 1007);
            }
            if (this.fIsoQuery == null) {
                this.fIsoQuery = conn.prepareStatement("SELECT ISOTOPE FROM ISOTOPES WHERE TYPE=?", 1003, 1007);
            }
            if (this.fMethylQuery == null) {
                this.fMethylQuery = conn.prepareStatement("SELECT ATOM30 FROM STAR3TO2 WHERE RESLABEL=?", 1003, 1007);
            }
            this.fMethyls = new ArrayList();
            this.fEntryMethyls = new ArrayList();
            this.fHisDRow = new Row();
            this.fHisERow = new Row();
            this.fTrpERow = new Row();
            this.fThrGRow = new Row();
            STARLexer lex = new STARLexer(in);
            SansParser p = new SansParser(lex, this, this);
            p.parse();
            if (this.fRs != null) {
                this.fRs.close();
            }
            this.fEntityQuery.close();
            this.fEntityQuery = null;
            this.fRescheckQuery.close();
            this.fRescheckQuery = null;
            this.fRestypeQuery.close();
            this.fRestypeQuery = null;
            this.fAtomQuery.close();
            this.fAtomQuery = null;
            this.fIsoQuery.close();
            this.fIsoQuery = null;
            this.fMethylQuery.close();
            this.fMethylQuery = null;
            this.fMethyls.clear();
            this.fMethyls = null;
            this.fEntryMethyls.clear();
            this.fEntryMethyls = null;
            return true;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            this.fErrs.add(new Error(Severity.CRIT, 21, -1, -1, "Caught exception, check error output"));
            return false;
        }
    }

    private void validateRow(int line) throws SQLException {
        if (this.fCheckResidue) {
            if (this.fMethyls.size() > 0 && this.fEntryMethyls.size() > 0) {
                block0: for (String methyl : this.fEntryMethyls) {
                    for (int i = 0; i < this.fMethyls.size(); ++i) {
                        if (!methyl.equals(this.fMethyls.get(i))) continue;
                        this.fMethyls.remove(i);
                        continue block0;
                    }
                }
                if (this.fMethyls.size() > 0) {
                    if (this.fMethyls.size() != 3) {
                        this.fErrs.add(new Error(Severity.ERR, 21, 21, this.fLastRow.line, "Incorrect count of methyl protons: %d\n", this.fEntryMethyls.size()));
                    } else {
                        String methyl = this.fMethyls.get(0).substring(0, 3);
                        if (!methyl.equals(this.fMethyls.get(1).substring(0, 3))) {
                            this.fErrs.add(new Error(Severity.ERR, 21, 21, this.fLastRow.line, "Incorrect count of methyl protons: %d\n", this.fEntryMethyls.size()));
                        } else if (!methyl.equals(this.fMethyls.get(2).substring(0, 3))) {
                            this.fErrs.add(new Error(Severity.ERR, 21, 21, this.fLastRow.line, "Incorrect count of methyl protons: %d\n", this.fEntryMethyls.size()));
                        } else {
                            methyl = this.fMethyls.get(1).substring(0, 3);
                            if (!methyl.equals(this.fMethyls.get(2).substring(0, 3))) {
                                this.fErrs.add(new Error(Severity.ERR, 21, 21, this.fLastRow.line, "Incorrect count of methyl protons: %d\n", this.fEntryMethyls.size()));
                            }
                        }
                    }
                }
            }
            this.fMethyls.clear();
            this.fEntryMethyls.clear();
            this.fCheckResidue = false;
            this.fHisDRow.clear();
            this.fHisERow.clear();
            this.fTrpERow.clear();
            this.fThrGRow.clear();
            if (this.fMethyls.size() < 3) {
                this.fMethylQuery.setString(1, this.fRow.label);
                this.fRs = this.fMethylQuery.executeQuery();
                int j = 0;
                while (this.fRs.next()) {
                    this.fMethyls.add(this.fRs.getString(1));
                    ++j;
                }
            }
        }
        boolean check_res = true;
        if (!this.fQueryResidue) {
            if (this.fLastRow.label == null || this.fRow.label == null) {
                this.fErrs.add(new Error(Severity.WARN, 21, -1, line, "Invalid row: missing residue label or atom name"));
                return;
            }
            if (this.fLastRow != null && this.fLastRow.eid == this.fRow.eid && this.fLastRow.label.equals(this.fRow.label)) {
                check_res = false;
            }
        }
        if (check_res) {
            if (this.fRow.eid >= 0) {
                this.fRescheckQuery.getConnection().commit();
                this.fRescheckQuery.getConnection().setAutoCommit(true);
                this.fRescheckQuery.setString(1, Integer.toString(this.fRow.eid));
                this.fRescheckQuery.setString(2, Integer.toString(this.fRow.seq));
                this.fRescheckQuery.setString(3, this.fRow.label);
                this.fRs = this.fRescheckQuery.executeQuery();
                if (!this.fRs.next()) {
                    this.fErrs.add(new Error(Severity.ERR, 21, 7, line, "Can't find residue in _Entity_comp_index loop: %d %s", this.fRow.seq, this.fRow.label));
                }
                this.fQueryResidue = false;
            } else {
                this.fErrs.add(new Error(Severity.ERR, 21, 0, line, "Entity ID is not a number: %d %s", this.fRow.seq, this.fRow.label));
            }
        }
        if (this.fMethyls.size() > 0) {
            for (String s : this.fMethyls) {
                if (!s.equals(this.fRow.atom)) continue;
                this.fEntryMethyls.add(this.fRow.atom);
                break;
            }
        }
        if (this.fRow.label == null || this.fRow.atom == null) {
            this.fErrs.add(new Error(Severity.WARN, 21, -1, line, "Invalid row: missing residue label or atom name"));
            return;
        }
        if (this.fRow.label.equals("THR") && this.fRow.atom.equals("HG1")) {
            this.fErrs.add(new Error(Severity.ERR, 21, 12, line, "Found THR:HG1"));
        }
        if (this.fRow.label.equals("HIS") && (this.fRow.atom.equals("HD1") || this.fRow.atom.equals("HD2"))) {
            if (this.fHisDRow.isEmpty()) {
                this.fHisDRow.copy(this.fRow);
            } else if (this.fHisDRow.eid == this.fRow.eid && !Float.isNaN(this.fHisDRow.shift) && !Float.isNaN(this.fRow.shift) && this.fHisDRow.shift == this.fRow.shift) {
                this.fErrs.add(new Error(Severity.ERR, 21, 13, line, "Found identical shifts for HIS HD1 and HD2"));
            }
        }
        if (this.fRow.label.equals("HIS") && (this.fRow.atom.equals("HE1") || this.fRow.atom.equals("HE2"))) {
            if (this.fHisERow.isEmpty()) {
                this.fHisERow.copy(this.fRow);
            } else if (!(this.fHisERow.eid != this.fRow.eid || this.fHisERow.atom.equals(this.fRow.atom) || Float.isNaN(this.fHisERow.shift) || Float.isNaN(this.fRow.shift) || this.fHisERow.shift != this.fRow.shift)) {
                this.fErrs.add(new Error(Severity.ERR, 21, 14, line, "Found identical shifts for HIS HE1 and HE2"));
            }
        }
        if (this.fRow.label.equals("TRP") && (this.fRow.atom.equals("HE1") || this.fRow.atom.equals("HE3"))) {
            if (this.fTrpERow.isEmpty()) {
                this.fTrpERow.copy(this.fRow);
            } else if (this.fTrpERow.eid == this.fRow.eid && !Float.isNaN(this.fTrpERow.shift) && !Float.isNaN(this.fRow.shift) && this.fTrpERow.shift == this.fRow.shift) {
                this.fErrs.add(new Error(Severity.ERR, 21, 15, line, "Found identical shifts for TRP HE1 and HE3"));
            }
        }
        if (this.fRow.label.equals("THR")) {
            if (this.fRow.atom.equals("HG1")) {
                this.fThrGRow.copy(this.fRow);
            } else if (this.fRow.atom.indexOf("HG2") > -1 && this.fThrGRow.eid == this.fRow.eid && !Float.isNaN(this.fThrGRow.shift) && !Float.isNaN(this.fRow.shift) && this.fThrGRow.shift == this.fRow.shift) {
                this.fErrs.add(new Error(Severity.ERR, 21, 19, line, "Found identical shifts for THR HG1 and HG2"));
            }
        }
        if (this.fLastRow != null && this.fLastRow.eid != -1 && this.fLastRow.atom.equals(this.fRow.atom) && this.fLastRow.seq == this.fRow.seq) {
            this.fErrs.add(new Error(Severity.ERR, 21, 18, line, "Duplicate atom: %s", this.fRow.atom));
        }
        String restype = null;
        this.fRestypeQuery.setString(1, Integer.toString(this.fRow.eid));
        this.fRs = this.fRestypeQuery.executeQuery();
        if (this.fRs.next()) {
            restype = this.fRs.getString(1);
            if (this.fRs.wasNull()) {
                restype = null;
            }
        }
        if (restype == null) {
            this.fEntityQuery.setString(1, Integer.toString(this.fRow.eid));
            this.fRs = this.fEntityQuery.executeQuery();
            if (!this.fRs.next()) {
                this.fErrs.add(new Error(Severity.ERR, 21, 8, line, "Invalid entity ID: %s", this.fRow.eid));
            }
            return;
        }
        if (restype.indexOf("polypeptide") > -1) {
            restype = "polypeptide";
        }
        int atomid = -1;
        this.fAtomQuery.setString(1, restype);
        this.fAtomQuery.setString(2, this.fRow.label);
        this.fAtomQuery.setString(3, this.fRow.atom);
        this.fRs = this.fAtomQuery.executeQuery();
        if (this.fRs.next()) {
            atomid = this.fRs.getInt(3);
            this.fRs.getString(1);
            if (!this.fRs.wasNull() && !this.fRs.getString(1).equals(this.fRow.atype)) {
                this.fErrs.add(new Error(Severity.ERR, 21, 9, line, "Invalid atom type, expected: %s", this.fRs.getString(1)));
            }
            if (this.fRs.getString(2).equals("Y")) {
                this.fErrs.add(new Error(Severity.ERR, 21, 10, line, "Pseudo atom: %s", this.fRow.atom));
            }
        } else {
            this.fErrs.add(new Error(Severity.ERR, 21, 11, line, "Invalid atom: %s", this.fRow.atom));
        }
        if (this.fRow.atype != null && this.fRow.isotope > -1) {
            boolean found = false;
            this.fIsoQuery.setString(1, this.fRow.atype);
            this.fRs = this.fIsoQuery.executeQuery();
            while (this.fRs.next()) {
                if (this.fRs.getInt(1) != this.fRow.isotope) continue;
                found = true;
                break;
            }
            if (!found) {
                this.fErrs.add(new Error(Severity.ERR, 21, 17, line, "Invalid isotope: %s", this.fRow.isotope));
            }
        }
    }

    public static void usage() {
        System.err.print("Usage: java EDU.bmrb.validator.functions.CheckShiftLoop ");
        System.err.println("[-c FILE] [-i FILE] [-h]");
        System.err.println("  -c FILE: use config FILE instead of ~/validator.conf");
        System.err.println("  -i FILE: input file name (default: stdin)");
        System.err.println("  -h: print this message");
    }

    public static void main(String[] args) {
        try {
            int opt;
            Getopt g = new Getopt("CheckShiftLoop", args, "c:i:h");
            String conffile = null;
            String infile = null;
            block6: while ((opt = g.getopt()) != -1) {
                switch (opt) {
                    case 99: {
                        conffile = g.getOptarg();
                        continue block6;
                    }
                    case 105: {
                        infile = g.getOptarg();
                        continue block6;
                    }
                }
                CheckShiftLoop.usage();
                return;
            }
            Config conf = conffile == null ? new Config() : new Config(conffile);
            ErrorList errs = new ErrorList();
            BufferedReader in = infile == null ? new BufferedReader(new InputStreamReader(System.in)) : new BufferedReader(new FileReader(infile));
            long start = System.currentTimeMillis();
            Star_DB star = new Star_DB(conf.getProperties());
            star.connect(true);
            System.err.println("DB open: " + (System.currentTimeMillis() - start));
            CheckShiftLoop chk = new CheckShiftLoop(errs, conf);
            chk.validate(star.getConnection(), in);
            System.err.println("Validated: " + (System.currentTimeMillis() - start));
            star.disconnect();
            ((Reader)in).close();
            if (errs.size() > 0) {
                errs.sort();
                errs.printErrors(System.out);
            }
            System.err.println("Elapsed: " + (System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }

    public void error(int param, int param1, String str) {
        this.fErrs.add(new Error(Severity.CRIT, 21, -1, param, str));
        System.err.printf("Parse error in line %d, col %d: %s\n", param, param1, str);
    }

    public boolean warning(int param, int param1, String str) {
        this.fErrs.add(new Error(Severity.ERR, 21, -1, param, str));
        System.err.printf("Parse warning in line %d, col d: %s\n", param, param1, str);
        return false;
    }

    public boolean startSaveFrame(int param, String str) {
        this.fSfName = str;
        return false;
    }

    public boolean endSaveFrame(int param, String str) {
        this.fSfName = null;
        return false;
    }

    public boolean startLoop(int param) {
        this.fInLoop = true;
        return false;
    }

    public boolean endLoop(int param) {
        this.fInLoop = false;
        this.fInShifts = false;
        if (this.fRow != null) {
            try {
                this.validateRow(param - 1);
            }
            catch (SQLException e) {
                this.fErrs.add(new Error(Severity.CRIT, 21, 1, param - 1, "DB exception, check error output"));
                System.err.println(e);
                e.printStackTrace();
                return false;
            }
        }
        this.fRow = null;
        this.fFirstTag = null;
        return false;
    }

    public boolean data(DataItemNode node) {
        int i;
        if (!this.fInLoop) {
            return false;
        }
        if (!this.fInShifts) {
            for (i = 0; i < LOOP_TAGS.length; ++i) {
                if (!LOOP_TAGS[i].equals(node.getName())) continue;
                this.fInShifts = true;
                break;
            }
        }
        if (!this.fInShifts) {
            return false;
        }
        if (this.fFirstTag == null) {
            this.fFirstTag = node.getName();
        }
        if (this.fFirstTag.equals(node.getName())) {
            if (this.fLastRow == null) {
                this.fLastRow = new Row();
            }
            if (this.fRow != null) {
                try {
                    this.validateRow(node.getValueLine() - 1);
                    this.fLastRow.copy(this.fRow);
                    this.fRow.clear();
                }
                catch (SQLException e) {
                    this.fErrs.add(new Error(Severity.CRIT, 21, 1, node.getValueLine(), "DB exception, check error output"));
                    System.err.println(e);
                    e.printStackTrace();
                    return false;
                }
            } else {
                this.fRow = new Row();
            }
        } else {
            block23: for (i = 0; i < LOOP_TAGS.length; ++i) {
                if (!LOOP_TAGS[i].equals(node.getName())) continue;
                switch (i) {
                    case 2: {
                        try {
                            this.fRow.eid = Integer.parseInt(node.getValue());
                            continue block23;
                        }
                        catch (NumberFormatException e) {
                            this.fErrs.add(new Error(Severity.ERR, 21, 0, node.getValueLine(), "Entity ID is not a number: %s", node.getValue()));
                            return false;
                        }
                    }
                    case 4: {
                        try {
                            this.fRow.seq = Integer.parseInt(node.getValue());
                        }
                        catch (NumberFormatException e) {
                            this.fErrs.add(new Error(Severity.ERR, 21, 1, node.getValueLine(), "Residue sequence is not a number: %s", node.getValue()));
                            return false;
                        }
                        this.fRow.line = node.getValueLine();
                        if (this.fLastSeq < 0) {
                            this.fLastSeq = this.fRow.seq;
                            this.fQueryResidue = true;
                        }
                        if (this.fLastSeq == this.fRow.seq) continue block23;
                        this.fLastSeq = this.fRow.seq;
                        this.fCheckResidue = true;
                        this.fQueryResidue = true;
                        continue block23;
                    }
                    case 5: {
                        if (node.getValue() == null || node.getValue().equals(".") || node.getValue().equals("?")) {
                            this.fErrs.add(new Error(Severity.ERR, 21, 2, node.getValueLine(), "Missing residue label: %s", node.getValue()));
                            return false;
                        }
                        this.fRow.label = node.getValue();
                        continue block23;
                    }
                    case 6: {
                        if (node.getValue() == null || node.getValue().equals(".") || node.getValue().equals("?")) {
                            this.fErrs.add(new Error(Severity.ERR, 21, 3, node.getValueLine(), "Missing atom name: %s", node.getValue()));
                            return false;
                        }
                        this.fRow.atom = node.getValue();
                        continue block23;
                    }
                    case 7: {
                        if (node.getValue() == null || node.getValue().equals(".") || node.getValue().equals("?")) {
                            this.fErrs.add(new Error(Severity.ERR, 21, 4, node.getValueLine(), "Missing atom type: %s", node.getValue()));
                            return false;
                        }
                        this.fRow.atype = node.getValue();
                        continue block23;
                    }
                    case 8: {
                        try {
                            this.fRow.isotope = Integer.parseInt(node.getValue());
                            continue block23;
                        }
                        catch (NumberFormatException e) {
                            this.fErrs.add(new Error(Severity.ERR, 21, 5, node.getValueLine(), "Atom isotope is not a number: %s", node.getValue()));
                            return false;
                        }
                    }
                    case 12: {
                        try {
                            this.fRow.shift = Float.parseFloat(node.getValue());
                        }
                        catch (NumberFormatException e) {
                            this.fRow.shift = Float.NaN;
                        }
                        continue block23;
                    }
                    case 15: {
                        try {
                            this.fRow.ambicode = Integer.parseInt(node.getValue());
                            continue block23;
                        }
                        catch (NumberFormatException e) {
                            return false;
                        }
                    }
                }
            }
        }
        return false;
    }

    public boolean comment(int param, String str) {
        return false;
    }

    public boolean startData(int param, String str) {
        return false;
    }

    public void endData(int param, String str) {
    }

    class Row {
        int eid = -1;
        int seq = -1;
        String label;
        String atom;
        String atype;
        int isotope = -1;
        float shift = Float.NaN;
        int ambicode = -1;
        int line = -1;

        Row() {
        }

        void clear() {
            this.eid = -1;
            this.seq = -1;
            this.label = null;
            this.atom = null;
            this.atype = null;
            this.isotope = -1;
            this.shift = Float.NaN;
            this.ambicode = -1;
            this.line = -1;
        }

        public void copy(Row src) {
            this.eid = src.eid;
            this.seq = src.seq;
            this.label = src.label;
            this.atom = src.atom;
            this.atype = src.atype;
            this.isotope = src.isotope;
            this.shift = src.shift;
            this.ambicode = src.ambicode;
            this.line = src.line;
        }

        public boolean isEmpty() {
            return this.eid == -1;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append(this.eid);
            buf.append(':');
            buf.append(this.seq);
            buf.append(':');
            buf.append(this.label);
            buf.append(':');
            buf.append(this.atom);
            buf.append(':');
            buf.append(this.atype);
            buf.append(':');
            buf.append(this.isotope);
            buf.append(':');
            buf.append(this.shift);
            buf.append(':');
            buf.append(this.ambicode);
            buf.append(':');
            buf.append(this.line);
            return buf.toString();
        }
    }
}

