/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.validator.functions;

import EDU.bmrb.stardb.Star_DB;
import EDU.bmrb.validator.Config;
import EDU.bmrb.validator.Error;
import EDU.bmrb.validator.ErrorList;
import EDU.bmrb.validator.ValidationFunction;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;

public class CheckTagDeps
extends ValidationFunction {
    public static final int NUMBER = 3;
    public static final String[] ERRS = new String[]{"Conflicting tags: ", "Value required for tag ", "Mandatory tag not found: "};

    public CheckTagDeps(ErrorList errs, Config conf) {
        super(errs, conf);
        this.fNum = new Integer(3);
        this.fName = CheckTagDeps.className(this.getClass().getName());
        this.init(3);
    }

    public boolean validate(Connection conn) {
        boolean rc = true;
        ResultSet rs1 = null;
        ResultSet rs2 = null;
        ResultSet rs3 = null;
        StringBuffer sql = new StringBuffer();
        try {
            Statement stat1 = conn.createStatement(1004, 1007);
            Statement stat2 = conn.createStatement(1004, 1007);
            Statement stat3 = conn.createStatement(1004, 1007);
            rs1 = stat1.executeQuery("SELECT d.CTLSEQ, d.CTLVALUE, d.MANDATORY, d.SEQ, t.ID, t.NAME, v.VAL FROM TAGDEPS d, ENTRYTAGS t, ENTRYVALS v WHERE d.CTLSEQ = t.SEQ AND t.ID = v.TAGID ORDER BY v.LINE");
            while (rs1.next()) {
                String str2;
                String str1 = rs1.getString(2);
                if (!rs1.wasNull()) {
                    str2 = rs1.getString(7);
                    if (rs1.wasNull() || !str1.equals(str2)) continue;
                }
                char flag = rs1.getString(3).charAt(0);
                sql.setLength(0);
                sql.append("SELECT t.ID, t.LINE, t.NAME, v.VAL, v.LINE FROM ENTRYTAGS t, ENTRYVALS v WHERE t.SEQ = ");
                sql.append(rs1.getInt(4));
                sql.append(" AND t.ID = v.TAGID ORDER BY v.LINE");
                rs2 = stat2.executeQuery(sql.toString());
                if (rs2.next()) {
                    do {
                        if (flag == 'I') {
                            sql.setLength(0);
                            sql.append(ERRS[0]);
                            sql.append(rs2.getString(1));
                            sql.append(" and ");
                            sql.append(rs1.getString(6));
                            this.fErrs.add(new Error(true, 3, 0, rs2.getInt(2), sql.toString()));
                            rc = false;
                            continue;
                        }
                        if (flag != 'V') continue;
                        rs2.getString(4);
                        if (!rs2.wasNull()) continue;
                        sql.setLength(0);
                        sql.append(ERRS[1]);
                        sql.append(rs2.getString(3));
                        this.fErrs.add(new Error(true, 3, 1, rs2.getInt(5), sql.toString()));
                        rc = false;
                    } while (rs2.next());
                    continue;
                }
                if (flag != 'M' && flag != 'V') continue;
                sql.setLength(0);
                sql.append("SELECT TAGNAME FROM TAGS WHERE SEQ = ");
                sql.append(rs1.getInt(4));
                str2 = null;
                rs3 = stat3.executeQuery(sql.toString());
                if (rs3.next()) {
                    str2 = rs3.getString(1);
                    if (rs3.wasNull()) {
                        str2 = null;
                    }
                }
                sql.setLength(0);
                sql.append("SELECT LINE FROM ENTRYTAGS WHERE SEQ > ");
                sql.append(rs1.getInt(4));
                sql.append(" ORDER BY SEQ");
                rs3 = stat3.executeQuery(sql.toString());
                Error err = new Error(true, 3, 2, 0, null);
                if (rs3.next()) {
                    err.setLineNum(rs3.getInt(1));
                }
                sql.setLength(0);
                sql.append(ERRS[2]);
                if (str2 == null) {
                    sql.append(rs1.getString(4));
                } else {
                    sql.append(str2);
                }
                err.setMessage(sql.toString());
                this.fErrs.add(err);
                rc = false;
            }
            stat1.close();
            stat2.close();
            stat3.close();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            this.fErrs.add(new Error(true, 3, -1, -1, "DB exception, check error output"));
            return false;
        }
        return rc;
    }

    public static void main(String[] args) {
        Config conf;
        long start = System.currentTimeMillis();
        ErrorList errs = new ErrorList();
        if (args.length > 0) {
            if (args[0].equals("-h")) {
                System.err.println("Usage: java EDU.bmrb.validator.functions.CheckTagDeps [config file]");
                System.err.println("Error messages:");
                for (int i = 0; i < ERRS.length; ++i) {
                    System.err.println(ERRS[i]);
                }
                return;
            }
            conf = new Config(args[0]);
        } else {
            conf = new Config();
        }
        Star_DB star = new Star_DB(conf.getProperties());
        CheckTagDeps chk = new CheckTagDeps(errs, conf);
        star.connect(true);
        System.err.println("DB open: " + (System.currentTimeMillis() - start));
        chk.validate(star.getConnection());
        System.err.println("Validated: " + (System.currentTimeMillis() - start));
        star.disconnect();
        if (errs.size() > 0) {
            errs.sort();
            errs.printErrors(System.out);
        }
        System.err.println("Elapsed: " + (System.currentTimeMillis() - start));
    }
}

