/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.validator.functions;

import EDU.bmrb.stardb.Star_DB;
import EDU.bmrb.validator.Config;
import EDU.bmrb.validator.Error;
import EDU.bmrb.validator.ErrorList;
import EDU.bmrb.validator.Pair;
import EDU.bmrb.validator.Severity;
import EDU.bmrb.validator.ValidationFunction;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;

public class CheckXlinkBond
extends ValidationFunction {
    private static final boolean DEBUG = false;
    private static final boolean PROFILE = false;
    public static final int NUMBER = 30;
    public static final String RESIDUE = "CYS";
    public static final String SEQ_TAG = "_Entity_comp_index.Comp_ID";
    public static final String BOND_TAG = "_Bond.Entity_label_%";

    public CheckXlinkBond(ErrorList errs, Config conf) {
        super(errs, conf);
        this.fNum = 30;
        this.fName = CheckXlinkBond.className(this.getClass().getName());
        this.init(30);
    }

    public boolean validate(Connection conn) {
        long start = System.currentTimeMillis();
        boolean rc = true;
        ResultSet rs = null;
        StringBuilder sql = new StringBuilder();
        try {
            Statement stat = conn.createStatement(1004, 1007);
            ArrayList<Pair<Integer, String>> list = new ArrayList<Pair<Integer, String>>();
            sql.append("SELECT s.NAME,count(*),t.LINE FROM ENTRYVALS v JOIN ENTRYTAGS t ON t.ID=v.TAGID JOIN ENTRYSFS s ON s.ID=t.SFID WHERE v.VAL='");
            sql.append(RESIDUE);
            sql.append("' AND t.NAME='");
            sql.append(SEQ_TAG);
            sql.append("' GROUP BY s.NAME,t.LINE");
            rs = stat.executeQuery(sql.toString());
            while (rs.next()) {
                if (rs.getInt(2) <= 1) continue;
                list.add(new Pair<Integer, String>(rs.getInt(3), rs.getString(1)));
            }
            if (list.size() < 1) {
                stat.close();
                return true;
            }
            sql.setLength(0);
            sql.append("SELECT DISTINCT v2.VAL FROM ENTRYVALS v1 JOIN ENTRYVALS v2 ON v2.LOOPROW=v1.LOOPROW AND v2.LOOPID=v1.LOOPID JOIN ENTRYTAGS t ON v2.TAGID=t.ID WHERE t.NAME LIKE '");
            sql.append(BOND_TAG);
            sql.append("' AND v1.VAL='");
            sql.append(RESIDUE);
            sql.append('\'');
            rs = stat.executeQuery(sql.toString());
            block3: while (rs.next()) {
                Iterator i = list.iterator();
                while (i.hasNext()) {
                    Pair p = (Pair)i.next();
                    if (!((String)p.getSecond()).equals(rs.getString(1))) continue;
                    i.remove();
                    continue block3;
                }
            }
            for (Pair pair : list) {
                this.fErrs.add(new Error(Severity.WARN, 30, 0, (Integer)pair.getFirst(), "More than 1 CYS and no CYS cross-link bond in saveframe %s", pair.getSecond()));
                rc = false;
            }
            stat.close();
            list.clear();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            this.fErrs.add(new Error(Severity.CRIT, 30, -1, -1, "Caught exception, check error output"));
            return false;
        }
        return rc;
    }

    public static void main(String[] args) {
        Config conf;
        long start = System.currentTimeMillis();
        ErrorList errs = new ErrorList();
        if (args.length > 0) {
            if (args[0].equals("-h")) {
                System.err.println("Usage: java EDU.bmrb.validator.functions.CheckXlinkBond [config file]");
                return;
            }
            conf = new Config(args[0]);
        } else {
            conf = new Config();
        }
        Star_DB star = new Star_DB(conf.getProperties());
        CheckXlinkBond chk = new CheckXlinkBond(errs, conf);
        star.connect(true);
        System.err.println("DB open: " + (System.currentTimeMillis() - start));
        chk.validate(star.getConnection());
        System.err.println("Validated: " + (System.currentTimeMillis() - start));
        star.disconnect();
        if (errs.size() > 0) {
            errs.sort();
            errs.printErrors(System.out);
        }
        System.err.println("Elapsed: " + (System.currentTimeMillis() - start));
    }
}

