/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.validator.functions;

import EDU.bmrb.stardb.Entry;
import EDU.bmrb.stardb.Star_DB;
import EDU.bmrb.stardb.Stardb;
import EDU.bmrb.stardb.sdbException;
import EDU.bmrb.validator.Config;
import EDU.bmrb.validator.EditingFunction;
import EDU.bmrb.validator.Error;
import EDU.bmrb.validator.ErrorList;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class EditResidueLabels
extends EditingFunction {
    private static final boolean DEBUG = false;
    public static final int NUMBER = 97;
    public static final String[] ERRS = new String[]{"No residue sequence loop (_poly_seq)", "No entity ID", "No residue type", "No residue sequence loop (_comp_index)"};
    public static final String ENTITY_SFCAT = "entity";
    public static final String TAG_LABEL = "_Entity_poly_seq.Mon_ID";
    public static final String TAG_LABEL2 = "_Entity_comp_index.Comp_ID";
    public static final String TAG_EID = "_Entity.ID";
    private StringBuffer fBuf = null;

    public EditResidueLabels(ErrorList errs, Config conf, Stardb star) {
        super(errs, conf, star);
        this.fNum = new Integer(97);
        this.fName = EditResidueLabels.className(this.getClass().getName());
        this.init(97);
        this.fBuf = new StringBuffer();
    }

    public boolean edit(boolean interactive) {
        try {
            boolean rc = true;
            this.fBuf.setLength(0);
            this.fBuf.append("SELECT ID,LINE FROM ENTRYSFS WHERE CATEGORY='");
            this.fBuf.append(ENTITY_SFCAT);
            this.fBuf.append("' ORDER BY ID");
            Statement query = this.fStar.getQueryStatement();
            ResultSet rs = query.executeQuery(this.fBuf.toString());
            while (rs.next()) {
                if (this.updateSaveframe(rs.getInt(1), rs.getInt(2))) continue;
                rc = false;
            }
            rs.close();
            query.close();
            return true;
        }
        catch (Exception e) {
            this.fErrs.add(new Error(true, 97, -1, -1, "DB exception, check error output"));
            System.err.println(e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public boolean updateSaveframe(int sfid, int sfline) throws SQLException, sdbException {
        int comptagid;
        int tagid = Entry.getTagID(this.fStar, sfid, TAG_LABEL);
        if (tagid < 0) {
            this.fErrs.add(new Error(false, 97, 0, sfline, ERRS[0]));
        }
        if ((comptagid = Entry.getTagID(this.fStar, sfid, TAG_LABEL2)) < 0) {
            this.fErrs.add(new Error(false, 97, 3, sfline, ERRS[3]));
        }
        if (tagid < 0 && comptagid < 0) {
            return false;
        }
        this.fBuf.setLength(0);
        this.fBuf.append("SELECT v.VAL FROM ENTRYVALS v,ENTRYTAGS t WHERE t.NAME='");
        this.fBuf.append(TAG_EID);
        this.fBuf.append("' AND t.SFID=");
        this.fBuf.append(sfid);
        this.fBuf.append(" AND v.TAGID=t.ID");
        int eid = -1;
        Statement query = this.fStar.getQueryStatement();
        ResultSet rs = query.executeQuery(this.fBuf.toString());
        if (rs.next()) {
            eid = rs.getInt(1);
            if (rs.wasNull()) {
                eid = -1;
            }
        }
        if (eid < 0) {
            rs.close();
            query.close();
            this.fErrs.add(new Error(false, 97, 1, sfline, ERRS[1]));
            return false;
        }
        String restype = null;
        this.fBuf.setLength(0);
        this.fBuf.append("SELECT ENTITY FROM ENTRYRESTYPES WHERE EID='");
        this.fBuf.append(eid);
        this.fBuf.append('\'');
        rs = query.executeQuery(this.fBuf.toString());
        if (rs.next()) {
            restype = rs.getString(1);
            if (rs.wasNull()) {
                restype = null;
            }
        }
        if (restype == null) {
            if (this.fErrs != null) {
                this.fErrs.add(new Error(false, 97, 2, sfline, ERRS[2]));
            }
            rs.close();
            query.close();
            return false;
        }
        restype = restype.toLowerCase().indexOf("polypeptide") >= 0 ? "polypeptide" : restype.toLowerCase();
        rs.close();
        query.close();
        boolean rc = true;
        if (tagid >= 0 && !this.updateLoop(tagid, restype)) {
            rc = false;
        }
        if (comptagid >= 0 && !this.updateLoop(comptagid, restype)) {
            rc = false;
        }
        return rc;
    }

    public boolean updateLoop(int tagid, String restype) throws SQLException, sdbException {
        this.fBuf.setLength(0);
        this.fBuf.append("UPDATE ENTRYVALS SET VAL=(SELECT r.LABEL FROM RESIDUES r,");
        this.fBuf.append("RESTYPES t WHERE t.NAME='");
        this.fBuf.append(restype);
        this.fBuf.append("' AND r.TYPEID=t.ID AND r.CODE=ENTRYVALS.VAL) WHERE TAGID=");
        this.fBuf.append(tagid);
        this.fBuf.append(" AND VAL IS NOT NULL AND LENGTH(VAL) < 3");
        Statement stat = this.fStar.getStatement();
        int rc = stat.executeUpdate(this.fBuf.toString());
        stat.getConnection().commit();
        stat.close();
        return rc > 0;
    }

    public static void main(String[] args) {
        Config conf;
        long start = System.currentTimeMillis();
        ErrorList errs = new ErrorList();
        if (args.length > 0) {
            if (args[0].equals("-h")) {
                System.err.println("Usage: java EDU.bmrb.validator.functions.EditResidueLabels [config file]");
                System.err.println("Error messages:");
                for (int i = 0; i < ERRS.length; ++i) {
                    System.err.println(ERRS[i]);
                }
                return;
            }
            conf = new Config(args[0]);
        } else {
            conf = new Config();
        }
        Star_DB star = new Star_DB(conf.getProperties());
        EditResidueLabels fn = new EditResidueLabels(errs, conf, star);
        star.connect(true);
        System.err.println("DB open: " + (System.currentTimeMillis() - start));
        boolean rc = fn.edit(false);
        System.err.println("Edited: " + (System.currentTimeMillis() - start));
        star.disconnect();
        if (errs.size() > 0) {
            errs.sort();
            errs.printErrors(System.out);
        }
        System.err.println("Elapsed: " + (System.currentTimeMillis() - start));
        if (!rc) {
            System.exit(1);
        }
    }
}

