/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.validator.functions;

import EDU.bmrb.stardb.CreateTemplate;
import EDU.bmrb.stardb.Entry;
import EDU.bmrb.stardb.Star_DB;
import EDU.bmrb.stardb.Stardb;
import EDU.bmrb.validator.Config;
import EDU.bmrb.validator.EditingFunction;
import EDU.bmrb.validator.Error;
import EDU.bmrb.validator.ErrorList;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class ExpandExperimentList
extends EditingFunction {
    private static final boolean DEBUG = false;
    public static final int NUMBER = 93;
    public static final String SRCSFCAT = "NMR_spectrometer_expt_list";
    public static final String TGTSFCAT = "NMR_spectrometer_expt";
    private CreateTemplate fCt = null;
    private PreparedStatement fPQuery = null;
    private int fSfSeq = -1;

    public ExpandExperimentList(ErrorList errs, Config conf, Stardb star) {
        super(errs, conf, star);
        this.fNum = new Integer(93);
        this.fName = ExpandExperimentList.className(this.getClass().getName());
        this.init(93);
    }

    public boolean edit(boolean interactive) {
        try {
            Statement query = this.fStar.getQueryStatement();
            ResultSet rs = query.executeQuery("SELECT ID FROM ENTRYSFS WHERE CATEGORY='NMR_spectrometer_expt_list'");
            if (!rs.next()) {
                rs.close();
                query.close();
                this.fErrs.add(true, 93, 0, -1, "No NMR expt. list saveframes");
                return false;
            }
            rs = query.executeQuery("SELECT ID,LINE FROM ENTRYSFS WHERE CATEGORY='NMR_spectrometer_expt'");
            if (rs.next()) {
                this.fErrs.add(true, 93, 0, rs.getInt(2), "NMR expt. saveframe(s) already exists");
                rs.close();
                query.close();
                return false;
            }
            int line = 9999;
            int count = 0;
            rs = query.executeQuery("SELECT MAX(LINE) FROM ENTRYVALS");
            if (rs.next()) {
                line = rs.getInt(1) + 1;
            }
            if ((rs = query.executeQuery("SELECT ID FROM SFCATS WHERE SFCAT='NMR_spectrometer_expt'")).next()) {
                this.fSfSeq = rs.getInt(1);
                if (rs.wasNull()) {
                    this.fSfSeq = -1;
                }
            }
            rs = query.executeQuery("SELECT DISTINCT v.VAL,v.LOOPROW FROM ENTRYVALS v,ENTRYTAGS t WHERE t.NAME='_NMR_spec_expt_list_item.Name' AND v.TAGID=t.ID ORDER BY v.LOOPROW");
            while (rs.next()) {
                ++count;
                String name = rs.getString(1);
                if (rs.wasNull()) continue;
                if (!this.addSaveframe(name = name.replaceAll("\\s", "_"), line)) {
                    rs.close();
                    query.close();
                    return false;
                }
                line += 50;
            }
            rs.close();
            query.close();
            if (this.fPQuery != null) {
                this.fPQuery.close();
                this.fPQuery = null;
            }
            return true;
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
            return false;
        }
    }

    private boolean addSaveframe(String name, int line) throws Exception {
        String val;
        if (this.fCt == null) {
            this.fCt = new CreateTemplate(this.fStar);
        }
        this.fCt.setStartLine(line);
        int sfid = this.fCt.addSaveFrame(name, TGTSFCAT, this.fSfSeq);
        if (sfid < 0) {
            if (this.fErrs != null) {
                this.fErrs.add(new Error(true, 93, -1, -1, "Cannot add saveframe"));
            }
            return false;
        }
        if (!this.fCt.addTags(name, TGTSFCAT, sfid)) {
            if (this.fErrs != null) {
                this.fErrs.add(new Error(true, 93, -1, -1, "Cannot add tags in new saveframe"));
            }
            return false;
        }
        int tagid = Entry.getTagID(this.fStar, sfid, "_NMR_spec_expt.Name");
        name = name.replaceAll("_", " ");
        if (tagid >= 0) {
            Entry.insertFreeValue(this.fStar, tagid, name);
        }
        if (this.fPQuery == null) {
            this.fPQuery = this.fStar.getPreparedQuery("SELECT NAME FROM ENTRYSFS WHERE CATEGORY=?");
        }
        this.fPQuery.setString(1, "sample");
        ResultSet rs = this.fPQuery.executeQuery();
        if (rs.next()) {
            tagid = Entry.getTagID(this.fStar, sfid, "_NMR_spec_expt.Sample_ID");
            if (tagid < 0) {
                Entry.insertFreeTagValue(this.fStar, sfid, "_NMR_spec_expt.Sample_ID", "?");
            }
            if ((tagid = Entry.getTagID(this.fStar, sfid, "_NMR_spec_expt.Sample_label")) < 0) {
                Entry.insertFreeTagValue(this.fStar, sfid, "_NMR_spec_expt.Sample_label", "?");
                tagid = Entry.getTagID(this.fStar, sfid, "_NMR_spec_expt.Sample_label");
            }
            val = rs.getString(1);
            if (!rs.next() && tagid >= 0) {
                Entry.insertFreeValue(this.fStar, tagid, val, 12);
            }
        }
        this.fPQuery.setString(1, "sample_conditions");
        rs = this.fPQuery.executeQuery();
        if (rs.next()) {
            tagid = Entry.getTagID(this.fStar, sfid, "_NMR_spec_expt.Sample_condition_list_ID");
            if (tagid < 0) {
                Entry.insertFreeTagValue(this.fStar, sfid, "_NMR_spec_expt.Sample_condition_list_ID", "?");
            }
            if ((tagid = Entry.getTagID(this.fStar, sfid, "_NMR_spec_expt.Sample_condition_list_label")) < 0) {
                Entry.insertFreeTagValue(this.fStar, sfid, "_NMR_spec_expt.Sample_condition_list_label", "?");
                tagid = Entry.getTagID(this.fStar, sfid, "_NMR_spec_expt.Sample_condition_list_label");
            }
            val = rs.getString(1);
            if (!rs.next() && tagid >= 0) {
                Entry.insertFreeValue(this.fStar, tagid, val, 12);
            }
        }
        this.fPQuery.setString(1, "NMR_spectrometer");
        rs = this.fPQuery.executeQuery();
        if (rs.next()) {
            tagid = Entry.getTagID(this.fStar, sfid, "_NMR_spec_expt.NMR_spectrometer_ID");
            if (tagid < 0) {
                Entry.insertFreeTagValue(this.fStar, sfid, "_NMR_spec_expt.NMR_spectrometer_ID", "?");
            }
            if ((tagid = Entry.getTagID(this.fStar, sfid, "_NMR_spec_expt.NMR_spectrometer_label")) < 0) {
                Entry.insertFreeTagValue(this.fStar, sfid, "_NMR_spec_expt.NMR_spectrometer_label", "?");
                tagid = Entry.getTagID(this.fStar, sfid, "_NMR_spec_expt.NMR_spectrometer_label");
            }
            val = rs.getString(1);
            if (!rs.next() && tagid >= 0) {
                Entry.insertFreeValue(this.fStar, tagid, val, 12);
            }
        }
        this.fPQuery.setString(1, "NMR_spectrometer_probe");
        rs = this.fPQuery.executeQuery();
        if (rs.next()) {
            tagid = Entry.getTagID(this.fStar, sfid, "_NMR_spec_expt.NMR_spectrometer_probe_ID");
            if (tagid < 0) {
                Entry.insertFreeTagValue(this.fStar, sfid, "_NMR_spec_expt.NMR_spectrometer_probe_ID", "?");
            }
            if ((tagid = Entry.getTagID(this.fStar, sfid, "_NMR_spec_expt.NMR_spectrometer_probe_label")) < 0) {
                Entry.insertFreeTagValue(this.fStar, sfid, "_NMR_spec_expt.NMR_spectrometer_probe_label", "?");
                tagid = Entry.getTagID(this.fStar, sfid, "_NMR_spec_expt.NMR_spectrometer_probe_label");
            }
            val = rs.getString(1);
            if (!rs.next() && tagid >= 0) {
                Entry.insertFreeValue(this.fStar, tagid, val, 12);
            }
        }
        this.fPQuery.setString(1, "software");
        rs = this.fPQuery.executeQuery();
        if (rs.next()) {
            tagid = Entry.getTagID(this.fStar, sfid, "_NMR_spec_expt.Software_ID");
            if (tagid < 0) {
                Entry.insertFreeTagValue(this.fStar, sfid, "_NMR_spec_expt.Software_ID", "?");
            }
            if ((tagid = Entry.getTagID(this.fStar, sfid, "_NMR_spec_expt.Software_label")) < 0) {
                Entry.insertFreeTagValue(this.fStar, sfid, "_NMR_spec_expt.Software_label", "?");
                tagid = Entry.getTagID(this.fStar, sfid, "_NMR_spec_expt.Software_label");
            }
            val = rs.getString(1);
            if (!rs.next() && tagid >= 0) {
                Entry.insertFreeValue(this.fStar, tagid, val, 12);
            }
        }
        this.fPQuery.setString(1, "method");
        rs = this.fPQuery.executeQuery();
        if (rs.next()) {
            tagid = Entry.getTagID(this.fStar, sfid, "_NMR_spec_expt.Method_ID");
            if (tagid < 0) {
                Entry.insertFreeTagValue(this.fStar, sfid, "_NMR_spec_expt.Method_ID", "?");
            }
            if ((tagid = Entry.getTagID(this.fStar, sfid, "_NMR_spec_expt.Method_label")) < 0) {
                Entry.insertFreeTagValue(this.fStar, sfid, "_NMR_spec_expt.Method_label", "?");
                tagid = Entry.getTagID(this.fStar, sfid, "_NMR_spec_expt.Method_label");
            }
            val = rs.getString(1);
            if (!rs.next() && tagid >= 0) {
                Entry.insertFreeValue(this.fStar, tagid, val, 12);
            }
        }
        rs.close();
        return true;
    }

    public static void main(String[] args) {
        Config conf;
        long start = System.currentTimeMillis();
        ErrorList errs = new ErrorList();
        if (args.length > 0) {
            if (args[0].equals("-h")) {
                System.err.println("Usage: java EDU.bmrb.validator.functions.ExpandExperimentList [config file]");
                return;
            }
            conf = new Config(args[0]);
        } else {
            conf = new Config();
        }
        Star_DB star = new Star_DB(conf.getProperties());
        ExpandExperimentList fn = new ExpandExperimentList(errs, conf, star);
        star.connect(true);
        System.err.println("DB open: " + (System.currentTimeMillis() - start));
        boolean rc = fn.edit(false);
        System.err.println("Edited: " + (System.currentTimeMillis() - start));
        star.disconnect();
        if (errs.size() > 0) {
            errs.sort();
            errs.printErrors(System.out);
        }
        System.err.println("Elapsed: " + (System.currentTimeMillis() - start));
        if (!rc) {
            System.exit(1);
        }
    }
}

