/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.validator.functions;

import EDU.bmrb.stardb.CreateTemplate;
import EDU.bmrb.stardb.Entry;
import EDU.bmrb.stardb.Star_DB;
import EDU.bmrb.stardb.Stardb;
import EDU.bmrb.validator.Config;
import EDU.bmrb.validator.EditingFunction;
import EDU.bmrb.validator.Error;
import EDU.bmrb.validator.ErrorList;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class ExpandSpectrometerList
extends EditingFunction {
    private static final boolean DEBUG = false;
    public static final int NUMBER = 91;
    public static final String SRCSFCAT = "NMR_spectrometer_list";
    public static final String TGTSFCAT = "NMR_spectrometer";
    private CreateTemplate fCt = null;
    private PreparedStatement fDtlStat = null;
    private PreparedStatement fCitStat = null;
    private PreparedStatement fMfrStat = null;
    private PreparedStatement fMdlStat = null;
    private PreparedStatement fFldStat = null;
    private PreparedStatement fSrlStat = null;
    private int fSfSeq = -1;

    public ExpandSpectrometerList(ErrorList errs, Config conf, Stardb star) {
        super(errs, conf, star);
        this.fNum = new Integer(91);
        this.fName = ExpandSpectrometerList.className(this.getClass().getName());
        this.init(91);
    }

    public boolean edit(boolean interactive) {
        try {
            Statement query = this.fStar.getQueryStatement();
            ResultSet rs = query.executeQuery("SELECT ID FROM ENTRYSFS WHERE CATEGORY='NMR_spectrometer_list'");
            if (!rs.next()) {
                rs.close();
                query.close();
                this.fErrs.add(true, 91, 0, -1, "No NMR spectrometer list saveframes");
                return false;
            }
            rs = query.executeQuery("SELECT ID,LINE FROM ENTRYSFS WHERE CATEGORY='NMR_spectrometer'");
            if (rs.next()) {
                this.fErrs.add(true, 91, 0, rs.getInt(2), "NMR spectrometer saveframe(s) already exists");
                rs.close();
                query.close();
                return false;
            }
            int line = 9999;
            rs = query.executeQuery("SELECT MAX(LINE) FROM ENTRYVALS");
            if (rs.next()) {
                line = rs.getInt(1) + 1;
            }
            if ((rs = query.executeQuery("SELECT ID FROM SFCATS WHERE SFCAT='NMR_spectrometer'")).next()) {
                this.fSfSeq = rs.getInt(1);
                if (rs.wasNull()) {
                    this.fSfSeq = -1;
                }
            }
            rs = query.executeQuery("SELECT DISTINCT v.LOOPROW,v.VAL FROM ENTRYVALS v,ENTRYTAGS t WHERE t.NAME='_NMR_spectrometer_view.ID' AND v.TAGID=t.ID ORDER BY v.LOOPROW");
            while (rs.next()) {
                rs.getString(2);
                String sfname = rs.wasNull() ? "spectrometer_" + rs.getInt(1) : "spectrometer_" + rs.getString(2);
                if (this.addSaveframe(sfname, rs.getInt(1), line)) continue;
                rs.close();
                query.close();
                return false;
            }
            rs.close();
            query.close();
            if (this.fMfrStat != null) {
                this.fMfrStat.close();
                this.fMfrStat = null;
            }
            if (this.fMdlStat != null) {
                this.fMdlStat.close();
                this.fMdlStat = null;
            }
            if (this.fFldStat != null) {
                this.fFldStat.close();
                this.fFldStat = null;
            }
            if (this.fDtlStat != null) {
                this.fDtlStat.close();
                this.fDtlStat = null;
            }
            if (this.fCitStat != null) {
                this.fCitStat.close();
                this.fCitStat = null;
            }
            if (this.fSrlStat != null) {
                this.fSrlStat.close();
                this.fSrlStat = null;
            }
            return true;
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace();
            return false;
        }
    }

    private boolean addSaveframe(String name, int row, int line) throws Exception {
        String val;
        if (this.fCt == null) {
            this.fCt = new CreateTemplate(this.fStar);
        }
        this.fCt.setStartLine(line);
        int sfid = this.fCt.addSaveFrame(name, TGTSFCAT, this.fSfSeq);
        if (sfid < 0) {
            if (this.fErrs != null) {
                this.fErrs.add(new Error(true, 91, -1, -1, "Cannot add saveframe"));
            }
            return false;
        }
        if (!this.fCt.addTags(name, TGTSFCAT, sfid)) {
            if (this.fErrs != null) {
                this.fErrs.add(new Error(true, 91, -1, -1, "Cannot add tags in new saveframe"));
            }
            return false;
        }
        int tagid = -1;
        if (this.fMfrStat == null) {
            this.fMfrStat = this.fStar.getPreparedQuery("SELECT v.VAL FROM ENTRYVALS v,ENTRYTAGS t WHERE t.NAME='_NMR_spectrometer_view.Manufacturer' AND v.TAGID=t.ID AND v.LOOPROW=?");
        }
        this.fMfrStat.setInt(1, row);
        ResultSet rs = this.fMfrStat.executeQuery();
        if (rs.next()) {
            val = rs.getString(1);
            if (!rs.wasNull() && (tagid = Entry.getTagID(this.fStar, sfid, "_NMR_spectrometer.Manufacturer")) >= 0) {
                Entry.insertFreeValue(this.fStar, tagid, val);
            }
        }
        if (this.fMdlStat == null) {
            this.fMdlStat = this.fStar.getPreparedQuery("SELECT v.VAL FROM ENTRYVALS v,ENTRYTAGS t WHERE t.NAME='_NMR_spectrometer_view.Model' AND v.TAGID=t.ID AND v.LOOPROW=?");
        }
        this.fMdlStat.setInt(1, row);
        rs = this.fMdlStat.executeQuery();
        if (rs.next()) {
            val = rs.getString(1);
            if (!rs.wasNull() && (tagid = Entry.getTagID(this.fStar, sfid, "_NMR_spectrometer.Model")) >= 0) {
                Entry.insertFreeValue(this.fStar, tagid, val);
            }
        }
        if (this.fFldStat == null) {
            this.fFldStat = this.fStar.getPreparedQuery("SELECT v.VAL FROM ENTRYVALS v,ENTRYTAGS t WHERE t.NAME='_NMR_spectrometer_view.Field_strength' AND v.TAGID=t.ID AND v.LOOPROW=?");
        }
        this.fFldStat.setInt(1, row);
        rs = this.fFldStat.executeQuery();
        if (rs.next()) {
            val = rs.getString(1);
            if (!rs.wasNull() && (tagid = Entry.getTagID(this.fStar, sfid, "_NMR_spectrometer.Field_strength")) >= 0) {
                Entry.insertFreeValue(this.fStar, tagid, val);
            }
        }
        if (this.fDtlStat == null) {
            this.fDtlStat = this.fStar.getPreparedQuery("SELECT v.VAL FROM ENTRYVALS v,ENTRYTAGS t WHERE t.NAME='_NMR_spectrometer_view.Details' AND v.LOOPROW=? AND v.TAGID=t.ID");
        }
        this.fDtlStat.setInt(1, row);
        rs = this.fDtlStat.executeQuery();
        if (rs.next()) {
            val = rs.getString(1);
            if (!(rs.wasNull() || val.equals(".") || val.equals("?"))) {
                Entry.insertFreeTagValue(this.fStar, sfid, "_NMR_spectrometer.Details", val);
            }
        }
        if (this.fSrlStat == null) {
            this.fSrlStat = this.fStar.getPreparedQuery("SELECT v.VAL FROM ENTRYVALS v,ENTRYTAGS t WHERE t.NAME='_NMR_spectrometer_view.Serial_number' AND v.LOOPROW=? AND v.TAGID=t.ID");
        }
        this.fSrlStat.setInt(1, row);
        rs = this.fSrlStat.executeQuery();
        if (rs.next()) {
            val = rs.getString(1);
            if (!(rs.wasNull() || val.equals(".") || val.equals("?"))) {
                Entry.insertFreeTagValue(this.fStar, sfid, "_NMR_spectrometer.Serial_number", val);
            }
        }
        if (this.fCitStat == null) {
            this.fCitStat = this.fStar.getPreparedQuery("SELECT v.VAL FROM ENTRYVALS v,ENTRYTAGS t WHERE t.NAME='_NMR_spectrometer_view.Citation_label' AND v.LOOPROW=? AND v.TAGID=t.ID");
        }
        this.fCitStat.setInt(1, row);
        rs = this.fCitStat.executeQuery();
        if (rs.next()) {
            int loopid;
            val = rs.getString(1);
            if (!(rs.wasNull() || val.equals(".") || val.equals("?") || (loopid = Entry.insertLoop(this.fStar, sfid, "_NMR_spectrometer_citation.Citation_label")) < 0 || (tagid = Entry.getTagID(this.fStar, sfid, "_NMR_spectrometer_citation.Citation_label")) < 0)) {
                Entry.insertLoopValue(this.fStar, loopid, tagid, 0, val);
            }
        }
        return true;
    }

    public static void main(String[] args) {
        Config conf;
        long start = System.currentTimeMillis();
        ErrorList errs = new ErrorList();
        if (args.length > 0) {
            if (args[0].equals("-h")) {
                System.err.println("Usage: java EDU.bmrb.validator.functions.ExpandSpectrometerList [config file]");
                return;
            }
            conf = new Config(args[0]);
        } else {
            conf = new Config();
        }
        Star_DB star = new Star_DB(conf.getProperties());
        ExpandSpectrometerList fn = new ExpandSpectrometerList(errs, conf, star);
        star.connect(true);
        System.err.println("DB open: " + (System.currentTimeMillis() - start));
        boolean rc = fn.edit(false);
        System.err.println("Edited: " + (System.currentTimeMillis() - start));
        star.disconnect();
        if (errs.size() > 0) {
            errs.sort();
            errs.printErrors(System.out);
        }
        System.err.println("Elapsed: " + (System.currentTimeMillis() - start));
        if (!rc) {
            System.exit(1);
        }
    }
}

