/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.validator.functions;

import EDU.bmrb.sansj.ContentHandler;
import EDU.bmrb.sansj.DataItemNode;
import EDU.bmrb.sansj.ErrorHandler;
import EDU.bmrb.sansj.STARLexer;
import EDU.bmrb.sansj.SansParser;
import EDU.bmrb.stardb.Star_DB;
import EDU.bmrb.validator.Config;
import EDU.bmrb.validator.DataValidationFunction;
import EDU.bmrb.validator.Error;
import EDU.bmrb.validator.ErrorList;
import EDU.bmrb.validator.Severity;
import gnu.getopt.Getopt;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;

public class ExtractResidueSequence
extends DataValidationFunction
implements ErrorHandler,
ContentHandler {
    private static final boolean DEBUG = false;
    public static final int NUMBER = 23;
    public static final String TAG_SHIFTID = "_Atom_chem_shift.ID";
    public static final String TAG_ENTITYID = "_Atom_chem_shift.Entity_ID";
    public static final String TAG_SEQNO = "_Atom_chem_shift.Comp_index_ID";
    public static final String TAG_RESLABEL = "_Atom_chem_shift.Comp_ID";
    public static final String TAG_SEQUENCEC = "_Entity.Polymer_seq_one_letter_code_can";
    public static final String TAG_SEQUENCE = "_Entity.Polymer_seq_one_letter_code";
    public static final String TAG_EID = "_Entity.ID";
    private boolean fInLoop = false;
    private boolean fInShifts = false;
    private String fSeqno = null;
    private int fEntity = -1;
    private boolean fAddRow = true;
    private PreparedStatement fRescodeQuery = null;
    private PreparedStatement fRestypeQuery = null;
    private PreparedStatement fEntityQuery = null;
    private ResultSet fRs = null;
    private HashMap<String, StringBuilder> fMap = null;
    private Row fRow = null;
    private boolean fWarnNonPolymer = true;

    public ExtractResidueSequence(ErrorList errs, Config conf) {
        super(errs, conf);
        this.fNum = 23;
        this.fName = ExtractResidueSequence.className(this.getClass().getName());
        this.init(23);
    }

    /*
     * Unable to fully structure code
     */
    public boolean validate(Connection conn, Reader in) {
        if (this.fMap == null) {
            this.fMap = new HashMap<K, V>();
        } else {
            this.fMap.clear();
        }
        try {
            if (this.fEntityQuery == null) {
                this.fEntityQuery = conn.prepareStatement("SELECT v.VAL FROM ENTRYVALS v JOIN ENTRYTAGS t ON t.ID=v.TAGID WHERE t.NAME='_Entity.ID' AND v.VAL=?", 1003, 1007);
            }
            if (this.fRescodeQuery == null) {
                this.fRescodeQuery = conn.prepareStatement("SELECT r.CODE FROM RESIDUES r JOIN RESTYPES t ON t.ID=r.TYPEID WHERE r.LABEL=? AND t.NAME=?", 1003, 1007);
            }
            if (this.fRestypeQuery == null) {
                this.fRestypeQuery = conn.prepareStatement("SELECT ENTITY FROM ENTRYRESTYPES WHERE EID=?", 1003, 1007);
            }
            this.fRow = new Row();
            lex = new STARLexer(in);
            p = new SansParser(lex, this, this);
            p.parse();
            this.fRescodeQuery.close();
            this.fRescodeQuery = null;
            this.fRestypeQuery.close();
            this.fRestypeQuery = null;
            pquery = conn.prepareStatement("SELECT v2.VAL,v1.LINE FROM ENTRYVALS v1 JOIN ENTRYTAGS t1 ON t1.ID=v1.TAGID JOIN ENTRYTAGS t2 ON t2.SFID=t1.SFID JOIN ENTRYVALS v2 ON v2.TAGID=t2.ID WHERE t1.NAME='_Entity.ID' AND v1.VAL=? AND t2.NAME=?", 1003, 1007);
            lineno = 0;
            for (String key : this.fMap.keySet()) {
                lineno = 0;
                entityseq = "";
                seq = this.fMap.get(key);
                pquery.setString(1, key);
                pquery.setString(2, "_Entity.Polymer_seq_one_letter_code");
                this.fRs = pquery.executeQuery();
                if (this.fRs.next()) ** GOTO lbl-1000
                pquery.setString(2, "_Entity.Polymer_seq_one_letter_code_can");
                this.fRs = pquery.executeQuery();
                if (!this.fRs.next()) {
                    this.fErrs.add(new Error(Severity.ERR, 23, 0, 0, "No residue sequence in entity %s", new Object[]{key}));
                } else lbl-1000:
                // 2 sources

                {
                    lineno = this.fRs.getInt(2);
                    this.fRs.getString(1);
                    if (this.fRs.wasNull() || this.fRs.getString(1).trim().length() < 1) {
                        this.fErrs.add(new Error(Severity.ERR, 23, 0, this.fRs.getInt(2), "No residue sequence in entity %s", new Object[]{key}));
                    }
                    this.fRs.getString(1);
                    if (!this.fRs.wasNull()) {
                        entityseq = this.fRs.getString(1).replaceAll("\\s", "");
                    }
                    if (!entityseq.equals("") && !entityseq.equals(seq.toString())) {
                        this.fErrs.add(new Error(Severity.ERR, 23, 1, this.fRs.getInt(2), "Residue sequence in chem. shift loop does not match residue sequence in entity %s:\n%s", new Object[]{key, entityseq}));
                    }
                }
                this.fErrs.add(new Error(Severity.INFO, 23, 2, lineno, "Sequence for entity %s\nfrom entity: %s\nfrom loop  : %s", new Object[]{key, entityseq.equals("") != false ? "no sequence" : entityseq, seq.toString()}));
            }
            if (this.fRs != null) {
                this.fRs.close();
            }
            pquery.close();
            return true;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            this.fErrs.add(new Error(Severity.CRIT, 23, -1, -1, "Caught exception, check error output"));
            return false;
        }
    }

    private void addRow() {
        if (!this.fAddRow) {
            return;
        }
        try {
            String restype = null;
            this.fRestypeQuery.setString(1, this.fRow.eid);
            this.fRs = this.fRestypeQuery.executeQuery();
            if (!this.fRs.next()) {
                this.fEntityQuery.setString(1, this.fRow.eid);
                this.fRs = this.fEntityQuery.executeQuery();
                if (!this.fRs.next()) {
                    this.fErrs.add(new Error(Severity.ERR, 23, 3, this.fRow.line, "Invalid entity id: %s", this.fRow.eid));
                } else if (this.fWarnNonPolymer) {
                    this.fErrs.add(new Error(Severity.ERR, 23, 4, this.fRow.line, "Unknown residue label: %s", this.fRow.label));
                    this.fWarnNonPolymer = false;
                }
                this.fRow.clear();
                return;
            }
            restype = this.fRs.getString(1);
            if (this.fRs.wasNull()) {
                this.fRow.clear();
                return;
            }
            int pos = restype.indexOf("(L)");
            if (pos < 0) {
                pos = restype.indexOf("(D)");
            }
            if (pos >= 0) {
                restype = restype.substring(0, restype.length() - 3);
            }
            this.fRescodeQuery.setString(1, this.fRow.label);
            this.fRescodeQuery.setString(2, restype);
            this.fRs = this.fRescodeQuery.executeQuery();
            if (!this.fRs.next()) {
                this.fErrs.add(new Error(Severity.ERR, 23, 4, this.fRow.line, "Unknown residue label: %s", this.fRow.label));
                this.fRow.clear();
                return;
            }
            if (this.fMap.containsKey(this.fRow.eid)) {
                StringBuilder seq = this.fMap.get(this.fRow.eid);
                seq.append(this.fRs.getString(1));
            } else {
                StringBuilder seq = new StringBuilder(this.fRs.getString(1));
                this.fMap.put(this.fRow.eid, seq);
            }
            this.fRow.clear();
            this.fAddRow = false;
        }
        catch (SQLException e) {
            this.fErrs.add(new Error(Severity.CRIT, 23, -1, -1, "DB exception, check error output"));
            System.err.println(e);
            e.printStackTrace();
        }
    }

    public static void usage() {
        System.err.print("Usage: java EDU.bmrb.validator.functions.ExtractResidueSequence ");
        System.err.println("[-c FILE] [-i FILE] [-h]");
        System.err.println("  -c FILE: use config FILE instead of ~/validator.conf");
        System.err.println("  -i FILE: input file name (default: stdin)");
        System.err.println("  -h: print this message");
    }

    public static void main(String[] args) {
        try {
            int opt;
            Getopt g = new Getopt("ExtractResidueSequence", args, "c:i:h");
            String conffile = null;
            String infile = null;
            block6: while ((opt = g.getopt()) != -1) {
                switch (opt) {
                    case 99: {
                        conffile = g.getOptarg();
                        continue block6;
                    }
                    case 105: {
                        infile = g.getOptarg();
                        continue block6;
                    }
                }
                ExtractResidueSequence.usage();
                return;
            }
            Config conf = conffile == null ? new Config() : new Config(conffile);
            ErrorList errs = new ErrorList();
            BufferedReader in = infile == null ? new BufferedReader(new InputStreamReader(System.in)) : new BufferedReader(new FileReader(infile));
            long start = System.currentTimeMillis();
            Star_DB star = new Star_DB(conf.getProperties());
            star.connect(true);
            System.err.println("DB open: " + (System.currentTimeMillis() - start));
            ExtractResidueSequence chk = new ExtractResidueSequence(errs, conf);
            chk.validate(star.getConnection(), in);
            System.err.println("Validated: " + (System.currentTimeMillis() - start));
            star.disconnect();
            ((Reader)in).close();
            if (errs.size() > 0) {
                errs.sort();
                errs.printErrors(System.out);
            }
            System.err.println("Elapsed: " + (System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }

    public void error(int param, int param1, String str) {
        this.fErrs.add(new Error(Severity.CRIT, 23, -1, param, str));
        System.err.printf("Parse error in line %d, col %d: %s\n", param, param1, str);
    }

    public boolean warning(int param, int param1, String str) {
        this.fErrs.add(new Error(Severity.ERR, 23, -1, param, str));
        System.err.printf("Parse warning in line %d, col %d: %s\n", param, param1, str);
        return false;
    }

    public boolean startLoop(int param) {
        this.fInLoop = true;
        return false;
    }

    public boolean endLoop(int param) {
        if (this.fInShifts) {
            this.addRow();
        }
        this.fInLoop = false;
        this.fInShifts = false;
        return false;
    }

    public boolean data(DataItemNode node) {
        if (!this.fInLoop) {
            return false;
        }
        boolean first = false;
        if (!this.fInShifts && node.getName().equals(TAG_SHIFTID)) {
            this.fInShifts = true;
            first = true;
        }
        if (!this.fInShifts) {
            return false;
        }
        if (node.getName().equals(TAG_SHIFTID)) {
            if (!first) {
                this.addRow();
            }
            this.fRow.line = node.getValueLine();
        }
        if (node.getName().equals(TAG_SEQNO)) {
            if (this.fSeqno == null) {
                this.fSeqno = node.getValue();
            } else if (!this.fSeqno.equals(node.getValue())) {
                this.fSeqno = node.getValue();
                this.fAddRow = true;
                this.fWarnNonPolymer = true;
            }
        }
        if (node.getName().equals(TAG_ENTITYID)) {
            this.fRow.eid = node.getValue();
        }
        if (node.getName().equals(TAG_RESLABEL)) {
            this.fRow.label = node.getValue();
        }
        return false;
    }

    public boolean comment(int param, String str) {
        return false;
    }

    public void endData(int param, String str) {
    }

    public boolean endSaveFrame(int param, String str) {
        return false;
    }

    public boolean startData(int param, String str) {
        return false;
    }

    public boolean startSaveFrame(int param, String str) {
        return false;
    }

    class Row {
        int line = -1;
        String eid = null;
        String label = null;

        Row() {
        }

        public void clear() {
            this.line = -1;
            this.eid = null;
            this.label = null;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(this.eid);
            buf.append(' ');
            buf.append(this.label);
            buf.append(" (");
            buf.append(this.line);
            buf.append(')');
            return buf.toString();
        }
    }
}

