/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.validator.functions;

import EDU.bmrb.stardb.Star_DB;
import EDU.bmrb.stardb.Stardb;
import EDU.bmrb.validator.Config;
import EDU.bmrb.validator.EditingFunction;
import EDU.bmrb.validator.Error;
import EDU.bmrb.validator.ErrorList;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class FixFramecodes
extends EditingFunction {
    private static final boolean DEBUG = false;
    public static final int NUMBER = 75;
    private StringBuffer fBuf = null;

    public FixFramecodes(ErrorList errs, Config conf, Stardb star) {
        super(errs, conf, star);
        this.fNum = new Integer(75);
        this.fName = FixFramecodes.className(this.getClass().getName());
        this.init(75);
    }

    public boolean edit(boolean interactive) {
        try {
            this.fixSfFramecodes();
            this.fixFramecodeValues();
            return true;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            if (this.fErrs != null) {
                this.fErrs.add(new Error(true, 75, -1, -1, "DB exception, check error output"));
            }
            return false;
        }
    }

    public void fixSfFramecodes() throws SQLException {
        PreparedStatement pstat = this.fStar.getPreparedStatement("UPDATE ENTRYVALS SET VAL=? WHERE TAGID=?");
        Statement query = this.fStar.getQueryStatement();
        ResultSet rs = query.executeQuery("SELECT s.NAME,t.ID FROM ENTRYSFS s,ENTRYTAGS t,TAGS d WHERE d.SFLABELFLAG='Y' AND t.SEQ=d.SEQ AND s.ID=t.SFID");
        while (rs.next()) {
            pstat.setString(1, rs.getString(1));
            pstat.setInt(2, rs.getInt(2));
            pstat.executeUpdate();
        }
        rs.close();
        query.close();
        pstat.getConnection().commit();
        pstat.close();
    }

    public void fixFramecodeValues() throws SQLException {
        String str = null;
        PreparedStatement pstat = this.fStar.getPreparedStatement("UPDATE ENTRYVALS SET VAL=? WHERE ID=?");
        Statement query = this.fStar.getQueryStatement();
        ResultSet rs = query.executeQuery("SELECT v.VAL,v.ID FROM TAGS d,ENTRYVALS v WHERE d.VALTYPE='FRAMECODE' AND v.SEQ IS NOT NULL AND v.VAL IS NOT NULL AND v.VAL<>'.' AND v.VAL<>'?' AND v.SEQ=d.SEQ");
        while (rs.next()) {
            str = rs.getString(1).replaceAll("\\s+", "_");
            if (rs.getString(1).equals(str)) continue;
            pstat.setString(1, str);
            pstat.setInt(2, rs.getInt(2));
            pstat.executeUpdate();
        }
        rs.close();
        query.close();
        pstat.getConnection().commit();
        pstat.close();
    }

    public static void main(String[] args) {
        Config conf;
        long start = System.currentTimeMillis();
        ErrorList errs = new ErrorList();
        if (args.length > 0) {
            if (args[0].equals("-h")) {
                System.err.println("Usage: java EDU.bmrb.validator.functions.FixFramecodes [config file]");
                return;
            }
            conf = new Config(args[0]);
        } else {
            conf = new Config();
        }
        Star_DB star = new Star_DB(conf.getProperties());
        FixFramecodes fn = new FixFramecodes(errs, conf, star);
        star.connect(true);
        System.err.println("DB open: " + (System.currentTimeMillis() - start));
        boolean rc = fn.edit(false);
        System.err.println("Edited: " + (System.currentTimeMillis() - start));
        star.disconnect();
        if (errs.size() > 0) {
            errs.sort();
            errs.printErrors(System.out);
        }
        System.err.println("Elapsed: " + (System.currentTimeMillis() - start));
        if (!rc) {
            System.exit(1);
        }
    }
}

