/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.validator.functions;

import EDU.bmrb.sansj.ContentHandler;
import EDU.bmrb.sansj.DataItemNode;
import EDU.bmrb.sansj.ErrorHandler;
import EDU.bmrb.sansj.STARLexer;
import EDU.bmrb.sansj.SansParser;
import EDU.bmrb.stardb.Entry;
import EDU.bmrb.stardb.Star_DB;
import EDU.bmrb.stardb.Stardb;
import EDU.bmrb.stardb.sdbException;
import EDU.bmrb.validator.Config;
import EDU.bmrb.validator.EditingFunction;
import EDU.bmrb.validator.Error;
import EDU.bmrb.validator.ErrorList;
import gnu.getopt.Getopt;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class InsertDatumCount
extends EditingFunction
implements ErrorHandler,
ContentHandler {
    private static final boolean DEBUG = false;
    public static final int NUMBER = 89;
    public static final String[] ERRS = new String[]{"Atom isotope is not a number", "No data to count", "No entry information saveframe"};
    public static final String DATUM_SFCAT = "entry_information";
    public static final String DATUM_TAGCAT = "_Datum.";
    public static final String TAG_ENTRYID = "_Entry.ID";
    public static final String TAG_SFID = "_Entry.Sf_ID";
    public static final String TAG_DATUMTYPE = "_Datum.Type";
    public static final String TAG_DATUMCOUNT = "_Datum.Count";
    public static final String TAG_DATUMSFID = "_Datum.Sf_ID";
    public static final String TAG_DATUMENTRYID = "_Datum.Entry_ID";
    public static final String TAG_ATOMTYPE = "_Atom_chem_shift.Atom_type";
    public static final String TAG_ATOMISOTOPE = "_Atom_chem_shift.Atom_isotope_number";
    private String fEntryId = null;
    private Row fLastRow = null;
    private ArrayList fList = null;
    private boolean fInShifts = false;
    private boolean fFirstRow = true;
    private String[] DATUM_TYPES = null;
    private String[] DATUM_TAGS = null;

    public InsertDatumCount(ErrorList errs, Config conf, Stardb star) {
        super(errs, conf, star);
        this.fNum = new Integer(89);
        this.fName = InsertDatumCount.className(this.getClass().getName());
        this.init(89);
        this.fList = new ArrayList();
    }

    public static void usage() {
        System.err.print("Usage: java EDU.bmrb.validator.functions.InsertDatumCount ");
        System.err.println("[-c FILE] [-i FILE] [-h]");
        System.err.println("  -c FILE: use config FILE instead of ~/validator.conf");
        System.err.println("  -i FILE: input file name (default: stdin)");
        System.err.println("  -h: print this message");
        System.err.println("Error messages:");
        for (int i = 0; i < ERRS.length; ++i) {
            System.err.print(i);
            System.err.print(": ");
            System.err.println(ERRS[i]);
        }
    }

    public static void main(String[] args) {
        try {
            int opt;
            Getopt g = new Getopt("InsertDatumCount", args, "c:i:o:h");
            String conffile = null;
            String infile = null;
            Object outfile = null;
            block6: while ((opt = g.getopt()) != -1) {
                switch (opt) {
                    case 99: {
                        conffile = g.getOptarg();
                        continue block6;
                    }
                    case 105: {
                        infile = g.getOptarg();
                        continue block6;
                    }
                }
                InsertDatumCount.usage();
                return;
            }
            Config conf = conffile == null ? new Config() : new Config(conffile);
            ErrorList errs = new ErrorList();
            BufferedReader in = infile == null ? new BufferedReader(new InputStreamReader(System.in)) : new BufferedReader(new FileReader(infile));
            long start = System.currentTimeMillis();
            Star_DB star = new Star_DB(conf.getProperties());
            star.connect(true);
            System.err.println("DB open: " + (System.currentTimeMillis() - start));
            InsertDatumCount chk = new InsertDatumCount(errs, conf, star);
            chk.edit(in);
            System.err.println("Validated: " + (System.currentTimeMillis() - start));
            star.disconnect();
            ((Reader)in).close();
            if (errs.size() > 0) {
                errs.sort();
                errs.printErrors(System.out);
            }
            System.err.println("Elapsed: " + (System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }

    public boolean edit(Reader in) {
        if (!this.getDatumTags()) {
            return false;
        }
        STARLexer lex = new STARLexer(in);
        SansParser p = new SansParser(lex, this, this);
        p.parse();
        if (this.fList.size() < 1) {
            this.fErrs.add(new Error(false, 89, 1, 0, ERRS[1]));
            return false;
        }
        boolean rc = true;
        try {
            rc = this.insertLoop();
        }
        catch (SQLException e) {
            this.fErrs.add(new Error(true, 89, -1, -1, "DB exception, check error output"));
            System.err.println(e);
            e.printStackTrace();
            return false;
        }
        catch (sdbException se) {
            this.fErrs.add(new Error(true, 89, -1, -1, "stardb exception, check error output"));
            System.err.println(se);
            se.printStackTrace();
            return false;
        }
        return rc;
    }

    public boolean edit(boolean interactive) {
        System.err.println("Do not use this method!");
        return false;
    }

    private boolean getDatumTags() {
        try {
            ArrayList<String> datums = new ArrayList<String>();
            ArrayList<String> tags = new ArrayList<String>();
            ResultSet rs2 = null;
            Statement query1 = this.fStar.getQueryStatement();
            Statement query2 = this.fStar.getQueryStatement();
            ResultSet rs1 = query1.executeQuery("SELECT TAGCAT,DATUMTYPE FROM DATUMTYPES");
            while (rs1.next()) {
                rs1.getString(2);
                if (rs1.wasNull()) continue;
                rs1.getString(1);
                if (rs1.wasNull()) continue;
                rs2 = query2.executeQuery("SELECT TAGNAME FROM TAGS WHERE TAGCAT='" + rs1.getString(1) + "'");
                if (!rs2.next()) {
                    this.fErrs.add(new Error(true, 89, -1, -1, "dictionary error, invalid tag category " + rs1.getString(1)));
                    query2.close();
                    query1.close();
                    return false;
                }
                rs2.getString(1);
                if (rs2.wasNull()) continue;
                datums.add(rs1.getString(2));
                tags.add(rs2.getString(1));
            }
            if (rs2 != null) {
                rs2.close();
            }
            query2.close();
            rs1.close();
            query2.close();
            if (datums.size() <= 0 || tags.size() <= 0) {
                this.fErrs.add(new Error(true, 89, -1, -1, "dictionary error, no datum info"));
                return false;
            }
            this.DATUM_TYPES = new String[datums.size()];
            this.DATUM_TYPES = datums.toArray(this.DATUM_TYPES);
            this.DATUM_TAGS = new String[tags.size()];
            this.DATUM_TAGS = tags.toArray(this.DATUM_TAGS);
            datums.clear();
            tags.clear();
            return true;
        }
        catch (SQLException e) {
            this.fErrs.add(new Error(true, 89, -1, -1, "DB exception, check error output"));
            System.err.println(e);
            e.printStackTrace();
            return false;
        }
    }

    public boolean insertLoop() throws SQLException, sdbException {
        StringBuffer sql = new StringBuffer("SELECT ID FROM ENTRYSFS WHERE CATEGORY='");
        sql.append(DATUM_SFCAT);
        sql.append('\'');
        Statement query = this.fStar.getQueryStatement();
        ResultSet rs = query.executeQuery(sql.toString());
        if (!rs.next()) {
            this.fErrs.add(new Error(false, 89, 2, 0, ERRS[2]));
            query.close();
            return false;
        }
        int sfid = rs.getInt(1);
        Statement stat = this.fStar.getStatement();
        sql.setLength(0);
        sql.append("SELECT DISTINCT LOOPID FROM ENTRYTAGS WHERE SFID=");
        sql.append(sfid);
        sql.append(" AND NAME LIKE '");
        sql.append(DATUM_TAGCAT);
        sql.append("%'");
        rs = query.executeQuery(sql.toString());
        while (rs.next()) {
            sql.setLength(0);
            sql.append("DELETE FROM ENTRYLOOPS WHERE ID=");
            sql.append(rs.getInt(1));
            stat.executeUpdate(sql.toString());
            sql.setLength(0);
            sql.append("DELETE FROM ENTRYTAGS WHERE LOOPID=");
            sql.append(rs.getInt(1));
            stat.executeUpdate(sql.toString());
        }
        String sf_id = null;
        sql.setLength(0);
        sql.append("SELECT v.VAL FROM ENTRYVALS v,ENTRYTAGS t WHERE t.SFID=");
        sql.append(sfid);
        sql.append(" AND t.NAME='");
        sql.append(TAG_SFID);
        sql.append("' AND v.TAGID=t.ID");
        rs = query.executeQuery(sql.toString());
        if (rs.next()) {
            sf_id = rs.getString(1);
            if (rs.wasNull() || sf_id.equals(".") || sf_id.equals("?")) {
                sf_id = null;
            }
        }
        rs.close();
        query.close();
        int loopid = Entry.insertLoop(this.fStar, sfid, TAG_DATUMCOUNT);
        sql.setLength(0);
        sql.append("DELETE FROM ENTRYVALS WHERE LOOPID=");
        sql.append(loopid);
        stat.executeUpdate(sql.toString());
        stat.getConnection().commit();
        stat.close();
        for (int i = 0; i < this.fList.size(); ++i) {
            Entry.insertLoopRow(this.fStar, loopid, i);
            Entry.insertLoopValue(this.fStar, loopid, Entry.getTagID(this.fStar, sfid, TAG_DATUMTYPE), i, ((Datum)this.fList.get((int)i)).type);
            Entry.insertLoopValue(this.fStar, loopid, Entry.getTagID(this.fStar, sfid, TAG_DATUMCOUNT), i, Integer.toString(((Datum)this.fList.get((int)i)).count));
            Entry.insertLoopValue(this.fStar, loopid, Entry.getTagID(this.fStar, sfid, TAG_DATUMENTRYID), i, this.fEntryId);
            if (sf_id == null) continue;
            Entry.insertLoopValue(this.fStar, loopid, Entry.getTagID(this.fStar, sfid, TAG_DATUMSFID), i, sf_id);
        }
        return true;
    }

    public void error(int param, int param1, String str) {
        this.fErrs.add(new Error(true, 89, -1, param, str));
        System.err.print("Parse error in line ");
        System.err.print(param);
        System.err.print(", col ");
        System.err.print(param1);
        System.err.print(": ");
        System.err.println(str);
    }

    public boolean warning(int param, int param1, String str) {
        this.fErrs.add(new Error(false, 89, -1, param, str));
        System.err.print("Parse warning in line ");
        System.err.print(param);
        System.err.print(", col ");
        System.err.print(param1);
        System.err.print(": ");
        System.err.println(str);
        return false;
    }

    public boolean startLoop(int param) {
        this.fInShifts = false;
        this.fFirstRow = true;
        return false;
    }

    public boolean endLoop(int param) {
        if (this.fInShifts) {
            StringBuffer buf = new StringBuffer();
            buf.append(this.fLastRow.isotope);
            buf.append(this.fLastRow.atype);
            buf.append(' ');
            buf.append(this.DATUM_TYPES[0]);
            boolean found = false;
            for (int i = 0; i < this.fList.size(); ++i) {
                if (!((Datum)this.fList.get((int)i)).type.equals(buf.toString())) continue;
                ++((Datum)this.fList.get((int)i)).count;
                found = true;
                break;
            }
            if (!found) {
                this.fList.add(new Datum(buf, 1));
            }
        }
        return false;
    }

    public boolean data(DataItemNode node) {
        int i;
        boolean found = false;
        if (node.getName().equals(TAG_ENTRYID)) {
            this.fEntryId = node.getValue();
            return false;
        }
        if (node.getName().equals(this.DATUM_TAGS[0])) {
            if (this.fFirstRow) {
                this.fFirstRow = false;
                this.fInShifts = true;
            } else {
                StringBuffer buf = new StringBuffer();
                if (this.fLastRow.isotope < 0) {
                    buf.append("UNKNOWN ISOTOPE ");
                } else {
                    buf.append(this.fLastRow.isotope);
                }
                if (this.fLastRow.atype == null) {
                    buf.append("NO ATOM TYPE");
                } else {
                    buf.append(this.fLastRow.atype);
                }
                buf.append(' ');
                buf.append(this.DATUM_TYPES[0]);
                found = false;
                for (i = 0; i < this.fList.size(); ++i) {
                    if (!((Datum)this.fList.get((int)i)).type.equals(buf.toString())) continue;
                    ++((Datum)this.fList.get((int)i)).count;
                    found = true;
                    break;
                }
                if (!found) {
                    this.fList.add(new Datum(buf, 1));
                }
            }
            this.fLastRow = new Row();
        }
        if (this.fInShifts) {
            if (node.getName().equals(TAG_ATOMTYPE)) {
                this.fLastRow.atype = node.getValue();
            }
            if (node.getName().equals(TAG_ATOMISOTOPE)) {
                try {
                    this.fLastRow.isotope = Integer.parseInt(node.getValue());
                }
                catch (NumberFormatException e) {
                    this.fErrs.add(new Error(true, 89, 0, node.getValueLine(), ERRS[0]));
                }
            }
        }
        for (i = 1; i < this.DATUM_TAGS.length; ++i) {
            if (!this.DATUM_TAGS[i].equals(node.getName())) continue;
            found = false;
            for (int j = 0; j < this.fList.size(); ++j) {
                if (!((Datum)this.fList.get((int)j)).type.equals(this.DATUM_TYPES[i])) continue;
                found = true;
                ++((Datum)this.fList.get((int)j)).count;
                break;
            }
            if (found) continue;
            this.fList.add(new Datum(this.DATUM_TYPES[i], 1));
        }
        return false;
    }

    public boolean comment(int param, String str) {
        return false;
    }

    public boolean startData(int param, String str) {
        return false;
    }

    public void endData(int param, String str) {
    }

    public boolean startSaveFrame(int param, String str) {
        return false;
    }

    public boolean endSaveFrame(int param, String str) {
        return false;
    }

    class Row {
        String atype = null;
        int isotope = -1;

        Row() {
        }
    }

    class Datum {
        String type = null;
        int count = 0;

        Datum(StringBuffer buf, int cnt) {
            this.type = buf.toString();
            this.count = cnt;
        }

        Datum(String str, int cnt) {
            this.type = str;
            this.count = cnt;
        }
    }
}

