/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.validator.functions;

import EDU.bmrb.nmrstar.utils.QuoteString;
import EDU.bmrb.stardb.Star_DB;
import EDU.bmrb.stardb.Stardb;
import EDU.bmrb.validator.Config;
import EDU.bmrb.validator.EditingFunction;
import EDU.bmrb.validator.Error;
import EDU.bmrb.validator.ErrorList;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class InsertEntryID
extends EditingFunction {
    private static final boolean DEBUG = false;
    public static final int NUMBER = 99;
    private StringBuffer fBuf = null;

    public InsertEntryID(ErrorList errs, Config conf, Stardb star) {
        super(errs, conf, star);
        this.fNum = new Integer(99);
        this.fName = InsertEntryID.className(this.getClass().getName());
        this.init(99);
        this.fBuf = new StringBuffer();
    }

    public boolean edit(boolean interactive) {
        try {
            String id = this.getID();
            if (id == null) {
                this.insertIDs("NEED_ACC_NUM");
            } else {
                this.insertIDs(id);
            }
            Statement stat = this.fStar.getStatement();
            if (id == null) {
                stat.executeUpdate("UPDATE ENTRYINFO SET NAME='NEED_ACC_NUM'");
            } else {
                stat.executeUpdate("UPDATE ENTRYINFO SET NAME='" + id + "'");
            }
            if (!stat.getConnection().getAutoCommit()) {
                stat.getConnection().commit();
            }
            stat.close();
            return true;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            if (this.fErrs != null) {
                this.fErrs.add(new Error(true, 99, -1, -1, "DB exception, check error output"));
            }
            return false;
        }
    }

    public void insertIDs(String id) throws SQLException {
        this.fBuf.setLength(0);
        this.fBuf.append("UPDATE ENTRYVALS SET VAL=");
        this.fBuf.append(QuoteString.quoteForDB(id));
        this.fBuf.append(" WHERE TAGID IN (SELECT t.ID FROM ENTRYTAGS t,TAGS d WHERE d.ENTRYIDFLAG='Y' AND d.SEQ=t.SEQ)");
        Statement stat = this.fStar.getStatement();
        stat.executeUpdate(this.fBuf.toString());
        stat.getConnection().commit();
        stat.close();
    }

    public String getID() throws SQLException {
        String id = null;
        Statement query = this.fStar.getQueryStatement();
        ResultSet rs = query.executeQuery("SELECT v.VAL FROM ENTRYVALS v,ENTRYTAGS t WHERE t.NAME='_Entry.ID' AND v.TAGID=t.ID");
        if (rs.next()) {
            id = rs.getString(1);
            if (rs.wasNull()) {
                id = null;
            } else if (id.equals(".") || id.equals("?")) {
                id = null;
            }
        }
        rs.close();
        query.close();
        return id;
    }

    public static void main(String[] args) {
        Config conf;
        long start = System.currentTimeMillis();
        ErrorList errs = new ErrorList();
        if (args.length > 0) {
            if (args[0].equals("-h")) {
                System.err.println("Usage: java EDU.bmrb.validator.functions.InsertEntryID [config file]");
                return;
            }
            conf = new Config(args[0]);
        } else {
            conf = new Config();
        }
        Star_DB star = new Star_DB(conf.getProperties());
        InsertEntryID fn = new InsertEntryID(errs, conf, star);
        star.connect(true);
        System.err.println("DB open: " + (System.currentTimeMillis() - start));
        boolean rc = fn.edit(false);
        System.err.println("Edited: " + (System.currentTimeMillis() - start));
        star.disconnect();
        if (errs.size() > 0) {
            errs.sort();
            errs.printErrors(System.out);
        }
        System.err.println("Elapsed: " + (System.currentTimeMillis() - start));
        if (!rc) {
            System.exit(1);
        }
    }
}

