/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.validator.functions;

import EDU.bmrb.stardb.Star_DB;
import EDU.bmrb.stardb.Stardb;
import EDU.bmrb.validator.Config;
import EDU.bmrb.validator.EditingFunction;
import EDU.bmrb.validator.Error;
import EDU.bmrb.validator.ErrorList;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class InsertLocalIDs
extends EditingFunction {
    public static final int NUMBER = 100;
    private StringBuffer fBuf = null;

    public InsertLocalIDs(ErrorList errs, Config conf, Stardb star) {
        super(errs, conf, star);
        this.fNum = new Integer(100);
        this.fName = InsertLocalIDs.className(this.getClass().getName());
        this.init(100);
        this.fBuf = new StringBuffer();
    }

    public boolean edit(boolean interactive) {
        boolean rc = true;
        try {
            Statement query = this.fStar.getQueryStatement();
            ResultSet rs = query.executeQuery("SELECT DISTINCT CATEGORY FROM ENTRYSFS WHERE CATEGORY IS NOT NULL");
            while (rs.next()) {
                if (this.updateCategory(rs.getString(1))) continue;
                rc = false;
            }
            return true;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            if (this.fErrs != null) {
                this.fErrs.add(new Error(true, 100, -1, -1, "DB exception, check error output"));
            }
            return false;
        }
    }

    public boolean updateCategory(String sfcat) throws SQLException {
        int id = 0;
        String chem_comp_id = null;
        Statement tagquery = this.fStar.getQueryStatement();
        ResultSet tagrs = null;
        PreparedStatement pstat = this.fStar.getPreparedStatement("UPDATE ENTRYVALS SET VAL=? WHERE TAGID=?");
        this.fBuf.setLength(0);
        this.fBuf.append("SELECT ID FROM ENTRYSFS WHERE CATEGORY='");
        this.fBuf.append(sfcat);
        this.fBuf.append("' ORDER BY ID");
        Statement sfquery = this.fStar.getQueryStatement();
        ResultSet sfrs = sfquery.executeQuery(this.fBuf.toString());
        while (sfrs.next()) {
            if (sfcat.equals("chem_comp")) {
                chem_comp_id = null;
                this.fBuf.setLength(0);
                this.fBuf.append("SELECT v.VAL FROM ENTRYTAGS t,TAGS d,ENTRYVALS v WHERE d.LOCALIDFLAG='Y' AND d.LOOPFLAG='N' AND t.SFID=");
                this.fBuf.append(sfrs.getInt(1));
                this.fBuf.append(" AND t.SEQ=d.SEQ AND v.TAGID=t.ID");
                tagrs = tagquery.executeQuery(this.fBuf.toString());
                if (tagrs.next()) {
                    chem_comp_id = tagrs.getString(1);
                    if (tagrs.wasNull()) {
                        chem_comp_id = null;
                    }
                }
            }
            ++id;
            this.fBuf.setLength(0);
            this.fBuf.append("SELECT t.ID FROM ENTRYTAGS t,TAGS d ");
            this.fBuf.append("WHERE d.LOCALIDFLAG='Y' AND t.SFID=");
            this.fBuf.append(sfrs.getInt(1));
            this.fBuf.append(" AND t.SEQ=d.SEQ ORDER BY t.ID");
            tagrs = tagquery.executeQuery(this.fBuf.toString());
            while (tagrs.next()) {
                if (chem_comp_id == null) {
                    chem_comp_id = Integer.toString(id);
                }
                if (sfcat.equals("chem_comp")) {
                    pstat.setString(1, chem_comp_id);
                } else {
                    pstat.setString(1, Integer.toString(id));
                }
                pstat.setInt(2, tagrs.getInt(1));
                pstat.executeUpdate();
            }
        }
        pstat.getConnection().commit();
        pstat.close();
        if (tagrs != null) {
            tagrs.close();
        }
        tagquery.close();
        sfrs.close();
        sfquery.close();
        return true;
    }

    public static void main(String[] args) {
        Config conf;
        long start = System.currentTimeMillis();
        ErrorList errs = new ErrorList();
        if (args.length > 0) {
            if (args[0].equals("-h")) {
                System.err.println("Usage: java EDU.bmrb.validator.functions.InsertLocalIDs [config file]");
                return;
            }
            conf = new Config(args[0]);
        } else {
            conf = new Config();
        }
        Star_DB star = new Star_DB(conf.getProperties());
        InsertLocalIDs fn = new InsertLocalIDs(errs, conf, star);
        star.connect(true);
        System.err.println("DB open: " + (System.currentTimeMillis() - start));
        boolean rc = fn.edit(false);
        System.err.println("Edited: " + (System.currentTimeMillis() - start));
        star.disconnect();
        if (errs.size() > 0) {
            errs.sort();
            errs.printErrors(System.out);
        }
        System.err.println("Elapsed: " + (System.currentTimeMillis() - start));
        if (!rc) {
            System.exit(1);
        }
    }
}

