/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.validator.functions;

import EDU.bmrb.stardb.Entry;
import EDU.bmrb.stardb.Star_DB;
import EDU.bmrb.stardb.Stardb;
import EDU.bmrb.stardb.sdbException;
import EDU.bmrb.validator.Config;
import EDU.bmrb.validator.Dictionary;
import EDU.bmrb.validator.EditingFunction;
import EDU.bmrb.validator.Error;
import EDU.bmrb.validator.ErrorList;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class InsertMandatoryTags
extends EditingFunction {
    private static final boolean DEBUG = false;
    public static final int NUMBER = 105;

    public InsertMandatoryTags(ErrorList errs, Config conf, Stardb star) {
        super(errs, conf, star);
        this.fNum = new Integer(105);
        this.fName = InsertMandatoryTags.className(this.getClass().getName());
        this.init(105);
    }

    public boolean edit(boolean interactive) {
        try {
            Statement query = this.fStar.getQueryStatement();
            ResultSet rs = query.executeQuery("SELECT ID FROM ENTRYSFS ORDER BY ID");
            while (rs.next()) {
                this.insertTags(rs.getInt(1));
            }
            rs.close();
            query.close();
            return true;
        }
        catch (SQLException e) {
            System.err.println(e);
            e.printStackTrace();
            if (this.fErrs != null) {
                this.fErrs.add(new Error(true, 105, -1, -1, "DB exception, check error output"));
            }
            return false;
        }
        catch (sdbException se) {
            System.err.println(se);
            se.printStackTrace();
            if (this.fErrs != null) {
                this.fErrs.add(new Error(true, 105, -1, -1, "StarDB exception, check error output"));
            }
            return false;
        }
    }

    public void insertTags(int sfid) throws SQLException, sdbException {
        char mandatory = '\u0000';
        String value = null;
        String cat = null;
        String[] looptags = null;
        Statement loopq = this.fStar.getQueryStatement();
        ResultSet looprs = null;
        StringBuffer sql = new StringBuffer("SELECT m.SEQ,m.TAGNAME,m.LOOPFLAG,m.ADITDEFAULT,m.MANDATORY,m.SFCAT FROM TAGS m,ENTRYSFS s WHERE s.ID=");
        sql.append(sfid);
        sql.append(" AND m.SEQ NOT IN (SELECT SEQ FROM ENTRYTAGS WHERE SFID=");
        sql.append(sfid);
        sql.append(") AND m.METADATA='Y' AND m.SFCAT=s.CATEGORY");
        Statement query = this.fStar.getQueryStatement();
        ResultSet rs = query.executeQuery(sql.toString());
        while (rs.next()) {
            mandatory = Dictionary.checkOverride(this.fStar.getConnection(), rs.getString(6), sfid, rs.getInt(1));
            if (mandatory == '\u0000') {
                mandatory = rs.getString(5).charAt(0);
            }
            if (mandatory == 'I' || mandatory == 'O') continue;
            value = rs.getString(4);
            if (rs.wasNull()) {
                value = "?";
            }
            if (rs.getString(3).charAt(0) == 'Y') {
                int pos = rs.getString(2).indexOf(46);
                if (pos < 0) {
                    System.err.println("Dictionary error: tag without category " + rs.getString(2));
                    continue;
                }
                cat = rs.getString(2).substring(0, pos + 1);
                sql.setLength(0);
                sql.append("SELECT DISTINCT LOOPID FROM ENTRYTAGS WHERE NAME LIKE '");
                sql.append(cat);
                sql.append("%' AND SFID=");
                sql.append(sfid);
                looprs = loopq.executeQuery(sql.toString());
                if (!looprs.next()) {
                    int loopid = Entry.insertLoop(this.fStar, sfid, rs.getString(2));
                    if (loopid >= 0) {
                        looptags = Entry.getLoopTagNames(this.fStar, loopid);
                        for (int i = 0; i < looptags.length; ++i) {
                            sql.setLength(0);
                            sql.append("SELECT ADITDEFAULT FROM TAGS WHERE TAGNAME='");
                            sql.append(looptags[i]);
                            sql.append('\'');
                            looprs = loopq.executeQuery(sql.toString());
                            if (looprs.next()) {
                                value = looprs.getString(1);
                                if (looprs.wasNull()) {
                                    value = "?";
                                }
                            }
                            Entry.updateLoopColumn(this.fStar, sfid, looptags[i], value);
                        }
                    }
                } else {
                    Entry.insertLoopColumn(this.fStar, sfid, looprs.getInt(1), rs.getString(2), value);
                }
                looprs.close();
                continue;
            }
            Entry.insertFreeTagValue(this.fStar, sfid, rs.getString(2), value);
        }
        loopq.close();
        rs.close();
        query.close();
    }

    public static void main(String[] args) {
        Config conf;
        long start = System.currentTimeMillis();
        ErrorList errs = new ErrorList();
        if (args.length > 0) {
            if (args[0].equals("-h")) {
                System.err.println("Usage: java EDU.bmrb.validator.functions.InsertMandatoryTags [config file]");
                return;
            }
            conf = new Config(args[0]);
        } else {
            conf = new Config();
        }
        Star_DB star = new Star_DB(conf.getProperties());
        InsertMandatoryTags it = new InsertMandatoryTags(errs, conf, star);
        star.connect(true);
        System.err.println("DB open: " + (System.currentTimeMillis() - start));
        it.edit(false);
        System.err.println("Edited: " + (System.currentTimeMillis() - start));
        star.disconnect();
        if (errs.size() > 0) {
            errs.sort();
            errs.printErrors(System.out);
        }
        System.err.println("Elapsed: " + (System.currentTimeMillis() - start));
    }
}

