/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.validator.functions;

import EDU.bmrb.stardb.Entry;
import EDU.bmrb.stardb.Star_DB;
import EDU.bmrb.stardb.Stardb;
import EDU.bmrb.stardb.sdbException;
import EDU.bmrb.validator.Config;
import EDU.bmrb.validator.EditingFunction;
import EDU.bmrb.validator.Error;
import EDU.bmrb.validator.ErrorList;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class InsertResidueSequence
extends EditingFunction {
    private static final boolean DEBUG = false;
    public static final String ENTITY_SFCAT = "entity";
    public static final String TAG_EID = "_Entity.ID";
    public static final String TAG_SEQ = "_Entity.Polymer_seq_one_letter_code";
    public static final String TAG_SEQCAN = "_Entity.Polymer_seq_one_letter_code_can";
    public static final String TAG_IDX = "_Entity_poly_seq.Num";
    public static final String TAG_LABEL = "_Entity_poly_seq.Mon_ID";
    public static final String[] ERRS = new String[]{"Residue sequence already exists", "No polymer type or entity ID in this saveframe", "No residue type", "Unknown residue type"};
    public static final int SEQ_STRLEN = 24;
    public static final int NUMBER = 106;
    private StringBuffer fBuf = null;

    public InsertResidueSequence(ErrorList errs, Config conf, Stardb star) {
        super(errs, conf, star);
        this.fNum = new Integer(106);
        this.fName = InsertResidueSequence.className(this.getClass().getName());
        this.init(106);
        this.fBuf = new StringBuffer();
    }

    public boolean edit(boolean interactive) {
        try {
            boolean rc = true;
            this.fBuf.setLength(0);
            this.fBuf.append("SELECT DISTINCT ID,LINE FROM ENTRYSFS WHERE CATEGORY='");
            this.fBuf.append(ENTITY_SFCAT);
            this.fBuf.append("' ORDER BY ID");
            Statement query = this.fStar.getQueryStatement();
            ResultSet rs = query.executeQuery(this.fBuf.toString());
            while (rs.next()) {
                if (this.updateSaveframe(rs.getInt(1), rs.getInt(2))) continue;
                rc = false;
            }
            rs.close();
            query.close();
            return true;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            if (this.fErrs != null) {
                this.fErrs.add(new Error(true, 106, -1, -1, "DB exception, check error output"));
            }
            return false;
        }
    }

    public boolean updateSaveframe(int sfid, int sfline) throws SQLException, sdbException {
        int seq_tagid = Entry.getTagID(this.fStar, sfid, TAG_SEQ);
        boolean has_seq = false;
        int seq_line = -1;
        ResultSet rs = null;
        PreparedStatement pquery = this.fStar.getPreparedQuery("SELECT VAL,LINE FROM ENTRYVALS WHERE TAGID=?");
        if (seq_tagid >= 0) {
            pquery.setInt(1, seq_tagid);
            rs = pquery.executeQuery();
            if (rs.next()) {
                rs.getString(1);
                if (!rs.wasNull()) {
                    has_seq = true;
                    seq_line = rs.getInt(2);
                }
            }
        }
        int can_tagid = Entry.getTagID(this.fStar, sfid, TAG_SEQCAN);
        boolean has_can = false;
        int can_line = -1;
        if (can_tagid >= 0) {
            pquery.setInt(1, can_tagid);
            rs = pquery.executeQuery();
            if (rs.next()) {
                rs.getString(1);
                if (!rs.wasNull()) {
                    has_can = true;
                    can_line = rs.getInt(2);
                }
            }
        }
        pquery.close();
        if (has_seq && has_can) {
            if (this.fErrs != null) {
                this.fErrs.add(new Error(false, 106, 0, can_line, ERRS[0]));
                this.fErrs.add(new Error(false, 106, 0, seq_line, ERRS[0]));
            }
            rs.close();
            return false;
        }
        this.fBuf.setLength(0);
        this.fBuf.append("SELECT v.VAL FROM ENTRYVALS v,ENTRYTAGS t WHERE t.SFID=");
        this.fBuf.append(sfid);
        this.fBuf.append(" AND t.NAME='");
        this.fBuf.append(TAG_EID);
        this.fBuf.append("' AND v.TAGID=t.ID");
        Statement query = this.fStar.getQueryStatement();
        rs = query.executeQuery(this.fBuf.toString());
        if (!rs.next()) {
            if (this.fErrs != null) {
                this.fErrs.add(new Error(true, 106, 1, sfline, ERRS[1]));
            }
            rs.close();
            query.close();
            return false;
        }
        int eid = rs.getInt(1);
        if (rs.wasNull()) {
            eid = -1;
        }
        String tmp = null;
        this.fBuf.setLength(0);
        this.fBuf.append("SELECT ENTITY FROM ENTRYRESTYPES WHERE EID='");
        this.fBuf.append(eid);
        this.fBuf.append('\'');
        rs = query.executeQuery(this.fBuf.toString());
        if (rs.next()) {
            tmp = rs.getString(1);
            if (rs.wasNull()) {
                tmp = null;
            }
        }
        if (tmp == null) {
            if (this.fErrs != null) {
                this.fErrs.add(new Error(true, 106, 1, sfline, ERRS[1]));
            }
            rs.close();
            query.close();
            return false;
        }
        String restype = tmp.toLowerCase().indexOf("polypeptide") >= 0 ? "polypeptide" : tmp.toLowerCase();
        StringBuffer seq = new StringBuffer();
        this.fBuf.setLength(0);
        this.fBuf.append("SELECT vi.VAL,vr.VAL,vi.LOOPROW FROM ENTRYVALS vi,ENTRYVALS vr,");
        this.fBuf.append("ENTRYTAGS ti,ENTRYTAGS tr WHERE ti.NAME='");
        this.fBuf.append(TAG_IDX);
        this.fBuf.append("' AND tr.NAME='");
        this.fBuf.append(TAG_LABEL);
        this.fBuf.append("' AND tr.SFID=");
        this.fBuf.append(sfid);
        this.fBuf.append(" AND ti.SFID=");
        this.fBuf.append(sfid);
        this.fBuf.append(" AND vi.TAGID=ti.ID AND vr.TAGID=tr.ID AND vi.LOOPROW=vr.LOOPROW");
        if (this.fStar.isOracle() && this.fStar.getEngineVersion() >= 10) {
            this.fBuf.append(" ORDER BY CAST(vi.VAL AS INTEGER)");
        } else {
            this.fBuf.append(" ORDER BY vi.LOOPROW");
        }
        rs = query.executeQuery(this.fBuf.toString());
        int i = 0;
        while (rs.next()) {
            tmp = rs.getString(2);
            if (rs.wasNull()) {
                seq.append(' ');
            } else if ((tmp = tmp.toUpperCase()).length() == 1) {
                seq.append(tmp);
            } else if ((tmp = this.getResidueCode(restype, tmp)) == null) {
                seq.append(' ');
            } else {
                seq.append(tmp);
            }
            if (++i != 24) continue;
            seq.append("\n");
            i = 0;
        }
        if (can_tagid >= 0) {
            if (!has_can) {
                Entry.insertFreeValue(this.fStar, can_tagid, seq.toString());
            }
        } else {
            Entry.insertFreeTagValue(this.fStar, sfid, TAG_SEQCAN, seq.toString());
        }
        if (seq_tagid >= 0) {
            if (!has_seq) {
                Entry.insertFreeValue(this.fStar, seq_tagid, seq.toString());
            }
        } else {
            Entry.insertFreeTagValue(this.fStar, sfid, TAG_SEQ, seq.toString());
        }
        rs.close();
        query.close();
        return true;
    }

    public String getResidueCode(String type, String label) throws SQLException {
        this.fBuf.setLength(0);
        this.fBuf.append("SELECT r.CODE FROM RESIDUES r,RESTYPES t WHERE t.NAME='");
        this.fBuf.append(type);
        this.fBuf.append("' AND r.LABEL='");
        this.fBuf.append(label);
        this.fBuf.append("' AND r.TYPEID=t.ID");
        Statement query = this.fStar.getQueryStatement();
        ResultSet rs = query.executeQuery(this.fBuf.toString());
        String rc = null;
        if (rs.next()) {
            rc = rs.getString(1);
            if (rs.wasNull()) {
                rc = null;
            }
        }
        rs.close();
        query.close();
        return rc;
    }

    public static void main(String[] args) {
        Config conf;
        long start = System.currentTimeMillis();
        ErrorList errs = new ErrorList();
        if (args.length > 0) {
            if (args[0].equals("-h")) {
                System.err.print("Usage: java ");
                System.err.print(InsertResidueSequence.class.getName());
                System.err.println(" [config file]");
                System.err.println("Error messages:");
                for (int i = 0; i < ERRS.length; ++i) {
                    System.err.println(ERRS[i]);
                }
                return;
            }
            conf = new Config(args[0]);
        } else {
            conf = new Config();
        }
        Star_DB star = new Star_DB(conf.getProperties());
        InsertResidueSequence fn = new InsertResidueSequence(errs, conf, star);
        star.connect(true);
        System.err.println("DB open: " + (System.currentTimeMillis() - start));
        boolean rc = fn.edit(false);
        System.err.println("Edited: " + (System.currentTimeMillis() - start));
        star.disconnect();
        if (errs.size() > 0) {
            errs.sort();
            errs.printErrors(System.out);
        }
        System.err.println("Elapsed: " + (System.currentTimeMillis() - start));
        if (!rc) {
            System.exit(1);
        }
    }
}

