/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.validator.functions;

import EDU.bmrb.stardb.CreateTemplate;
import EDU.bmrb.stardb.Star_DB;
import EDU.bmrb.stardb.Stardb;
import EDU.bmrb.validator.Config;
import EDU.bmrb.validator.EditingFunction;
import EDU.bmrb.validator.Error;
import EDU.bmrb.validator.ErrorList;
import gnu.getopt.Getopt;
import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class InsertSaveFrame
extends EditingFunction {
    public static final int NUMBER = 71;
    private static final String NAME_SUFFIX = "_BLANK";
    private String fSfCat = null;
    private int fSfId = -1;
    private StringBuffer fBuf = null;

    public InsertSaveFrame(ErrorList errs, Config conf, Stardb star) {
        super(errs, conf, star);
        this.fNum = new Integer(71);
        this.fName = InsertSaveFrame.className(this.getClass().getName());
        this.init(71);
        this.fBuf = new StringBuffer();
    }

    public String[] listCategories() {
        String[] rc = null;
        ResultSet rs = null;
        Statement query = this.fStar.getQueryStatement();
        try {
            rs = query.executeQuery("SELECT DISTINCT SFCAT,ID FROM SFCATS WHERE UNIQ='N' OR (UNIQ='Y' AND SFCAT NOT IN (SELECT DISTINCT CATEGORY FROM ENTRYSFS)) ORDER BY ID");
            if (rs.next()) {
                ArrayList<String> sfcats = new ArrayList<String>();
                do {
                    sfcats.add(rs.getString(1));
                } while (rs.next());
                rs.close();
                query.close();
                rc = new String[sfcats.size()];
                for (int i = 0; i < sfcats.size(); ++i) {
                    rc[i] = (String)sfcats.get(i);
                }
                sfcats.clear();
                sfcats = null;
            }
            return rc;
        }
        catch (SQLException e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            if (this.fErrs != null) {
                this.fErrs.add(new Error(true, 71, -1, -1, "DB exception, check error output"));
            }
            return null;
        }
    }

    public boolean setSaveframeCategory(String sfcat) {
        Statement query = null;
        ResultSet rs = null;
        try {
            int id = -1;
            this.fBuf.setLength(0);
            this.fBuf.append("SELECT ID,UNIQ FROM SFCATS WHERE SFCAT='");
            this.fBuf.append(sfcat);
            this.fBuf.append('\'');
            query = this.fStar.getQueryStatement();
            rs = query.executeQuery(this.fBuf.toString());
            if (!rs.next()) {
                if (this.fErrs != null) {
                    this.fErrs.add(new Error(true, 71, -1, -1, "Invalid saveframe category"));
                }
                return false;
            }
            id = rs.getInt(1);
            char uniq = rs.getString(2).charAt(0);
            if (uniq == 'Y') {
                this.fBuf.setLength(0);
                this.fBuf.append("SELECT CATEGORY FROM ENTRYSFS WHERE SEQ=");
                this.fBuf.append(id);
                rs = query.executeQuery(this.fBuf.toString());
                if (rs.next()) {
                    if (this.fErrs != null) {
                        this.fErrs.add(new Error(true, 71, -1, -1, "Unique saveframe category already exists"));
                    }
                    return false;
                }
            }
            this.fSfCat = sfcat;
            this.fSfId = id;
            if (rs != null) {
                rs.close();
            }
            if (query != null) {
                query.close();
            }
            return true;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            if (this.fErrs != null) {
                this.fErrs.add(new Error(true, 71, -1, -1, "DB exception, check error output"));
            }
            return false;
        }
    }

    public boolean edit(boolean interactive) {
        if (!interactive) {
            return false;
        }
        Statement query = null;
        ResultSet rs = null;
        int line = -1;
        String name = this.fSfCat + NAME_SUFFIX;
        try {
            this.fBuf.setLength(0);
            if (this.fStar.isHSQLDB()) {
                this.fBuf.append("SELECT TOP 1 LINE,ID FROM ENTRYSFS WHERE ID>");
            } else {
                this.fBuf.append("SELECT LINE,ID FROM ENTRYSFS WHERE ID>");
            }
            this.fBuf.append(this.fSfId);
            this.fBuf.append(" ORDER BY ID");
            query = this.fStar.getQueryStatement();
            rs = query.executeQuery(this.fBuf.toString());
            if (!rs.next() && !(rs = query.executeQuery("SELECT MAX(LINE) FROM ENTRYVALS")).next()) {
                line = 1;
            }
            line = rs.getInt(1) + 1;
            rs.close();
            query.close();
            CreateTemplate ct = new CreateTemplate(this.fStar);
            ct.setStartLine(line);
            int sfid = ct.addSaveFrame(name, this.fSfCat, this.fSfId);
            if (sfid < 0) {
                if (this.fErrs != null) {
                    this.fErrs.add(new Error(true, 71, -1, -1, "Cannot add saveframe"));
                }
                return false;
            }
            if (!ct.addTags(name, this.fSfCat, sfid)) {
                if (this.fErrs != null) {
                    this.fErrs.add(new Error(true, 71, -1, -1, "Cannot add tags in new saveframe"));
                }
                return false;
            }
            return true;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            if (this.fErrs != null) {
                this.fErrs.add(new Error(true, 71, -1, -1, "DB exception, check error output"));
            }
            return false;
        }
    }

    public static void usage() {
        System.out.print("Usage: java ");
        System.out.print(InsertSaveFrame.class.getName());
        System.out.println(" [-h] [-c FILE] <-s SFCAT | -l>");
        System.out.println(" -h: print usage summary");
        System.out.print(" -c FILE: use configuration file FILE instead of ");
        System.out.print(System.getProperty("user.home"));
        System.out.print(File.separatorChar);
        System.out.println("validator.properties");
        System.out.println(" -s SFCAT: saveframe category to insert");
        System.out.println(" -l: list saveframe categories that can be inserted");
        System.out.println(" -l and -s options are mutually exclusive");
    }

    public static void main(String[] args) {
        int opt;
        long start = System.currentTimeMillis();
        boolean rc = false;
        Getopt g = new Getopt("InsertSaveFrame", args, "c:s:hl");
        boolean list = false;
        String conffile = null;
        String sfcat = null;
        block5: while ((opt = g.getopt()) != -1) {
            switch (opt) {
                case 99: {
                    conffile = g.getOptarg();
                    continue block5;
                }
                case 115: {
                    sfcat = g.getOptarg();
                    continue block5;
                }
                case 108: {
                    list = true;
                    continue block5;
                }
            }
            InsertSaveFrame.usage();
            return;
        }
        if (!list && sfcat == null) {
            InsertSaveFrame.usage();
            return;
        }
        ErrorList errs = new ErrorList();
        Config conf = conffile == null ? new Config() : new Config(conffile);
        Star_DB star = new Star_DB(conf.getProperties());
        InsertSaveFrame fn = new InsertSaveFrame(errs, conf, star);
        star.connect(true);
        System.err.println("DB open: " + (System.currentTimeMillis() - start));
        if (list) {
            String[] cats = fn.listCategories();
            for (opt = 0; opt < cats.length; ++opt) {
                System.out.println(cats[opt]);
            }
        } else {
            if (!fn.setSaveframeCategory(sfcat)) {
                System.err.println("Invalid saveframe category");
            } else {
                rc = fn.edit(true);
            }
            if (errs.size() > 0) {
                errs.sort();
                errs.printErrors(System.out);
            }
        }
        System.err.println("Edited: " + (System.currentTimeMillis() - start));
        star.disconnect();
        System.err.println("Elapsed: " + (System.currentTimeMillis() - start));
        if (!rc) {
            System.exit(1);
        }
    }
}

