/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.validator.functions;

import EDU.bmrb.stardb.Entry;
import EDU.bmrb.stardb.Star_DB;
import EDU.bmrb.stardb.Stardb;
import EDU.bmrb.stardb.sdbException;
import EDU.bmrb.validator.Config;
import EDU.bmrb.validator.EditingFunction;
import EDU.bmrb.validator.Error;
import EDU.bmrb.validator.ErrorList;
import gnu.getopt.Getopt;
import java.io.File;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class InsertShiftReference
extends EditingFunction {
    private static final boolean DEBUG = false;
    public static final int NUMBER = 87;
    public static final String[] ERRS = new String[0];

    public InsertShiftReference(ErrorList errs, Config conf, Stardb star) {
        super(errs, conf, star);
        this.fNum = new Integer(87);
        this.fName = InsertShiftReference.className(this.getClass().getName());
        this.init(87);
    }

    public boolean edit(boolean interactive) {
        try {
            Statement query = this.fStar.getQueryStatement();
            ResultSet rs = query.executeQuery("SELECT ID FROM ENTRYSFS WHERE CATEGORY='chem_shift_reference'");
            while (rs.next()) {
                this.updateSaveframe(rs.getInt(1));
            }
            rs.close();
            query.close();
            return true;
        }
        catch (SQLException e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            if (this.fErrs != null) {
                this.fErrs.add(new Error(true, 87, -1, -1, "DB exception, check error output"));
            }
            return false;
        }
        catch (sdbException e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            if (this.fErrs != null) {
                this.fErrs.add(new Error(true, 87, -1, -1, "Stardb exception, check error output"));
            }
            return false;
        }
    }

    public void updateSaveframe(int sfid) throws SQLException, sdbException {
        PreparedStatement pquery = this.fStar.getPreparedQuery("SELECT v1.VAL,v2.VAL,v3.VAL FROM ENTRYTAGS t1,ENTRYVALS v1,ENTRYTAGS t2,ENTRYVALS v2,ENTRYTAGS t3,ENTRYVALS v3 WHERE t1.NAME='_Chem_shift_ref.Atom_type' AND t2.NAME='_Chem_shift_ref.Atom_isotope' AND t3.NAME='_Chem_shift_ref.Indirect_shift_ratio' AND v1.VAL=? AND v2.VAL=? AND v3.VAL=? AND t1.ID=v1.TAGID AND t2.ID=v2.TAGID AND t3.ID=v3.TAGID AND t1.SFID=t2.SFID AND t2.SFID=t3.SFID AND v1.LOOPROW=v2.LOOPROW AND v2.LOOPROW=v3.LOOPROW");
        ResultSet rs1 = null;
        StringBuffer sql = new StringBuffer();
        int[] loopids = Entry.getLoopIDs(this.fStar, sfid, "_Chem_shift_ref.Atom_type");
        int loopid = loopids == null ? -1 : loopids[0];
        loopids = null;
        int tagid = -1;
        int row = 0;
        Statement query = this.fStar.getQueryStatement();
        ResultSet rs = null;
        if (loopid >= 0) {
            sql.append("SELECT MAX(LOOPROW) FROM ENTRYVALS WHERE LOOPID=");
            sql.append(loopid);
            rs = query.executeQuery(sql.toString());
            if (rs.next()) {
                row = rs.getInt(1) + 1;
            }
        }
        sql.setLength(0);
        sql.append("SELECT t.NAME,v.VAL FROM ENTRYTAGS t,ENTRYVALS v WHERE t.SFID=");
        sql.append(sfid);
        sql.append(" AND t.NAME LIKE '_Chem_shift_reference.IUPAC_default_%' AND v.TAGID=t.ID");
        rs = query.executeQuery(sql.toString());
        while (rs.next()) {
            rs.getString(2);
            if (rs.wasNull() || rs.getString(2).trim().toUpperCase().charAt(0) != 'Y') continue;
            if (rs.getString(1).equals("_Chem_shift_reference.IUPAC_default_1H")) {
                pquery.setString(1, "H");
                pquery.setString(2, "1");
                pquery.setString(3, "1.0");
                rs1 = pquery.executeQuery();
                if (!rs1.next()) {
                    if (loopid < 0) {
                        loopid = Entry.insertLoop(this.fStar, sfid, "_Chem_shift_ref.Atom_type");
                    }
                    this.insertRow(sfid, loopid, row, 'H');
                    ++row;
                }
            }
            if (rs.getString(1).equals("_Chem_shift_reference.IUPAC_default_13C")) {
                pquery.setString(1, "C");
                pquery.setString(2, "13");
                pquery.setString(3, "0.251449530");
                rs1 = pquery.executeQuery();
                if (!rs1.next()) {
                    if (loopid < 0) {
                        loopid = Entry.insertLoop(this.fStar, sfid, "_Chem_shift_ref.Atom_type");
                    }
                    this.insertRow(sfid, loopid, row, 'C');
                    ++row;
                }
            }
            if (rs.getString(1).equals("_Chem_shift_reference.IUPAC_default_15N")) {
                pquery.setString(1, "N");
                pquery.setString(2, "15");
                pquery.setString(3, "0.101329118");
                rs1 = pquery.executeQuery();
                if (!rs1.next()) {
                    if (loopid < 0) {
                        loopid = Entry.insertLoop(this.fStar, sfid, "_Chem_shift_ref.Atom_type");
                    }
                    this.insertRow(sfid, loopid, row, 'N');
                    ++row;
                }
            }
            if (!rs.getString(1).equals("_Chem_shift_reference.IUPAC_default_31P")) continue;
            pquery.setString(1, "P");
            pquery.setString(2, "31");
            pquery.setString(3, "0.404808636");
            rs1 = pquery.executeQuery();
            if (rs1.next()) continue;
            if (loopid < 0) {
                loopid = Entry.insertLoop(this.fStar, sfid, "_Chem_shift_ref.Atom_type");
            }
            this.insertRow(sfid, loopid, row, 'P');
            ++row;
        }
        if (rs1 != null) {
            rs1.close();
        }
        pquery.close();
        if (rs != null) {
            rs.close();
        }
        query.close();
    }

    public void insertRow(int sfid, int loopid, int row, char atype) throws sdbException, SQLException {
        int tagid = Entry.getTagID(this.fStar, sfid, "_Chem_shift_ref.Mol_common_name");
        if (tagid < 0) {
            throw new sdbException("No _Chem_shift_ref.Mol_common_name tag");
        }
        Entry.insertLoopValue(this.fStar, loopid, tagid, row, "DSS");
        tagid = Entry.getTagID(this.fStar, sfid, "_Chem_shift_ref.Atom_type");
        if (tagid < 0) {
            throw new sdbException("No _Chem_shift_ref.Atom_type tag");
        }
        Entry.insertLoopValue(this.fStar, loopid, tagid, row, Character.toString(atype));
        tagid = Entry.getTagID(this.fStar, sfid, "_Chem_shift_ref.Atom_group");
        if (tagid < 0) {
            throw new sdbException("No _Chem_shift_ref.Atom_group tag");
        }
        Entry.insertLoopValue(this.fStar, loopid, tagid, row, "methyl protons");
        tagid = Entry.getTagID(this.fStar, sfid, "_Chem_shift_ref.Chem_shift_units");
        if (tagid < 0) {
            throw new sdbException("No _Chem_shift_ref.Chem_shift_units tag");
        }
        Entry.insertLoopValue(this.fStar, loopid, tagid, row, "ppm");
        tagid = Entry.getTagID(this.fStar, sfid, "_Chem_shift_ref.Chem_shift_val");
        if (tagid < 0) {
            throw new sdbException("No _Chem_shift_ref.Chem_shift_val tag");
        }
        Entry.insertLoopValue(this.fStar, loopid, tagid, row, "0.0");
        switch (atype) {
            case 'H': {
                tagid = Entry.getTagID(this.fStar, sfid, "_Chem_shift_ref.Ref_type");
                if (tagid < 0) {
                    throw new sdbException("No _Chem_shift_ref.Ref_type tag");
                }
                Entry.insertLoopValue(this.fStar, loopid, tagid, row, "direct");
                tagid = Entry.getTagID(this.fStar, sfid, "_Chem_shift_ref.Ref_method");
                if (tagid < 0) {
                    throw new sdbException("No _Chem_shift_ref.Ref_method tag");
                }
                Entry.insertLoopValue(this.fStar, loopid, tagid, row, "internal");
                tagid = Entry.getTagID(this.fStar, sfid, "_Chem_shift_ref.Atom_isotope");
                if (tagid < 0) {
                    throw new sdbException("No _Chem_shift_ref.Atom_isotope tag");
                }
                Entry.insertLoopValue(this.fStar, loopid, tagid, row, "1");
                tagid = Entry.getTagID(this.fStar, sfid, "_Chem_shift_ref.Indirect_shift_ratio");
                if (tagid < 0) {
                    throw new sdbException("No _Chem_shift_ref.Indirect_shift_ratio tag");
                }
                Entry.insertLoopValue(this.fStar, loopid, tagid, row, "1.0");
                break;
            }
            case 'C': {
                tagid = Entry.getTagID(this.fStar, sfid, "_Chem_shift_ref.Ref_type");
                if (tagid < 0) {
                    throw new sdbException("No _Chem_shift_ref.Ref_type tag");
                }
                Entry.insertLoopValue(this.fStar, loopid, tagid, row, "indirect");
                tagid = Entry.getTagID(this.fStar, sfid, "_Chem_shift_ref.Atom_isotope");
                if (tagid < 0) {
                    throw new sdbException("No _Chem_shift_ref.Atom_isotope tag");
                }
                Entry.insertLoopValue(this.fStar, loopid, tagid, row, "13");
                tagid = Entry.getTagID(this.fStar, sfid, "_Chem_shift_ref.Indirect_shift_ratio");
                if (tagid < 0) {
                    throw new sdbException("No _Chem_shift_ref.Indirect_shift_ratio tag");
                }
                Entry.insertLoopValue(this.fStar, loopid, tagid, row, "0.251449530");
                break;
            }
            case 'N': {
                tagid = Entry.getTagID(this.fStar, sfid, "_Chem_shift_ref.Ref_type");
                if (tagid < 0) {
                    throw new sdbException("No _Chem_shift_ref.Ref_type tag");
                }
                Entry.insertLoopValue(this.fStar, loopid, tagid, row, "indirect");
                tagid = Entry.getTagID(this.fStar, sfid, "_Chem_shift_ref.Atom_isotope");
                if (tagid < 0) {
                    throw new sdbException("No _Chem_shift_ref.Atom_isotope tag");
                }
                Entry.insertLoopValue(this.fStar, loopid, tagid, row, "15");
                tagid = Entry.getTagID(this.fStar, sfid, "_Chem_shift_ref.Indirect_shift_ratio");
                if (tagid < 0) {
                    throw new sdbException("No _Chem_shift_ref.Indirect_shift_ratio tag");
                }
                Entry.insertLoopValue(this.fStar, loopid, tagid, row, "0.101329118");
                break;
            }
            case 'P': {
                tagid = Entry.getTagID(this.fStar, sfid, "_Chem_shift_ref.Ref_type");
                if (tagid < 0) {
                    throw new sdbException("No _Chem_shift_ref.Ref_type tag");
                }
                Entry.insertLoopValue(this.fStar, loopid, tagid, row, "indirect");
                tagid = Entry.getTagID(this.fStar, sfid, "_Chem_shift_ref.Atom_isotope");
                if (tagid < 0) {
                    throw new sdbException("No _Chem_shift_ref.Atom_isotope tag");
                }
                Entry.insertLoopValue(this.fStar, loopid, tagid, row, "31");
                tagid = Entry.getTagID(this.fStar, sfid, "_Chem_shift_ref.Indirect_shift_ratio");
                if (tagid < 0) {
                    throw new sdbException("No _Chem_shift_ref.Indirect_shift_ratio tag");
                }
                Entry.insertLoopValue(this.fStar, loopid, tagid, row, "0.404808636");
            }
        }
    }

    public static void usage() {
        System.out.println("Usage: java InsertShiftReference [-h] [-c FILE]");
        System.out.println(" -h: print usage summary");
        System.out.print(" -c FILE: use configuration file FILE instead of ");
        System.out.print(System.getProperty("user.home"));
        System.out.print(File.separatorChar);
        System.out.println("validator.properties");
    }

    public static void main(String[] args) {
        try {
            int opt;
            long start = System.currentTimeMillis();
            Getopt g = new Getopt("InsertShiftReference", args, "hc:");
            String conffile = null;
            block5: while ((opt = g.getopt()) != -1) {
                switch (opt) {
                    case 99: {
                        conffile = g.getOptarg();
                        continue block5;
                    }
                }
                InsertShiftReference.usage();
                return;
            }
            ErrorList errs = new ErrorList();
            Config conf = conffile == null ? new Config() : new Config(conffile);
            Star_DB star = new Star_DB(conf.getProperties());
            InsertShiftReference fn = new InsertShiftReference(errs, conf, star);
            star.connect(true);
            boolean rc = fn.edit(true);
            star.disconnect();
            if (errs.size() > 0) {
                errs.sort();
                errs.printErrors(System.out);
            }
            if (!rc) {
                System.exit(2);
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            System.exit(1);
        }
    }
}

