/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.validator.functions;

import EDU.bmrb.stardb.Entry;
import EDU.bmrb.stardb.Star_DB;
import EDU.bmrb.stardb.Stardb;
import EDU.bmrb.stardb.sdbException;
import EDU.bmrb.validator.Config;
import EDU.bmrb.validator.EditingFunction;
import EDU.bmrb.validator.Error;
import EDU.bmrb.validator.ErrorList;
import gnu.getopt.Getopt;
import java.io.File;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class InsertValues
extends EditingFunction {
    private static final boolean DEBUG = false;
    public static final int NUMBER = 72;
    public static final String[] ERRS = new String[]{"Cannot find saveframe category ", "Cannot find tag ", "Should be two words in ", "Did not find any loops in "};
    public static final String EXPT_METHOD_SFCAT = "entry_information";
    public static final String EXPT_METHOD_TAG = "_Entry.Experimental_method";
    public static final String EXPT_METHOD_VAL = "NMR";
    public static final String VERSION_TAG = "_Entry.NMR_STAR_version";
    public static final String ASSEMBLY_TAG = "_Assembly.Sf_framecode";
    public static final String ENTITY_SFCAT = "entity";
    public static final String ENTITY_TAG = "_Entity.Sf_framecode";
    public static final String ENTNAME_TAG = "_Entity.Name";
    public static final String ENTPARA_TAG = "_Entity.Paramagnetic";
    public static final String ASMPARA_TAG = "_Assembly.Paramagnetic";
    public static final String SOFTWARE_SFCAT = "software";
    public static final String SWCODE_TAG = "_Software.Sf_framecode";
    public static final String SWNAME_TAG = "_Software.Name";
    public static final String NATSRC_SFCAT = "natural_source";
    public static final String ORGNAME_TAG = "_Entity_natural_src.Organism_name_scientific";
    public static final String ORGGEN_TAG = "_Entity_natural_src.Genus";
    public static final String ORGSPC_TAG = "_Entity_natural_src.Species";
    public static final String EXPSRC_SFCAT = "experimental_source";
    public static final String HOSTNAME_TAG = "_Entity_experimental_src.Host_org_scientific_name";
    public static final String HOSTGEN_TAG = "_Entity_experimental_src.Host_org_genus";
    public static final String HOSTSPC_TAG = "_Entity_experimental_src.Host_org_species";
    private StringBuilder fBuf = null;

    public InsertValues(ErrorList errs, Config conf, Stardb star) {
        super(errs, conf, star);
        this.fNum = new Integer(72);
        this.fName = InsertValues.className(this.getClass().getName());
        this.init(72);
        this.fBuf = new StringBuilder();
    }

    public boolean edit(boolean interactive) {
        boolean rc = this.addExperimentalMethod();
        if (!this.addAssemblyID()) {
            rc = false;
        }
        if (!this.fixEntityNames()) {
            rc = false;
        }
        if (!this.fixSoftwareNames()) {
            rc = false;
        }
        if (!this.insertParamagnetic()) {
            rc = false;
        }
        if (!this.splitScientificName(true)) {
            rc = false;
        }
        if (!this.splitScientificName(false)) {
            rc = false;
        }
        return rc;
    }

    public boolean addExperimentalMethod() {
        try {
            int[] sfids = Entry.getSaveframeIDs(this.fStar, EXPT_METHOD_SFCAT);
            if (sfids == null) {
                if (this.fErrs != null) {
                    this.fErrs.add(new Error(true, 72, 0, -1, ERRS[0] + EXPT_METHOD_SFCAT));
                }
                return true;
            }
            for (int i : sfids) {
                int tagid = Entry.getTagID(this.fStar, i, EXPT_METHOD_TAG);
                if (tagid < 0) {
                    if (this.fErrs != null) {
                        this.fErrs.add(new Error(true, 72, 1, -1, ERRS[1] + EXPT_METHOD_TAG));
                    }
                    return true;
                }
                Entry.insertFreeValue(this.fStar, tagid, EXPT_METHOD_VAL);
            }
            return true;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            if (this.fErrs != null) {
                this.fErrs.add(new Error(true, 72, -1, -1, "DB exception, check error output"));
            }
            return false;
        }
    }

    public boolean insertStarVersion() {
        try {
            Statement query = this.fStar.getQueryStatement();
            ResultSet rs = query.executeQuery("SELECT VERSION FROM DICT");
            String version = null;
            if (rs.next()) {
                version = rs.getString(1);
                if (rs.wasNull()) {
                    version = null;
                }
            }
            int valid = -1;
            this.fBuf.setLength(0);
            this.fBuf.append("SELECT v.ID FROM ENTRYVALS v,ENTRYTAGS t WHERE t.NAME='");
            this.fBuf.append(VERSION_TAG);
            this.fBuf.append("' AND v.TAGID=t.ID");
            rs = query.executeQuery(this.fBuf.toString());
            if (rs.next()) {
                valid = rs.getInt(1);
                if (rs.wasNull()) {
                    valid = -1;
                }
            }
            rs.close();
            query.close();
            if (version != null && valid >= 0) {
                this.fBuf.setLength(0);
                this.fBuf.append("UPDATE ENTRYVALS SET VAL='");
                this.fBuf.append(version);
                this.fBuf.append("' WHERE ID=");
                this.fBuf.append(valid);
                Statement stat = this.fStar.getStatement();
                stat.executeUpdate(this.fBuf.toString());
                stat.getConnection().commit();
                stat.close();
                return true;
            }
            return false;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            if (this.fErrs != null) {
                this.fErrs.add(new Error(true, 72, -1, -1, "DB exception, check error output"));
            }
            return false;
        }
    }

    public boolean addAssemblyID() {
        try {
            this.fBuf.setLength(0);
            this.fBuf.append("SELECT v.VAL FROM ENTRYVALS v,ENTRYTAGS t WHERE t.NAME='");
            this.fBuf.append(ASSEMBLY_TAG);
            this.fBuf.append("' AND v.TAGID=t.ID");
            Statement query = this.fStar.getQueryStatement();
            ResultSet rs = query.executeQuery(this.fBuf.toString());
            if (!rs.next()) {
                if (this.fErrs != null) {
                    this.fErrs.add(new Error(true, 72, -1, -1, "Cannot find assembly saveframe"));
                }
                query.close();
                return false;
            }
            String framecode = rs.getString(1);
            rs.close();
            query.close();
            Statement stat = this.fStar.getStatement();
            this.fBuf.setLength(0);
            this.fBuf.append("UPDATE ENTRYVALS SET VAL='");
            this.fBuf.append(framecode);
            this.fBuf.append("', DELIMITER=");
            this.fBuf.append(12);
            this.fBuf.append(" WHERE TAGID IN (SELECT ID FROM ENTRYTAGS WHERE NAME LIKE '%.Assembly_label' AND NAME<>'_Sample_component.Assembly_label')");
            stat.executeUpdate(this.fBuf.toString());
            stat.executeUpdate("UPDATE ENTRYVALS SET VAL=1 WHERE TAGID IN (SELECT ID FROM ENTRYTAGS WHERE NAME LIKE '%.Assembly_ID' AND NAME<>'_Sample_component.Assembly_ID')");
            if (!stat.getConnection().getAutoCommit()) {
                stat.getConnection().commit();
            }
            stat.close();
            return true;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            if (this.fErrs != null) {
                this.fErrs.add(new Error(true, 72, -1, -1, "DB exception, check error output"));
            }
            return false;
        }
    }

    public boolean fixEntityNames() {
        try {
            int[] sfids = Entry.getSaveframeIDs(this.fStar, ENTITY_SFCAT);
            if (sfids == null) {
                if (this.fErrs != null) {
                    this.fErrs.add(new Error(true, 72, 0, -1, ERRS[0] + ENTITY_SFCAT));
                }
                return true;
            }
            PreparedStatement pquery = this.fStar.getPreparedQuery("SELECT VAL FROM ENTRYVALS WHERE TAGID=?");
            ResultSet rs = null;
            for (int i : sfids) {
                String name = null;
                int nameid = Entry.getTagID(this.fStar, i, ENTNAME_TAG);
                int valid = Entry.getTagID(this.fStar, i, ENTITY_TAG);
                if (valid < 0) {
                    if (this.fErrs == null) continue;
                    this.fErrs.add(new Error(true, 72, 1, -1, ERRS[1] + ENTITY_TAG));
                    continue;
                }
                pquery.setInt(1, valid);
                rs = pquery.executeQuery();
                if (rs.next()) {
                    name = rs.getString(1);
                    if (rs.wasNull()) continue;
                }
                if (nameid >= 0) {
                    Entry.insertFreeValue(this.fStar, nameid, name);
                    continue;
                }
                Entry.insertFreeTagValue(this.fStar, i, ENTNAME_TAG, name);
            }
            if (rs != null) {
                rs.close();
            }
            pquery.close();
            return true;
        }
        catch (SQLException e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            if (this.fErrs != null) {
                this.fErrs.add(new Error(true, 72, -1, -1, "DB exception, check error output"));
            }
            return false;
        }
        catch (sdbException e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            if (this.fErrs != null) {
                this.fErrs.add(new Error(true, 72, -1, -1, "StarDB exception, check error output"));
            }
            return false;
        }
    }

    public boolean insertParamagnetic() {
        try {
            String str;
            boolean paramagnetic = false;
            Statement query = this.fStar.getQueryStatement();
            ResultSet rs = query.executeQuery("SELECT v.VAL FROM ENTRYTAGS t,ENTRYVALS v WHERE t.NAME='_Entity.Paramagnetic' AND v.TAGID=t.ID");
            while (rs.next()) {
                str = rs.getString(1);
                if (rs.wasNull() || !str.toLowerCase().equals("yes") && !str.toLowerCase().equals("y")) continue;
                paramagnetic = true;
                break;
            }
            str = null;
            rs = query.executeQuery("SELECT ID FROM ENTRYTAGS WHERE NAME='_Assembly.Paramagnetic'");
            if (rs.next()) {
                str = rs.getString(1);
                if (rs.wasNull()) {
                    str = null;
                }
            }
            if (str != null) {
                Entry.insertFreeValue(this.fStar, rs.getInt(1), paramagnetic ? "yes" : "no");
            } else {
                rs = query.executeQuery("SELECT SFID FROM ENTRYTAGS WHERE NAME='_Assembly.Sf_framecode'");
                rs.next();
                Entry.insertFreeTagValue(this.fStar, rs.getInt(1), ASMPARA_TAG, paramagnetic ? "yes" : "no");
            }
            rs.close();
            query.close();
            return true;
        }
        catch (SQLException e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            if (this.fErrs != null) {
                this.fErrs.add(new Error(true, 72, -1, -1, "DB exception, check error output"));
            }
            return false;
        }
        catch (sdbException e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            if (this.fErrs != null) {
                this.fErrs.add(new Error(true, 72, -1, -1, "StarDB exception, check error output"));
            }
            return false;
        }
    }

    public boolean fixSoftwareNames() {
        try {
            int[] sfids = Entry.getSaveframeIDs(this.fStar, SOFTWARE_SFCAT);
            if (sfids == null) {
                if (this.fErrs != null) {
                    this.fErrs.add(new Error(true, 72, 0, -1, ERRS[0] + SOFTWARE_SFCAT));
                }
                return true;
            }
            PreparedStatement pquery = this.fStar.getPreparedQuery("SELECT VAL FROM ENTRYVALS WHERE TAGID=?");
            ResultSet rs = null;
            for (int i : sfids) {
                String name = null;
                int nameid = Entry.getTagID(this.fStar, i, SWNAME_TAG);
                int valid = Entry.getTagID(this.fStar, i, SWCODE_TAG);
                if (valid < 0) {
                    if (this.fErrs == null) continue;
                    this.fErrs.add(new Error(true, 72, 1, -1, ERRS[1] + SWCODE_TAG));
                    continue;
                }
                pquery.setInt(1, valid);
                rs = pquery.executeQuery();
                if (rs.next()) {
                    name = rs.getString(1);
                    if (rs.wasNull()) continue;
                }
                if (nameid >= 0) {
                    Entry.insertFreeValue(this.fStar, nameid, name);
                    continue;
                }
                Entry.insertFreeTagValue(this.fStar, i, SWNAME_TAG, name);
            }
            if (rs != null) {
                rs.close();
            }
            pquery.close();
            return true;
        }
        catch (SQLException e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            if (this.fErrs != null) {
                this.fErrs.add(new Error(true, 72, -1, -1, "DB exception, check error output"));
            }
            return false;
        }
        catch (sdbException e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            if (this.fErrs != null) {
                this.fErrs.add(new Error(true, 72, -1, -1, "StarDB exception, check error output"));
            }
            return false;
        }
    }

    public boolean splitScientificName(boolean natsrc) {
        try {
            String SFCAT = natsrc ? NATSRC_SFCAT : EXPSRC_SFCAT;
            String ORGNAME = natsrc ? ORGNAME_TAG : HOSTNAME_TAG;
            String ORGGEN = natsrc ? ORGGEN_TAG : HOSTGEN_TAG;
            String ORGSPC = natsrc ? ORGSPC_TAG : HOSTSPC_TAG;
            int[] sfids = Entry.getSaveframeIDs(this.fStar, SFCAT);
            if (sfids == null) {
                if (this.fErrs != null) {
                    this.fErrs.add(new Error(true, 72, 0, -1, ERRS[0] + SFCAT));
                }
                return true;
            }
            PreparedStatement pquery1 = this.fStar.getPreparedQuery("SELECT VAL,LOOPROW FROM ENTRYVALS WHERE TAGID=?");
            PreparedStatement pquery2 = this.fStar.getPreparedQuery("SELECT VAL FROM ENTRYVALS WHERE TAGID=? AND LOOPROW=?");
            ResultSet rs1 = null;
            ResultSet rs2 = null;
            for (int sfid : sfids) {
                int[] loopids = Entry.getLoopIDs(this.fStar, sfid, ORGNAME);
                if (loopids == null) {
                    if (this.fErrs != null) {
                        this.fErrs.add(new Error(true, 72, 3, -1, ERRS[3] + SFCAT));
                    }
                    return true;
                }
                for (int loopid : loopids) {
                    String val = null;
                    int tagid = Entry.getTagID(this.fStar, sfid, ORGNAME);
                    if (tagid < 0) {
                        if (this.fErrs == null) continue;
                        this.fErrs.add(new Error(true, 72, 1, -1, ERRS[1] + ORGNAME));
                        continue;
                    }
                    pquery1.setInt(1, tagid);
                    rs1 = pquery1.executeQuery();
                    while (rs1.next()) {
                        val = rs1.getString(1);
                        if (rs1.wasNull()) continue;
                        String[] split = val.split("\\s+");
                        int looprow = rs1.getInt(2);
                        if (split.length != 2) {
                            if (this.fErrs == null) continue;
                            this.fErrs.add(new Error(true, 72, 2, -1, ERRS[2] + ORGNAME));
                            continue;
                        }
                        tagid = Entry.getTagID(this.fStar, sfid, ORGGEN);
                        if (tagid < 0) {
                            if (this.fErrs == null) continue;
                            this.fErrs.add(new Error(true, 72, 1, -1, ERRS[1] + ORGGEN));
                            continue;
                        }
                        pquery2.setInt(1, tagid);
                        pquery2.setInt(2, looprow);
                        rs2 = pquery2.executeQuery();
                        if (rs2.next()) {
                            val = rs2.getString(1);
                            if (rs2.wasNull() || val.equals("?") || val.equals(".")) {
                                Entry.insertLoopValue(this.fStar, loopid, tagid, looprow, split[0]);
                            }
                        }
                        if ((tagid = Entry.getTagID(this.fStar, sfid, ORGSPC)) < 0) {
                            if (this.fErrs == null) continue;
                            this.fErrs.add(new Error(true, 72, 1, -1, ERRS[1] + ORGSPC));
                            continue;
                        }
                        pquery2.setInt(1, tagid);
                        pquery2.setInt(2, looprow);
                        rs2 = pquery2.executeQuery();
                        if (!rs2.next()) continue;
                        val = rs2.getString(1);
                        if (!rs2.wasNull() && !val.equals("?") && !val.equals(".")) continue;
                        Entry.insertLoopValue(this.fStar, loopid, tagid, looprow, split[1]);
                    }
                }
            }
            if (rs2 != null) {
                rs2.close();
            }
            pquery2.close();
            if (rs1 != null) {
                rs1.close();
            }
            pquery1.close();
            return true;
        }
        catch (SQLException e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            if (this.fErrs != null) {
                this.fErrs.add(new Error(true, 72, -1, -1, "DB exception, check error output"));
            }
            return false;
        }
        catch (sdbException e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            if (this.fErrs != null) {
                this.fErrs.add(new Error(true, 72, -1, -1, "StarDB exception, check error output"));
            }
            return false;
        }
    }

    public static void usage() {
        System.out.print("Usage: java ");
        System.out.print(InsertValues.class.getName());
        System.out.println(" [-h] [-c FILE] <-s SFCAT> <-t tagname=value>");
        System.out.println(" -h: print usage summary");
        System.out.print(" -c FILE: use configuration file FILE instead of ");
        System.out.print(System.getProperty("user.home"));
        System.out.print(File.separatorChar);
        System.out.println("validator.properties");
        System.out.println(" -s SFCAT: saveframe category");
        System.out.println(" -t tagname: tag name, e.g. _Entry.Version_type");
        System.out.print(" value: tag value to insert. Tagname=value pairs");
        System.out.println(" must be separated with equal sign (no spaces around =)");
        System.out.print("Multiple tag=value pairs are allowed; however, they must ");
        System.out.println("all be in the same saveframe");
    }

    public static void main(String[] args) {
        int opt;
        long start = System.currentTimeMillis();
        Getopt g = new Getopt("InsertValues", args, "hc:s:t:");
        String conffile = null;
        String sfcat = null;
        String tmp = null;
        ArrayList<String> tags = new ArrayList<String>();
        ArrayList<String> vals = new ArrayList<String>();
        block5: while ((opt = g.getopt()) != -1) {
            switch (opt) {
                case 99: {
                    conffile = g.getOptarg();
                    continue block5;
                }
                case 115: {
                    sfcat = g.getOptarg();
                    continue block5;
                }
                case 116: {
                    tmp = g.getOptarg();
                    int pos = tmp.indexOf(61);
                    if (pos < 0) {
                        InsertValues.usage();
                        return;
                    }
                    tags.add(tmp.substring(0, pos));
                    vals.add(tmp.substring(pos + 1));
                    continue block5;
                }
            }
            InsertValues.usage();
            return;
        }
        ErrorList errs = new ErrorList();
        Config conf = conffile == null ? new Config() : new Config(conffile);
        Star_DB star = new Star_DB(conf.getProperties());
        InsertValues fn = new InsertValues(errs, conf, star);
        star.connect(true);
        System.err.println("DB open: " + (System.currentTimeMillis() - start));
        boolean rc = fn.edit(true);
        System.err.println("Edited: " + (System.currentTimeMillis() - start));
        star.disconnect();
        if (errs.size() > 0) {
            errs.sort();
            errs.printErrors(System.out);
        }
        System.err.println("Elapsed: " + (System.currentTimeMillis() - start));
        if (!rc) {
            System.exit(1);
        }
    }
}

