/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.validator.functions;

import EDU.bmrb.stardb.Entry;
import EDU.bmrb.stardb.Star_DB;
import EDU.bmrb.stardb.Stardb;
import EDU.bmrb.validator.Config;
import EDU.bmrb.validator.EditingFunction;
import EDU.bmrb.validator.Error;
import EDU.bmrb.validator.ErrorList;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class MarkFramecodeValues
extends EditingFunction {
    public static final int NUMBER = 73;

    public MarkFramecodeValues(ErrorList errs, Config conf, Stardb star) {
        super(errs, conf, star);
        this.fNum = new Integer(73);
        this.fName = MarkFramecodeValues.className(this.getClass().getName());
        this.init(73);
    }

    public boolean edit(boolean interactive) {
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("UPDATE ENTRYVALS SET DELIMITER=");
            sql.append(12);
            sql.append(" WHERE TAGID=?");
            PreparedStatement pstat = this.fStar.getPreparedStatement(sql.toString());
            Statement query = this.fStar.getQueryStatement();
            ResultSet rs = query.executeQuery("SELECT ID FROM ENTRYTAGS WHERE SEQ IS NOT NULL");
            while (rs.next()) {
                if (!Entry.isFramecode(this.fStar, rs.getInt(1))) continue;
                pstat.setInt(1, rs.getInt(1));
                pstat.executeUpdate();
            }
            rs.close();
            query.close();
            pstat.getConnection().commit();
            pstat.close();
            return true;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            if (this.fErrs != null) {
                this.fErrs.add(new Error(true, 73, -1, -1, "DB exception, check error output"));
            }
            return false;
        }
    }

    public static void main(String[] args) {
        Config conf;
        long start = System.currentTimeMillis();
        ErrorList errs = new ErrorList();
        if (args.length > 0) {
            if (args[0].equals("-h")) {
                System.err.print("Usage: java ");
                System.err.print(MarkFramecodeValues.class.getName());
                System.err.println(" [config file]");
                return;
            }
            conf = new Config(args[0]);
        } else {
            conf = new Config();
        }
        Star_DB star = new Star_DB(conf.getProperties());
        MarkFramecodeValues fn = new MarkFramecodeValues(errs, conf, star);
        star.connect(true);
        System.err.println("DB open: " + (System.currentTimeMillis() - start));
        boolean rc = fn.edit(false);
        System.err.println("Edited: " + (System.currentTimeMillis() - start));
        star.disconnect();
        if (errs.size() > 0) {
            errs.sort();
            errs.printErrors(System.out);
        }
        System.err.println("Elapsed: " + (System.currentTimeMillis() - start));
        if (!rc) {
            System.exit(1);
        }
    }
}

