/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.validator.functions;

import EDU.bmrb.stardb.Star_DB;
import EDU.bmrb.stardb.Stardb;
import EDU.bmrb.validator.Config;
import EDU.bmrb.validator.EditingFunction;
import EDU.bmrb.validator.Error;
import EDU.bmrb.validator.ErrorList;
import java.sql.Statement;

public class RemoveComments
extends EditingFunction {
    public static final int NUMBER = 90;

    public RemoveComments(ErrorList errs, Config conf, Stardb star) {
        super(errs, conf, star);
        this.fNum = new Integer(90);
        this.fName = RemoveComments.className(this.getClass().getName());
        this.init(90);
    }

    public boolean edit(boolean interactive) {
        try {
            Statement st = this.fStar.getStatement();
            st.executeUpdate("UPDATE ENTRYINFO SET PRECOMMENT = NULL");
            st.executeUpdate("UPDATE ENTRYSFS SET PRECOMMENT = NULL");
            st.executeUpdate("UPDATE ENTRYLOOPS SET PRECOMMENT = NULL");
            st.executeUpdate("UPDATE ENTRYTAGS SET PRECOMMENT = NULL");
            st.executeUpdate("UPDATE ENTRYVALS SET PRECOMMENT = NULL");
            if (!st.getConnection().getAutoCommit()) {
                st.getConnection().commit();
            }
            st.close();
            return true;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            if (this.fErrs != null) {
                this.fErrs.add(new Error(true, 90, -1, -1, "DB exception, check error output"));
            }
            return false;
        }
    }

    public static void main(String[] args) {
        Config conf;
        long start = System.currentTimeMillis();
        ErrorList errs = new ErrorList();
        if (args.length > 0) {
            if (args[0].equals("-h")) {
                System.err.print("Usage: java ");
                System.err.print(RemoveComments.class.getName());
                System.err.println(" [config file]");
                return;
            }
            conf = new Config(args[0]);
        } else {
            conf = new Config();
        }
        Star_DB star = new Star_DB(conf.getProperties());
        RemoveComments chk = new RemoveComments(errs, conf, star);
        star.connect(true);
        System.err.println("DB open: " + (System.currentTimeMillis() - start));
        boolean rc = chk.edit(false);
        System.err.println("Edited: " + (System.currentTimeMillis() - start));
        star.disconnect();
        if (errs.size() > 0) {
            errs.sort();
            errs.printErrors(System.out);
        }
        System.err.println("Elapsed: " + (System.currentTimeMillis() - start));
        if (!rc) {
            System.exit(1);
        }
    }
}

