/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.validator.functions;

import EDU.bmrb.stardb.Entry;
import EDU.bmrb.stardb.Star_DB;
import EDU.bmrb.stardb.Stardb;
import EDU.bmrb.validator.Config;
import EDU.bmrb.validator.EditingFunction;
import EDU.bmrb.validator.Error;
import EDU.bmrb.validator.ErrorList;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class UpdateRelatedTags
extends EditingFunction {
    private static final boolean DEBUG = false;
    public static final int NUMBER = 101;
    private static final String IDTAG_SUFFIX = "_ID";
    private static final String LABTAG_SUFFIX = "_label";
    private static final String SAMPLETAG_CAT = "_Sample_component.";
    private static final String EXPTAG_SUFFIX = "_experiment.Sample_label";
    private static final String CITTAG_SUFFIX = ".Citation_label";
    private static final String COMPIDX_TAG = "_Entity_comp_index.Comp_label";
    public static final String[] ERRS = new String[]{"Dictionary error: SF link tag does not end with _ID", "No local ID in parent saveframe", "Missing saveframe label value"};
    private StringBuffer fBuf = null;

    public UpdateRelatedTags(ErrorList errs, Config conf, Stardb star) {
        super(errs, conf, star);
        this.fNum = new Integer(101);
        this.fName = UpdateRelatedTags.className(this.getClass().getName());
        this.init(101);
        this.fBuf = new StringBuffer();
    }

    public boolean edit(boolean interactive) {
        try {
            this.updateSfLabels();
            this.updateSfLinkTags();
            this.updateChildFreeTags();
            return true;
        }
        catch (Exception e) {
            this.fErrs.add(new Error(true, 101, -1, -1, "DB exception, check error output"));
            System.err.println(e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public void updateChildFreeTags() throws SQLException {
        int tagid = -1;
        String val = null;
        ArrayList sfids = new ArrayList();
        PreparedStatement tagquery = this.fStar.getPreparedQuery("SELECT r.CHLDSEQ FROM TAGRELS r,ENTRYTAGS t,TAGS d WHERE r.PRNTSEQ=? AND t.SFID=? AND d.LOOPFLAG<>'Y' AND t.SEQ=r.CHLDSEQ AND d.SEQ=t.SEQ");
        ResultSet tagrs = null;
        PreparedStatement valquery = this.fStar.getPreparedQuery("SELECT VAL FROM ENTRYVALS WHERE TAGID=?");
        PreparedStatement valquery1 = this.fStar.getPreparedQuery("SELECT v.ID,v.VAL FROM ENTRYVALS v,ENTRYTAGS t WHERE t.SFID=? AND t.SEQ=? AND t.ID=v.TAGID");
        ResultSet valrs = null;
        PreparedStatement prntquery = this.fStar.getPreparedQuery("SELECT DISTINCT r.PRNTSEQ FROM TAGRELS r,TAGS t WHERE r.PRNTSEQ IN (SELECT SEQ FROM ENTRYTAGS WHERE SFID=?) AND t.LOOPFLAG<>'Y' AND r.PRNTSEQ=t.SEQ");
        ResultSet rs = null;
        Statement sfidquery = this.fStar.getQueryStatement();
        ResultSet sfidrs = sfidquery.executeQuery("SELECT ID FROM ENTRYSFS ORDER BY ID");
        while (sfidrs.next()) {
            prntquery.setInt(1, sfidrs.getInt(1));
            rs = prntquery.executeQuery();
            while (rs.next()) {
                tagid = Entry.getTagID(this.fStar, sfidrs.getInt(1), rs.getInt(1));
                valquery.setInt(1, tagid);
                valrs = valquery.executeQuery();
                if (valrs.next()) {
                    val = valrs.getString(1);
                    if (valrs.wasNull() || val.equals("?")) continue;
                }
                tagquery.setInt(1, rs.getInt(1));
                tagquery.setInt(2, sfidrs.getInt(1));
                tagrs = tagquery.executeQuery();
                while (tagrs.next()) {
                    valquery1.setInt(1, sfidrs.getInt(1));
                    valquery1.setInt(2, tagrs.getInt(1));
                    valrs = valquery1.executeQuery();
                    while (valrs.next()) {
                        if (val.equals(valrs.getString(2))) continue;
                        Entry.updateValue(this.fStar, valrs.getInt(1), val);
                    }
                }
            }
        }
        if (valrs != null) {
            valrs.close();
        }
        valquery.close();
        valquery1.close();
        if (tagrs != null) {
            tagrs.close();
        }
        tagquery.close();
        if (rs != null) {
            rs.close();
        }
        sfidrs.close();
        sfidquery.close();
        prntquery.close();
    }

    public void updateSfLinkTags() throws SQLException {
        PreparedStatement label_query = this.fStar.getPreparedQuery("SELECT v.VAL,v.LOOPROW,v.TAGID FROM ENTRYVALS v,ENTRYTAGS t WHERE t.NAME=? AND t.SFID=? AND v.TAGID=t.ID");
        ResultSet rs1 = null;
        PreparedStatement id_query = this.fStar.getPreparedQuery("SELECT v.VAL FROM ENTRYVALS v,ENTRYTAGS t,ENTRYSFS s WHERE t.SEQ=? AND s.NAME=? AND s.ID=t.SFID AND v.TAGID=t.ID");
        ResultSet rs2 = null;
        PreparedStatement pstat = this.fStar.getPreparedStatement("UPDATE ENTRYVALS SET VAL=? WHERE TAGID=?");
        PreparedStatement pstat_loop = this.fStar.getPreparedStatement("UPDATE ENTRYVALS SET VAL=? WHERE TAGID=? AND LOOPROW=?");
        Statement query = this.fStar.getQueryStatement();
        ResultSet rs = query.executeQuery("SELECT DISTINCT t.ID,t.NAME,t.SFID,t.LINE,r.PRNTSEQ FROM ENTRYTAGS t,TAGS d,TAGRELS r WHERE d.SFLINKFLAG='Y' AND d.SEQ=t.SEQ AND r.CHLDSEQ=t.SEQ ORDER BY t.ID");
        while (rs.next()) {
            int srctagid = rs.getInt(1);
            int srcsfid = rs.getInt(3);
            int srcprntid = rs.getInt(5);
            String srctag = rs.getString(2);
            int pos = srctag.indexOf(IDTAG_SUFFIX);
            if (pos < 0) {
                System.err.println("Dictionary error: tag " + srctag + " is a SF link tag and does not end in " + IDTAG_SUFFIX);
                this.fErrs.add(new Error(true, 101, 0, rs.getInt(1), ERRS[0]));
                continue;
            }
            this.fBuf.setLength(0);
            this.fBuf.append(srctag.substring(0, pos));
            this.fBuf.append(LABTAG_SUFFIX);
            this.fBuf.append(srctag.substring(pos + 3));
            label_query.setString(1, this.fBuf.toString());
            label_query.setInt(2, srcsfid);
            rs1 = label_query.executeQuery();
            int srclooprow = -1;
            while (rs1.next()) {
                String label = rs1.getString(1);
                srclooprow = rs1.getInt(2);
                if (rs1.wasNull()) {
                    srclooprow = -1;
                }
                if (label == null || label.trim().equals(".") || label.trim().equals("?")) {
                    this.fErrs.add(new Error(false, 101, 1, rs.getInt(4), ERRS[2]));
                    continue;
                }
                id_query.setInt(1, srcprntid);
                id_query.setString(2, label);
                rs2 = id_query.executeQuery();
                while (rs2.next()) {
                    String id = rs.getString(1);
                    if (id == null || id.trim().equals(".") || id.trim().equals("?")) {
                        this.fErrs.add(new Error(false, 101, 1, rs.getInt(4), ERRS[1]));
                        continue;
                    }
                    if (srclooprow < 0) {
                        pstat.setString(1, rs2.getString(1));
                        pstat.setInt(2, srctagid);
                        pstat.executeUpdate();
                        continue;
                    }
                    pstat_loop.setString(1, rs2.getString(1));
                    pstat_loop.setInt(2, srctagid);
                    pstat_loop.setInt(3, srclooprow);
                    pstat_loop.executeUpdate();
                }
                rs2.close();
            }
            rs1.close();
        }
        if (!pstat.getConnection().getAutoCommit()) {
            pstat.getConnection().commit();
        }
        pstat.close();
        pstat_loop.close();
        rs.close();
        label_query.close();
        id_query.close();
        query.close();
    }

    public void updateSfLabels() throws SQLException {
        PreparedStatement pstat = this.fStar.getPreparedStatement("UPDATE ENTRYVALS SET VAL=?,DELIMITER=12 WHERE TAGID=?");
        PreparedStatement vquery = this.fStar.getPreparedQuery("SELECT VAL FROM ENTRYVALS WHERE TAGID=?");
        PreparedStatement pquery = this.fStar.getPreparedQuery("SELECT COUNT(*) FROM ENTRYSFS s,ENTRYTAGS t WHERE t.SEQ=? AND s.ID=t.SFID");
        ResultSet rs2 = null;
        Statement query = this.fStar.getQueryStatement();
        ResultSet rs = query.executeQuery("SELECT DISTINCT v.TAGID,t.SEQ,t.ID,d.TAGNAME FROM ENTRYVALS v,ENTRYTAGS t,TAGRELS r,TAGS d WHERE d.VALTYPE='FRAMECODE' AND (v.VAL IS NULL OR v.VAL='?' OR v.VAL='.') AND v.SEQ=r.CHLDSEQ AND d.SEQ=v.SEQ AND t.SEQ=r.PRNTSEQ ORDER BY t.ID");
        while (rs.next()) {
            int count = -1;
            pquery.setInt(1, rs.getInt(2));
            rs2 = pquery.executeQuery();
            if (rs2.next()) {
                count = rs2.getInt(1);
                if (rs2.wasNull()) {
                    count = -1;
                }
            }
            if (count != 1) continue;
            String val = rs.getString(4);
            if (!rs.wasNull() && (val.trim().indexOf(SAMPLETAG_CAT) == 0 || val.trim().indexOf(EXPTAG_SUFFIX) > 0 || val.trim().indexOf(CITTAG_SUFFIX) > 0 || val.trim().equals(COMPIDX_TAG))) continue;
            val = null;
            vquery.setInt(1, rs.getInt(3));
            rs2 = vquery.executeQuery();
            if (rs2.next()) {
                val = rs2.getString(1);
                if (rs2.wasNull()) {
                    val = null;
                }
            }
            if (val == null) continue;
            pstat.setString(1, val);
            pstat.setInt(2, rs.getInt(1));
            pstat.executeUpdate();
        }
        if (!pstat.getConnection().getAutoCommit()) {
            pstat.getConnection().commit();
        }
        pstat.close();
        if (rs2 != null) {
            rs2.close();
        }
        rs.close();
        query.close();
    }

    public static void main(String[] args) {
        Config conf;
        long start = System.currentTimeMillis();
        ErrorList errs = new ErrorList();
        if (args.length > 0) {
            if (args[0].equals("-h")) {
                System.err.print("Usage: java ");
                System.err.print(UpdateRelatedTags.class.getName());
                System.err.println(" [config file]");
                return;
            }
            conf = new Config(args[0]);
        } else {
            conf = new Config();
        }
        Star_DB star = new Star_DB(conf.getProperties());
        UpdateRelatedTags fn = new UpdateRelatedTags(errs, conf, star);
        star.connect(true);
        System.err.println("DB open: " + (System.currentTimeMillis() - start));
        boolean rc = fn.edit(false);
        System.err.println("Edited: " + (System.currentTimeMillis() - start));
        star.disconnect();
        if (errs.size() > 0) {
            errs.sort();
            errs.printErrors(System.out);
        }
        System.err.println("Elapsed: " + (System.currentTimeMillis() - start));
        if (!rc) {
            System.exit(1);
        }
    }
}

