/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.validator;

import EDU.bmrb.stardb.AddDictionaryInfo;
import EDU.bmrb.stardb.HSQLdb;
import EDU.bmrb.stardb.LoadMetadata;
import EDU.bmrb.stardb.Stardb;
import EDU.bmrb.validator.Config;
import EDU.bmrb.validator.DataValidationFunction;
import EDU.bmrb.validator.EditingFunction;
import EDU.bmrb.validator.Error;
import EDU.bmrb.validator.ErrorList;
import EDU.bmrb.validator.Function;
import EDU.bmrb.validator.Severity;
import EDU.bmrb.validator.ValidationFunction;
import EDU.bmrb.validator.ValidatorException;
import EDU.bmrb.validator.functions.AddComments;
import EDU.bmrb.validator.functions.AddRowIndexes;
import EDU.bmrb.validator.functions.CheckAmbiguityCodes;
import EDU.bmrb.validator.functions.CheckCharset;
import EDU.bmrb.validator.functions.CheckDataTypes;
import EDU.bmrb.validator.functions.CheckDataValues;
import EDU.bmrb.validator.functions.CheckEmptyRows;
import EDU.bmrb.validator.functions.CheckFrameCodes;
import EDU.bmrb.validator.functions.CheckInvalidTags;
import EDU.bmrb.validator.functions.CheckLocalIds;
import EDU.bmrb.validator.functions.CheckMandatoryTags;
import EDU.bmrb.validator.functions.CheckRelatedTags;
import EDU.bmrb.validator.functions.CheckResidueSequence;
import EDU.bmrb.validator.functions.CheckRowIndexes;
import EDU.bmrb.validator.functions.CheckSampleSaveframe;
import EDU.bmrb.validator.functions.CheckSaveFrames;
import EDU.bmrb.validator.functions.CheckShiftLoop;
import EDU.bmrb.validator.functions.CheckShiftStats;
import EDU.bmrb.validator.functions.CheckTagOrder;
import EDU.bmrb.validator.functions.CheckXlinkBond;
import EDU.bmrb.validator.functions.EditResidueLabels;
import EDU.bmrb.validator.functions.ExpandExperimentList;
import EDU.bmrb.validator.functions.ExpandSpectrometerList;
import EDU.bmrb.validator.functions.ExtractResidueSequence;
import EDU.bmrb.validator.functions.FixFramecodes;
import EDU.bmrb.validator.functions.InsertDataSetCount;
import EDU.bmrb.validator.functions.InsertEntryID;
import EDU.bmrb.validator.functions.InsertLocalIDs;
import EDU.bmrb.validator.functions.InsertMandatoryTags;
import EDU.bmrb.validator.functions.InsertResidueLoop;
import EDU.bmrb.validator.functions.InsertResidueSequence;
import EDU.bmrb.validator.functions.InsertShiftReference;
import EDU.bmrb.validator.functions.InsertValues;
import EDU.bmrb.validator.functions.MarkFramecodeValues;
import EDU.bmrb.validator.functions.RemoveComments;
import EDU.bmrb.validator.functions.SortTags;
import EDU.bmrb.validator.functions.TrimValues;
import EDU.bmrb.validator.functions.UpdateRelatedTags;
import edu.bmrb.starobj.db.LoadDict;
import edu.bmrb.starobj.db.RunSQL;
import gnu.getopt.Getopt;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class passthru {
    private static final boolean DEBUG = true;
    public static final String DICT_SCHEMA = "Dictionary.schema";
    public static final String DICT_CONSTR = "Dictionary.constraints";
    public static final String REFDB_SCHEMA = "Refdata.schema";
    public static final String REFDB_CONSTR = "Refdata.constraints";
    private Stardb fStar = null;
    private Config fConf = null;
    private ErrorList fErrs = null;
    private Map<Integer, Function> fFuncs = null;
    private Map<String, Function> fNames = null;
    private boolean fInteractive = true;

    public passthru(ErrorList errs, Config conf, Stardb star) {
        this.fErrs = errs;
        this.fConf = conf;
        this.fStar = star;
        this.init();
        this.init_functions();
    }

    private void init() {
        this.fFuncs = new TreeMap<Integer, Function>();
        this.fNames = new HashMap<String, Function>();
        if (!this.fStar.isConnected()) {
            this.fStar.connect(false);
        }
    }

    private void init_functions() {
        this.add(new CheckSaveFrames(this.fErrs, this.fConf));
        this.add(new CheckInvalidTags(this.fErrs, this.fConf));
        this.add(new CheckMandatoryTags(this.fErrs, this.fConf));
        this.add(new CheckTagOrder(this.fErrs, this.fConf));
        this.add(new CheckFrameCodes(this.fErrs, this.fConf));
        this.add(new CheckDataTypes(this.fErrs, this.fConf));
        this.add(new CheckDataValues(this.fErrs, this.fConf));
        this.add(new CheckRelatedTags(this.fErrs, this.fConf));
        this.add(new CheckLocalIds(this.fErrs, this.fConf));
        this.add(new CheckEmptyRows(this.fErrs, this.fConf));
        this.add(new CheckRowIndexes(this.fErrs, this.fConf));
        this.add(new CheckCharset(this.fErrs, this.fConf));
        this.add(new CheckShiftStats(this.fErrs, this.fConf));
        this.add(new CheckShiftLoop(this.fErrs, this.fConf));
        this.add(new CheckAmbiguityCodes(this.fErrs, this.fConf));
        this.add(new ExtractResidueSequence(this.fErrs, this.fConf));
        this.add(new CheckXlinkBond(this.fErrs, this.fConf));
        this.add(new CheckResidueSequence(this.fErrs, this.fConf));
        this.add(new CheckSampleSaveframe(this.fErrs, this.fConf));
        this.add(new InsertValues(this.fErrs, this.fConf, this.fStar));
        this.add(new MarkFramecodeValues(this.fErrs, this.fConf, this.fStar));
        this.add(new TrimValues(this.fErrs, this.fConf, this.fStar));
        this.add(new FixFramecodes(this.fErrs, this.fConf, this.fStar));
        this.add(new SortTags(this.fErrs, this.fConf, this.fStar));
        this.add(new AddRowIndexes(this.fErrs, this.fConf, this.fStar));
        this.add(new InsertShiftReference(this.fErrs, this.fConf, this.fStar));
        this.add(new InsertDataSetCount(this.fErrs, this.fConf, this.fStar));
        this.add(new RemoveComments(this.fErrs, this.fConf, this.fStar));
        this.add(new ExpandSpectrometerList(this.fErrs, this.fConf, this.fStar));
        this.add(new ExpandExperimentList(this.fErrs, this.fConf, this.fStar));
        this.add(new InsertResidueLoop(this.fErrs, this.fConf, this.fStar));
        this.add(new EditResidueLabels(this.fErrs, this.fConf, this.fStar));
        this.add(new InsertEntryID(this.fErrs, this.fConf, this.fStar));
        this.add(new InsertLocalIDs(this.fErrs, this.fConf, this.fStar));
        this.add(new UpdateRelatedTags(this.fErrs, this.fConf, this.fStar));
        this.add(new InsertMandatoryTags(this.fErrs, this.fConf, this.fStar));
        this.add(new InsertResidueSequence(this.fErrs, this.fConf, this.fStar));
        this.add(new AddComments(this.fErrs, this.fConf, this.fStar));
    }

    public void add(Function func) {
        this.fFuncs.put(func.getNumber(), func);
        this.fNames.put(func.getName(), func);
    }

    public boolean select(Integer num) {
        Function func = this.fFuncs.get(num);
        if (func == null) {
            return false;
        }
        func.setSelected(true);
        return true;
    }

    public void deselectAll() {
        for (Function f : this.fFuncs.values()) {
            f.setSelected(false);
        }
    }

    public void validate(FileInputStream in, long offset) throws IOException {
        if (this.fErrs == null) {
            throw new NullPointerException("No error list");
        }
        for (Function func : this.fFuncs.values()) {
            if (this.fErrs.size() > this.fConf.getMaxErrors()) {
                this.fErrs.add(new Error(Severity.CRIT, -1, -1, 32000, "Too many previous errors"));
                return;
            }
            if (func instanceof ValidationFunction) {
                if (!func.isSelected()) continue;
                System.out.printf("Running %s (#%d)\n", func.getName(), func.getNumber());
                ((ValidationFunction)func).validate(this.fStar.getConnection());
                continue;
            }
            if (!(func instanceof DataValidationFunction) || !func.isSelected()) continue;
            System.out.printf("Running %s (#%d)\n", func.getName(), func.getNumber());
            ((DataValidationFunction)func).validate(this.fStar.getConnection(), new InputStreamReader((InputStream)in, "ISO-8859-1"));
            in.getChannel().position(offset);
        }
    }

    public void edit() {
        if (this.fErrs == null) {
            throw new NullPointerException("No error list");
        }
        Iterator<Function> i = this.fFuncs.values().iterator();
        Function func = null;
        while (i.hasNext() && this.fErrs.size() <= this.fConf.getMaxErrors()) {
            func = i.next();
            if (!(func instanceof EditingFunction) || !func.isSelected()) continue;
            ((EditingFunction)func).edit(this.fInteractive);
        }
    }

    public static void usage() {
        System.out.print("Usage: java EDU.bmrb.validator.passthru <-d FILE> <-i FILE>");
        System.out.println(" <-r FILE> [-c FILE] [-o FILE] <-f NUM> [[-f NUM] ...] [-e]");
        System.out.println(" -d FILE: dictionary file name (required)");
        System.out.println(" -r FILE: reference data file name (required)");
        System.out.println(" -i FILE: input file name (required)");
        System.out.println(" -c FILE: use config FILE instead of ~/validator.conf");
        System.out.println(" -o FILE: output file name (default: stdout)");
        System.out.print(" -f NUM: validation/editing function to run. Multiple");
        System.out.print(" -f's are allowed. (If none specified, read the input");
        System.out.println(" and print parser messages, if any)");
    }

    public static void main(String ... args) {
        long start;
        long begin = start = System.currentTimeMillis();
        String outfile = null;
        ErrorList errs = null;
        try {
            int opt;
            Getopt g = new Getopt("passthru", args, "c:d:i:o:r:f:eh");
            String conffile = null;
            String infile = null;
            String dictfile = null;
            String reffile = null;
            boolean edit = false;
            ArrayList<Integer> funcs = new ArrayList<Integer>();
            block13: while ((opt = g.getopt()) != -1) {
                switch (opt) {
                    case 102: {
                        String arg = g.getOptarg();
                        try {
                            funcs.add(new Integer(arg));
                            continue block13;
                        }
                        catch (NumberFormatException e) {
                            System.err.printf("Invalid option -f %s\n", arg);
                            passthru.usage();
                            return;
                        }
                    }
                    case 99: {
                        conffile = g.getOptarg();
                        continue block13;
                    }
                    case 100: {
                        dictfile = g.getOptarg();
                        continue block13;
                    }
                    case 105: {
                        infile = g.getOptarg();
                        continue block13;
                    }
                    case 111: {
                        outfile = g.getOptarg();
                        continue block13;
                    }
                    case 114: {
                        reffile = g.getOptarg();
                        continue block13;
                    }
                    case 101: {
                        edit = true;
                        continue block13;
                    }
                }
                passthru.usage();
                System.exit(1);
            }
            if (infile == null || dictfile == null || reffile == null) {
                passthru.usage();
                System.exit(2);
            }
            if (funcs.size() < 1) {
                System.err.println("No functions selected");
                passthru.usage();
                System.exit(3);
            }
            System.out.printf("Checking %s\n", infile);
            Config c = conffile == null ? new Config() : new Config(conffile);
            errs = new ErrorList();
            HSQLdb star = new HSQLdb(c.getProperties());
            passthru v = new passthru(errs, c, star);
            v.deselectAll();
            int i = 0;
            for (Integer n : funcs) {
                if (v.select(n)) continue;
                errs.add(new Error(Severity.INFO, -1, -1, -1, "No such function: %d\n", n));
                ++i;
            }
            if (!star.connect(false)) {
                errs.add(new Error(Severity.CRIT, -1, -1, -1, "Failed to open database"));
                throw new ValidatorException();
            }
            System.err.printf("DB open: %d ms\n", System.currentTimeMillis() - start);
            start = System.currentTimeMillis();
            String str = star.getProperty(DICT_SCHEMA);
            if (str == null) {
                errs.add(new Error(Severity.CRIT, -1, -1, -1, "Error in properties file: missing dictinary SQL script %s\n", DICT_SCHEMA));
                throw new ValidatorException();
            }
            BufferedReader in = new BufferedReader(new FileReader(str));
            RunSQL.run(star.getConnection(), in, null);
            in.close();
            in = new BufferedReader(new FileReader(dictfile));
            LoadDict dl = new LoadDict(star.getConnection());
            dl.load(in);
            in.close();
            str = star.getProperty(DICT_CONSTR);
            if (str == null) {
                errs.add(new Error(Severity.CRIT, -1, -1, -1, "Error in properties file: missing dictinary SQL script %s\n", DICT_CONSTR));
                throw new ValidatorException();
            }
            in = new BufferedReader(new FileReader(str));
            RunSQL.run(star.getConnection(), in, null);
            in.close();
            System.err.printf("Dictionary loaded: %d ms\n", System.currentTimeMillis() - start);
            start = System.currentTimeMillis();
            str = star.getProperty(REFDB_SCHEMA);
            if (str == null) {
                errs.add(new Error(Severity.CRIT, -1, -1, -1, "Error in properties file: missing refdb SQL script %s\n", DICT_SCHEMA));
                throw new ValidatorException();
            }
            in = new BufferedReader(new FileReader(str));
            RunSQL.run(star.getConnection(), in, null);
            in.close();
            in = new BufferedReader(new FileReader(reffile));
            dl.load(in);
            in.close();
            str = star.getProperty(REFDB_CONSTR);
            if (str == null) {
                errs.add(new Error(Severity.CRIT, -1, -1, -1, "Error in properties file: missing refdb SQL script %s\n", DICT_CONSTR));
                throw new ValidatorException();
            }
            in = new BufferedReader(new FileReader(str));
            RunSQL.run(star.getConnection(), in, null);
            in.close();
            System.err.printf("Reference data loaded: %d ms\n", System.currentTimeMillis() - start);
            start = System.currentTimeMillis();
            FileInputStream fin = new FileInputStream(infile);
            long seek_set = fin.getChannel().position();
            in = new BufferedReader(new InputStreamReader((InputStream)fin, "ISO-8859-1"));
            LoadMetadata ldr = new LoadMetadata(star, errs);
            boolean load_ok = ldr.load(in, true);
            fin.getChannel().position(seek_set);
            System.err.printf("Entry loaded: %d ms\n", System.currentTimeMillis() - start);
            start = System.currentTimeMillis();
            if (!load_ok) {
                errs.add(new Error(Severity.CRIT, -1, -1, -1, "Cannot load entry"));
                throw new ValidatorException();
            }
            AddDictionaryInfo.addDictionaryInfo(star);
            if (!AddDictionaryInfo.checkVersion(star, null)) {
                errs.add(new Error(Severity.WARN, -1, -1, -1, "NMR-STAR versions don't match"));
            }
            System.err.printf("Added overrides: %d ms\n", System.currentTimeMillis() - start);
            start = System.currentTimeMillis();
            v.validate(fin, seek_set);
            System.err.printf("Validated: %d ms\n", System.currentTimeMillis() - start);
            start = System.currentTimeMillis();
            fin.close();
            star.close();
            System.err.printf("DB closed: %d ms\n", System.currentTimeMillis() - start);
            if (outfile == null) {
                errs.print(new PrintWriter(System.out), true);
                System.out.flush();
            } else {
                PrintWriter out = new PrintWriter(outfile);
                errs.print(out, true);
                out.flush();
            }
        }
        catch (Exception e) {
            if (errs != null) {
                errs.print(new PrintWriter(System.err), true);
            }
            System.err.println(e);
            e.printStackTrace();
            System.out.println(e);
            e.printStackTrace(System.out);
            System.exit(4);
        }
        System.err.println("Elapsed total: " + (System.currentTimeMillis() - begin));
    }
}

