/*
 * Decompiled with CFR 0.152.
 */
package EDU.bmrb.validator.swing;

import EDU.bmrb.validator.Error;
import EDU.bmrb.validator.ErrorList;
import java.awt.Color;
import java.util.Iterator;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ErrorTextArea
extends JScrollPane {
    private JTextArea textArea = new JTextArea();
    private ErrorList fErrs = null;

    public ErrorTextArea(ErrorList errs) {
        this.textArea.setLineWrap(false);
        this.textArea.setEditable(false);
        this.textArea.setSelectionColor(Color.red);
        this.textArea.setSelectedTextColor(Color.yellow);
        this.textArea.setSize(300, 300);
        this.setViewportView(this.textArea);
        this.fErrs = errs;
        this.showErrors();
    }

    public void showErrors() {
        this.textArea.setText("");
        this.fErrs.sort();
        Iterator<Error> i = this.fErrs.iterator();
        int fno = -1;
        int oldfno = -1;
        int numerrs = this.fErrs.numErrors();
        int numwarns = this.fErrs.numWarnings();
        boolean iserr = true;
        while (i.hasNext()) {
            Error err = i.next();
            fno = err.getFuncNum();
            if (fno > oldfno) {
                this.textArea.append("\n");
                oldfno = fno;
            }
            if (iserr && !err.isError()) {
                this.textArea.append("\n");
                iserr = false;
            }
            this.textArea.append(err.toString());
            this.textArea.append("\n");
        }
        this.textArea.append("\nSummary: ");
        this.textArea.append(Integer.toString(numerrs));
        this.textArea.append(" errors, ");
        this.textArea.append(Integer.toString(numwarns));
        this.textArea.append(" warnings\n");
    }

    public JTextArea getTextArea() {
        return this.textArea;
    }
}

